
<?php
get_template_part('templates/home/home-header');
get_template_part('templates/global/new-service-block');

//Getting services for the postcode search
$serviceMarkers = [];
$serviceLoop = new WP_Query(['post_type' => 'services']);

if ($serviceLoop->have_posts()) {
    $count = 0;
    while ($serviceLoop->have_posts()) {
        $serviceLoop->the_post();
        $map = get_field('google_map');
        if($map) {
            array_push($serviceMarkers, [get_the_title(), $map['lat'], $map['lng'], get_permalink(),'']);
        }
    }
}
wp_reset_postdata();
?>

<div class="block-6040">
    <div class="container-fluid">
        <div class="row row-eq-height find-service-row">
            <div class="col-lg-7 left-col" style="background-image: url('<?= get_field("service_map_image","option"); ?>'); background-position: right bottom; background-repeat: no-repeat; background-size: contain;">
                <div class="left-inner">
                    <h3><?php the_field('left_block_title', 'option'); ?></h3>
                    <?php the_field('left_block_content', 'option'); ?>
                </div>
            </div>
            <div class="col-lg-5 map-col">

                <div id="map-block" data-services="<?= htmlspecialchars(json_encode($serviceMarkers)); ?>"></div>


                <div id="search-panel">
                    <p>Find a service</p>
                    <input type="text" id="addressInput" placeholder="Location or postcode"/>
                    <select id="radiusSelect" label="Radius">
                        <option value="10" selected>10 mile radius</option>
                        <option value="20">20 mile radius</option>
                        <option value="30">30 mile radius</option>
                        <option value="40">40 mile radius</option>
                        <option value="50">50 mile radius</option>
                    </select>
                    <input type="button" id="searchButton" value="Search"/>
                </div>

                <div class="output">
                    <ul>
                        <li class="no-results">Aberlour has more than 40 services across Scotland dedicated to helping children and families. Enter your location to find services nearest to you</li>
                    </ul>
                </div>

            </div>
        </div>
    </div>
</div>

<div class="stories-block">
    <div class="container">
        <h2>Our Stories</h2>
        <?php
        $posts = get_field('stories', 'option');
        if( $posts ): ?>
            <div class="row">
                <?php foreach( $posts as $post): // variable must be called $post (IMPORTANT) ?>
                    <?php setup_postdata($post); ?>
                    <div class="story-col">
                        <div class="inner-col-story" style="background-image:url('<?php the_post_thumbnail_url(); ?>')">
                            <a href="<?php the_permalink(); ?>">
                                <h3><?php the_title(); ?></h3>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <?php wp_reset_postdata(); // IMPORTANT - reset the $post object so the rest of the page works correctly ?>
        <?php endif; ?>
    </div>
</div>

<?php
$cta1 = get_field('box_cta_1', 'option');
$cta2 = get_field('box_cta_2', 'option');
?>

<section class="fluid-bg-container banner-links-support">
    <div class="container-fluid">
        <div class="col-xs-12 col-md-6 green-bg fluid-bg-colour-left support-panel ">
            <h2><?php the_field('box_title_1', 'option') ?></h2>
            <?php the_field('box_content_1', 'option') ?>
            <a class="general-button" href="<?= $cta1['url'] ?>"><?= $cta1['title']; ?></a>
        </div>
        <div class="col-xs-12 col-md-6 fluid-bg-colour-right front-block support-panel ">
            <h2><?php the_field('box_title_2', 'option') ?></h2>
            <?php the_field('box_content_2', 'option') ?>
            <a class="general-button" href="<?= $cta2['url'] ?>"><?= $cta2['title']; ?></a>
        </div>
    </div>
</section>
