<?php

$cat_colour = get_field('category_colour', 'service_category_' . get_queried_object()->term_id);

$haveContent=0;
if(get_field('object_embed','service_category_' . get_queried_object()->term_id)){
    $haveContent++;
}
if(get_field('related_story','service_category_' . get_queried_object()->term_id) ){
    $haveContent++;
}

if($haveContent>0){
?>
<section class="services-extras container">
    <div class="row">
        <?php
        }

        if(get_field('object_embed','service_category_' . get_queried_object()->term_id)){
            if($haveContent>1){
                echo '<div class="col-sm-8 desktop-padding">';
            }
            echo '<div class="embed-container">';
            the_field('object_embed','service_category_' . get_queried_object()->term_id);
            echo '</div>';
            if($haveContent>1){
                echo '</div>';
            }
        }
        if(get_field('related_story','service_category_' . get_queried_object()->term_id)){
            if($haveContent>1){
                echo '<div class="col-sm-4"><div class="row">';
            }
            $theStory=get_field('related_story','service_category_' . get_queried_object()->term_id);
            $theID=$theStory->ID;
            $theTitle=$theStory->post_title;
            $pullQuote=get_field('pull_quote',$theID);
            if(strlen($pullQuote)>0){
                echo '<blockquote class="blockquote"><span class="quote color-purple">&ldquo;</span><p>'.$pullQuote.'</p><span class="quote color-purple">&rdquo;</span><a class="cite color-purple" href="'.get_permalink($theID).'"><i class="fa fa-angle-right"></i> '.$theTitle.'</a></blockquote>';
            }
            if($haveContent>1){
                echo '</div></div>';
            }
        }

        if($haveContent>0){
        ?>
    </div>
</section>
<?php
}
?>

<?php
$args = array(
    "post_type" => "services",
    "tax_query" => array(
        array(
            "taxonomy" => "service_category",
            "field" => "slug",
            "terms" => get_queried_object()->slug
        )
    )
);
$services = new WP_Query($args);

$cat_count = $services->found_posts;
if($services->have_posts()){
?>
    <section class="services-listing">
        <div class="container">
            <!--            <div class="tabled">-->
            <h2>Services</h2>

            <div class="row list-row">
                <?php
                while ($services->have_posts()) {
                    $services->the_post();
                    $featImage = wp_get_attachment_image_src(get_post_thumbnail_id(), "large") ? wp_get_attachment_image_src(get_post_thumbnail_id(), "full") : array("https://dummyimage.com/300x300/cccccc/000000.jpg&text=Pending+");
                    $featImgAlt = get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true);
                    ?>
                    <div class="col-md-6 col-lg-4 list-col">
                        <a href="<?php the_permalink(); ?>" class="cover-link"> </a>
                        <div class="purple-block list-block">
                            <div class="content-area">
                                <h2 class="h2sub-serv"><?php the_title(); ?></h2>
                                <p><?= wp_trim_words(get_the_content(), 10, '..'); ?></p>
                            </div>
                            <div class="cta">
                                <a href="<?php the_permalink(); ?>">Read more</a>
                            </div>
                        </div>
                    </div>

                <?php } ?>
            </div>
            <!--</div>-->
        </div>
    </section>
<?php } ?>
