<?php
if (get_field('banner_type')) {
    if (have_rows('banner_no_bubbles')):
        while (have_rows('banner_no_bubbles')) : the_row(); ?>
            <section class="main-banner no-bubble" style="background-image: url('<?php the_sub_field('banner_image') ?>'); background-position: <?php the_sub_field('banner_image_position') ?>">
                <img id='bg' class="hidden" src="<?php the_sub_field('banner_image') ?>" alt="">
                <div class="container container--fullheight">
                    <div class="banner-no-bubble heading ">
                        <div class="no-bubble-layout">
                            <h1><?php the_sub_field('banner_main_text', false, false) ?></h1>
                            <?php if (get_sub_field('banner_cta_text')) { ?>
                                <div class="banner-no-bubble-cta <?php the_sub_field('banner_cta_button_colour') ?>">
                                    <?php if (get_sub_field('banner_cta_link')) {
                                        ?>
                                        <a class="cover-link" target="_blank" href="<?php the_sub_field('banner_cta_link') ?>"
                                           title="<?php the_sub_field('banner_cta_text') ?>"> </a>
                                    <?php } ?>
                                    <span><?php the_sub_field('banner_cta_text') ?></span>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <a href="#bannerLinks" class="banner-chevron"><i class="fa fa-angle-down"></i></a>

            </section>
            <div id="bannerLinks" class="banner-links">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-xs-6 text-center">
                                <a href="<?php echo esc_url(home_url('/need-help/')); ?>"><span>need</span> help?</a>
                            </div>
                            <div class="col-xs-6 text-center">
                                <a href="<?php echo esc_url(home_url('/help-us/')); ?>"><span>help</span> us.</a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php
        endwhile;
    endif;
} else {
    if (have_rows('banner')):
        while (have_rows('banner')) : the_row(); ?>
            <section class="main-banner" style="background-image: url('<?php the_sub_field('banner_image') ?>');">
                <img id='bg' class="hidden" src="<?php the_sub_field('banner_image') ?>" alt="">
                <div class="container">
                    <?php if (get_sub_field('banner_bar_text')) { ?>
                        <div class="preheading-circle mid transparency fade-in-out">
                            <div class="preheading-content"><?php the_sub_field('banner_bar_text'); ?></div>
                        </div>
                    <?php } ?>
                    <div class="circle heading xlarge light-blue-bg transparency fade-in">
                        <h1><?php the_sub_field('banner_main_text', false, false) ?></h1></div>
                    <?php if (get_sub_field('banner_cta_text')) {
                        ?>
                        <div class="circle small yellow-bg transparency fade-in-delayed">
                            <?php if (get_sub_field('banner_cta_link')) {
                                ?>
                                <a class="cover-link cover-link-custom" target="_blank" href="<?php the_sub_field('banner_cta_link') ?>"
                                   title="<?php the_sub_field('banner_cta_text') ?>"> </a>
                            <?php } ?>
                            <span class="banner-text-custom"><?php the_sub_field('banner_cta_text') ?></span>
                        </div>
                    <?php } ?>

                    <?php if (get_sub_field('banner_cta2_text')) {
                        ?>
                        <div class="circle mid yellow-bg extra-transparency fade-in-delayed">
                            <?php if (get_sub_field('banner_cta2_link')) {
                                ?>
                                <a class="cover-link" target="_blank" href="<?php the_sub_field('banner_cta2_link') ?>"
                                   title="<?php the_sub_field('banner_cta2_text') ?>"> </a>
                            <?php } ?>
                            <span><?php the_sub_field('banner_cta2_text') ?></span>
                        </div>
                    <?php } ?>
                </div>
            </section>
            <?php
        endwhile;
    endif;
}
?>



