<?php

/**
 * Template Name: Fundraise for Us
 */

while (have_posts()) {
    the_post();
    get_template_part('templates/page', 'header'); ?>

    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <div class="fundraise-blocks">
                    <?php
                    if (have_rows('fundraise_for_us_blocks')) {
                        while (have_rows('fundraise_for_us_blocks')) {
                            the_row();
                    ?>
                            <div class="fundraise-single-block" id="<?php the_sub_field('section_id') ?>">
                                <h2><?php the_sub_field('main_title'); ?></h2>
                                <h3><?php the_sub_field('sub_title'); ?></h3>
                                <?php the_Sub_field('content') ?>
                            </div>
                    <?php }
                    }
                    ?>
                </div>
            </div>
            <div class="col-lg-offset-1 col-lg-3 jump-points-col">
                <div class="jump-points">
                    <h2><?php echo the_title() ?></h2>
                    <?php if (have_rows('fundraise_for_us_blocks')) { ?>
                        <ul>
                            <?php while (have_rows('fundraise_for_us_blocks')) {
                                the_row(); ?>
                                <li><a href="#<?php the_sub_field('section_id'); ?>"><?php the_sub_field('main_title'); ?></a></li>
                            <?php } ?>
                        </ul>
                    <?php } ?>
                </div>
            </div>
        </div>

    </div>


<?php } ?>