<?php

use Roots\Sage\Setup;
use Roots\Sage\Wrapper;

?>

<!doctype html>
<html <?php language_attributes(); ?> class="no-js">
  <?php get_template_part('templates/head'); ?>
  <body  id="pagetop" <?php body_class(); ?>>
  <!-- Google Tag Manager (noscript) -->
  <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-NXLDW8T" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
  <!-- End Google Tag Manager (noscript) -->
    <!--[if IE]>
      <div class="alert alert-warning">
        <?php _e('You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.', 'sage'); ?>
      </div>
    <![endif]-->
    <div class="mp-pusher" id="mp-pusher">
      <?php
        do_action('get_header');
        get_template_part('templates/header');
      ?>

      <div class="wrap" role="document">
        <div class="content">
              <?php if (Setup\display_sidebar()) { ?>
              <div class="container">
              <main class="main">
                <?php include Wrapper\template_path(); ?>
              </main><!-- /.main -->

                <aside class="sidebar">
                  <?php include Wrapper\sidebar_path(); ?>
                </aside><!-- /.sidebar -->
              </div>
              <?php } else { ?>
                <main class="main">
                    <?php include Wrapper\template_path(); ?>
                </main><!-- /.main -->
              <?php } ?>
        </div><!-- /.content -->
      </div><!-- /.wrap -->
      <?php
        do_action('get_footer');
        get_template_part('templates/footer');
        wp_footer();
      ?>
    </div>
    <script src="<?php echo get_template_directory_uri(); ?>/assets/scripts/classie.js"></script>
    <script src="<?php echo get_template_directory_uri(); ?>/assets/scripts/modernizr.custom.js"></script>
    <script src="<?php echo get_template_directory_uri(); ?>/assets/scripts/mlpushmenu.js"></script>
	<script src="<?php echo get_template_directory_uri(); ?>/assets/scripts/oms.min.js"></script>
    <?php wp_enqueue_scripts('jquery'); ?>
      <!-- Twitter universal website tag code -->
      <script>
          !function(e,t,n,s,u,a){e.twq||(s=e.twq=function(){s.exe?s.exe.apply(s,arguments):s.queue.push(arguments);
          },s.version='1.1',s.queue=[],u=t.createElement(n),u.async=!0,u.src='//static.ads-twitter.com/uwt.js',
              a=t.getElementsByTagName(n)[0],a.parentNode.insertBefore(u,a))}(window,document,'script');
          // Insert Twitter Pixel ID and Standard Event data below
          twq('init','o0jsq');
          twq('track','PageView');
      </script>
      <!-- End Twitter universal website tag code -->
  </body>
</html>
