function initMap() {
    var locations = $('#map-block').data('services');
    var radiusSelect = $('#radiusSelect');
    var searchType = ' Service';
    var searchTypePlural = ' Services';
    var map = new google.maps.Map(document.getElementById('map-block'), {
        zoom: 9,
        mapTypeControl: false,
        center: {lat: 56.1114507, lng: -3.9483485}
    });

    searchButton = document.getElementById("searchButton").onclick = searchLocations;

    function searchLocations() {
        console.log('Searching locs');
        var address = document.getElementById("addressInput").value;
        var geocoder = new google.maps.Geocoder();
        
        // if volunteer search field is blank, show everything. 
        if( $('#map-block').hasClass('volunteering-search-map') && address==''){
            searchType=' Opportunity';
            searchTypePlural=' Opportunities';
            address="Crianlarich";
            radiusSelect = 'everywhere';
        }
        
        if($('#nationWideSearch').prop('checked')==true){
            $('.output ul').html($('.output--nationwide ul').html());
        }else{
            geocoder.geocode({address: address}, function (results, status) {
                if (status == google.maps.GeocoderStatus.OK) {
                    searchLocationsNear(results[0].geometry.location);
                } else {
                    $('.output ul').empty();
                    $('.output ul').append('<li class="no-results">No results, please enter a different postcode or location</li>');
                }
            });
        }
    }

    function searchLocationsNear(center) {
        $('.output ul').empty();
        var range;
        if (radiusSelect != 'everywhere'){
            range = $('#radiusSelect').val() * 1609.344;
        }else{
            range=2000 * 1609.344;
        }
        
        var locCount = 0;

        for (var i = 0; i < locations.length; i++) {
            var link = locations[i][3];
            var name = locations[i][0];
            var latlng = new google.maps.LatLng(locations[i][1], locations[i][2]);
            var cssClass = locations[i][4];
            const distance = google.maps.geometry.spherical.computeDistanceBetween(latlng, center);

            if (distance < range) {
                locCount++;
                $('.output ul').append('<li class="'+cssClass+'"><a href="' + link + '" target="_blank">' + name + '</a></li>');
            }
        }
        
        if(locCount > 1){
            searchType=searchTypePlural;
        }
        if(locCount >= 6){
            $('.output').css('overflow-y', 'scroll');
            $('.scroll-notify').remove();
            $('#search-panel').append('<p class="scroll-notify">' + locCount + searchType + ' - Scroll to show</p>');
        } else{
            $('.output').css('overflow', 'hidden');
            $('.scroll-notify').remove();
            $('#search-panel').append('<p class="scroll-notify">' + locCount + searchType + ' Found</p>');
        }

        if (locCount === 0) {
            $('.output ul').append('<li class="no-results">No results, please enter a different postcode or location</li>');
            $('.output').css('overflow', 'hidden');
        }
    }
}

jQuery(document).ready(function($) {
    initMap();
});
