<header class="banner">
    <?php get_template_part('templates/header-navigation'); ?>
</header>
<?php
if (is_archive() ){
    if( is_post_type_archive('stories')){
        $image = get_field('stories_archive_banner', 'option');
        $xpos = get_field('stories_image_x_pos', 'option');
        $ypos = get_field('stories_image_y_pos', 'option');
    }
    if( is_post_type_archive('events')){
        $image = get_field('events_archive_banner', 'option');
        $xpos = get_field('events_image_x_pos', 'option');
        $ypos = get_field('events_image_y_pos', 'option');
    }
    if( is_post_type_archive('people')){
        $image = get_field('people_archive_banner', 'option');
        $xpos = get_field('people_image_x_pos', 'option');
        $ypos = get_field('people_image_y_pos', 'option');
    }
    if( is_post_type_archive('product')){
        $image = get_field('shop_archive_banner', 'option');
        $xpos = get_field('shop_image_x_pos', 'option');
        $ypos = get_field('shop_image_y_pos', 'option');
    }

}else{

    if (is_singular('stories')) {
        $image = get_field('hero_image');
    } else {
        $image = get_field('image');
    }

    $xpos = get_field('image_x_pos');
    $ypos = get_field('image_y_pos');
    if (!$image){ // Fix for News posts page banner
        $image = get_field('image', get_option('page_for_posts'));
        $xpos = get_field('image_x_pos', get_option('page_for_posts'));
        $ypos = get_field('image_y_pos', get_option('page_for_posts'));
    }
    if(is_singular('post')){ // Get featured image from News stories for banner
        if( get_field('use_featured_image_as_banner') != true) {
            $image = get_field('image');
            $xpos = '50%';
            $ypos = '50%';
        } else {
            $image = get_the_post_thumbnail_url(null,'large');
            $xpos = '50%';
            $ypos = '50%';
        }
    }
    //Try featured image for stories.
    if(is_singular('stories')  && !$image){
        $image = get_the_post_thumbnail_url(null,'large');
        $xpos = '50%';
        $ypos = '50%';
    }


    // If we still have no image, attempt to get corresponding archive image.
    if (!$image) {
        if(is_singular('stories')){
            $image = get_field('stories_archive_banner', 'option');
            $xpos = get_field('stories_image_x_pos', 'option');
            $ypos = get_field('stories_image_y_pos', 'option');
        }
        if(is_singular('events')){
            $image = get_field('events_archive_banner', 'option');
            $xpos = get_field('events_image_x_pos', 'option');
            $ypos = get_field('events_image_y_pos', 'option');
        }
        if(is_singular('people')){
            $image = get_field('people_archive_banner', 'option');
            $xpos = get_field('people_image_x_pos', 'option');
            $ypos = get_field('people_image_y_pos', 'option');
        }
        if(is_singular('shop')){
            $image = get_field('shop_archive_banner', 'option');
            $xpos = get_field('shop_image_x_pos', 'option');
            $ypos = get_field('shop_image_y_pos', 'option');
        }
    }
}

if (is_search()){
    unset($image);
}

if(is_tax('service_category')){
    $term = get_queried_object();
    $image = get_field('image', $term);
    $xpos = '50%';
    $ypos = '50%';
}

if (!$image) {
    // Use default theme banner image as fallback.
    $image = get_template_directory_uri().'/dist/images/banner-img.jpg';
    $xpos = '75%';
    $ypos = '-50px';
}


if(!is_front_page()){
    $styles="background-image:url('".$image."');";
    if ($xpos){
        $styles.=" background-position-x:".$xpos.";";
    }
    if ($ypos){
        $styles.=" background-position-y:".$ypos.";";
    }

    if (!is_singular('post')) {
        ?>

        <section class="main-banner" style="<?php echo $styles; ?>">
            <div class="header-title">
                <div class="container">
                    <div class="header-title-content">
                        <?php
                        if ( is_single()){
                            the_field('global_cta','option');
                        }else{
                            if (get_field('title')) {
                                the_field('title');
                            }
                        }
                        ?>
                    </div>
                </div>
            </div>
            <div class="container">

                <?php
                $orange = "#f78e1f";
                $green = "#03a64b";
                $purple = "#6a2d91";
                $blue = "#004a9a";

                if(is_singular('stories') || is_post_type_archive('stories') || is_post_type_archive('people') || is_singular('people') || is_post_type_archive('publications')){
                    $headerBackground = $orange;
                    $headerText = 'white';
                }
                else if(is_singular('events') || is_post_type_archive('events') || is_shop()){
                    $headerBackground = $green;
                    $headerText = 'white';
                }
                else if(is_singular('services') || is_post_type_archive('services')){
                    $headerBackground = $purple;
                    $headerText = 'white';
                }
                else if(is_home()){
                    $headerBackground = $blue;
                    $headerText = 'white';
                }
                else{
                    $headerText = get_field('header_text_colour') ? get_field('header_text_colour') : '';
                    $headerBackground = get_field('header_background_colour') ? get_field('header_background_colour') : '';
                }

                ?>


                <div class="sub-heading" style="background-color:<?= $headerBackground; ?>; color:<?= $headerText; ?>">
                    <?php
                    if ( is_single() ) {
                        if (get_post_type() == 'post'){
                            echo '<h1 class="news-heading">'.get_the_title().'</h1>';
                            get_template_part('templates/entry-meta');
                        }else{
                            echo '<h1>'.get_the_title().'</h1>';
                        }
                    } elseif (is_post_type_archive()) {
                        echo '<h1>';
                        post_type_archive_title();
                        echo '</h1>';
                    } elseif (is_archive()) {
                        echo '<h1>';
                        single_term_title();
                        echo '</h1>';
                    } elseif (is_home()){
                        echo '<h1>';
                        echo apply_filters( 'the_title', get_the_title( get_option( 'page_for_posts' ) ) );
                        echo '</h1>';
                    } elseif (is_404()){
                        echo '<h1>page not found</h1>';
                    }elseif (is_search()){
                        echo '<h1>search results</h1>';
                    } else {
                        if (get_field('sub_heading')) {
                            echo '<h1>';
                            echo sanitize_text_field(get_field('sub_heading'));
                            echo '</h1>';
                        }else{
                            echo '<h1>';
                            the_title();
                            echo '</h1>';
                        }
                    } ?>
                </div>
            </div>
        </section>
    <?php }
} ?>
