<?php
/**
 * Single Product Rating
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/rating.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

global $product;

$question_count = YITH_YWQA ()->get_questions_count ( $product->get_id() );

if ( $question_count > 0 ) : ?>

	<div class="ywqa-product-questions-counter">

		<span class="dashicons dashicons-format-chat"></span><a href="#tab-questions" class="ywqa-product-questions-counter-link" rel="nofollow">(<?php printf( _n( '%s question', '%s questions', $question_count, 'yith-woocommerce-questions-and-answers' ), '<span class="count">' . esc_html( $question_count ) . '</span>' ); ?>)</a>

	</div>

<?php endif; ?>
