<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * Dashboard. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * this starts the plugin.
 *
 * @since             1.0.0
 * @package           WPInv_SagePay
 *
 * @wordpress-plugin
 * Plugin Name:       Invoicing SagePay Payment Gateway
 * Plugin URI:        https://wpgeodirectory.com/invoicing-sagepay-payment/
 * Description:       This is a short description of what the plugin does. It's displayed in the WordPress dashboard.
 * Version:           1.0.2
 * Author:            GeoDirectory Team
 * Author URI:        https://wpgeodirectory.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       wpinv-sagepay
 * Domain Path:       /languages
 * Update URL:        https://wpinvoicing.com
 * Update ID:         83
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( is_admin() ) {
    include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
    
    if ( !is_plugin_active( 'invoicing/invoicing.php' ) ) {
        return;
    }
}

if ( !defined( 'WPINV_SAGEPAY_VERSION' ) ) {
    define( 'WPINV_SAGEPAY_VERSION', '1.0.2' );
}

if ( !defined( 'WPINV_SAGEPAY_TEXTDOMAIN' ) ) {
    define( 'WPINV_SAGEPAY_TEXTDOMAIN', 'wpinv-sagepay' );
}

if ( !defined( 'WPINV_SAGEPAY_FILE' ) ) {
    define( 'WPINV_SAGEPAY_FILE', __FILE__ );
}

if ( !defined( 'WPINV_SAGEPAY_DIR' ) ) {
    define( 'WPINV_SAGEPAY_DIR', plugin_dir_path( WPINV_SAGEPAY_FILE ) );
}

if ( !defined( 'WPINV_SAGEPAY_URL' ) ) {
    define( 'WPINV_SAGEPAY_URL', plugin_dir_url( WPINV_SAGEPAY_FILE ) );
}

/**
 * The core plugin class that is used to define internationalization,
 * dashboard-specific hooks, and public-facing site hooks.
 */
require_once WPINV_SAGEPAY_DIR . 'includes/class-wpinv-sagepay.php';

/** This action is documented in includes/class-wpinv-sagepay-activator.php */
register_activation_hook( WPINV_SAGEPAY_FILE, array( 'WPInv_SagePay', 'activate' ) );

/** This action is documented in includes/class-wpinv-sagepay-deactivator.php */
register_activation_hook( WPINV_SAGEPAY_FILE, array( 'WPInv_SagePay', 'deactivate' ) );

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_wpinv_sagepay() {
	global $wpinv_sagepay;
    $wpinv_sagepay = new WPInv_SagePay();
	$wpinv_sagepay->run();
}
run_wpinv_sagepay();
