<?php
/**
 * The dashboard-specific functionality of the plugin.
 *
 * @link       https://wpgeodirectory.com
 * @since      1.0.0
 *
 * @package    WPInv_SagePay
 * @subpackage WPInv_SagePay/includes
 */

/**
 * The dashboard-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the dashboard-specific stylesheet and JavaScript.
 *
 * @package    WPInv_SagePay
 * @subpackage WPInv_SagePay/admin
 * @author     GeoDirectory <info@wpgeodirectory.com>
 */
class WPInv_SagePay_Admin {
	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $name    The ID of this plugin.
	 */
	private $name;

    /**
	 * The domain specified for this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $domain    The domain identifier for this plugin.
	 */
	private $domain;
    
	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @var      string    $name       The name of this plugin.
	 * @var      string    $version    The version of this plugin.
	 * @var      string    $domain    The domain identifier for this plugin.
	 */
	public function __construct( $name, $domain, $version ) {
		$this->name = $name;
        $this->domain = $domain;
		$this->version = $version;
	}

	public function activation_redirect() {
		// Bail if no activation redirect
		if ( !get_transient( '_wpinv_sagepay_activation_redirect' ) ) {
			return;
		}

		// Delete the redirect transient
		delete_transient( '_wpinv_sagepay_activation_redirect' );

		// Bail if activating from network, or bulk
		if ( is_network_admin() || isset( $_GET['activate-multi'] ) ) {
			return;
		}

		wp_safe_redirect( admin_url( 'admin.php?page=wpinv-settings&tab=gateways&section=sagepay' ) );
		exit;
	}

	/**
	 * Register the stylesheets for the Dashboard.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {
	}

	/**
	 * Register the JavaScript for the dashboard.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {
	}

    public function add_gateway( $gateways = array() ) {
        $gateways['sagepay'] = array(
            'admin_label'    => __( 'SagePay Payment', $this->domain ),
            'checkout_label' => __( 'SagePay Payment', $this->domain ),
            'ordering'       => 10,
        );
        
        return $gateways;
    }
    
    public function gateway_settings( $settings ) {        
        $settings['sagepay_sandbox'] = array(
                'type' => 'checkbox',
                'id'   => 'sagepay_sandbox',
                'name' => __( 'SagePay Test Mode', $this->domain ),
                'desc' => __( 'This provides a special Test Environment to enable you to test your installation and integration to your website before going live.', $this->domain ),
                'std'  => 1
            );
            
        $settings['sagepay_username'] = array(
                'type' => 'text',
                'id'   => 'sagepay_username',
                'name' => __( 'Username', $this->domain ),
                'desc' => __( 'Your SagePay account username. Ex: mySagePayUsername ', $this->domain ),
                'std' => 'mySagePayUsername',
            );
            
        $settings['sagepay_encrypt_password'] = array(
                'type' => 'text',
                'id'   => 'sagepay_encrypt_password',
                'name' => __( 'Encryption Password', $this->domain ),
                'desc' => __( 'Your SagePay account encryption password. Ex: 479f49451e829890', $this->domain ),
                'std' => '479f49451e829897',
            );
        
        $settings['sagepay_ipn_url'] = array(
                'type' => 'ipn_url',
                'id'   => 'sagepay_ipn_url',
                'name' => __( 'ITN Url', $this->domain ),
                'std' => wpinv_get_ipn_url( 'sagepay' ),
                'desc' => __( 'SagePay payment callback url (should not be changed)', $this->domain ),
                'size' => 'large',
                'custom' => 'sagepay',
                'readonly' => true
            );
            
        return $settings;
    }
}
