class wpdevart_org_chart_front{
	constructor(container, options = {} ){
		var def_options = {
			mobile_frendly:'mobile',
			mobile_size: 450,
			def_scroll: 0,
			zoomable: 'disable',
			draggable: 'disable',
			max_zoomable: '1',
			min_zoomable: '10',
			zoom_speed: '10',
		}
		this.options = Object.assign(def_options, options);
		var self = this;
		this.container=document.getElementById( container );
		this.container_id = this.container.getAttribute( "id" );
		this.container_width = this.container.clientWidth;
		if(options.mobile_frendly == 'mobile' || options.mobile_frendly == 'mob_view_only_on_mob'){	
			window.addEventListener('resize', function(){ 
				self.set_mobile_class(); 
				self.create_tree_line_mobile_css(); 
			});			
			self.container_width = self.container.clientWidth;
			self.set_mobile_class();
			self.create_tree_line_mobile_css();			
		}else{
			self.setResponsiveAfterThis();
			self.create_tree_line_mobile_css();	
		}
		self.set_def_scroll();
		self.set_zoomable();		
	}

	set_mobile_class(){
		var self = this, check_only_mob = true, elementAfterMobile = document.getElementsByClassName('has_children chart_wpda_mobile_before');
		self.mob_width = Math.min( window.innerWidth, self.container.parentElement.parentElement.clientWidth );
		if(this.options.mobile_frendly == 'mob_view_only_on_mob'){
			check_only_mob = (window.innerWidth <= this.options.mobile_size)
		}
		if(self.mob_width <= self.container_width && check_only_mob){
			self.container.classList.add('wpda_mobile');
			self.container.setAttribute('style','');
			self.resetResponsiveAfterThis();
			
		}else{
			self.container.classList.remove( 'wpda_mobile' );
			self.container.style.marginTop = "0";
			self.setResponsiveAfterThis();		
		}
	}

	setResponsiveAfterThis(){
		let elementAfterMobile = document.getElementsByClassName('has_children chart_wpda_mobile_before');
		for(let i = 0; i < elementAfterMobile.length; i++){			
			if(this.checkElementParentsHasClassName(elementAfterMobile[i].parentElement,'chart_wpda_mobile_before')){
				continue;
			}			
			let liWidth = elementAfterMobile[i].offsetWidth,childDivWidth = elementAfterMobile[i].getElementsByTagName('div')[0].offsetWidth,ulElement = elementAfterMobile[i].getElementsByTagName('ul')[0];
			ulElement.style.left = parseFloat((liWidth - childDivWidth - 10)/2) + 'px';
		}
	}

	resetResponsiveAfterThis(){
		let elementAfterMobile = document.getElementsByClassName('has_children chart_wpda_mobile_before');
		for(let i = 0; i < elementAfterMobile.length; i++){			
			if(this.checkElementParentsHasClassName(elementAfterMobile[i].parentElement,'chart_wpda_mobile_before')){
				continue;
			}			
			let ulElement = elementAfterMobile[i].getElementsByTagName('ul')[0];
			ulElement.style.left = 'initial';
		}
	}



	checkElementParentsHasClassName(element,nameOfClass){
		if (element.className.split(' ').indexOf(nameOfClass)>=0) 
			return true;
		return element.parentElement && this.checkElementParentsHasClassName(element.parentElement, nameOfClass);
	}

	set_def_scroll(){
		var self = this, scroll_pixels = 0, diff = 0;
		diff = (self.container.parentElement.parentElement.clientWidth - self.container_width)
		if(diff >= 0){
			return;
		}		
		scroll_pixels = parseInt( Math.abs( diff ) * self.options.def_scroll / 100 );
		self.container.parentElement.scrollTo( scroll_pixels, 0);
	}

	create_tree_line_mobile_css(){
		let self = this;
		if(self.container.classList.contains( 'first_child_hidden' ) && self.container.classList.contains( 'wpda_mobile' )){
			let firstElementHeight = self.container.getElementsByTagName( 'ul' )[0].getElementsByTagName( 'li' )[0].getElementsByTagName( 'ul' )[0].getElementsByTagName('li')[0].getElementsByClassName( 'wpda_tree_item_container' )[0].offsetHeight;
			let line_css = document.getElementById(self.container_id + "_line_css");		
			if(line_css == null){
				line_css = document.createElement("style");
				line_css.setAttribute("id", self.container_id + "_line_css");
				line_css.innerHTML = '.wpda_mobile.first_child_hidden#' + self.container_id + ' > ul > li > ul > li:first-child::before{top: ' + parseInt(firstElementHeight / 2) + 'px; height: calc(100% -  ' + parseInt( firstElementHeight / 2 ) + 'px); }';
				document.getElementsByTagName('body')[0].appendChild( line_css );				
			}else{
				line_css.innerHTML = '.wpda_mobile.first_child_hidden#' + self.container_id + ' > ul > li > ul > li:first-child::before{top: ' + parseInt(firstElementHeight/2) + 'px; height: calc(100% -  ' + parseInt(firstElementHeight/2) + 'px); }';
			}
		}		
	}

	set_zoomable(){		
		let zoomableButtonsDiv = this.container.parentElement.parentElement.getElementsByClassName('zoomable_buttons_container');		
		if(zoomableButtonsDiv.length > 0 || this.options.zoomable == 'enable_shift' || this.options.zoomable == 'enable' || this.options.draggable == 'enable' || this.options.draggable == 'horizontal' || this.options.draggable == 'vertical'){
			let self = this;
			let zoomableElement = this.container.getElementsByTagName('ul')[0];
			let parent = zoomableElement.parentElement;
			let options = {
				maxScale: parseFloat( self.options.max_zoomable ),
				maxZoom: parseFloat( self.options.max_zoomable ),
				minScale: parseFloat( 1 / self.options.min_zoomable ),
				minZoom: parseFloat( 1 / self.options.min_zoomable ),
				step: 0.01 * parseFloat( self.options.zoom_speed ),
			}
			console.log(options)
			switch(this.options.draggable){
				case 'horizontal':
					options['disableYAxis'] = true;
				break;
				case 'vertical':
					options['disableXAxis'] = true;
				break;
				case 'disable':
					options['disableXAxis'] = true;
					options['disableYAxis'] = true;
				break;
			}
			self.panzoom = panZoom(zoomableElement, options);
			/// add events
			if(self.options.zoomable == 'enable_shift'){
				parent.addEventListener('wheel', function(event) {
					if (!event.shiftKey) return;
					self.panzoom.zoomWithWheel(event);
				})
			}
			if(self.options.zoomable == 'enable'){
				parent.addEventListener('wheel', function(event) {
					self.panzoom.zoomWithWheel(event);
				})
			}
			
			if(zoomableButtonsDiv.length > 0){
				zoomableButtonsDiv = zoomableButtonsDiv[0];
				let zoomIn = zoomableButtonsDiv.getElementsByClassName('wpda_zoom_in'),
				zoomOut = zoomableButtonsDiv.getElementsByClassName('wpda_zoom_out'),
				zoomReset = zoomableButtonsDiv.getElementsByClassName('wpda_zoom_reset'),
				fullScreen = zoomableButtonsDiv.getElementsByClassName('wpda_fullScreen'),
				outFullScreen = zoomableButtonsDiv.getElementsByClassName('wpda_outfullscreen');
				console.log(fullScreen)
				if(zoomIn.length > 0){
					zoomIn[0].addEventListener('click', self.panzoom.zoomIn)					
				}
				if(zoomOut.length > 0){
					zoomOut[0].addEventListener('click', self.panzoom.zoomOut)					
				}
				if(zoomReset.length > 0){
					zoomReset[0].addEventListener('click', self.panzoom.reset)					
				}
				
				if(fullScreen.length > 0){
					fullScreen[0].addEventListener('click', function(){
						self.container.prepend(zoomableButtonsDiv);
						self.container.style.overflowX = 'auto';
						zoomableButtonsDiv.style.position = 'fixed'
						self.container.requestFullscreen();
						this.style.display = 'none';
						outFullScreen[0].style.display = 'inline-block';
					})
					outFullScreen[0].addEventListener('click', function(){
						self.container.parentElement.prepend(zoomableButtonsDiv);
						self.container.style.overflowX = 'hidden';
						zoomableButtonsDiv.style.position = 'absolute';
						document.exitFullscreen();
						this.style.display = 'none';
						fullScreen[0].style.display = 'inline-block';
					});
					document.addEventListener('fullscreenchange',function(){
						
						if(document.fullscreenElement == null){
							if(fullScreen.length > 0){
								outFullScreen[0].style.display = 'none';
								fullScreen[0].style.display = 'inline-block';
								self.container.parentElement.prepend(zoomableButtonsDiv);
								self.container.style.overflowX = 'hidden';
								zoomableButtonsDiv.style.position = 'absolute';
							}							
						}
					});		
				}
			}					
		}
	}
	
}