<?php
/**
 * Plugin Name: WP Simple Booking Calendar
 * Plugin URI:  http://www.wpsimplebookingcalendar.com
 * Description: WP Simple Booking Calendar.
 * Version:     6.2.6
 * Author:      WP Simple Booking Calendar
 * Author URI:  http://www.wpsimplebookingcalendar.com
 *
 * Copyright (c) 2016 WP Simple Booking Calendar
 */



include 'include/createTables.php';
register_activation_hook( __FILE__, 'wpsbc_install' );

define("MIN_USER_CAPABILITY", "manage_options");
define("WPSBC_PATH",plugins_url('',__FILE__));
define("WPSBC_DIR_PATH",dirname(__FILE__));

add_action( 'plugins_loaded', 'wpsbc_load_textdomain' );
function wpsbc_load_textdomain() {
    load_plugin_textdomain( 'wpsbc', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' ); 
}


include 'include/calendarLanguages.php';
include 'include/calendarFunctions.php';
include 'include/calendarAdmin.php';
include 'include/calendarCore.php';
include 'include/calendarAjax.php';

include 'include/pluginStructure.php';
include 'include/pluginShortcodeButton.php';
include 'include/pluginShortcode.php';
include 'include/pluginWidget.php';


if(get_option('timezone_string')){
    @date_default_timezone_set(get_option('timezone_string'));    
}
if(get_option('gmt_offset')){
    @date_default_timezone_set(wpsbc_tz_offset_to_name(get_option('gmt_offset')));

}

if (is_admin()) {
    add_action('admin_head','wpsbc_prevent_iphone_format');
    function wpsbc_prevent_iphone_format(){
        echo '<meta name="format-detection" content="telephone=no" />';
    }
    
	add_action('admin_menu', 'wpsbc_menu');   
    function wpsbc_admin_enqueue_files() {
        wp_enqueue_style( 'wpsbc-calendar', WPSBC_PATH . '/css/wpsbc-calendar.css' );
        wp_enqueue_style( 'wpsbc-admin', WPSBC_PATH . '/css/wpsbc-admin.css' );
        wp_enqueue_style( 'colorpicker', WPSBC_PATH . '/css/colorpicker.css' );
        wp_enqueue_style( 'chosen', WPSBC_PATH . '/css/chosen.min.css' );
        
        
        wp_enqueue_script('wpsbc-admin', WPSBC_PATH . '/js/wpsbc-admin.js', array('jquery'));
        wp_enqueue_script('wpsbc-colorpicker', WPSBC_PATH . '/js/colorpicker.js', array('jquery'));
        wp_enqueue_script('custom-select', WPSBC_PATH . '/js/custom-select.js', array('jquery'));
        wp_enqueue_script('chosen', WPSBC_PATH . '/js/chosen.jquery.min.js', array('jquery'));
        


    }
    add_action( 'admin_init', 'wpsbc_admin_enqueue_files' );       
} else {
    function wpsbc_enqueue_files() {
        wp_enqueue_style( 'wpsbc-calendar', WPSBC_PATH . '/css/wpsbc-calendar.css' );
        wp_enqueue_script('wpsbc', WPSBC_PATH . '/js/wpsbc.js', array('jquery'));
        wp_enqueue_script('custom-select', WPSBC_PATH . '/js/custom-select.js', array('jquery'));    
    }
    $wpsbcOptions = json_decode(get_site_option('wpsbc-options'),true);  
    if(!empty($wpsbcOptions['alwaysEnqueueScripts']) && $wpsbcOptions['alwaysEnqueueScripts'] == 'yes'){
        add_action( 'wp_enqueue_scripts', 'wpsbc_enqueue_files' );    
    }
    
            
    add_action('wp_head','wpsbc_ajaxurl');
}

//Admin Menu
function wpsbc_menu(){
    add_menu_page( 'WP Simple Booking Calendar', 'WP Simple Booking Calendar', 'read', 'wp-simple-booking-calendar-premium', 'wpsbc_calendars', WPSBC_PATH . '/images/date-button.gif' , 108 );
    add_submenu_page( 'wp-simple-booking-calendar-premium', __('Calendars','wpsbc'), __('Calendars','wpsbc'), 'read', 'wp-simple-booking-calendar-premium', 'wpsbc_calendars' );
    add_submenu_page( 'wp-simple-booking-calendar-premium', __('Default Legend','wpsbc'), __('Default Legend','wpsbc'), 'read', 'wp-simple-booking-calendar-premium-default-legend', 'wpsbc_default_legend' );
    add_submenu_page( 'wp-simple-booking-calendar-premium', __('Sync'), __('Sync'), 'read_private_pages', 'wp-simple-booking-calendar-ical', 'wpsbc_ical' );
    add_submenu_page( 'wp-simple-booking-calendar-premium', __('Settings','wpsbc'), __('Settings','wpsbc'), 'read', 'wp-simple-booking-calendar-settings', 'wpsbc_settings' );  
    
}

// Ajax Hooks
add_action('wp_ajax_changeDayAdmin', 'wpsbc_changeDayAdmin_callback');
add_action('wp_ajax_changeDay', 'wpsbc_changeDay_callback');
add_action('wp_ajax_nopriv_changeDay', 'wpsbc_changeDay_callback');

function wpsbc_ajaxurl() {
    ?>
    <script type="text/javascript">var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';</script>
    <?php
}


$wpsbcOptions = json_decode(get_option('wpsbc-options'),true);
if( @$wpsbcOptions['enableiCal'] == 'yes' && isset($_GET['wp-simple-booking-calendar-ical']) && !empty($_GET['wp-simple-booking-calendar-ical'])){
    include 'include/pluginiCal.php';
    die();
}