<?php global $wpdb;?>
<div class="wrap wpsbc-wrap">
    <div id="icon-themes" class="icon32"></div>
    <h2><?php echo __('Settings','wpsbc');?></h2>
    <?php if(!empty($_GET['save']) && $_GET['save'] == 'ok'):?>
    <div id="message" class="updated">
        <p><?php echo __('The settings were saved.','wpsbc')?></p>
    </div>
    <?php endif;?>
    
        <div class="postbox-container">
            
            <form action="<?php echo admin_url( 'admin.php?page=wp-simple-booking-calendar-settings&do=save&noheader=true');?>" method="post">
            <div class="wpsbc-action-buttons"><input type="submit" class="button button-primary button-h2" value="<?php echo __('Save Changes','wpsbc');?>" /> </div>
            
            <div class="metabox-holder">
                <div class="postbox">
                    <div class="handlediv" title="Click to toggle"><br /></div>
                    <h3 class="hndle"><?php echo __('General Settings','wpsbc');?></h3>
                    <div class="inside">     
                        <?php $wpsbcOptions = json_decode(get_site_option('wpsbc-options'),true);?>  
                        
                        <div class="wpsbc-settings-col">
                            <div class="wpsbc-settings-col-left">
                                <strong><?php echo __("Date Format",'wpsbc') ;?></strong>                                
                            </div>
                            <div class="wpsbc-settings-col-right wpsbc-date-format">
                                <label><input class="small" type="radio" id="" name="dateFormat" <?php if(!empty($wpsbcOptions['dateFormat']) && $wpsbcOptions['dateFormat'] == 'j F Y'): ?>checked="checked"<?php endif;?> value="j F Y" /> 25 <?php _e('July');?> 2013</label>
                                <label><input class="small" type="radio" id="" name="dateFormat"<?php if(!empty($wpsbcOptions['dateFormat']) && $wpsbcOptions['dateFormat'] == 'F j, Y'): ?>checked="checked"<?php endif;?> value="F j, Y" /> <?php _e('July');?> 25, 2013</label>
                                <label><input class="small" type="radio" id="" name="dateFormat"<?php if(!empty($wpsbcOptions['dateFormat']) && $wpsbcOptions['dateFormat'] == 'Y/m/d'): ?>checked="checked"<?php endif;?> value="Y/m/d" /> 2013/07/25</label>
                                <label><input class="small" type="radio" id="" name="dateFormat"<?php if(!empty($wpsbcOptions['dateFormat']) && $wpsbcOptions['dateFormat'] == 'm/d/Y'): ?>checked="checked"<?php endif;?> value="m/d/Y" /> 07/25/2013</label>
                                <label><input class="small" type="radio" id="" name="dateFormat"<?php if(!empty($wpsbcOptions['dateFormat']) && $wpsbcOptions['dateFormat'] == 'd/m/Y'): ?>checked="checked"<?php endif;?> value="d/m/Y" /> 25/07/2013</label>
                            </div>
                            <div class="wpsbc-clear"></div>                            
                        </div>   
                          
                        <div class="wpsbc-settings-col">
                            <div class="wpsbc-settings-col-left">
                                <strong><?php echo __('Booking History Color','wpsbc');?></strong>                                
                            </div>
                            <div class="wpsbc-settings-col-right wpsbc-colorpicker">
                                <span class="color-box" id="historyColorBox"  style="background-color:<?php echo $wpsbcOptions['historyColor'];?>;"><!-- --></span>
                                <input class="small" type="text" id="historyColor" name="historyColor" value="<?php echo $wpsbcOptions['historyColor'];?>" />
                                <small><?php echo __("The color that will be used if you select 'Use Booking History Color' when you generate a shortcode.",'wpsbc');?></small>
                            </div>
                            <div class="wpsbc-clear"></div>                            
                        </div> 
                        <div class="wpsbc-settings-col">
                            <div class="wpsbc-settings-col-left">
                                <strong><?php echo __('Backend Start Day','wpsbc');?></strong>                                
                            </div>
                            <?php if(empty($wpsbcOptions['backendStartDay'])) $wpsbcOptions['backendStartDay'] = 1;?>
                            <div class="wpsbc-settings-col-right">
                                <select name="backend-start-day">
                                    <option <?php if($wpsbcOptions['backendStartDay'] == 1):?>selected="selected"<?php endif;?> value="1"><?php _e('Monday');?></option>
                                    <option <?php if($wpsbcOptions['backendStartDay'] == 2):?>selected="selected"<?php endif;?> value="2"><?php _e('Tuesday');?></option>
                                    <option <?php if($wpsbcOptions['backendStartDay'] == 3):?>selected="selected"<?php endif;?> value="3"><?php _e('Wednesday');?></option>
                                    <option <?php if($wpsbcOptions['backendStartDay'] == 4):?>selected="selected"<?php endif;?> value="4"><?php _e('Thursday');?></option>
                                    <option <?php if($wpsbcOptions['backendStartDay'] == 5):?>selected="selected"<?php endif;?> value="5"><?php _e('Friday');?></option>
                                    <option <?php if($wpsbcOptions['backendStartDay'] == 6):?>selected="selected"<?php endif;?> value="6"><?php _e('Saturday');?></option>
                                    <option <?php if($wpsbcOptions['backendStartDay'] == 7):?>selected="selected"<?php endif;?> value="7"><?php _e('Sunday');?></option>
                                </select>
                            </div> 
                            <div class="wpsbc-clear"></div>                            
                        </div> 
                        <div class="wpsbc-settings-col">
                            <div class="wpsbc-settings-col-left">
                                <strong><?php echo __('Always enqueue scripts and styles','wpsbc');?></strong>                                
                            </div>
                            <div class="wpsbc-settings-col-right">
                                <select name="always-enqueue-scripts">
                                    <option <?php if(!empty($wpsbcOptions['alwaysEnqueueScripts']) && $wpsbcOptions['alwaysEnqueueScripts'] == 'no'):?>selected="selected"<?php endif;?> value="no"><?php _e('No');?></option>
                                    <option <?php if(!empty($wpsbcOptions['alwaysEnqueueScripts']) && $wpsbcOptions['alwaysEnqueueScripts'] == 'yes'):?>selected="selected"<?php endif;?> value="yes"><?php _e('Yes');?></option>
                                    
                                </select>
                                <br /><small><?php echo __("If you are loading the calendar with ajax then you should set this option to 'Yes'.",'wpsbc');?></small>
                            </div>
                            <div class="wpsbc-clear"></div>                            
                        </div> 
                        <div class="wpsbc-settings-col">
                            <div class="wpsbc-settings-col-left">
                                <strong><?php echo __("iCalendar Sync",'wpsbc') ;?></strong><br />
                            </div>
                            <div class="wpsbc-settings-col-right">

                                    <label><input type="checkbox" name="enable_ical" <?php if(!empty($wpsbcOptions['enableiCal']) && $wpsbcOptions['enableiCal'] == 'yes'):?>checked="checked"<?php endif;?> value="yes" /> <?php _e("Enable",'wpsbc');?></label>
                                
                            </div>
                            <div class="wpsbc-clear"></div>
                            
                        </div> 
                    </div>
                </div>
            </div> 
           
            
            <div class="metabox-holder">
                <div class="postbox">
                    
                    <h3 class="hndle"><?php echo __('Languages','wpsbc');?></h3>
                    <div class="inside">
                        <?php $activeLanguages = json_decode(get_site_option('wpsbc-languages'),true);?>
                        <?php $languages = array('en' => 'English', 'bg' => 'Bulgarian','ca' => 'Catalan','hr' => 'Croatian','cz' => 'Czech','da' => 'Danish','nl' => 'Dutch','et' => 'Estonian','fi' => 'Finnish','fr' => 'French','de' => 'German','el' => 'Greek','hu' => 'Hungarian','it' => 'Italian', 'jp' => 'Japanese', 'lt' => 'Lithuanian', 'no' => 'Norwegian','pl' => 'Polish','pt' => 'Portugese','ro' => 'Romanian','ru' => 'Russian','sk' => 'Slovak','sl' => 'Slovenian','es' => 'Spanish','sv' => 'Swedish','tr' => 'Turkish','ua' => 'Ukrainian');?>    
                        <div class="wpsbc-settings-col">
                            <div class="wpsbc-settings-col-left">
                                <strong><?php echo __('Languages','wpsbc');?></strong><br />
                                <small><?php echo __('What languages do you <br />want to use?','wpsbc');?></small>
                            </div>
                            <div class="wpsbc-settings-col-right">
                                <?php foreach($languages as $code => $language):?>
                                    <label><input type="checkbox" name="<?php echo $code;?>" <?php if(in_array($language,$activeLanguages)):?>checked="checked"<?php endif;?> value="<?php echo $code;?>" /> <?php echo $language;?></label>
                                <?php endforeach;?>
                            </div>
                            <div class="wpsbc-clear"></div>
                            
                        </div> 
                        
                    </div>
                </div>
            </div> 
            <br /><input type="submit" class="button button-primary" value="<?php echo __('Save Changes','wpsbc');?>" /> 
            </form>
        </div>
<script>
jQuery(document).ready(function(){
    wpsbc('#historyColor').ColorPicker({
		color: '<?php echo $wpsbcOptions['historyColor'];?>',
		onShow: function (colpkr) {
			wpsbc(colpkr).fadeIn(500);
			return false;
		},
		onHide: function (colpkr) {
			wpsbc(colpkr).fadeOut(500);
			return false;
		},
		onChange: function (hsb, hex, rgb) {
			wpsbc('#historyColorBox').css('backgroundColor', '#' + hex);
            wpsbc('#historyColor').val('#' + hex);
		}
	});

})
</script>
</div>

