<?php global $wpdb;?>
<div class="wrap wpsbc-wrap">
    <div id="icon-themes" class="icon32"></div>
    <h2><?php _e('Sync');?></h2>
    <?php $wpsbcOptions = json_decode(get_option('wpsbc-options'),true); if(@$wpsbcOptions['enableiCal'] != 'yes'):?>
        <div class="error settings-error notice"> 
            <p><?php echo __("Sync is disabled. Please go to the settings page to enable it.",'wpsbc') ;?></p>
        </div>
    <?php else:?>
        <?php $sql = 'SELECT * FROM ' . $wpdb->prefix . 'sbc_calendars';?>
        <?php $rows = $wpdb->get_results( $sql, ARRAY_A );?>
        
        <?php if($wpdb->num_rows > 0):?>
        <table class="widefat wp-list-table wpsbc-table wpsbc-table-ical wpsbc-table-800">
            <thead>
                <tr>
                    <th class="wpsbc-table-id"><?php echo __('ID','wpsbc')?></th>
                    <th><?php echo __('Calendar Title','wpsbc')?></th>   
                    <th style="width: 60%;"><?php echo __('iCalendar Link','wpsbc')?></th>
                    <th style="width: 20%;"><?php echo __('Options','wpsbc')?></th>
                </tr>
            </thead>
            
            <tbody>                
                <?php $i=0; foreach($rows as $calendar):
                if( ! (current_user_can( 'manage_options' ) || @in_array( get_current_user_id(), json_decode($calendar['calendarUsers']) )) ) continue;?>
              
                
                
                <tr<?php if($i++%2==0):?> class="alternate"<?php endif;?>>
                    <td class="wpsbc-table-id">#<?php echo $calendar['calendarID']; ?></td>
                    <td class="post-title page-title column-title wpsbc-table-ical-title">
                        <strong><?php echo $calendar['calendarTitle']; ?></strong>
                        
                    </td>
                    <td><span class="wpsbc-ical-link" onclick="wpsbc_select_text(this);"><?php echo site_url();?>/?wp-simple-booking-calendar-ical=<?php echo $calendar['calendarHash'];?></span></td>
                    <td class="wpsbc-table-options"><a onclick="return confirm('<?php echo __("Are you sure you want to reset the private key? The current key will no longer work.",'wpsbc') ;?>');" href="<?php echo admin_url( 'admin.php?page=wp-simple-booking-calendar-premium&do=reset-private-key&id=' . $calendar['calendarID'] . '&noheader=true' );?>">reset private link</a></td>
                </tr>
                <?php endforeach;?>
            </tbody>
        </table>
        <?php else:?>
            <?php echo __('No calendars found.','wpsbc')?> <a href="<?php echo admin_url( 'admin.php?page=wp-simple-booking-calendar&do=edit-calendar');?>"><?php echo __("Click here to create your first calendar.",'wpsbc') ;?></a>
        <?php endif;?>
    <?php endif;?>
    
</div>