<?php global $wpdb;?>
<div class="wrap wpsbc-wrap">
    <div id="icon-themes" class="icon32"></div>
    <h2>WP Simple Booking Calendar 
    <?php if( current_user_can(MIN_USER_CAPABILITY) ):?>
    <a href="<?php echo admin_url( 'admin.php?page=wp-simple-booking-calendar-premium&do=edit-calendar');?>" class="add-new-h2"><?php echo __('Add New','wpsbc');?></a>
    <?php endif;?>
    </h2>
    <?php if(!empty($status) && $status == 1):?>
    <div id="message" class="updated">
        <p><?php echo __('The calendar was updated','wpsbc')?></p>
    </div>
    <?php endif;?>

    <?php 
    
    $order = (!isset($_GET['order'])) ? 'asc' : ($_GET['order'] == 'desc') ? 'desc' : 'asc';
    $orderby = (!isset($_GET['orderby'])) ? 'id' : $_GET['orderby'];
    switch($orderby){
        case 'id':
            $orderbyQuery = 'ORDER BY calendarId';
            break;
        case 'title':
            $orderbyQuery = 'ORDER BY calendarTitle';
            break;
        case 'created':
            $orderbyQuery = 'ORDER BY createdDate';
            break;
        case 'modified':
            $orderbyQuery = 'ORDER BY modifiedDate';
            break;
        default:
            $orderbyQuery = 'ORDER BY calendarId';
    }
    ?>
    <?php $sql = 'SELECT * FROM ' . $wpdb->base_prefix . 'sbc_calendars ' . $orderbyQuery . ' ' . $order;?>
    <?php $rows = $wpdb->get_results( $sql, ARRAY_A );?>
    
    <?php if($wpdb->num_rows > 0):?>
    <table class="widefat wp-list-table wpsbc-table wpsbc-table-calendars wpsbc-table-800">
        <thead>
            <tr>
                <?php $orderItem = ($orderby == 'id' && $order == 'asc') ? 'asc' : 'desc';?>
                <th style="width: 50px;" class="sortable <?php echo ($orderby == 'id') ? $order : 'desc';?> <?php if($orderby == 'id') echo 'sorted';?>">
                    <?php $orderItem = ($orderby == 'id' && $order == 'asc') ? 'desc' : 'asc';?>
                    <a href="<?php echo admin_url( 'admin.php?page=wp-simple-booking-calendar-premium&orderby=id&order=' . $orderItem );?>">
                        <span><?php echo __('ID','wpsbc')?></span>
                        <span class="sorting-indicator"></span>
                    </a>
                </th>
                                
                <?php $orderItem = ($orderby == 'title' && $order == 'asc') ? 'asc' : 'desc';?>
                <th class="sortable <?php echo ($orderby == 'title') ? $order : 'desc';?> <?php if($orderby == 'title') echo 'sorted';?>">
                    <?php $orderItem = ($orderby == 'title' && $order == 'asc') ? 'desc' : 'asc';?>
                    <a href="<?php echo admin_url( 'admin.php?page=wp-simple-booking-calendar-premium&orderby=title&order=' . $orderItem );?>">
                        <span><?php echo __('Calendar Title','wpsbc')?></span>
                        <span class="sorting-indicator"></span>
                    </a>
                </th>
                
                <?php $orderItem = ($orderby == 'created' && $order == 'asc') ? 'asc' : 'desc';?>
                <th class="sortable <?php echo ($orderby == 'created') ? $order : 'desc';?> <?php if($orderby == 'created') echo 'sorted';?>">
                    <?php $orderItem = ($orderby == 'created' && $order == 'asc') ? 'desc' : 'asc';?>
                    <a href="<?php echo admin_url( 'admin.php?page=wp-simple-booking-calendar-premium&orderby=created&order=' . $orderItem );?>">
                        <span><?php echo __('Date Created','wpsbc')?></span>
                        <span class="sorting-indicator"></span>
                    </a>
                </th> 
                
                <?php $orderItem = ($orderby == 'modified' && $order == 'asc') ? 'asc' : 'desc';?>
                <th class="sortable <?php echo ($orderby == 'modified') ? $order : 'desc';?> <?php if($orderby == 'modified') echo 'sorted';?>">
                    <?php $orderItem = ($orderby == 'modified' && $order == 'asc') ? 'desc' : 'asc';?>
                    <a href="<?php echo admin_url( 'admin.php?page=wp-simple-booking-calendar-premium&orderby=modified&order=' . $orderItem );?>">
                        <span><?php echo __('Date Modified','wpsbc')?></span>
                        <span class="sorting-indicator"></span>
                    </a>
                </th> 
                
                 
            </tr>
        </thead>
        
        <tbody>                
            <?php $i=0; foreach($rows as $calendar): 
            if( ! (current_user_can( MIN_USER_CAPABILITY ) || @in_array( get_current_user_id(), json_decode($calendar['calendarUsers']) )) ) continue;?>
            <tr<?php if($i++%2==0):?> class="alternate"<?php endif;?>>
                <td class="">#<?php echo $calendar['calendarID']; ?></td>
                <td class="post-title page-title column-title">
                    <strong><a class="row-title" href="<?php echo admin_url( 'admin.php?page=wp-simple-booking-calendar-premium&do=edit-calendar&id=' . $calendar['calendarID']);?>"><?php echo $calendar['calendarTitle']; ?></a></strong>
                    <div class="row-actions">
                        <span class="edit"><a href="<?php echo admin_url( 'admin.php?page=wp-simple-booking-calendar-premium&do=edit-calendar&id=' . $calendar['calendarID']);?>" title="<?php echo __('Edit this item','wpsbc');?>"><?php echo __('Edit','wpsbc');?></a> | </span>
                        <span class="trash"><a onclick="return confirm('<?php echo __('Are you sure you want to delete this calendar?','wpsbc');?>');" class="submitdelete" href="<?php echo admin_url( 'admin.php?page=wp-simple-booking-calendar-premium&do=calendar-delete&id=' . $calendar['calendarID'] . '&noheader=true');?>"><?php echo __('Delete','wpsbc');?></a></span>
                    </div>
                </td>
                <td><?php echo wpsbc_timeFormat($calendar['createdDate'])?></td>
                <td><?php echo wpsbc_timeFormat($calendar['modifiedDate']) ?></td>
            </tr>
            <?php endforeach;?>
        </tbody>
    </table>
    <?php else:?>
        <?php echo __('No calendars found.','wpsbc')?> <a href="<?php echo admin_url( 'admin.php?page=wp-simple-booking-calendar-premium&do=edit-calendar');?>"><?php echo __('Click here to create your first calendar.','wpsbc');?></a>
    <?php endif;?>
</div>