<?php
class wpsbc_widget extends WP_Widget {
    public function __construct(){
        parent::__construct(false, $name = 'WP Simple Booking Calendar', array(
            'description' => 'WP Simple Booking Calendar Widget'
        ));
    }
    function widget($args, $instance) {
        global $post;
        extract( $args );        
        
        echo $args['before_widget'];
        
        echo '<div class="wpsbc-widget">';       
        echo do_shortcode('[wpsbc id="'.$instance['wpsbc_select_calendar'].'" title="'.$instance['wpsbc_show_title'].'" legend="'.$instance['wpsbc_show_legend'].'" dropdown="'.$instance['wpsbc_show_dropdown'].'" start="'.$instance['wpsbc_calendar_start'].'" display="'.$instance['wpsbc_calendar_view'].'" language="'.$instance['wpsbc_calendar_language'].'" month="'.$instance['wpsbc_calendar_month'].'" year="'.$instance['wpsbc_calendar_year'].'" history="'.$instance['wpsbc_calendar_history'].'" tooltip="'.$instance['wpsbc_calendar_tooltip'].'" weeknumbers="'.$instance['wpsbc_calendar_weeknumbers'].'"]'); 
        echo '</div>';
        
        
        
        echo $args['after_widget'];

    }
    function update($new_instance, $old_instance) {
        return $new_instance;
    }
    function form($instance) {
        global $wpdb;
        
        
        $calendarId = 0; if(!empty($instance['wpsbc_select_calendar'])) 
            $calendarId = $instance['wpsbc_select_calendar'];
        
        $showTitle = 'yes'; if(!empty($instance['wpsbc_show_title'])) 
            $showTitle = $instance['wpsbc_show_title'];
            
        $showLegend = 'yes'; if(!empty($instance['wpsbc_show_legend'])) 
            $showLegend = $instance['wpsbc_show_legend'];
            
        $showDropdown = 'yes'; if(!empty($instance['wpsbc_show_dropdown'])) 
            $showDropdown = $instance['wpsbc_show_dropdown'];

        $calendarView = '1'; if(!empty($instance['wpsbc_calendar_view'])) 
            $calendarView = $instance['wpsbc_calendar_view'];
            
        
        $calendarStart = '1'; if(!empty($instance['wpsbc_calendar_start'])) 
            $calendarStart = $instance['wpsbc_calendar_start'];
        
        $calendarLanguage = 'en'; if(!empty($instance['wpsbc_calendar_language'])) 
            $calendarLanguage = $instance['wpsbc_calendar_language'];
        
        $calendarMonth = '0'; if(!empty($instance['wpsbc_calendar_month'])) 
            $calendarMonth = $instance['wpsbc_calendar_month'];
        
        $calendarYear = '0'; if(!empty($instance['wpsbc_calendar_year'])) 
            $calendarYear = $instance['wpsbc_calendar_year'];
            
        $calendarHistory = '1'; if(!empty($instance['wpsbc_calendar_history'])) 
            $calendarHistory = $instance['wpsbc_calendar_history'];  
        
        $calendarTooltip = 'no'; if(!empty($instance['wpsbc_calendar_tooltip'])) 
            $calendarTooltip = $instance['wpsbc_calendar_tooltip'];
           
        $calendarWeeknumbers = 'no'; if(!empty($instance['wpsbc_calendar_weeknumbers'])) 
            $calendarWeeknumbers = $instance['wpsbc_calendar_weeknumbers'];    
            

            
        $sql = 'SELECT * FROM ' . $wpdb->base_prefix . 'sbc_calendars';
        $rows = $wpdb->get_results( $sql, ARRAY_A );
        
        
        ?>
        
        <p>
            <label for="<?php echo $this->get_field_id('wpsbc_select_calendar'); ?>"><?php _e('Calendar', "wpsbc");?></label>
            <select name="<?php echo $this->get_field_name('wpsbc_select_calendar'); ?>" id="<?php echo $this->get_field_id('wpsbc_select_calendar'); ?>" class="widefat">
            <?php foreach($rows as $calendar):?>
                <option<?php if($calendar['calendarID']==$calendarId) echo ' selected="selected"';?> value="<?php echo $calendar['calendarID'];?>"><?php echo $calendar['calendarTitle'];?></option>
            <?php endforeach;?>   
            </select>
         </p>   
         <p>
            <label for="<?php echo $this->get_field_id('wpsbc_show_title'); ?>"><?php _e('Display title?', "wpsbc");?></label>
            <select name="<?php echo $this->get_field_name('wpsbc_show_title'); ?>" id="<?php echo $this->get_field_id('wpsbc_show_title'); ?>" class="widefat">
                <option value="yes"><?php _e('Yes', "wpsbc");?></option>
                <option value="no"<?php if($showTitle=='no'):?> selected="selected"<?php endif;?>><?php _e('No', "wpsbc");?></option>
            </select>
         </p>   
         <p>   
            <label for="<?php echo $this->get_field_id('wpsbc_show_legend'); ?>"><?php _e('Display legend?', "wpsbc");?></label>
            <select name="<?php echo $this->get_field_name('wpsbc_show_legend'); ?>" id="<?php echo $this->get_field_id('wpsbc_show_legend'); ?>" class="widefat">
                <option value="yes"><?php _e('Yes', "wpsbc");?></option>
                <option value="no"<?php if($showLegend=='no'):?> selected="selected"<?php endif;?>><?php _e('No', "wpsbc");?></option>
            </select>
         </p>   
         <p>   
            <label for="<?php echo $this->get_field_id('wpsbc_show_dropdown'); ?>">D<?php _e('isplay dropdown?', "wpsbc");?></label>
            <select name="<?php echo $this->get_field_name('wpsbc_show_dropdown'); ?>" id="<?php echo $this->get_field_id('wpsbc_show_dropdown'); ?>" class="widefat">
                <option value="yes"><?php _e('Yes', "wpsbc");?></option>
                <option value="no"<?php if($showDropdown=='no'):?> selected="selected"<?php endif;?>><?php _e('No', "wpsbc");?></option>
            </select>
         </p>   
         <p>   
            <label for="<?php echo $this->get_field_id('wpsbc_calendar_start'); ?>"><?php _e('Week starts on', "wpsbc");?></label>
            <select name="<?php echo $this->get_field_name('wpsbc_calendar_start'); ?>" id="<?php echo $this->get_field_id('wpsbc_calendar_start'); ?>" class="widefat">
            
                <option value="1"<?php if($calendarStart==1):?> selected="selected"<?php endif;?>><?php _e("Monday", "wpsbc"); ?></option>
                <option value="2"<?php if($calendarStart==2):?> selected="selected"<?php endif;?>><?php _e("Tuesday", "wpsbc"); ?></option>
                <option value="3"<?php if($calendarStart==3):?> selected="selected"<?php endif;?>><?php _e("Wednesday", "wpsbc"); ?></option>
                <option value="4"<?php if($calendarStart==4):?> selected="selected"<?php endif;?>><?php _e("Thursday", "wpsbc"); ?></option>
                <option value="5"<?php if($calendarStart==5):?> selected="selected"<?php endif;?>><?php _e("Friday", "wpsbc"); ?></option>
                <option value="6"<?php if($calendarStart==6):?> selected="selected"<?php endif;?>><?php _e("Saturday", "wpsbc"); ?></option>
                <option value="7"<?php if($calendarStart==7):?> selected="selected"<?php endif;?>><?php _e("Sunday", "wpsbc"); ?></option>
            </select>
         </p>   
         <p>   
            <label for="<?php echo $this->get_field_id('wpsbc_calendar_view'); ?>"><?php _e('Months to display?', "wpsbc");?></label>
            <select name="<?php echo $this->get_field_name('wpsbc_calendar_view'); ?>" id="<?php echo $this->get_field_id('wpsbc_calendar_view'); ?>" class="widefat">
                <?php for($i=1;$i<=12; $i++):?>
                    <option value="<?php echo $i;?>"<?php if($calendarView==$i):?> selected="selected"<?php endif;?>><?php echo $i;?></option>
                <?php endfor;?>
            </select>
        </p>   
        <p>    
            <label for="<?php echo $this->get_field_id('wpsbc_calendar_language'); ?>"><?php _e('Language', "wpsbc");?></label>
            <select name="<?php echo $this->get_field_name('wpsbc_calendar_language'); ?>" id="<?php echo $this->get_field_id('wpsbc_calendar_language'); ?>" class="widefat">
                <?php $activeLanguages = json_decode(get_site_option('wpsbc-languages'),true);?>
                <option value="auto"><?php _e('Auto (let WP choose)', "wpsbc");?></option>
                <?php foreach($activeLanguages as $code => $language):?>
                    <option value="<?php echo $code;?>"<?php if($calendarLanguage == $code):?> selected="selected"<?php endif;?>><?php echo $language;?></option>
                <?php endforeach;?>   
            </select>
        </p>
        
        <p>    
            <label for="<?php echo $this->get_field_id('wpsbc_calendar_month'); ?>"><?php _e('Start Month', "wpsbc");?></label>
            <select name="<?php echo $this->get_field_name('wpsbc_calendar_month'); ?>" id="<?php echo $this->get_field_id('wpsbc_calendar_month'); ?>" class="widefat">
                <option<?php if($calendarMonth == 0):?> selected="selected"<?php endif;?> value="0"><?php _e('Current Month', "wpsbc");?></option>
                <option<?php if($calendarMonth == 1):?> selected="selected"<?php endif;?>  value="1"><?php _e('January', "wpsbc");?></option>
                <option<?php if($calendarMonth == 2):?> selected="selected"<?php endif;?>  value="2"><?php _e('February', "wpsbc");?></option>
                <option<?php if($calendarMonth == 3):?> selected="selected"<?php endif;?>  value="3"><?php _e('March', "wpsbc");?></option>
                <option<?php if($calendarMonth == 4):?> selected="selected"<?php endif;?>  value="4"><?php _e('April', "wpsbc");?></option>
                <option<?php if($calendarMonth == 5):?> selected="selected"<?php endif;?>  value="5"><?php _e('May', "wpsbc");?></option>
                <option<?php if($calendarMonth == 6):?> selected="selected"<?php endif;?>  value="6"><?php _e('June', "wpsbc");?></option>
                <option<?php if($calendarMonth == 7):?> selected="selected"<?php endif;?>  value="7"><?php _e('July', "wpsbc");?></option>
                <option<?php if($calendarMonth == 8):?> selected="selected"<?php endif;?>  value="8"><?php _e('August', "wpsbc");?></option>
                <option<?php if($calendarMonth == 9):?> selected="selected"<?php endif;?>  value="9"><?php _e('September', "wpsbc");?></option>
                <option<?php if($calendarMonth == 10):?> selected="selected"<?php endif;?>  value="10"><?php _e('October', "wpsbc");?></option>
                <option<?php if($calendarMonth == 11):?> selected="selected"<?php endif;?>  value="11"><?php _e('November', "wpsbc");?></option>
                <option<?php if($calendarMonth == 12):?> selected="selected"<?php endif;?>  value="12"><?php _e('December', "wpsbc");?></option>   
            </select>
        </p>
        
        <p>    
            <label for="<?php echo $this->get_field_id('wpsbc_calendar_year'); ?>"><?php _e('Start Year', "wpsbc");?></label>
            <select name="<?php echo $this->get_field_name('wpsbc_calendar_year'); ?>" id="<?php echo $this->get_field_id('wpsbc_calendar_year'); ?>" class="widefat">
                <option value="0">Current Year</option>
                <?php for($i = date("Y"); $i<= date("Y") + 10; $i++):?>
                    <option<?php if($calendarYear == $i):?> selected="selected"<?php endif;?> value="<?php echo $i;?>"><?php echo $i;?></option>
                <?php endfor;?>      
            </select>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('wpsbc_calendar_history'); ?>"><?php _e('Show history?', "wpsbc");?></label>
            <select name="<?php echo $this->get_field_name('wpsbc_calendar_history'); ?>" id="<?php echo $this->get_field_id('wpsbc_calendar_history'); ?>" class="widefat">
                <option <?php if($calendarHistory == 1):?> selected="selected"<?php endif;?> value="1"><?php _e('Display booking history', "wpsbc");?></option>
                <option <?php if($calendarHistory == 2):?> selected="selected"<?php endif;?> value="2"><?php _e('Replace booking history with the default legend item', "wpsbc");?></option>
                <option <?php if($calendarHistory == 3):?> selected="selected"<?php endif;?> value="3"><?php _e('Use the Booking History Color from the Settings', "wpsbc");?></option>                        
            </select>              

        </p>
        
        <p>
            <label for="<?php echo $this->get_field_id('wpsbc_calendar_tooltip'); ?>"><?php _e('Show Tooltip?', "wpsbc");?></label>
            <select name="<?php echo $this->get_field_name('wpsbc_calendar_tooltip'); ?>" id="<?php echo $this->get_field_id('wpsbc_calendar_tooltip'); ?>" class="widefat">
                <option <?php if($calendarTooltip == '1'):?> selected="selected"<?php endif;?> value="1"><?php _e('No', "wpsbc");?></option>
                <option <?php if($calendarTooltip == '2'):?> selected="selected"<?php endif;?> value="2"><?php _e('Yes', "wpsbc");?></option>
                <option <?php if($calendarTooltip == '3'):?> selected="selected"<?php endif;?> value="3"><?php _e('Yes, with red indicator', "wpsbc");?></option>        
                            
            </select>              

        </p>
        
        <p>
            <label for="<?php echo $this->get_field_id('wpsbc_calendar_weeknumbers'); ?>"><?php _e('Show Week Numbers?', "wpsbc");?></label>
            <select name="<?php echo $this->get_field_name('wpsbc_calendar_weeknumbers'); ?>" id="<?php echo $this->get_field_id('wpsbc_calendar_weeknumbers'); ?>" class="widefat">
                <option <?php if($calendarWeeknumbers == 'no'):?> selected="selected"<?php endif;?> value="no"><?php _e('No', "wpsbc");?></option>
                <option <?php if($calendarWeeknumbers == 'yes'):?> selected="selected"<?php endif;?> value="yes"><?php _e('Yes', "wpsbc");?></option>
                            
            </select>              

        </p>

        <?php
    }
}
function wpsbc_register_widget() {
	register_widget( 'wpsbc_widget' );
}
add_action( 'widgets_init', 'wpsbc_register_widget' );