<?php
function wpsbc_shortcode( $atts ) {
    $wpsbcOptions = json_decode(get_site_option('wpsbc-options'),true);  
    if(empty($wpsbcOptions['alwaysEnqueueScripts']) || $wpsbcOptions['alwaysEnqueueScripts'] == 'no'){
        wp_enqueue_style( 'wpsbc-calendar', WPSBC_PATH . '/css/wpsbc-calendar.css' );
        wp_enqueue_script('wpsbc', WPSBC_PATH . '/js/wpsbc.js', array('jquery'));
        wp_enqueue_script('custom-select', WPSBC_PATH . '/js/custom-select.js', array('jquery'));    
    }
    
    
	extract( shortcode_atts( array(
		'id'        => null,
		'title'     => 'no',
        'legend'    => 'no',
        'dropdown'  => 'yes',
        'start'     => '1',
        'display'   => '1',
        'language'  => 'en',
        'history'  => '1',
        'tooltip'  => '1',
        'weeknumbers' => 'no',
        'month' => 0,
        'year' => 0
	), $atts, 'wpsbc' ) );
    
    
    
    if(!in_array($month,range(1,48))) {$month = date('m');}
    if(intval($year) < 1970 || intval($year) > 2100) { $year = date("Y");}
    
    if($id == null) return "WP Simple Booking Calendar: ID parameter missing.";
    if(!in_array($title,array('yes','no'))) $title = 'no';
    if(!in_array($weeknumbers,array('yes','no'))) $weeknumbers = 'no';
    if(!in_array($tooltip,array(1,2,3))) $tooltip = 1;
    if(!in_array($legend,array('yes','no'))) $legend = 'no';
    if(!in_array($dropdown,array('yes','no'))) $dropdown = 'yes';
    $dropdown = str_replace(array('yes','no'),array(true,false),$dropdown);
    
    if(!in_array(absint($start),array(1,2,3,4,5,6,7))) $start = 1;
    if(absint($display) < 1) $display = 1;    
    if(!in_array(absint($history),array(1,2,3))) $history = 1;
        
    
    
    global $wpdb;
    
    
    if($language == 'auto'){
        $language = wpsbc_get_locale();
    } else {
        $activeLanguages = json_decode(get_site_option('wpsbc-languages'),true); if(!array_key_exists($language,$activeLanguages)) $language = 'en';    
    }

    $sql = $wpdb->prepare('SELECT * FROM ' . $wpdb->base_prefix . 'sbc_calendars WHERE calendarID=%d',$id);
    $calendar = $wpdb->get_row( $sql, ARRAY_A );
    if($wpdb->num_rows > 0):
        
        $calendarOutput = wpsbc_print_legend_css($calendar['calendarLegend'],$calendar['calendarID']);
        if($title == 'yes') $calendarOutput .= '<h2>' . $calendar['calendarTitle'] . "</h2>";
        $calendarOutput .= wpsbc_calendar(array('ajaxCall' => false, 'calendarHistory' => $history, 'calendarID' => $calendar['calendarID'], 'calendarData' => $calendar['calendarData'], 'totalCalendars' => $display, 'firstDayOfWeek' => $start, 'showDateEditor' => false, 'calendarLegend' => $calendar['calendarLegend'], 'showDropdown' => $dropdown, 'showTooltip' => $tooltip, 'showWeekNumbers' => $weeknumbers, 'showLegend' => $legend, 'calendarLanguage' => $language, 'currentTimestamp' => strtotime(date("F", mktime(0, 0, 0, $month, 15, date('Y'))) . " " . $year) ));
        

        return $calendarOutput;
    else:
        return __('WP Simple Booking Calendar: Invalid calendar ID.');
    endif;
	
}
add_shortcode( 'wpsbc', 'wpsbc_shortcode' );