<?php
global $wpsbc_db_version;
$wpsbc_db_version = "1.4";
function wpsbc_install(){
    global $wpdb;
    global $wpsbc_db_version;
    
    $wpsbc_current_db_version = get_site_option( "wpsbc_db_version" );
    if( $wpsbc_current_db_version != $wpsbc_db_version ):   
        $sql = "CREATE TABLE `".$wpdb->base_prefix."sbc_calendars` (
              `calendarID` int(10) NOT NULL AUTO_INCREMENT,
              `calendarTitle` text,
              `createdDate` int(11) DEFAULT NULL,
              `modifiedDate` int(11) DEFAULT NULL,
              `calendarData` text,
              `calendarLegend` text,
              `calendarUsers` text,
              `calendarHash` varchar(32),
            UNIQUE KEY (`calendarID`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='WP Simple Booking Calendar';";            
        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        dbDelta( $sql );
        add_site_option( "wpsbc_db_version", $wpsbc_db_version );
        add_site_option( "wpsbc-languages", '{"en":"English"}', '' );
        add_site_option( "wpsbc-options", '{"selectedColor":"#3399cc","selectedBorder":"#336699","dateFormat":"j F Y","historyColor":"#E4E4E4"}', '' );
        add_site_option( "wpsbc-default-legend", '{"default":{"name":{"default":"Available","hr":"Slobodno","cs":"Volno","da":"Ledigt","nl":"Vrij","en":"Available","fr":"Libre","de":"Frei","hu":"Szabad","it":"Libero","ro":"Disponobil","ru":"\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e","sk":"Vo\u013en\u00fd","es":"Libre","sv":"Ledigt","uk":"B\u0456\u043b\u044c\u043d\u043e","cz":"","jp":"\u7a7a\u304d\u3042\u308a","ua":"","bg":"\u0421\u0432\u043e\u0431\u043e\u0434\u043d\u043e","ca":"","el":"","et":"","fi":"","lt":"Prieinama","no":"","pl":"","pt":"","sl":"","tr":""},"color":"#DDFFCC","splitColor":false,"bookable":false,"sync":"no"},"1":{"name":{"default":"Booked","hr":"Zauzeto","cs":"Obsazeno","da":"Booket","nl":"Bezet","en":"Booked","fr":"Occup\u00e9","de":"Belegt","hu":"Foglalt","it":"Prenotato","ro":"Rezervat","ru":"\u0417\u0430\u043d\u044f\u0442\u043e","sk":"Obsaden\u00fd","es":"Reservado","sv":"Bokat","uk":"\u0417\u0430\u0439\u043d\u044f\u0442\u043e","cz":"","jp":"\u6e80\u5e2d","ua":"","bg":"\u0417\u0430\u0435\u0442\u043e","ca":"","el":"","et":"","fi":"","lt":"U\u017eimta","no":"","pl":"","pt":"","sl":"","tr":""},"color":"#FFC0BD","splitColor":false,"bookable":false,"sync":"yes"},"2":{"name":{"en":"Changeover 1","nl":"","et":"","fi":"","fr":"","de":"","pt":"","ro":"","default":"Changeover 1","hr":"","cz":"","jp":"\u30a4\u30f3\/\u30a2\u30a6\u30c8\u65e5","ru":"","ua":""},"color":"#DDFFCC","splitColor":"#FFC0BD","bookable":"yes","hide":"hide","sync":"no"},"3":{"name":{"en":"Changeover 2","nl":"","et":"","fi":"","fr":"","de":"","pt":"","ro":"","default":"Changeover 2","hr":"","cz":"","jp":"\u30a4\u30f3\/\u30a2\u30a6\u30c8\u65e5","ru":"","ua":""},"color":"#FFC0BD","splitColor":"#DDFFCC","bookable":"yes","hide":"hide","sync":"no"}}' );
        
        $sql = 'SELECT * FROM ' . $wpdb->prefix . 'sbc_calendars WHERE calendarHash IS NULL';
        $rows = $wpdb->get_results( $sql, ARRAY_A ); foreach($rows as $row){
            $random_string = wpsbc_generateRandomString(32);
            $wpdb->update( $wpdb->prefix.'sbc_calendars', array('calendarHash' => $random_string), array('calendarID' => $row['calendarID']) );
        }
    
    endif;
}


function wpsbc_update_db_check() {
    global $wpsbc_db_version;
    if (get_site_option( 'wpsbc_db_version' ) != $wpsbc_db_version) {
        wpsbc_install();
        update_site_option( "wpsbc_db_version", $wpsbc_db_version );
    }
}
add_action( 'plugins_loaded', 'wpsbc_update_db_check' );