<?php
function wpsbc_print_legend_css($legend, $calendarID = null){
    $output = "<style>";
    foreach(json_decode($legend,true) as $key => $value ){
        if(!empty($value["splitColor"])){
            
            $output .= ".wpsbc-calendar-".$calendarID." .wpsbc-day-split-top-" . $key . " {border-color: " . $value['color'] ." transparent transparent transparent ; _border-color: " . $value['color'] ." #000000 #000000 #000000 ;}";
            $output .= ".wpsbc-calendar-".$calendarID." .wpsbc-day-split-bottom-" . $key . " {border-color: transparent transparent " . $value['splitColor'] ." transparent ; _border-color:  #000000 #000000 " . $value['splitColor'] ." #000000 ;}";
        } else {
            $output .= ".wpsbc-calendar-".$calendarID." .status-" . $key . " {background-color: " . $value['color'] ." ;}";
            $output .= ".wpsbc-calendar-".$calendarID." .wpsbc-day-split-top-" . $key . " {display:none ;} ";
            $output .= ".wpsbc-calendar-".$calendarID." .wpsbc-day-split-bottom-" . $key . " {display:none ;} ";
        }
    }
    $wpsbcOptions = json_decode(get_site_option('wpsbc-options'),true);
    
    $output .= ".status-wpsbc-grey-out-history {background-color:".$wpsbcOptions['historyColor']."}";
    $output .= ".status-wpsbc-grey-out-history .wpsbc-day-split-top, .status-wpsbc-grey-out-history .wpsbc-day-split-bottom {display:none;}";
    $output .= "</style>";
    
    return $output;
}

function wpsbc_timeFormat($timestamp){
    $wpsbcOptions = json_decode(get_site_option('wpsbc-options'),true);
    
    if(!isset($wpsbcOptions['dateFormat'])) $wpsbcOptions['dateFormat'] = 'd-m-Y';
    
    $date = date($wpsbcOptions['dateFormat'], $timestamp);
    
    $month = date('F', $timestamp);
    $date = str_replace($month, __($month), $date);

    return $date;
    
}

function wpsbc_defaultCalendarLegend(){
    return get_site_option('wpsbc-default-legend');
}

function wpsbc_print_legend($legend,$language,$hideLegend = true){
    $output = '';
    foreach(json_decode($legend,true) as $key => $value ):
        if(!(!empty($value['hide']) && $value['hide'] == 'hide') || $hideLegend == false){
           if(!empty($value['name'][$language])) $legendName = $value['name'][$language]; else $legendName = $value['name']['default'];
            $output .= '<div class="wpsbc-legend-item"><div class="wpsbc-legend-color status-' . $key . '">
                    <div class="wpsbc-day-split-top wpsbc-day-split-top-'.$key.'"></div>
                    <div class="wpsbc-day-split-bottom wpsbc-day-split-bottom-'.$key.'"></div>    
                </div><p>' . $legendName . '</p></div>'; 
        }
        
    endforeach;
    return $output;
}

function wpsbc_get_language(){
    $activeLanguages = json_decode(get_site_option('wpsbc-languages'),true);
    if(array_key_exists(substr(get_bloginfo('language'),0,2),$activeLanguages)){
        return substr(get_bloginfo('language'),0,2);    
    }
    return 'en';
}

function wpsbc_get_locale(){
    return substr(get_locale(),0,2);
}
function wpsbc_tz_offset_to_name($offset){
    $offset *= 3600;
    $abbrarray = timezone_abbreviations_list();
    foreach ($abbrarray as $abbr){
        foreach ($abbr as $city){
            if ($city['offset'] == $offset){
                    return $city['timezone_id'];
            }
        }
    }
    
    return false;
}

function wpsbc_generateRandomString($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}