<?php
function wpsbc_replaceCustom($str){
    return str_replace( 
        array(
            '--AMP--',
            '--DOUBLEQUOTE--',
            '--QUOTE--',
            '--LT--',
            '--GT--'
        ),
        array(
            '&',
            '"',
            "'",
            '<',
            '>'
        ),
        $str );
}

function wpsbc_edit_dates($options){
    
    foreach($options as $key => $value){
        if(empty($$key))
            $$key = $value;
    }
    
    
    $output = '<div class="wpsbc-dates-editor"><ul>';
    for($i=1;$i<=date('t',$currentTimestamp);$i++):
        $output .= wpsbc_edit_date($calendarData,$calendarLegend,$i,$currentTimestamp,$calendarLanguage);
    endfor;
    $output .= "</ul></div>";
    
    $output .= "<input type='hidden' name='wpsbcCalendarData' id='inputCalendarData' value='".$calendarData."' />";
    return $output;
}

function wpsbc_edit_date($calendarData,$legend,$day,$timestamp,$language){
    $calendarData = json_decode($calendarData,true);
    $status = 'default';
    if(!empty($calendarData[date('Y',$timestamp)][date('n',$timestamp)][$day]))
        $status = $calendarData[date('Y',$timestamp)][date('n',$timestamp)][$day];
    $description = '';   
    if(!empty($calendarData[date('Y',$timestamp)][date('n',$timestamp)]["description-" . $day]))
        $description = $calendarData[date('Y',$timestamp)][date('n',$timestamp)]["description-" . $day]; 
    $output = '';    
    $output .= '<li>';
        $output .= '<span class="wpsbc-select-status status-'.$status.'">';
            $output .= '<span class="wpsbc-day-split-top wpsbc-day-split-top-'.$status.'"></span>';
            $output .= '<span class="wpsbc-day-split-bottom wpsbc-day-split-bottom-'.$status.'"></span>';    
            $output .= '<span class="wpsbc-day-split-day">'.$day.'</span>';
        $output .= '</span>';
        
        $output .= '<select class="wpsbc-day-select wpsbc-day-'.$day.'" name="wpsbc-day-'.$day.'">';
        foreach(json_decode($legend,true) as $key => $value ): $selected = null;
            if(!empty($value['name'][$language])) $legendName = $value['name'][$language]; else $legendName = $value['name']['default'];
            if(!empty($status) && $status == $key) $selected = ' selected="selected"';
            $output .= '<option class="wpsbc-option-'.$key.'" value="' . $key . '"' . $selected . '>' . $legendName . '</option>';
        endforeach;
        $output .= "</select>";
        $output .= "<span class='wpsbc-input-description-wrap'><input class='wpsbc-input-description' type='text' value='". htmlentities(wpsbc_replaceCustom(stripslashes($description)),ENT_QUOTES,"UTF-8")."' name='wpsbc-description-".$day."' /></span>";
    $output .= "</li>";
    return $output;
}

function wpsbc_edit_users($calendarID){
    global $wpdb;
    ob_start();
    if( current_user_can( MIN_USER_CAPABILITY ) ):
        $sql = $wpdb->prepare('SELECT * FROM ' . $wpdb->base_prefix . 'sbc_calendars WHERE calendarID=%d',$calendarID); 
        $calendar = $wpdb->get_row( $sql, ARRAY_A );
        $calendarUsers = json_decode($calendar['calendarUsers']);
        ?>
        
        <div class="wpsbc-calendar-users">
            <p><?php echo __('Assign users to this calendar','wpsbc');?></p>
            <select data-placeholder="<?php echo __("Select users",'wpsbc');?>" class="wpsbc-chosen" name="wpbbs-calendar-users[]" multiple="multiple">
            <?php $users = get_users(); foreach($users as $user): if($user->roles[0] == 'administrator') continue; ?>
                <option<?php if( !empty($calendarUsers) && in_array($user->ID, $calendarUsers ) ):?> selected="selected"<?php endif;?> value="<?php echo $user->ID; ?>"><?php echo $user->user_nicename; ?></option>
            <?php endforeach;?> 
            </select>
        </div>
        <?php
    endif;
    $output = ob_get_contents();
    ob_clean();
    return $output;
}

function wpsbc_edit_legend($calendarLegend,$showEdit, $calendarID){
    
    $output = '<div class="wpsbc-calendar-legend-container">';
        $output .= wpsbc_print_legend($calendarLegend,wpsbc_get_language(),false);
        $output .= '<a class="button button-secondary" href="'. admin_url( 'admin.php?page=wp-simple-booking-calendar-premium&do=edit-legend&id=' . $calendarID) .'">' . __('Edit Legend','wpsbc') . '</a>';
    $output .= '</div>';
    
    return $output;
}

function wpsbc_batch_update($calendarLegend){
    ob_start();
    ?>
    <div class="wpsbc-batch-update">
            <span class="error"><?php echo __('Start time must be lower than end time','wpsbc');?></span>
    		<p>
    			<label for="startYear"><?php echo __('Start Date','wpsbc');?>:</label>
    			<select name="startYear" id="startYear">
                    <?php for($i = date("Y"); $i<= date("Y") + 10; $i++):?>
                    <option value="<?php echo $i;?>"><?php echo $i;?></option>
                    <?php endfor?>
                </select>
                <select name="startMonth" id="startMonth">
                    <?php for($i = strtotime('1 January ' . date('Y')); $i<= strtotime('1 January ' . date('Y') . ' + 1 year'); $i = $i + (60*60*24*31)):?>
                    <option<?php if(date('F') == date("F",$i)):?> selected="selected"<?php endif;?> value="<?php echo date('F',$i);?>"><?php echo wpsbcShortMonth(date('F',$i), wpsbc_get_locale());?></option>
                    <?php endfor?>
                </select>
                <select name="startDay" id="startDay">
                    <?php for($i = 1; $i<= 31; $i++):?>
                    <option value="<?php echo $i;?>"><?php echo $i;?></option>
                    <?php endfor?>
                </select>
    		</p>
            
            <p>
    			<label for="endYear"><?php echo __('End Date','wpsbc');?>:</label>
    			<select name="endYear" id="endYear">
                    <?php for($i = date("Y"); $i<= date("Y") + 10; $i++):?>
                    <option value="<?php echo $i;?>"><?php echo $i;?></option>
                    <?php endfor?>
                </select>
                <select name="endMonth" id="endMonth">
                    <?php for($i = strtotime('1 January ' . date('Y')); $i<= strtotime('1 January ' . date('Y') . ' + 1 year'); $i = $i + (60*60*24*31)):?>
                    <option<?php if(date('F') == date("F",$i)):?> selected="selected"<?php endif;?> value="<?php echo date('F',$i);?>"><?php echo wpsbcShortMonth(date('F',$i), wpsbc_get_locale());?></option>
                    <?php endfor?>
                </select>
                <select name="endDay" id="endDay">
                    <?php for($i = 1; $i<= 31; $i++):?>
                    <option value="<?php echo $i;?>"><?php echo $i;?></option>
                    <?php endfor?>
                </select>
    		</p>
            
            <p>
    			<label for="bookingDetails"><?php echo __('Booking Details','wpsbc');?>:</label>
                <input type="text" id="bookingDetails" name="bookingDetails" />
                
    		</p>
            
            <p class="wpsbc-batch-change-status">
    			<label for="changeStatus"><?php echo __('Status','wpsbc');?>:</label>            
    			<select name="changeStatus" id="changeStatus">
    				<?php foreach (json_decode($calendarLegend,true) as $statusKey => $statusName): ?>
                    <?php if(!empty($statusName['name'][wpsbc_get_language()])) $legendName = $statusName['name'][wpsbc_get_language()]; else $legendName = $statusName['name']['default'];?>
                    <?php $selected = ''; if($statusKey == 'default') $selected = ' selected="selected"';?>
    				<option<?php echo $selected;?> class="ac-status-<?php echo $statusKey ?>" value="<?php echo $statusKey ?>"><?php echo $legendName; ?></option>
    				<?php endforeach ?>
    			</select>
    		</p>
            <input type="button" id="calendarBatchUpdate" class="button button-secondary" value="<?php echo __('Apply Changes','wpsbc');?>" />
            
    </div>
<?php
    $output = ob_get_contents();
    ob_clean();
    return $output;
}