<?php
// This file was auto-generated from sdk-root/src/data/ssm/2014-11-06/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2014-11-06', 'endpointPrefix' => 'ssm', 'jsonVersion' => '1.1', 'protocol' => 'json', 'serviceAbbreviation' => 'Amazon SSM', 'serviceFullName' => 'Amazon Simple Systems Manager (SSM)', 'signatureVersion' => 'v4', 'targetPrefix' => 'AmazonSSM', 'uid' => 'ssm-2014-11-06', ], 'operations' => [ 'AddTagsToResource' => [ 'name' => 'AddTagsToResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'AddTagsToResourceRequest', ], 'output' => [ 'shape' => 'AddTagsToResourceResult', ], 'errors' => [ [ 'shape' => 'InvalidResourceType', ], [ 'shape' => 'InvalidResourceId', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'TooManyTagsError', ], ], ], 'CancelCommand' => [ 'name' => 'CancelCommand', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CancelCommandRequest', ], 'output' => [ 'shape' => 'CancelCommandResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidCommandId', ], [ 'shape' => 'InvalidInstanceId', ], [ 'shape' => 'DuplicateInstanceId', ], ], ], 'CreateActivation' => [ 'name' => 'CreateActivation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateActivationRequest', ], 'output' => [ 'shape' => 'CreateActivationResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], ], ], 'CreateAssociation' => [ 'name' => 'CreateAssociation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateAssociationRequest', ], 'output' => [ 'shape' => 'CreateAssociationResult', ], 'errors' => [ [ 'shape' => 'AssociationAlreadyExists', ], [ 'shape' => 'AssociationLimitExceeded', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidDocument', ], [ 'shape' => 'InvalidDocumentVersion', ], [ 'shape' => 'InvalidInstanceId', ], [ 'shape' => 'UnsupportedPlatformType', ], [ 'shape' => 'InvalidOutputLocation', ], [ 'shape' => 'InvalidParameters', ], [ 'shape' => 'InvalidTarget', ], [ 'shape' => 'InvalidSchedule', ], ], ], 'CreateAssociationBatch' => [ 'name' => 'CreateAssociationBatch', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateAssociationBatchRequest', ], 'output' => [ 'shape' => 'CreateAssociationBatchResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidDocument', ], [ 'shape' => 'InvalidDocumentVersion', ], [ 'shape' => 'InvalidInstanceId', ], [ 'shape' => 'InvalidParameters', ], [ 'shape' => 'DuplicateInstanceId', ], [ 'shape' => 'AssociationLimitExceeded', ], [ 'shape' => 'UnsupportedPlatformType', ], [ 'shape' => 'InvalidOutputLocation', ], [ 'shape' => 'InvalidTarget', ], [ 'shape' => 'InvalidSchedule', ], ], ], 'CreateDocument' => [ 'name' => 'CreateDocument', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateDocumentRequest', ], 'output' => [ 'shape' => 'CreateDocumentResult', ], 'errors' => [ [ 'shape' => 'DocumentAlreadyExists', ], [ 'shape' => 'MaxDocumentSizeExceeded', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidDocumentContent', ], [ 'shape' => 'DocumentLimitExceeded', ], [ 'shape' => 'InvalidDocumentSchemaVersion', ], ], ], 'CreateMaintenanceWindow' => [ 'name' => 'CreateMaintenanceWindow', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateMaintenanceWindowRequest', ], 'output' => [ 'shape' => 'CreateMaintenanceWindowResult', ], 'errors' => [ [ 'shape' => 'IdempotentParameterMismatch', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'InternalServerError', ], ], ], 'CreatePatchBaseline' => [ 'name' => 'CreatePatchBaseline', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreatePatchBaselineRequest', ], 'output' => [ 'shape' => 'CreatePatchBaselineResult', ], 'errors' => [ [ 'shape' => 'IdempotentParameterMismatch', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'InternalServerError', ], ], ], 'DeleteActivation' => [ 'name' => 'DeleteActivation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteActivationRequest', ], 'output' => [ 'shape' => 'DeleteActivationResult', ], 'errors' => [ [ 'shape' => 'InvalidActivationId', ], [ 'shape' => 'InvalidActivation', ], [ 'shape' => 'InternalServerError', ], ], ], 'DeleteAssociation' => [ 'name' => 'DeleteAssociation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteAssociationRequest', ], 'output' => [ 'shape' => 'DeleteAssociationResult', ], 'errors' => [ [ 'shape' => 'AssociationDoesNotExist', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidDocument', ], [ 'shape' => 'InvalidInstanceId', ], [ 'shape' => 'TooManyUpdates', ], ], ], 'DeleteDocument' => [ 'name' => 'DeleteDocument', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteDocumentRequest', ], 'output' => [ 'shape' => 'DeleteDocumentResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidDocument', ], [ 'shape' => 'InvalidDocumentOperation', ], [ 'shape' => 'AssociatedInstances', ], ], ], 'DeleteMaintenanceWindow' => [ 'name' => 'DeleteMaintenanceWindow', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteMaintenanceWindowRequest', ], 'output' => [ 'shape' => 'DeleteMaintenanceWindowResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], ], ], 'DeleteParameter' => [ 'name' => 'DeleteParameter', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteParameterRequest', ], 'output' => [ 'shape' => 'DeleteParameterResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'ParameterNotFound', ], ], ], 'DeletePatchBaseline' => [ 'name' => 'DeletePatchBaseline', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeletePatchBaselineRequest', ], 'output' => [ 'shape' => 'DeletePatchBaselineResult', ], 'errors' => [ [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'InternalServerError', ], ], ], 'DeregisterManagedInstance' => [ 'name' => 'DeregisterManagedInstance', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeregisterManagedInstanceRequest', ], 'output' => [ 'shape' => 'DeregisterManagedInstanceResult', ], 'errors' => [ [ 'shape' => 'InvalidInstanceId', ], [ 'shape' => 'InternalServerError', ], ], ], 'DeregisterPatchBaselineForPatchGroup' => [ 'name' => 'DeregisterPatchBaselineForPatchGroup', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeregisterPatchBaselineForPatchGroupRequest', ], 'output' => [ 'shape' => 'DeregisterPatchBaselineForPatchGroupResult', ], 'errors' => [ [ 'shape' => 'InvalidResourceId', ], [ 'shape' => 'InternalServerError', ], ], ], 'DeregisterTargetFromMaintenanceWindow' => [ 'name' => 'DeregisterTargetFromMaintenanceWindow', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeregisterTargetFromMaintenanceWindowRequest', ], 'output' => [ 'shape' => 'DeregisterTargetFromMaintenanceWindowResult', ], 'errors' => [ [ 'shape' => 'DoesNotExistException', ], [ 'shape' => 'InternalServerError', ], ], ], 'DeregisterTaskFromMaintenanceWindow' => [ 'name' => 'DeregisterTaskFromMaintenanceWindow', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeregisterTaskFromMaintenanceWindowRequest', ], 'output' => [ 'shape' => 'DeregisterTaskFromMaintenanceWindowResult', ], 'errors' => [ [ 'shape' => 'DoesNotExistException', ], [ 'shape' => 'InternalServerError', ], ], ], 'DescribeActivations' => [ 'name' => 'DescribeActivations', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeActivationsRequest', ], 'output' => [ 'shape' => 'DescribeActivationsResult', ], 'errors' => [ [ 'shape' => 'InvalidFilter', ], [ 'shape' => 'InvalidNextToken', ], [ 'shape' => 'InternalServerError', ], ], ], 'DescribeAssociation' => [ 'name' => 'DescribeAssociation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeAssociationRequest', ], 'output' => [ 'shape' => 'DescribeAssociationResult', ], 'errors' => [ [ 'shape' => 'AssociationDoesNotExist', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidDocument', ], [ 'shape' => 'InvalidInstanceId', ], ], ], 'DescribeAutomationExecutions' => [ 'name' => 'DescribeAutomationExecutions', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeAutomationExecutionsRequest', ], 'output' => [ 'shape' => 'DescribeAutomationExecutionsResult', ], 'errors' => [ [ 'shape' => 'InvalidNextToken', ], [ 'shape' => 'InternalServerError', ], ], ], 'DescribeAvailablePatches' => [ 'name' => 'DescribeAvailablePatches', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeAvailablePatchesRequest', ], 'output' => [ 'shape' => 'DescribeAvailablePatchesResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], ], ], 'DescribeDocument' => [ 'name' => 'DescribeDocument', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeDocumentRequest', ], 'output' => [ 'shape' => 'DescribeDocumentResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidDocument', ], [ 'shape' => 'InvalidDocumentVersion', ], ], ], 'DescribeDocumentPermission' => [ 'name' => 'DescribeDocumentPermission', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeDocumentPermissionRequest', ], 'output' => [ 'shape' => 'DescribeDocumentPermissionResponse', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidDocument', ], [ 'shape' => 'InvalidPermissionType', ], ], ], 'DescribeEffectiveInstanceAssociations' => [ 'name' => 'DescribeEffectiveInstanceAssociations', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeEffectiveInstanceAssociationsRequest', ], 'output' => [ 'shape' => 'DescribeEffectiveInstanceAssociationsResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidInstanceId', ], [ 'shape' => 'InvalidNextToken', ], ], ], 'DescribeEffectivePatchesForPatchBaseline' => [ 'name' => 'DescribeEffectivePatchesForPatchBaseline', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeEffectivePatchesForPatchBaselineRequest', ], 'output' => [ 'shape' => 'DescribeEffectivePatchesForPatchBaselineResult', ], 'errors' => [ [ 'shape' => 'InvalidResourceId', ], [ 'shape' => 'DoesNotExistException', ], [ 'shape' => 'InternalServerError', ], ], ], 'DescribeInstanceAssociationsStatus' => [ 'name' => 'DescribeInstanceAssociationsStatus', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeInstanceAssociationsStatusRequest', ], 'output' => [ 'shape' => 'DescribeInstanceAssociationsStatusResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidInstanceId', ], [ 'shape' => 'InvalidNextToken', ], ], ], 'DescribeInstanceInformation' => [ 'name' => 'DescribeInstanceInformation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeInstanceInformationRequest', ], 'output' => [ 'shape' => 'DescribeInstanceInformationResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidInstanceId', ], [ 'shape' => 'InvalidNextToken', ], [ 'shape' => 'InvalidInstanceInformationFilterValue', ], [ 'shape' => 'InvalidFilterKey', ], ], ], 'DescribeInstancePatchStates' => [ 'name' => 'DescribeInstancePatchStates', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeInstancePatchStatesRequest', ], 'output' => [ 'shape' => 'DescribeInstancePatchStatesResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidNextToken', ], ], ], 'DescribeInstancePatchStatesForPatchGroup' => [ 'name' => 'DescribeInstancePatchStatesForPatchGroup', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeInstancePatchStatesForPatchGroupRequest', ], 'output' => [ 'shape' => 'DescribeInstancePatchStatesForPatchGroupResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidFilter', ], [ 'shape' => 'InvalidNextToken', ], ], ], 'DescribeInstancePatches' => [ 'name' => 'DescribeInstancePatches', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeInstancePatchesRequest', ], 'output' => [ 'shape' => 'DescribeInstancePatchesResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidInstanceId', ], [ 'shape' => 'InvalidFilter', ], [ 'shape' => 'InvalidNextToken', ], ], ], 'DescribeMaintenanceWindowExecutionTaskInvocations' => [ 'name' => 'DescribeMaintenanceWindowExecutionTaskInvocations', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest', ], 'output' => [ 'shape' => 'DescribeMaintenanceWindowExecutionTaskInvocationsResult', ], 'errors' => [ [ 'shape' => 'DoesNotExistException', ], [ 'shape' => 'InternalServerError', ], ], ], 'DescribeMaintenanceWindowExecutionTasks' => [ 'name' => 'DescribeMaintenanceWindowExecutionTasks', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeMaintenanceWindowExecutionTasksRequest', ], 'output' => [ 'shape' => 'DescribeMaintenanceWindowExecutionTasksResult', ], 'errors' => [ [ 'shape' => 'DoesNotExistException', ], [ 'shape' => 'InternalServerError', ], ], ], 'DescribeMaintenanceWindowExecutions' => [ 'name' => 'DescribeMaintenanceWindowExecutions', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeMaintenanceWindowExecutionsRequest', ], 'output' => [ 'shape' => 'DescribeMaintenanceWindowExecutionsResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], ], ], 'DescribeMaintenanceWindowTargets' => [ 'name' => 'DescribeMaintenanceWindowTargets', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeMaintenanceWindowTargetsRequest', ], 'output' => [ 'shape' => 'DescribeMaintenanceWindowTargetsResult', ], 'errors' => [ [ 'shape' => 'DoesNotExistException', ], [ 'shape' => 'InternalServerError', ], ], ], 'DescribeMaintenanceWindowTasks' => [ 'name' => 'DescribeMaintenanceWindowTasks', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeMaintenanceWindowTasksRequest', ], 'output' => [ 'shape' => 'DescribeMaintenanceWindowTasksResult', ], 'errors' => [ [ 'shape' => 'DoesNotExistException', ], [ 'shape' => 'InternalServerError', ], ], ], 'DescribeMaintenanceWindows' => [ 'name' => 'DescribeMaintenanceWindows', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeMaintenanceWindowsRequest', ], 'output' => [ 'shape' => 'DescribeMaintenanceWindowsResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], ], ], 'DescribeParameters' => [ 'name' => 'DescribeParameters', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeParametersRequest', ], 'output' => [ 'shape' => 'DescribeParametersResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidFilterValue', ], [ 'shape' => 'InvalidNextToken', ], ], ], 'DescribePatchBaselines' => [ 'name' => 'DescribePatchBaselines', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribePatchBaselinesRequest', ], 'output' => [ 'shape' => 'DescribePatchBaselinesResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], ], ], 'DescribePatchGroupState' => [ 'name' => 'DescribePatchGroupState', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribePatchGroupStateRequest', ], 'output' => [ 'shape' => 'DescribePatchGroupStateResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidNextToken', ], ], ], 'DescribePatchGroups' => [ 'name' => 'DescribePatchGroups', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribePatchGroupsRequest', ], 'output' => [ 'shape' => 'DescribePatchGroupsResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], ], ], 'GetAutomationExecution' => [ 'name' => 'GetAutomationExecution', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetAutomationExecutionRequest', ], 'output' => [ 'shape' => 'GetAutomationExecutionResult', ], 'errors' => [ [ 'shape' => 'AutomationExecutionNotFoundException', ], [ 'shape' => 'InternalServerError', ], ], ], 'GetCommandInvocation' => [ 'name' => 'GetCommandInvocation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetCommandInvocationRequest', ], 'output' => [ 'shape' => 'GetCommandInvocationResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidCommandId', ], [ 'shape' => 'InvalidInstanceId', ], [ 'shape' => 'InvalidPluginName', ], [ 'shape' => 'InvocationDoesNotExist', ], ], ], 'GetDefaultPatchBaseline' => [ 'name' => 'GetDefaultPatchBaseline', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetDefaultPatchBaselineRequest', ], 'output' => [ 'shape' => 'GetDefaultPatchBaselineResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], ], ], 'GetDeployablePatchSnapshotForInstance' => [ 'name' => 'GetDeployablePatchSnapshotForInstance', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetDeployablePatchSnapshotForInstanceRequest', ], 'output' => [ 'shape' => 'GetDeployablePatchSnapshotForInstanceResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], ], ], 'GetDocument' => [ 'name' => 'GetDocument', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetDocumentRequest', ], 'output' => [ 'shape' => 'GetDocumentResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidDocument', ], [ 'shape' => 'InvalidDocumentVersion', ], ], ], 'GetInventory' => [ 'name' => 'GetInventory', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetInventoryRequest', ], 'output' => [ 'shape' => 'GetInventoryResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidFilter', ], [ 'shape' => 'InvalidNextToken', ], [ 'shape' => 'InvalidTypeNameException', ], [ 'shape' => 'InvalidResultAttributeException', ], ], ], 'GetInventorySchema' => [ 'name' => 'GetInventorySchema', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetInventorySchemaRequest', ], 'output' => [ 'shape' => 'GetInventorySchemaResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidTypeNameException', ], [ 'shape' => 'InvalidNextToken', ], ], ], 'GetMaintenanceWindow' => [ 'name' => 'GetMaintenanceWindow', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetMaintenanceWindowRequest', ], 'output' => [ 'shape' => 'GetMaintenanceWindowResult', ], 'errors' => [ [ 'shape' => 'DoesNotExistException', ], [ 'shape' => 'InternalServerError', ], ], ], 'GetMaintenanceWindowExecution' => [ 'name' => 'GetMaintenanceWindowExecution', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetMaintenanceWindowExecutionRequest', ], 'output' => [ 'shape' => 'GetMaintenanceWindowExecutionResult', ], 'errors' => [ [ 'shape' => 'DoesNotExistException', ], [ 'shape' => 'InternalServerError', ], ], ], 'GetMaintenanceWindowExecutionTask' => [ 'name' => 'GetMaintenanceWindowExecutionTask', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetMaintenanceWindowExecutionTaskRequest', ], 'output' => [ 'shape' => 'GetMaintenanceWindowExecutionTaskResult', ], 'errors' => [ [ 'shape' => 'DoesNotExistException', ], [ 'shape' => 'InternalServerError', ], ], ], 'GetParameterHistory' => [ 'name' => 'GetParameterHistory', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetParameterHistoryRequest', ], 'output' => [ 'shape' => 'GetParameterHistoryResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'ParameterNotFound', ], [ 'shape' => 'InvalidNextToken', ], ], ], 'GetParameters' => [ 'name' => 'GetParameters', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetParametersRequest', ], 'output' => [ 'shape' => 'GetParametersResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], ], ], 'GetPatchBaseline' => [ 'name' => 'GetPatchBaseline', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetPatchBaselineRequest', ], 'output' => [ 'shape' => 'GetPatchBaselineResult', ], 'errors' => [ [ 'shape' => 'DoesNotExistException', ], [ 'shape' => 'InvalidResourceId', ], [ 'shape' => 'InternalServerError', ], ], ], 'GetPatchBaselineForPatchGroup' => [ 'name' => 'GetPatchBaselineForPatchGroup', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetPatchBaselineForPatchGroupRequest', ], 'output' => [ 'shape' => 'GetPatchBaselineForPatchGroupResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], ], ], 'ListAssociations' => [ 'name' => 'ListAssociations', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListAssociationsRequest', ], 'output' => [ 'shape' => 'ListAssociationsResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidNextToken', ], ], ], 'ListCommandInvocations' => [ 'name' => 'ListCommandInvocations', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListCommandInvocationsRequest', ], 'output' => [ 'shape' => 'ListCommandInvocationsResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidCommandId', ], [ 'shape' => 'InvalidInstanceId', ], [ 'shape' => 'InvalidFilterKey', ], [ 'shape' => 'InvalidNextToken', ], ], ], 'ListCommands' => [ 'name' => 'ListCommands', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListCommandsRequest', ], 'output' => [ 'shape' => 'ListCommandsResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidCommandId', ], [ 'shape' => 'InvalidInstanceId', ], [ 'shape' => 'InvalidFilterKey', ], [ 'shape' => 'InvalidNextToken', ], ], ], 'ListDocumentVersions' => [ 'name' => 'ListDocumentVersions', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListDocumentVersionsRequest', ], 'output' => [ 'shape' => 'ListDocumentVersionsResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidNextToken', ], [ 'shape' => 'InvalidDocument', ], ], ], 'ListDocuments' => [ 'name' => 'ListDocuments', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListDocumentsRequest', ], 'output' => [ 'shape' => 'ListDocumentsResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidNextToken', ], [ 'shape' => 'InvalidFilterKey', ], ], ], 'ListInventoryEntries' => [ 'name' => 'ListInventoryEntries', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListInventoryEntriesRequest', ], 'output' => [ 'shape' => 'ListInventoryEntriesResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidInstanceId', ], [ 'shape' => 'InvalidTypeNameException', ], [ 'shape' => 'InvalidFilter', ], [ 'shape' => 'InvalidNextToken', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResult', ], 'errors' => [ [ 'shape' => 'InvalidResourceType', ], [ 'shape' => 'InvalidResourceId', ], [ 'shape' => 'InternalServerError', ], ], ], 'ModifyDocumentPermission' => [ 'name' => 'ModifyDocumentPermission', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ModifyDocumentPermissionRequest', ], 'output' => [ 'shape' => 'ModifyDocumentPermissionResponse', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidDocument', ], [ 'shape' => 'InvalidPermissionType', ], [ 'shape' => 'DocumentPermissionLimit', ], [ 'shape' => 'DocumentLimitExceeded', ], ], ], 'PutInventory' => [ 'name' => 'PutInventory', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'PutInventoryRequest', ], 'output' => [ 'shape' => 'PutInventoryResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidInstanceId', ], [ 'shape' => 'InvalidTypeNameException', ], [ 'shape' => 'InvalidItemContentException', ], [ 'shape' => 'TotalSizeLimitExceededException', ], [ 'shape' => 'ItemSizeLimitExceededException', ], [ 'shape' => 'ItemContentMismatchException', ], [ 'shape' => 'CustomSchemaCountLimitExceededException', ], [ 'shape' => 'UnsupportedInventorySchemaVersionException', ], ], ], 'PutParameter' => [ 'name' => 'PutParameter', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'PutParameterRequest', ], 'output' => [ 'shape' => 'PutParameterResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidKeyId', ], [ 'shape' => 'ParameterLimitExceeded', ], [ 'shape' => 'TooManyUpdates', ], [ 'shape' => 'ParameterAlreadyExists', ], [ 'shape' => 'UnsupportedParameterType', ], ], ], 'RegisterDefaultPatchBaseline' => [ 'name' => 'RegisterDefaultPatchBaseline', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'RegisterDefaultPatchBaselineRequest', ], 'output' => [ 'shape' => 'RegisterDefaultPatchBaselineResult', ], 'errors' => [ [ 'shape' => 'InvalidResourceId', ], [ 'shape' => 'DoesNotExistException', ], [ 'shape' => 'InternalServerError', ], ], ], 'RegisterPatchBaselineForPatchGroup' => [ 'name' => 'RegisterPatchBaselineForPatchGroup', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'RegisterPatchBaselineForPatchGroupRequest', ], 'output' => [ 'shape' => 'RegisterPatchBaselineForPatchGroupResult', ], 'errors' => [ [ 'shape' => 'AlreadyExistsException', ], [ 'shape' => 'DoesNotExistException', ], [ 'shape' => 'InvalidResourceId', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'InternalServerError', ], ], ], 'RegisterTargetWithMaintenanceWindow' => [ 'name' => 'RegisterTargetWithMaintenanceWindow', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'RegisterTargetWithMaintenanceWindowRequest', ], 'output' => [ 'shape' => 'RegisterTargetWithMaintenanceWindowResult', ], 'errors' => [ [ 'shape' => 'IdempotentParameterMismatch', ], [ 'shape' => 'DoesNotExistException', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'InternalServerError', ], ], ], 'RegisterTaskWithMaintenanceWindow' => [ 'name' => 'RegisterTaskWithMaintenanceWindow', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'RegisterTaskWithMaintenanceWindowRequest', ], 'output' => [ 'shape' => 'RegisterTaskWithMaintenanceWindowResult', ], 'errors' => [ [ 'shape' => 'IdempotentParameterMismatch', ], [ 'shape' => 'DoesNotExistException', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'InternalServerError', ], ], ], 'RemoveTagsFromResource' => [ 'name' => 'RemoveTagsFromResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'RemoveTagsFromResourceRequest', ], 'output' => [ 'shape' => 'RemoveTagsFromResourceResult', ], 'errors' => [ [ 'shape' => 'InvalidResourceType', ], [ 'shape' => 'InvalidResourceId', ], [ 'shape' => 'InternalServerError', ], ], ], 'SendCommand' => [ 'name' => 'SendCommand', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'SendCommandRequest', ], 'output' => [ 'shape' => 'SendCommandResult', ], 'errors' => [ [ 'shape' => 'DuplicateInstanceId', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidInstanceId', ], [ 'shape' => 'InvalidDocument', ], [ 'shape' => 'InvalidOutputFolder', ], [ 'shape' => 'InvalidParameters', ], [ 'shape' => 'UnsupportedPlatformType', ], [ 'shape' => 'MaxDocumentSizeExceeded', ], [ 'shape' => 'InvalidRole', ], [ 'shape' => 'InvalidNotificationConfig', ], ], ], 'StartAutomationExecution' => [ 'name' => 'StartAutomationExecution', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StartAutomationExecutionRequest', ], 'output' => [ 'shape' => 'StartAutomationExecutionResult', ], 'errors' => [ [ 'shape' => 'AutomationDefinitionNotFoundException', ], [ 'shape' => 'InvalidAutomationExecutionParametersException', ], [ 'shape' => 'AutomationExecutionLimitExceededException', ], [ 'shape' => 'AutomationDefinitionVersionNotFoundException', ], [ 'shape' => 'InternalServerError', ], ], ], 'StopAutomationExecution' => [ 'name' => 'StopAutomationExecution', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StopAutomationExecutionRequest', ], 'output' => [ 'shape' => 'StopAutomationExecutionResult', ], 'errors' => [ [ 'shape' => 'AutomationExecutionNotFoundException', ], [ 'shape' => 'InternalServerError', ], ], ], 'UpdateAssociation' => [ 'name' => 'UpdateAssociation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateAssociationRequest', ], 'output' => [ 'shape' => 'UpdateAssociationResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidSchedule', ], [ 'shape' => 'InvalidParameters', ], [ 'shape' => 'InvalidOutputLocation', ], [ 'shape' => 'InvalidDocumentVersion', ], [ 'shape' => 'AssociationDoesNotExist', ], [ 'shape' => 'InvalidUpdate', ], [ 'shape' => 'TooManyUpdates', ], [ 'shape' => 'InvalidDocument', ], [ 'shape' => 'InvalidTarget', ], ], ], 'UpdateAssociationStatus' => [ 'name' => 'UpdateAssociationStatus', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateAssociationStatusRequest', ], 'output' => [ 'shape' => 'UpdateAssociationStatusResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidInstanceId', ], [ 'shape' => 'InvalidDocument', ], [ 'shape' => 'AssociationDoesNotExist', ], [ 'shape' => 'StatusUnchanged', ], [ 'shape' => 'TooManyUpdates', ], ], ], 'UpdateDocument' => [ 'name' => 'UpdateDocument', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateDocumentRequest', ], 'output' => [ 'shape' => 'UpdateDocumentResult', ], 'errors' => [ [ 'shape' => 'MaxDocumentSizeExceeded', ], [ 'shape' => 'DocumentVersionLimitExceeded', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'DuplicateDocumentContent', ], [ 'shape' => 'InvalidDocumentContent', ], [ 'shape' => 'InvalidDocumentVersion', ], [ 'shape' => 'InvalidDocumentSchemaVersion', ], [ 'shape' => 'InvalidDocument', ], ], ], 'UpdateDocumentDefaultVersion' => [ 'name' => 'UpdateDocumentDefaultVersion', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateDocumentDefaultVersionRequest', ], 'output' => [ 'shape' => 'UpdateDocumentDefaultVersionResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', ], [ 'shape' => 'InvalidDocument', ], [ 'shape' => 'InvalidDocumentVersion', ], [ 'shape' => 'InvalidDocumentSchemaVersion', ], ], ], 'UpdateMaintenanceWindow' => [ 'name' => 'UpdateMaintenanceWindow', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateMaintenanceWindowRequest', ], 'output' => [ 'shape' => 'UpdateMaintenanceWindowResult', ], 'errors' => [ [ 'shape' => 'DoesNotExistException', ], [ 'shape' => 'InternalServerError', ], ], ], 'UpdateManagedInstanceRole' => [ 'name' => 'UpdateManagedInstanceRole', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateManagedInstanceRoleRequest', ], 'output' => [ 'shape' => 'UpdateManagedInstanceRoleResult', ], 'errors' => [ [ 'shape' => 'InvalidInstanceId', ], [ 'shape' => 'InternalServerError', ], ], ], 'UpdatePatchBaseline' => [ 'name' => 'UpdatePatchBaseline', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdatePatchBaselineRequest', ], 'output' => [ 'shape' => 'UpdatePatchBaselineResult', ], 'errors' => [ [ 'shape' => 'DoesNotExistException', ], [ 'shape' => 'InternalServerError', ], ], ], ], 'shapes' => [ 'AccountId' => [ 'type' => 'string', 'pattern' => '(?i)all|[0-9]{12}', ], 'AccountIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AccountId', 'locationName' => 'AccountId', ], 'max' => 20, ], 'Activation' => [ 'type' => 'structure', 'members' => [ 'ActivationId' => [ 'shape' => 'ActivationId', ], 'Description' => [ 'shape' => 'ActivationDescription', ], 'DefaultInstanceName' => [ 'shape' => 'DefaultInstanceName', ], 'IamRole' => [ 'shape' => 'IamRole', ], 'RegistrationLimit' => [ 'shape' => 'RegistrationLimit', ], 'RegistrationsCount' => [ 'shape' => 'RegistrationsCount', ], 'ExpirationDate' => [ 'shape' => 'ExpirationDate', ], 'Expired' => [ 'shape' => 'Boolean', ], 'CreatedDate' => [ 'shape' => 'CreatedDate', ], ], ], 'ActivationCode' => [ 'type' => 'string', 'max' => 250, 'min' => 20, ], 'ActivationDescription' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'ActivationId' => [ 'type' => 'string', 'pattern' => '^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$', ], 'ActivationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Activation', ], ], 'AddTagsToResourceRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceType', 'ResourceId', 'Tags', ], 'members' => [ 'ResourceType' => [ 'shape' => 'ResourceTypeForTagging', ], 'ResourceId' => [ 'shape' => 'ResourceId', ], 'Tags' => [ 'shape' => 'TagList', ], ], ], 'AddTagsToResourceResult' => [ 'type' => 'structure', 'members' => [], ], 'AgentErrorCode' => [ 'type' => 'string', 'max' => 10, ], 'AlreadyExistsException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'ApproveAfterDays' => [ 'type' => 'integer', 'max' => 100, 'min' => 0, ], 'AssociatedInstances' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'Association' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'AssociationId' => [ 'shape' => 'AssociationId', ], 'DocumentVersion' => [ 'shape' => 'DocumentVersion', ], 'Targets' => [ 'shape' => 'Targets', ], 'LastExecutionDate' => [ 'shape' => 'DateTime', ], 'Overview' => [ 'shape' => 'AssociationOverview', ], 'ScheduleExpression' => [ 'shape' => 'ScheduleExpression', ], ], ], 'AssociationAlreadyExists' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'AssociationDescription' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'Date' => [ 'shape' => 'DateTime', ], 'LastUpdateAssociationDate' => [ 'shape' => 'DateTime', ], 'Status' => [ 'shape' => 'AssociationStatus', ], 'Overview' => [ 'shape' => 'AssociationOverview', ], 'DocumentVersion' => [ 'shape' => 'DocumentVersion', ], 'Parameters' => [ 'shape' => 'Parameters', ], 'AssociationId' => [ 'shape' => 'AssociationId', ], 'Targets' => [ 'shape' => 'Targets', ], 'ScheduleExpression' => [ 'shape' => 'ScheduleExpression', ], 'OutputLocation' => [ 'shape' => 'InstanceAssociationOutputLocation', ], 'LastExecutionDate' => [ 'shape' => 'DateTime', ], 'LastSuccessfulExecutionDate' => [ 'shape' => 'DateTime', ], ], ], 'AssociationDescriptionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssociationDescription', 'locationName' => 'AssociationDescription', ], ], 'AssociationDoesNotExist' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'AssociationFilter' => [ 'type' => 'structure', 'required' => [ 'key', 'value', ], 'members' => [ 'key' => [ 'shape' => 'AssociationFilterKey', ], 'value' => [ 'shape' => 'AssociationFilterValue', ], ], ], 'AssociationFilterKey' => [ 'type' => 'string', 'enum' => [ 'InstanceId', 'Name', 'AssociationId', 'AssociationStatusName', 'LastExecutedBefore', 'LastExecutedAfter', ], ], 'AssociationFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssociationFilter', 'locationName' => 'AssociationFilter', ], 'min' => 1, ], 'AssociationFilterValue' => [ 'type' => 'string', 'min' => 1, ], 'AssociationId' => [ 'type' => 'string', 'pattern' => '[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', ], 'AssociationLimitExceeded' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'AssociationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Association', 'locationName' => 'Association', ], ], 'AssociationOverview' => [ 'type' => 'structure', 'members' => [ 'Status' => [ 'shape' => 'StatusName', ], 'DetailedStatus' => [ 'shape' => 'StatusName', ], 'AssociationStatusAggregatedCount' => [ 'shape' => 'AssociationStatusAggregatedCount', ], ], ], 'AssociationStatus' => [ 'type' => 'structure', 'required' => [ 'Date', 'Name', 'Message', ], 'members' => [ 'Date' => [ 'shape' => 'DateTime', ], 'Name' => [ 'shape' => 'AssociationStatusName', ], 'Message' => [ 'shape' => 'StatusMessage', ], 'AdditionalInfo' => [ 'shape' => 'StatusAdditionalInfo', ], ], ], 'AssociationStatusAggregatedCount' => [ 'type' => 'map', 'key' => [ 'shape' => 'StatusName', ], 'value' => [ 'shape' => 'InstanceCount', ], ], 'AssociationStatusName' => [ 'type' => 'string', 'enum' => [ 'Pending', 'Success', 'Failed', ], ], 'AttributeName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, ], 'AttributeValue' => [ 'type' => 'string', 'max' => 1024, 'min' => 0, ], 'AutomationActionName' => [ 'type' => 'string', 'pattern' => '^aws:[a-zA-Z]{3,25}$', ], 'AutomationDefinitionNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'AutomationDefinitionVersionNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'AutomationExecution' => [ 'type' => 'structure', 'members' => [ 'AutomationExecutionId' => [ 'shape' => 'AutomationExecutionId', ], 'DocumentName' => [ 'shape' => 'DocumentName', ], 'DocumentVersion' => [ 'shape' => 'DocumentVersion', ], 'ExecutionStartTime' => [ 'shape' => 'DateTime', ], 'ExecutionEndTime' => [ 'shape' => 'DateTime', ], 'AutomationExecutionStatus' => [ 'shape' => 'AutomationExecutionStatus', ], 'StepExecutions' => [ 'shape' => 'StepExecutionList', ], 'Parameters' => [ 'shape' => 'AutomationParameterMap', ], 'Outputs' => [ 'shape' => 'AutomationParameterMap', ], 'FailureMessage' => [ 'shape' => 'String', ], ], ], 'AutomationExecutionFilter' => [ 'type' => 'structure', 'required' => [ 'Key', 'Values', ], 'members' => [ 'Key' => [ 'shape' => 'AutomationExecutionFilterKey', ], 'Values' => [ 'shape' => 'AutomationExecutionFilterValueList', ], ], ], 'AutomationExecutionFilterKey' => [ 'type' => 'string', 'enum' => [ 'DocumentNamePrefix', 'ExecutionStatus', ], ], 'AutomationExecutionFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AutomationExecutionFilter', ], 'max' => 10, 'min' => 1, ], 'AutomationExecutionFilterValue' => [ 'type' => 'string', 'max' => 150, 'min' => 1, ], 'AutomationExecutionFilterValueList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AutomationExecutionFilterValue', ], 'max' => 10, 'min' => 1, ], 'AutomationExecutionId' => [ 'type' => 'string', 'max' => 36, 'min' => 36, ], 'AutomationExecutionLimitExceededException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'AutomationExecutionMetadata' => [ 'type' => 'structure', 'members' => [ 'AutomationExecutionId' => [ 'shape' => 'AutomationExecutionId', ], 'DocumentName' => [ 'shape' => 'DocumentName', ], 'DocumentVersion' => [ 'shape' => 'DocumentVersion', ], 'AutomationExecutionStatus' => [ 'shape' => 'AutomationExecutionStatus', ], 'ExecutionStartTime' => [ 'shape' => 'DateTime', ], 'ExecutionEndTime' => [ 'shape' => 'DateTime', ], 'ExecutedBy' => [ 'shape' => 'String', ], 'LogFile' => [ 'shape' => 'String', ], 'Outputs' => [ 'shape' => 'AutomationParameterMap', ], ], ], 'AutomationExecutionMetadataList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AutomationExecutionMetadata', ], 'max' => 50, 'min' => 0, ], 'AutomationExecutionNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'AutomationExecutionStatus' => [ 'type' => 'string', 'enum' => [ 'Pending', 'InProgress', 'Success', 'TimedOut', 'Cancelled', 'Failed', ], ], 'AutomationParameterKey' => [ 'type' => 'string', 'max' => 30, 'min' => 1, ], 'AutomationParameterMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'AutomationParameterKey', ], 'value' => [ 'shape' => 'AutomationParameterValueList', ], 'max' => 200, 'min' => 1, ], 'AutomationParameterValue' => [ 'type' => 'string', 'max' => 512, 'min' => 1, ], 'AutomationParameterValueList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AutomationParameterValue', ], 'max' => 10, 'min' => 0, ], 'BaselineDescription' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'BaselineId' => [ 'type' => 'string', 'max' => 128, 'min' => 20, 'pattern' => '^[a-zA-Z0-9_\\-:/]{20,128}$', ], 'BaselineName' => [ 'type' => 'string', 'max' => 128, 'min' => 3, 'pattern' => '^[a-zA-Z0-9_\\-.]{3,128}$', ], 'BatchErrorMessage' => [ 'type' => 'string', ], 'Boolean' => [ 'type' => 'boolean', ], 'CancelCommandRequest' => [ 'type' => 'structure', 'required' => [ 'CommandId', ], 'members' => [ 'CommandId' => [ 'shape' => 'CommandId', ], 'InstanceIds' => [ 'shape' => 'InstanceIdList', ], ], ], 'CancelCommandResult' => [ 'type' => 'structure', 'members' => [], ], 'ClientToken' => [ 'type' => 'string', 'max' => 64, 'min' => 1, ], 'Command' => [ 'type' => 'structure', 'members' => [ 'CommandId' => [ 'shape' => 'CommandId', ], 'DocumentName' => [ 'shape' => 'DocumentName', ], 'Comment' => [ 'shape' => 'Comment', ], 'ExpiresAfter' => [ 'shape' => 'DateTime', ], 'Parameters' => [ 'shape' => 'Parameters', ], 'InstanceIds' => [ 'shape' => 'InstanceIdList', ], 'Targets' => [ 'shape' => 'Targets', ], 'RequestedDateTime' => [ 'shape' => 'DateTime', ], 'Status' => [ 'shape' => 'CommandStatus', ], 'StatusDetails' => [ 'shape' => 'StatusDetails', ], 'OutputS3Region' => [ 'shape' => 'S3Region', ], 'OutputS3BucketName' => [ 'shape' => 'S3BucketName', ], 'OutputS3KeyPrefix' => [ 'shape' => 'S3KeyPrefix', ], 'MaxConcurrency' => [ 'shape' => 'MaxConcurrency', ], 'MaxErrors' => [ 'shape' => 'MaxErrors', ], 'TargetCount' => [ 'shape' => 'TargetCount', ], 'CompletedCount' => [ 'shape' => 'CompletedCount', ], 'ErrorCount' => [ 'shape' => 'ErrorCount', ], 'ServiceRole' => [ 'shape' => 'ServiceRole', ], 'NotificationConfig' => [ 'shape' => 'NotificationConfig', ], ], ], 'CommandFilter' => [ 'type' => 'structure', 'required' => [ 'key', 'value', ], 'members' => [ 'key' => [ 'shape' => 'CommandFilterKey', ], 'value' => [ 'shape' => 'CommandFilterValue', ], ], ], 'CommandFilterKey' => [ 'type' => 'string', 'enum' => [ 'InvokedAfter', 'InvokedBefore', 'Status', ], ], 'CommandFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CommandFilter', ], 'max' => 3, 'min' => 1, ], 'CommandFilterValue' => [ 'type' => 'string', 'min' => 1, ], 'CommandId' => [ 'type' => 'string', 'max' => 36, 'min' => 36, ], 'CommandInvocation' => [ 'type' => 'structure', 'members' => [ 'CommandId' => [ 'shape' => 'CommandId', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'InstanceName' => [ 'shape' => 'InstanceTagName', ], 'Comment' => [ 'shape' => 'Comment', ], 'DocumentName' => [ 'shape' => 'DocumentName', ], 'RequestedDateTime' => [ 'shape' => 'DateTime', ], 'Status' => [ 'shape' => 'CommandInvocationStatus', ], 'StatusDetails' => [ 'shape' => 'StatusDetails', ], 'TraceOutput' => [ 'shape' => 'InvocationTraceOutput', ], 'StandardOutputUrl' => [ 'shape' => 'Url', ], 'StandardErrorUrl' => [ 'shape' => 'Url', ], 'CommandPlugins' => [ 'shape' => 'CommandPluginList', ], 'ServiceRole' => [ 'shape' => 'ServiceRole', ], 'NotificationConfig' => [ 'shape' => 'NotificationConfig', ], ], ], 'CommandInvocationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CommandInvocation', ], ], 'CommandInvocationStatus' => [ 'type' => 'string', 'enum' => [ 'Pending', 'InProgress', 'Delayed', 'Success', 'Cancelled', 'TimedOut', 'Failed', 'Cancelling', ], ], 'CommandList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Command', ], ], 'CommandMaxResults' => [ 'type' => 'integer', 'max' => 50, 'min' => 1, ], 'CommandPlugin' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'CommandPluginName', ], 'Status' => [ 'shape' => 'CommandPluginStatus', ], 'StatusDetails' => [ 'shape' => 'StatusDetails', ], 'ResponseCode' => [ 'shape' => 'ResponseCode', ], 'ResponseStartDateTime' => [ 'shape' => 'DateTime', ], 'ResponseFinishDateTime' => [ 'shape' => 'DateTime', ], 'Output' => [ 'shape' => 'CommandPluginOutput', ], 'StandardOutputUrl' => [ 'shape' => 'Url', ], 'StandardErrorUrl' => [ 'shape' => 'Url', ], 'OutputS3Region' => [ 'shape' => 'S3Region', ], 'OutputS3BucketName' => [ 'shape' => 'S3BucketName', ], 'OutputS3KeyPrefix' => [ 'shape' => 'S3KeyPrefix', ], ], ], 'CommandPluginList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CommandPlugin', ], ], 'CommandPluginName' => [ 'type' => 'string', 'min' => 4, ], 'CommandPluginOutput' => [ 'type' => 'string', 'max' => 2500, ], 'CommandPluginStatus' => [ 'type' => 'string', 'enum' => [ 'Pending', 'InProgress', 'Success', 'TimedOut', 'Cancelled', 'Failed', ], ], 'CommandStatus' => [ 'type' => 'string', 'enum' => [ 'Pending', 'InProgress', 'Success', 'Cancelled', 'Failed', 'TimedOut', 'Cancelling', ], ], 'Comment' => [ 'type' => 'string', 'max' => 100, ], 'CompletedCount' => [ 'type' => 'integer', ], 'ComputerName' => [ 'type' => 'string', 'max' => 255, 'min' => 1, ], 'CreateActivationRequest' => [ 'type' => 'structure', 'required' => [ 'IamRole', ], 'members' => [ 'Description' => [ 'shape' => 'ActivationDescription', ], 'DefaultInstanceName' => [ 'shape' => 'DefaultInstanceName', ], 'IamRole' => [ 'shape' => 'IamRole', ], 'RegistrationLimit' => [ 'shape' => 'RegistrationLimit', 'box' => true, ], 'ExpirationDate' => [ 'shape' => 'ExpirationDate', ], ], ], 'CreateActivationResult' => [ 'type' => 'structure', 'members' => [ 'ActivationId' => [ 'shape' => 'ActivationId', ], 'ActivationCode' => [ 'shape' => 'ActivationCode', ], ], ], 'CreateAssociationBatchRequest' => [ 'type' => 'structure', 'required' => [ 'Entries', ], 'members' => [ 'Entries' => [ 'shape' => 'CreateAssociationBatchRequestEntries', ], ], ], 'CreateAssociationBatchRequestEntries' => [ 'type' => 'list', 'member' => [ 'shape' => 'CreateAssociationBatchRequestEntry', 'locationName' => 'entries', ], 'min' => 1, ], 'CreateAssociationBatchRequestEntry' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'Parameters' => [ 'shape' => 'Parameters', ], 'DocumentVersion' => [ 'shape' => 'DocumentVersion', ], 'Targets' => [ 'shape' => 'Targets', ], 'ScheduleExpression' => [ 'shape' => 'ScheduleExpression', ], 'OutputLocation' => [ 'shape' => 'InstanceAssociationOutputLocation', ], ], ], 'CreateAssociationBatchResult' => [ 'type' => 'structure', 'members' => [ 'Successful' => [ 'shape' => 'AssociationDescriptionList', ], 'Failed' => [ 'shape' => 'FailedCreateAssociationList', ], ], ], 'CreateAssociationRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'DocumentVersion' => [ 'shape' => 'DocumentVersion', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'Parameters' => [ 'shape' => 'Parameters', ], 'Targets' => [ 'shape' => 'Targets', ], 'ScheduleExpression' => [ 'shape' => 'ScheduleExpression', ], 'OutputLocation' => [ 'shape' => 'InstanceAssociationOutputLocation', ], ], ], 'CreateAssociationResult' => [ 'type' => 'structure', 'members' => [ 'AssociationDescription' => [ 'shape' => 'AssociationDescription', ], ], ], 'CreateDocumentRequest' => [ 'type' => 'structure', 'required' => [ 'Content', 'Name', ], 'members' => [ 'Content' => [ 'shape' => 'DocumentContent', ], 'Name' => [ 'shape' => 'DocumentName', ], 'DocumentType' => [ 'shape' => 'DocumentType', ], ], ], 'CreateDocumentResult' => [ 'type' => 'structure', 'members' => [ 'DocumentDescription' => [ 'shape' => 'DocumentDescription', ], ], ], 'CreateMaintenanceWindowRequest' => [ 'type' => 'structure', 'required' => [ 'Name', 'Schedule', 'Duration', 'Cutoff', 'AllowUnassociatedTargets', ], 'members' => [ 'Name' => [ 'shape' => 'MaintenanceWindowName', ], 'Schedule' => [ 'shape' => 'MaintenanceWindowSchedule', ], 'Duration' => [ 'shape' => 'MaintenanceWindowDurationHours', ], 'Cutoff' => [ 'shape' => 'MaintenanceWindowCutoff', ], 'AllowUnassociatedTargets' => [ 'shape' => 'MaintenanceWindowAllowUnassociatedTargets', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CreateMaintenanceWindowResult' => [ 'type' => 'structure', 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], ], ], 'CreatePatchBaselineRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'BaselineName', ], 'GlobalFilters' => [ 'shape' => 'PatchFilterGroup', ], 'ApprovalRules' => [ 'shape' => 'PatchRuleGroup', ], 'ApprovedPatches' => [ 'shape' => 'PatchIdList', ], 'RejectedPatches' => [ 'shape' => 'PatchIdList', ], 'Description' => [ 'shape' => 'BaselineDescription', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CreatePatchBaselineResult' => [ 'type' => 'structure', 'members' => [ 'BaselineId' => [ 'shape' => 'BaselineId', ], ], ], 'CreatedDate' => [ 'type' => 'timestamp', ], 'CustomSchemaCountLimitExceededException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'DateTime' => [ 'type' => 'timestamp', ], 'DefaultBaseline' => [ 'type' => 'boolean', ], 'DefaultInstanceName' => [ 'type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => '^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$', ], 'DeleteActivationRequest' => [ 'type' => 'structure', 'required' => [ 'ActivationId', ], 'members' => [ 'ActivationId' => [ 'shape' => 'ActivationId', ], ], ], 'DeleteActivationResult' => [ 'type' => 'structure', 'members' => [], ], 'DeleteAssociationRequest' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'AssociationId' => [ 'shape' => 'AssociationId', ], ], ], 'DeleteAssociationResult' => [ 'type' => 'structure', 'members' => [], ], 'DeleteDocumentRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], ], ], 'DeleteDocumentResult' => [ 'type' => 'structure', 'members' => [], ], 'DeleteMaintenanceWindowRequest' => [ 'type' => 'structure', 'required' => [ 'WindowId', ], 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], ], ], 'DeleteMaintenanceWindowResult' => [ 'type' => 'structure', 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], ], ], 'DeleteParameterRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'PSParameterName', ], ], ], 'DeleteParameterResult' => [ 'type' => 'structure', 'members' => [], ], 'DeletePatchBaselineRequest' => [ 'type' => 'structure', 'required' => [ 'BaselineId', ], 'members' => [ 'BaselineId' => [ 'shape' => 'BaselineId', ], ], ], 'DeletePatchBaselineResult' => [ 'type' => 'structure', 'members' => [ 'BaselineId' => [ 'shape' => 'BaselineId', ], ], ], 'DeregisterManagedInstanceRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'ManagedInstanceId', ], ], ], 'DeregisterManagedInstanceResult' => [ 'type' => 'structure', 'members' => [], ], 'DeregisterPatchBaselineForPatchGroupRequest' => [ 'type' => 'structure', 'required' => [ 'BaselineId', 'PatchGroup', ], 'members' => [ 'BaselineId' => [ 'shape' => 'BaselineId', ], 'PatchGroup' => [ 'shape' => 'PatchGroup', ], ], ], 'DeregisterPatchBaselineForPatchGroupResult' => [ 'type' => 'structure', 'members' => [ 'BaselineId' => [ 'shape' => 'BaselineId', ], 'PatchGroup' => [ 'shape' => 'PatchGroup', ], ], ], 'DeregisterTargetFromMaintenanceWindowRequest' => [ 'type' => 'structure', 'required' => [ 'WindowId', 'WindowTargetId', ], 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], 'WindowTargetId' => [ 'shape' => 'MaintenanceWindowTargetId', ], ], ], 'DeregisterTargetFromMaintenanceWindowResult' => [ 'type' => 'structure', 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], 'WindowTargetId' => [ 'shape' => 'MaintenanceWindowTargetId', ], ], ], 'DeregisterTaskFromMaintenanceWindowRequest' => [ 'type' => 'structure', 'required' => [ 'WindowId', 'WindowTaskId', ], 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], 'WindowTaskId' => [ 'shape' => 'MaintenanceWindowTaskId', ], ], ], 'DeregisterTaskFromMaintenanceWindowResult' => [ 'type' => 'structure', 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], 'WindowTaskId' => [ 'shape' => 'MaintenanceWindowTaskId', ], ], ], 'DescribeActivationsFilter' => [ 'type' => 'structure', 'members' => [ 'FilterKey' => [ 'shape' => 'DescribeActivationsFilterKeys', ], 'FilterValues' => [ 'shape' => 'StringList', ], ], ], 'DescribeActivationsFilterKeys' => [ 'type' => 'string', 'enum' => [ 'ActivationIds', 'DefaultInstanceName', 'IamRole', ], ], 'DescribeActivationsFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DescribeActivationsFilter', ], ], 'DescribeActivationsRequest' => [ 'type' => 'structure', 'members' => [ 'Filters' => [ 'shape' => 'DescribeActivationsFilterList', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeActivationsResult' => [ 'type' => 'structure', 'members' => [ 'ActivationList' => [ 'shape' => 'ActivationList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeAssociationRequest' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'AssociationId' => [ 'shape' => 'AssociationId', ], ], ], 'DescribeAssociationResult' => [ 'type' => 'structure', 'members' => [ 'AssociationDescription' => [ 'shape' => 'AssociationDescription', ], ], ], 'DescribeAutomationExecutionsRequest' => [ 'type' => 'structure', 'members' => [ 'Filters' => [ 'shape' => 'AutomationExecutionFilterList', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeAutomationExecutionsResult' => [ 'type' => 'structure', 'members' => [ 'AutomationExecutionMetadataList' => [ 'shape' => 'AutomationExecutionMetadataList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeAvailablePatchesRequest' => [ 'type' => 'structure', 'members' => [ 'Filters' => [ 'shape' => 'PatchOrchestratorFilterList', ], 'MaxResults' => [ 'shape' => 'PatchBaselineMaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeAvailablePatchesResult' => [ 'type' => 'structure', 'members' => [ 'Patches' => [ 'shape' => 'PatchList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeDocumentPermissionRequest' => [ 'type' => 'structure', 'required' => [ 'Name', 'PermissionType', ], 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'PermissionType' => [ 'shape' => 'DocumentPermissionType', ], ], ], 'DescribeDocumentPermissionResponse' => [ 'type' => 'structure', 'members' => [ 'AccountIds' => [ 'shape' => 'AccountIdList', ], ], ], 'DescribeDocumentRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'DocumentARN', ], 'DocumentVersion' => [ 'shape' => 'DocumentVersion', ], ], ], 'DescribeDocumentResult' => [ 'type' => 'structure', 'members' => [ 'Document' => [ 'shape' => 'DocumentDescription', ], ], ], 'DescribeEffectiveInstanceAssociationsRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', ], 'MaxResults' => [ 'shape' => 'EffectiveInstanceAssociationMaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeEffectiveInstanceAssociationsResult' => [ 'type' => 'structure', 'members' => [ 'Associations' => [ 'shape' => 'InstanceAssociationList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeEffectivePatchesForPatchBaselineRequest' => [ 'type' => 'structure', 'required' => [ 'BaselineId', ], 'members' => [ 'BaselineId' => [ 'shape' => 'BaselineId', ], 'MaxResults' => [ 'shape' => 'PatchBaselineMaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeEffectivePatchesForPatchBaselineResult' => [ 'type' => 'structure', 'members' => [ 'EffectivePatches' => [ 'shape' => 'EffectivePatchList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeInstanceAssociationsStatusRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeInstanceAssociationsStatusResult' => [ 'type' => 'structure', 'members' => [ 'InstanceAssociationStatusInfos' => [ 'shape' => 'InstanceAssociationStatusInfos', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeInstanceInformationRequest' => [ 'type' => 'structure', 'members' => [ 'InstanceInformationFilterList' => [ 'shape' => 'InstanceInformationFilterList', ], 'Filters' => [ 'shape' => 'InstanceInformationStringFilterList', ], 'MaxResults' => [ 'shape' => 'MaxResultsEC2Compatible', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeInstanceInformationResult' => [ 'type' => 'structure', 'members' => [ 'InstanceInformationList' => [ 'shape' => 'InstanceInformationList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeInstancePatchStatesForPatchGroupRequest' => [ 'type' => 'structure', 'required' => [ 'PatchGroup', ], 'members' => [ 'PatchGroup' => [ 'shape' => 'PatchGroup', ], 'Filters' => [ 'shape' => 'InstancePatchStateFilterList', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'PatchComplianceMaxResults', 'box' => true, ], ], ], 'DescribeInstancePatchStatesForPatchGroupResult' => [ 'type' => 'structure', 'members' => [ 'InstancePatchStates' => [ 'shape' => 'InstancePatchStatesList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeInstancePatchStatesRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceIds', ], 'members' => [ 'InstanceIds' => [ 'shape' => 'InstanceIdList', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'PatchComplianceMaxResults', 'box' => true, ], ], ], 'DescribeInstancePatchStatesResult' => [ 'type' => 'structure', 'members' => [ 'InstancePatchStates' => [ 'shape' => 'InstancePatchStateList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeInstancePatchesRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', ], 'Filters' => [ 'shape' => 'PatchOrchestratorFilterList', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'PatchComplianceMaxResults', 'box' => true, ], ], ], 'DescribeInstancePatchesResult' => [ 'type' => 'structure', 'members' => [ 'Patches' => [ 'shape' => 'PatchComplianceDataList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest' => [ 'type' => 'structure', 'required' => [ 'WindowExecutionId', 'TaskId', ], 'members' => [ 'WindowExecutionId' => [ 'shape' => 'MaintenanceWindowExecutionId', ], 'TaskId' => [ 'shape' => 'MaintenanceWindowExecutionTaskId', ], 'Filters' => [ 'shape' => 'MaintenanceWindowFilterList', ], 'MaxResults' => [ 'shape' => 'MaintenanceWindowMaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeMaintenanceWindowExecutionTaskInvocationsResult' => [ 'type' => 'structure', 'members' => [ 'WindowExecutionTaskInvocationIdentities' => [ 'shape' => 'MaintenanceWindowExecutionTaskInvocationIdentityList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeMaintenanceWindowExecutionTasksRequest' => [ 'type' => 'structure', 'required' => [ 'WindowExecutionId', ], 'members' => [ 'WindowExecutionId' => [ 'shape' => 'MaintenanceWindowExecutionId', ], 'Filters' => [ 'shape' => 'MaintenanceWindowFilterList', ], 'MaxResults' => [ 'shape' => 'MaintenanceWindowMaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeMaintenanceWindowExecutionTasksResult' => [ 'type' => 'structure', 'members' => [ 'WindowExecutionTaskIdentities' => [ 'shape' => 'MaintenanceWindowExecutionTaskIdentityList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeMaintenanceWindowExecutionsRequest' => [ 'type' => 'structure', 'required' => [ 'WindowId', ], 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], 'Filters' => [ 'shape' => 'MaintenanceWindowFilterList', ], 'MaxResults' => [ 'shape' => 'MaintenanceWindowMaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeMaintenanceWindowExecutionsResult' => [ 'type' => 'structure', 'members' => [ 'WindowExecutions' => [ 'shape' => 'MaintenanceWindowExecutionList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeMaintenanceWindowTargetsRequest' => [ 'type' => 'structure', 'required' => [ 'WindowId', ], 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], 'Filters' => [ 'shape' => 'MaintenanceWindowFilterList', ], 'MaxResults' => [ 'shape' => 'MaintenanceWindowMaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeMaintenanceWindowTargetsResult' => [ 'type' => 'structure', 'members' => [ 'Targets' => [ 'shape' => 'MaintenanceWindowTargetList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeMaintenanceWindowTasksRequest' => [ 'type' => 'structure', 'required' => [ 'WindowId', ], 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], 'Filters' => [ 'shape' => 'MaintenanceWindowFilterList', ], 'MaxResults' => [ 'shape' => 'MaintenanceWindowMaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeMaintenanceWindowTasksResult' => [ 'type' => 'structure', 'members' => [ 'Tasks' => [ 'shape' => 'MaintenanceWindowTaskList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeMaintenanceWindowsRequest' => [ 'type' => 'structure', 'members' => [ 'Filters' => [ 'shape' => 'MaintenanceWindowFilterList', ], 'MaxResults' => [ 'shape' => 'MaintenanceWindowMaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeMaintenanceWindowsResult' => [ 'type' => 'structure', 'members' => [ 'WindowIdentities' => [ 'shape' => 'MaintenanceWindowIdentityList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeParametersRequest' => [ 'type' => 'structure', 'members' => [ 'Filters' => [ 'shape' => 'ParametersFilterList', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeParametersResult' => [ 'type' => 'structure', 'members' => [ 'Parameters' => [ 'shape' => 'ParameterMetadataList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribePatchBaselinesRequest' => [ 'type' => 'structure', 'members' => [ 'Filters' => [ 'shape' => 'PatchOrchestratorFilterList', ], 'MaxResults' => [ 'shape' => 'PatchBaselineMaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribePatchBaselinesResult' => [ 'type' => 'structure', 'members' => [ 'BaselineIdentities' => [ 'shape' => 'PatchBaselineIdentityList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribePatchGroupStateRequest' => [ 'type' => 'structure', 'required' => [ 'PatchGroup', ], 'members' => [ 'PatchGroup' => [ 'shape' => 'PatchGroup', ], ], ], 'DescribePatchGroupStateResult' => [ 'type' => 'structure', 'members' => [ 'Instances' => [ 'shape' => 'Integer', ], 'InstancesWithInstalledPatches' => [ 'shape' => 'Integer', ], 'InstancesWithInstalledOtherPatches' => [ 'shape' => 'Integer', ], 'InstancesWithMissingPatches' => [ 'shape' => 'Integer', ], 'InstancesWithFailedPatches' => [ 'shape' => 'Integer', ], 'InstancesWithNotApplicablePatches' => [ 'shape' => 'Integer', ], ], ], 'DescribePatchGroupsRequest' => [ 'type' => 'structure', 'members' => [ 'MaxResults' => [ 'shape' => 'PatchBaselineMaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribePatchGroupsResult' => [ 'type' => 'structure', 'members' => [ 'Mappings' => [ 'shape' => 'PatchGroupPatchBaselineMappingList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescriptionInDocument' => [ 'type' => 'string', ], 'DocumentARN' => [ 'type' => 'string', 'pattern' => '^[a-zA-Z0-9_\\-.:/]{3,128}$', ], 'DocumentAlreadyExists' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'DocumentContent' => [ 'type' => 'string', 'min' => 1, ], 'DocumentDefaultVersionDescription' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'DefaultVersion' => [ 'shape' => 'DocumentVersion', ], ], ], 'DocumentDescription' => [ 'type' => 'structure', 'members' => [ 'Sha1' => [ 'shape' => 'DocumentSha1', ], 'Hash' => [ 'shape' => 'DocumentHash', ], 'HashType' => [ 'shape' => 'DocumentHashType', ], 'Name' => [ 'shape' => 'DocumentARN', ], 'Owner' => [ 'shape' => 'DocumentOwner', ], 'CreatedDate' => [ 'shape' => 'DateTime', ], 'Status' => [ 'shape' => 'DocumentStatus', ], 'DocumentVersion' => [ 'shape' => 'DocumentVersion', ], 'Description' => [ 'shape' => 'DescriptionInDocument', ], 'Parameters' => [ 'shape' => 'DocumentParameterList', ], 'PlatformTypes' => [ 'shape' => 'PlatformTypeList', ], 'DocumentType' => [ 'shape' => 'DocumentType', ], 'SchemaVersion' => [ 'shape' => 'DocumentSchemaVersion', ], 'LatestVersion' => [ 'shape' => 'DocumentVersion', ], 'DefaultVersion' => [ 'shape' => 'DocumentVersion', ], ], ], 'DocumentFilter' => [ 'type' => 'structure', 'required' => [ 'key', 'value', ], 'members' => [ 'key' => [ 'shape' => 'DocumentFilterKey', ], 'value' => [ 'shape' => 'DocumentFilterValue', ], ], ], 'DocumentFilterKey' => [ 'type' => 'string', 'enum' => [ 'Name', 'Owner', 'PlatformTypes', 'DocumentType', ], ], 'DocumentFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DocumentFilter', 'locationName' => 'DocumentFilter', ], 'min' => 1, ], 'DocumentFilterValue' => [ 'type' => 'string', 'min' => 1, ], 'DocumentHash' => [ 'type' => 'string', 'max' => 256, ], 'DocumentHashType' => [ 'type' => 'string', 'enum' => [ 'Sha256', 'Sha1', ], ], 'DocumentIdentifier' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DocumentARN', ], 'Owner' => [ 'shape' => 'DocumentOwner', ], 'PlatformTypes' => [ 'shape' => 'PlatformTypeList', ], 'DocumentVersion' => [ 'shape' => 'DocumentVersion', ], 'DocumentType' => [ 'shape' => 'DocumentType', ], 'SchemaVersion' => [ 'shape' => 'DocumentSchemaVersion', ], ], ], 'DocumentIdentifierList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DocumentIdentifier', 'locationName' => 'DocumentIdentifier', ], ], 'DocumentLimitExceeded' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'DocumentName' => [ 'type' => 'string', 'pattern' => '^[a-zA-Z0-9_\\-.]{3,128}$', ], 'DocumentOwner' => [ 'type' => 'string', ], 'DocumentParameter' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DocumentParameterName', ], 'Type' => [ 'shape' => 'DocumentParameterType', ], 'Description' => [ 'shape' => 'DocumentParameterDescrption', ], 'DefaultValue' => [ 'shape' => 'DocumentParameterDefaultValue', ], ], ], 'DocumentParameterDefaultValue' => [ 'type' => 'string', ], 'DocumentParameterDescrption' => [ 'type' => 'string', ], 'DocumentParameterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DocumentParameter', 'locationName' => 'DocumentParameter', ], ], 'DocumentParameterName' => [ 'type' => 'string', ], 'DocumentParameterType' => [ 'type' => 'string', 'enum' => [ 'String', 'StringList', ], ], 'DocumentPermissionLimit' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'DocumentPermissionType' => [ 'type' => 'string', 'enum' => [ 'Share', ], ], 'DocumentSchemaVersion' => [ 'type' => 'string', 'pattern' => '([0-9]+)\\.([0-9]+)', ], 'DocumentSha1' => [ 'type' => 'string', ], 'DocumentStatus' => [ 'type' => 'string', 'enum' => [ 'Creating', 'Active', 'Updating', 'Deleting', ], ], 'DocumentType' => [ 'type' => 'string', 'enum' => [ 'Command', 'Policy', 'Automation', ], ], 'DocumentVersion' => [ 'type' => 'string', 'pattern' => '([$]LATEST|[$]DEFAULT|^[1-9][0-9]*$)', ], 'DocumentVersionInfo' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'DocumentVersion' => [ 'shape' => 'DocumentVersion', ], 'CreatedDate' => [ 'shape' => 'DateTime', ], 'IsDefaultVersion' => [ 'shape' => 'Boolean', ], ], ], 'DocumentVersionLimitExceeded' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'DocumentVersionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DocumentVersionInfo', ], 'min' => 1, ], 'DocumentVersionNumber' => [ 'type' => 'string', 'pattern' => '(^[1-9][0-9]*$)', ], 'DoesNotExistException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'DuplicateDocumentContent' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'DuplicateInstanceId' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'EffectiveInstanceAssociationMaxResults' => [ 'type' => 'integer', 'max' => 5, 'min' => 1, ], 'EffectivePatch' => [ 'type' => 'structure', 'members' => [ 'Patch' => [ 'shape' => 'Patch', ], 'PatchStatus' => [ 'shape' => 'PatchStatus', ], ], ], 'EffectivePatchList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EffectivePatch', ], ], 'ErrorCount' => [ 'type' => 'integer', ], 'ExpirationDate' => [ 'type' => 'timestamp', ], 'FailedCreateAssociation' => [ 'type' => 'structure', 'members' => [ 'Entry' => [ 'shape' => 'CreateAssociationBatchRequestEntry', ], 'Message' => [ 'shape' => 'BatchErrorMessage', ], 'Fault' => [ 'shape' => 'Fault', ], ], ], 'FailedCreateAssociationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FailedCreateAssociation', 'locationName' => 'FailedCreateAssociationEntry', ], ], 'FailureDetails' => [ 'type' => 'structure', 'members' => [ 'FailureStage' => [ 'shape' => 'String', ], 'FailureType' => [ 'shape' => 'String', ], 'Details' => [ 'shape' => 'AutomationParameterMap', ], ], ], 'Fault' => [ 'type' => 'string', 'enum' => [ 'Client', 'Server', 'Unknown', ], ], 'GetAutomationExecutionRequest' => [ 'type' => 'structure', 'required' => [ 'AutomationExecutionId', ], 'members' => [ 'AutomationExecutionId' => [ 'shape' => 'AutomationExecutionId', ], ], ], 'GetAutomationExecutionResult' => [ 'type' => 'structure', 'members' => [ 'AutomationExecution' => [ 'shape' => 'AutomationExecution', ], ], ], 'GetCommandInvocationRequest' => [ 'type' => 'structure', 'required' => [ 'CommandId', 'InstanceId', ], 'members' => [ 'CommandId' => [ 'shape' => 'CommandId', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'PluginName' => [ 'shape' => 'CommandPluginName', ], ], ], 'GetCommandInvocationResult' => [ 'type' => 'structure', 'members' => [ 'CommandId' => [ 'shape' => 'CommandId', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'Comment' => [ 'shape' => 'Comment', ], 'DocumentName' => [ 'shape' => 'DocumentName', ], 'PluginName' => [ 'shape' => 'CommandPluginName', ], 'ResponseCode' => [ 'shape' => 'ResponseCode', ], 'ExecutionStartDateTime' => [ 'shape' => 'StringDateTime', ], 'ExecutionElapsedTime' => [ 'shape' => 'StringDateTime', ], 'ExecutionEndDateTime' => [ 'shape' => 'StringDateTime', ], 'Status' => [ 'shape' => 'CommandInvocationStatus', ], 'StatusDetails' => [ 'shape' => 'StatusDetails', ], 'StandardOutputContent' => [ 'shape' => 'StandardOutputContent', ], 'StandardOutputUrl' => [ 'shape' => 'Url', ], 'StandardErrorContent' => [ 'shape' => 'StandardErrorContent', ], 'StandardErrorUrl' => [ 'shape' => 'Url', ], ], ], 'GetDefaultPatchBaselineRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetDefaultPatchBaselineResult' => [ 'type' => 'structure', 'members' => [ 'BaselineId' => [ 'shape' => 'BaselineId', ], ], ], 'GetDeployablePatchSnapshotForInstanceRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'SnapshotId', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', ], 'SnapshotId' => [ 'shape' => 'SnapshotId', ], ], ], 'GetDeployablePatchSnapshotForInstanceResult' => [ 'type' => 'structure', 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', ], 'SnapshotId' => [ 'shape' => 'SnapshotId', ], 'SnapshotDownloadUrl' => [ 'shape' => 'SnapshotDownloadUrl', ], ], ], 'GetDocumentRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'DocumentARN', ], 'DocumentVersion' => [ 'shape' => 'DocumentVersion', ], ], ], 'GetDocumentResult' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DocumentARN', ], 'DocumentVersion' => [ 'shape' => 'DocumentVersion', ], 'Content' => [ 'shape' => 'DocumentContent', ], 'DocumentType' => [ 'shape' => 'DocumentType', ], ], ], 'GetInventoryRequest' => [ 'type' => 'structure', 'members' => [ 'Filters' => [ 'shape' => 'InventoryFilterList', ], 'ResultAttributes' => [ 'shape' => 'ResultAttributeList', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'box' => true, ], ], ], 'GetInventoryResult' => [ 'type' => 'structure', 'members' => [ 'Entities' => [ 'shape' => 'InventoryResultEntityList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'GetInventorySchemaMaxResults' => [ 'type' => 'integer', 'max' => 200, 'min' => 50, ], 'GetInventorySchemaRequest' => [ 'type' => 'structure', 'members' => [ 'TypeName' => [ 'shape' => 'InventoryItemTypeNameFilter', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'GetInventorySchemaMaxResults', 'box' => true, ], ], ], 'GetInventorySchemaResult' => [ 'type' => 'structure', 'members' => [ 'Schemas' => [ 'shape' => 'InventoryItemSchemaResultList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'GetMaintenanceWindowExecutionRequest' => [ 'type' => 'structure', 'required' => [ 'WindowExecutionId', ], 'members' => [ 'WindowExecutionId' => [ 'shape' => 'MaintenanceWindowExecutionId', ], ], ], 'GetMaintenanceWindowExecutionResult' => [ 'type' => 'structure', 'members' => [ 'WindowExecutionId' => [ 'shape' => 'MaintenanceWindowExecutionId', ], 'TaskIds' => [ 'shape' => 'MaintenanceWindowExecutionTaskIdList', ], 'Status' => [ 'shape' => 'MaintenanceWindowExecutionStatus', ], 'StatusDetails' => [ 'shape' => 'MaintenanceWindowExecutionStatusDetails', ], 'StartTime' => [ 'shape' => 'DateTime', ], 'EndTime' => [ 'shape' => 'DateTime', ], ], ], 'GetMaintenanceWindowExecutionTaskRequest' => [ 'type' => 'structure', 'required' => [ 'WindowExecutionId', 'TaskId', ], 'members' => [ 'WindowExecutionId' => [ 'shape' => 'MaintenanceWindowExecutionId', ], 'TaskId' => [ 'shape' => 'MaintenanceWindowExecutionTaskId', ], ], ], 'GetMaintenanceWindowExecutionTaskResult' => [ 'type' => 'structure', 'members' => [ 'WindowExecutionId' => [ 'shape' => 'MaintenanceWindowExecutionId', ], 'TaskExecutionId' => [ 'shape' => 'MaintenanceWindowExecutionTaskId', ], 'TaskArn' => [ 'shape' => 'MaintenanceWindowTaskArn', ], 'ServiceRole' => [ 'shape' => 'ServiceRole', ], 'Type' => [ 'shape' => 'MaintenanceWindowTaskType', ], 'TaskParameters' => [ 'shape' => 'MaintenanceWindowTaskParametersList', ], 'Priority' => [ 'shape' => 'MaintenanceWindowTaskPriority', ], 'MaxConcurrency' => [ 'shape' => 'MaxConcurrency', ], 'MaxErrors' => [ 'shape' => 'MaxErrors', ], 'Status' => [ 'shape' => 'MaintenanceWindowExecutionStatus', ], 'StatusDetails' => [ 'shape' => 'MaintenanceWindowExecutionStatusDetails', ], 'StartTime' => [ 'shape' => 'DateTime', ], 'EndTime' => [ 'shape' => 'DateTime', ], ], ], 'GetMaintenanceWindowRequest' => [ 'type' => 'structure', 'required' => [ 'WindowId', ], 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], ], ], 'GetMaintenanceWindowResult' => [ 'type' => 'structure', 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], 'Name' => [ 'shape' => 'MaintenanceWindowName', ], 'Schedule' => [ 'shape' => 'MaintenanceWindowSchedule', ], 'Duration' => [ 'shape' => 'MaintenanceWindowDurationHours', ], 'Cutoff' => [ 'shape' => 'MaintenanceWindowCutoff', ], 'AllowUnassociatedTargets' => [ 'shape' => 'MaintenanceWindowAllowUnassociatedTargets', ], 'Enabled' => [ 'shape' => 'MaintenanceWindowEnabled', ], 'CreatedDate' => [ 'shape' => 'DateTime', ], 'ModifiedDate' => [ 'shape' => 'DateTime', ], ], ], 'GetParameterHistoryRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'PSParameterName', ], 'WithDecryption' => [ 'shape' => 'Boolean', 'box' => true, ], 'MaxResults' => [ 'shape' => 'MaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'GetParameterHistoryResult' => [ 'type' => 'structure', 'members' => [ 'Parameters' => [ 'shape' => 'ParameterHistoryList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'GetParametersRequest' => [ 'type' => 'structure', 'required' => [ 'Names', ], 'members' => [ 'Names' => [ 'shape' => 'ParameterNameList', ], 'WithDecryption' => [ 'shape' => 'Boolean', 'box' => true, ], ], ], 'GetParametersResult' => [ 'type' => 'structure', 'members' => [ 'Parameters' => [ 'shape' => 'ParameterList', ], 'InvalidParameters' => [ 'shape' => 'ParameterNameList', ], ], ], 'GetPatchBaselineForPatchGroupRequest' => [ 'type' => 'structure', 'required' => [ 'PatchGroup', ], 'members' => [ 'PatchGroup' => [ 'shape' => 'PatchGroup', ], ], ], 'GetPatchBaselineForPatchGroupResult' => [ 'type' => 'structure', 'members' => [ 'BaselineId' => [ 'shape' => 'BaselineId', ], 'PatchGroup' => [ 'shape' => 'PatchGroup', ], ], ], 'GetPatchBaselineRequest' => [ 'type' => 'structure', 'required' => [ 'BaselineId', ], 'members' => [ 'BaselineId' => [ 'shape' => 'BaselineId', ], ], ], 'GetPatchBaselineResult' => [ 'type' => 'structure', 'members' => [ 'BaselineId' => [ 'shape' => 'BaselineId', ], 'Name' => [ 'shape' => 'BaselineName', ], 'GlobalFilters' => [ 'shape' => 'PatchFilterGroup', ], 'ApprovalRules' => [ 'shape' => 'PatchRuleGroup', ], 'ApprovedPatches' => [ 'shape' => 'PatchIdList', ], 'RejectedPatches' => [ 'shape' => 'PatchIdList', ], 'PatchGroups' => [ 'shape' => 'PatchGroupList', ], 'CreatedDate' => [ 'shape' => 'DateTime', ], 'ModifiedDate' => [ 'shape' => 'DateTime', ], 'Description' => [ 'shape' => 'BaselineDescription', ], ], ], 'IPAddress' => [ 'type' => 'string', 'max' => 46, 'min' => 1, ], 'IamRole' => [ 'type' => 'string', 'max' => 64, ], 'IdempotentParameterMismatch' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InstanceAggregatedAssociationOverview' => [ 'type' => 'structure', 'members' => [ 'DetailedStatus' => [ 'shape' => 'StatusName', ], 'InstanceAssociationStatusAggregatedCount' => [ 'shape' => 'InstanceAssociationStatusAggregatedCount', ], ], ], 'InstanceAssociation' => [ 'type' => 'structure', 'members' => [ 'AssociationId' => [ 'shape' => 'AssociationId', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'Content' => [ 'shape' => 'DocumentContent', ], ], ], 'InstanceAssociationExecutionSummary' => [ 'type' => 'string', 'max' => 512, 'min' => 1, ], 'InstanceAssociationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InstanceAssociation', ], ], 'InstanceAssociationOutputLocation' => [ 'type' => 'structure', 'members' => [ 'S3Location' => [ 'shape' => 'S3OutputLocation', ], ], ], 'InstanceAssociationOutputUrl' => [ 'type' => 'structure', 'members' => [ 'S3OutputUrl' => [ 'shape' => 'S3OutputUrl', ], ], ], 'InstanceAssociationStatusAggregatedCount' => [ 'type' => 'map', 'key' => [ 'shape' => 'StatusName', ], 'value' => [ 'shape' => 'InstanceCount', ], ], 'InstanceAssociationStatusInfo' => [ 'type' => 'structure', 'members' => [ 'AssociationId' => [ 'shape' => 'AssociationId', ], 'Name' => [ 'shape' => 'DocumentName', ], 'DocumentVersion' => [ 'shape' => 'DocumentVersion', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'ExecutionDate' => [ 'shape' => 'DateTime', ], 'Status' => [ 'shape' => 'StatusName', ], 'DetailedStatus' => [ 'shape' => 'StatusName', ], 'ExecutionSummary' => [ 'shape' => 'InstanceAssociationExecutionSummary', ], 'ErrorCode' => [ 'shape' => 'AgentErrorCode', ], 'OutputUrl' => [ 'shape' => 'InstanceAssociationOutputUrl', ], ], ], 'InstanceAssociationStatusInfos' => [ 'type' => 'list', 'member' => [ 'shape' => 'InstanceAssociationStatusInfo', ], ], 'InstanceCount' => [ 'type' => 'integer', ], 'InstanceId' => [ 'type' => 'string', 'pattern' => '(^i-(\\w{8}|\\w{17})$)|(^mi-\\w{17}$)', ], 'InstanceIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InstanceId', ], 'max' => 50, 'min' => 0, ], 'InstanceInformation' => [ 'type' => 'structure', 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', ], 'PingStatus' => [ 'shape' => 'PingStatus', ], 'LastPingDateTime' => [ 'shape' => 'DateTime', 'box' => true, ], 'AgentVersion' => [ 'shape' => 'Version', ], 'IsLatestVersion' => [ 'shape' => 'Boolean', 'box' => true, ], 'PlatformType' => [ 'shape' => 'PlatformType', ], 'PlatformName' => [ 'shape' => 'String', ], 'PlatformVersion' => [ 'shape' => 'String', ], 'ActivationId' => [ 'shape' => 'ActivationId', ], 'IamRole' => [ 'shape' => 'IamRole', ], 'RegistrationDate' => [ 'shape' => 'DateTime', 'box' => true, ], 'ResourceType' => [ 'shape' => 'ResourceType', ], 'Name' => [ 'shape' => 'String', ], 'IPAddress' => [ 'shape' => 'IPAddress', ], 'ComputerName' => [ 'shape' => 'ComputerName', ], 'AssociationStatus' => [ 'shape' => 'StatusName', ], 'LastAssociationExecutionDate' => [ 'shape' => 'DateTime', ], 'LastSuccessfulAssociationExecutionDate' => [ 'shape' => 'DateTime', ], 'AssociationOverview' => [ 'shape' => 'InstanceAggregatedAssociationOverview', ], ], ], 'InstanceInformationFilter' => [ 'type' => 'structure', 'required' => [ 'key', 'valueSet', ], 'members' => [ 'key' => [ 'shape' => 'InstanceInformationFilterKey', ], 'valueSet' => [ 'shape' => 'InstanceInformationFilterValueSet', ], ], ], 'InstanceInformationFilterKey' => [ 'type' => 'string', 'enum' => [ 'InstanceIds', 'AgentVersion', 'PingStatus', 'PlatformTypes', 'ActivationIds', 'IamRole', 'ResourceType', 'AssociationStatus', ], ], 'InstanceInformationFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InstanceInformationFilter', 'locationName' => 'InstanceInformationFilter', ], 'min' => 0, ], 'InstanceInformationFilterValue' => [ 'type' => 'string', 'min' => 1, ], 'InstanceInformationFilterValueSet' => [ 'type' => 'list', 'member' => [ 'shape' => 'InstanceInformationFilterValue', 'locationName' => 'InstanceInformationFilterValue', ], 'max' => 100, 'min' => 1, ], 'InstanceInformationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InstanceInformation', 'locationName' => 'InstanceInformation', ], ], 'InstanceInformationStringFilter' => [ 'type' => 'structure', 'required' => [ 'Key', 'Values', ], 'members' => [ 'Key' => [ 'shape' => 'InstanceInformationStringFilterKey', ], 'Values' => [ 'shape' => 'InstanceInformationFilterValueSet', ], ], ], 'InstanceInformationStringFilterKey' => [ 'type' => 'string', 'min' => 1, ], 'InstanceInformationStringFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InstanceInformationStringFilter', 'locationName' => 'InstanceInformationStringFilter', ], 'min' => 0, ], 'InstancePatchState' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'PatchGroup', 'BaselineId', 'OperationStartTime', 'OperationEndTime', 'Operation', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', ], 'PatchGroup' => [ 'shape' => 'PatchGroup', ], 'BaselineId' => [ 'shape' => 'BaselineId', ], 'SnapshotId' => [ 'shape' => 'SnapshotId', ], 'OwnerInformation' => [ 'shape' => 'OwnerInformation', ], 'InstalledCount' => [ 'shape' => 'PatchInstalledCount', ], 'InstalledOtherCount' => [ 'shape' => 'PatchInstalledOtherCount', ], 'MissingCount' => [ 'shape' => 'PatchMissingCount', ], 'FailedCount' => [ 'shape' => 'PatchFailedCount', ], 'NotApplicableCount' => [ 'shape' => 'PatchNotApplicableCount', ], 'OperationStartTime' => [ 'shape' => 'PatchOperationStartTime', ], 'OperationEndTime' => [ 'shape' => 'PatchOperationEndTime', ], 'Operation' => [ 'shape' => 'PatchOperationType', ], ], ], 'InstancePatchStateFilter' => [ 'type' => 'structure', 'required' => [ 'Key', 'Values', 'Type', ], 'members' => [ 'Key' => [ 'shape' => 'InstancePatchStateFilterKey', ], 'Values' => [ 'shape' => 'InstancePatchStateFilterValues', ], 'Type' => [ 'shape' => 'InstancePatchStateOperatorType', ], ], ], 'InstancePatchStateFilterKey' => [ 'type' => 'string', 'max' => 200, 'min' => 1, ], 'InstancePatchStateFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InstancePatchStateFilter', ], 'max' => 4, 'min' => 0, ], 'InstancePatchStateFilterValue' => [ 'type' => 'string', ], 'InstancePatchStateFilterValues' => [ 'type' => 'list', 'member' => [ 'shape' => 'InstancePatchStateFilterValue', ], 'max' => 1, 'min' => 1, ], 'InstancePatchStateList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InstancePatchState', ], ], 'InstancePatchStateOperatorType' => [ 'type' => 'string', 'enum' => [ 'Equal', 'NotEqual', 'LessThan', 'GreaterThan', ], ], 'InstancePatchStatesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InstancePatchState', ], 'max' => 5, 'min' => 1, ], 'InstanceTagName' => [ 'type' => 'string', 'max' => 255, ], 'Integer' => [ 'type' => 'integer', ], 'InternalServerError' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidActivation' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidActivationId' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidAutomationExecutionParametersException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidCommandId' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidDocument' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidDocumentContent' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidDocumentOperation' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidDocumentSchemaVersion' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidDocumentVersion' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidFilter' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidFilterKey' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidFilterValue' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidInstanceId' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidInstanceInformationFilterValue' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidItemContentException' => [ 'type' => 'structure', 'members' => [ 'TypeName' => [ 'shape' => 'InventoryItemTypeName', ], 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidKeyId' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidNextToken' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidNotificationConfig' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidOutputFolder' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidOutputLocation' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidParameters' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidPermissionType' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidPluginName' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidResourceId' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidResourceType' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidResultAttributeException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidRole' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidSchedule' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidTarget' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidTypeNameException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidUpdate' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InventoryAttributeDataType' => [ 'type' => 'string', 'enum' => [ 'string', 'number', ], ], 'InventoryFilter' => [ 'type' => 'structure', 'required' => [ 'Key', 'Values', ], 'members' => [ 'Key' => [ 'shape' => 'InventoryFilterKey', ], 'Values' => [ 'shape' => 'InventoryFilterValueList', ], 'Type' => [ 'shape' => 'InventoryQueryOperatorType', ], ], ], 'InventoryFilterKey' => [ 'type' => 'string', 'max' => 200, 'min' => 1, ], 'InventoryFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InventoryFilter', 'locationName' => 'InventoryFilter', ], 'max' => 5, 'min' => 1, ], 'InventoryFilterValue' => [ 'type' => 'string', ], 'InventoryFilterValueList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InventoryFilterValue', 'locationName' => 'FilterValue', ], 'max' => 20, 'min' => 1, ], 'InventoryItem' => [ 'type' => 'structure', 'required' => [ 'TypeName', 'SchemaVersion', 'CaptureTime', ], 'members' => [ 'TypeName' => [ 'shape' => 'InventoryItemTypeName', ], 'SchemaVersion' => [ 'shape' => 'InventoryItemSchemaVersion', ], 'CaptureTime' => [ 'shape' => 'InventoryItemCaptureTime', ], 'ContentHash' => [ 'shape' => 'InventoryItemContentHash', ], 'Content' => [ 'shape' => 'InventoryItemEntryList', ], ], ], 'InventoryItemAttribute' => [ 'type' => 'structure', 'required' => [ 'Name', 'DataType', ], 'members' => [ 'Name' => [ 'shape' => 'InventoryItemAttributeName', ], 'DataType' => [ 'shape' => 'InventoryAttributeDataType', ], ], ], 'InventoryItemAttributeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InventoryItemAttribute', 'locationName' => 'Attribute', ], 'max' => 50, 'min' => 1, ], 'InventoryItemAttributeName' => [ 'type' => 'string', ], 'InventoryItemCaptureTime' => [ 'type' => 'string', 'pattern' => '^(20)[0-9][0-9]-(0[1-9]|1[012])-([12][0-9]|3[01]|0[1-9])(T)(2[0-3]|[0-1][0-9])(:[0-5][0-9])(:[0-5][0-9])(Z)$', ], 'InventoryItemContentHash' => [ 'type' => 'string', 'max' => 256, ], 'InventoryItemEntry' => [ 'type' => 'map', 'key' => [ 'shape' => 'AttributeName', ], 'value' => [ 'shape' => 'AttributeValue', ], 'max' => 50, 'min' => 0, ], 'InventoryItemEntryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InventoryItemEntry', ], 'max' => 10000, 'min' => 0, ], 'InventoryItemList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InventoryItem', 'locationName' => 'Item', ], 'max' => 30, 'min' => 1, ], 'InventoryItemSchema' => [ 'type' => 'structure', 'required' => [ 'TypeName', 'Attributes', ], 'members' => [ 'TypeName' => [ 'shape' => 'InventoryItemTypeName', ], 'Version' => [ 'shape' => 'InventoryItemSchemaVersion', ], 'Attributes' => [ 'shape' => 'InventoryItemAttributeList', ], ], ], 'InventoryItemSchemaResultList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InventoryItemSchema', ], ], 'InventoryItemSchemaVersion' => [ 'type' => 'string', 'pattern' => '^([0-9]{1,6})(\\.[0-9]{1,6})$', ], 'InventoryItemTypeName' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '^(AWS|Custom):.*$', ], 'InventoryItemTypeNameFilter' => [ 'type' => 'string', 'max' => 100, 'min' => 0, ], 'InventoryQueryOperatorType' => [ 'type' => 'string', 'enum' => [ 'Equal', 'NotEqual', 'BeginWith', 'LessThan', 'GreaterThan', ], ], 'InventoryResultEntity' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'InventoryResultEntityId', ], 'Data' => [ 'shape' => 'InventoryResultItemMap', ], ], ], 'InventoryResultEntityId' => [ 'type' => 'string', ], 'InventoryResultEntityList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InventoryResultEntity', 'locationName' => 'Entity', ], ], 'InventoryResultItem' => [ 'type' => 'structure', 'required' => [ 'TypeName', 'SchemaVersion', 'Content', ], 'members' => [ 'TypeName' => [ 'shape' => 'InventoryItemTypeName', ], 'SchemaVersion' => [ 'shape' => 'InventoryItemSchemaVersion', ], 'CaptureTime' => [ 'shape' => 'InventoryItemCaptureTime', ], 'ContentHash' => [ 'shape' => 'InventoryItemContentHash', ], 'Content' => [ 'shape' => 'InventoryItemEntryList', ], ], ], 'InventoryResultItemKey' => [ 'type' => 'string', ], 'InventoryResultItemMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'InventoryResultItemKey', ], 'value' => [ 'shape' => 'InventoryResultItem', ], ], 'InvocationDoesNotExist' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvocationTraceOutput' => [ 'type' => 'string', 'max' => 2500, ], 'ItemContentMismatchException' => [ 'type' => 'structure', 'members' => [ 'TypeName' => [ 'shape' => 'InventoryItemTypeName', ], 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'ItemSizeLimitExceededException' => [ 'type' => 'structure', 'members' => [ 'TypeName' => [ 'shape' => 'InventoryItemTypeName', ], 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'KeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], ], 'ListAssociationsRequest' => [ 'type' => 'structure', 'members' => [ 'AssociationFilterList' => [ 'shape' => 'AssociationFilterList', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListAssociationsResult' => [ 'type' => 'structure', 'members' => [ 'Associations' => [ 'shape' => 'AssociationList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListCommandInvocationsRequest' => [ 'type' => 'structure', 'members' => [ 'CommandId' => [ 'shape' => 'CommandId', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'MaxResults' => [ 'shape' => 'CommandMaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], 'Filters' => [ 'shape' => 'CommandFilterList', ], 'Details' => [ 'shape' => 'Boolean', ], ], ], 'ListCommandInvocationsResult' => [ 'type' => 'structure', 'members' => [ 'CommandInvocations' => [ 'shape' => 'CommandInvocationList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListCommandsRequest' => [ 'type' => 'structure', 'members' => [ 'CommandId' => [ 'shape' => 'CommandId', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'MaxResults' => [ 'shape' => 'CommandMaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], 'Filters' => [ 'shape' => 'CommandFilterList', ], ], ], 'ListCommandsResult' => [ 'type' => 'structure', 'members' => [ 'Commands' => [ 'shape' => 'CommandList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListDocumentVersionsRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListDocumentVersionsResult' => [ 'type' => 'structure', 'members' => [ 'DocumentVersions' => [ 'shape' => 'DocumentVersionList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListDocumentsRequest' => [ 'type' => 'structure', 'members' => [ 'DocumentFilterList' => [ 'shape' => 'DocumentFilterList', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListDocumentsResult' => [ 'type' => 'structure', 'members' => [ 'DocumentIdentifiers' => [ 'shape' => 'DocumentIdentifierList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListInventoryEntriesRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'TypeName', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', ], 'TypeName' => [ 'shape' => 'InventoryItemTypeName', ], 'Filters' => [ 'shape' => 'InventoryFilterList', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'box' => true, ], ], ], 'ListInventoryEntriesResult' => [ 'type' => 'structure', 'members' => [ 'TypeName' => [ 'shape' => 'InventoryItemTypeName', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'SchemaVersion' => [ 'shape' => 'InventoryItemSchemaVersion', ], 'CaptureTime' => [ 'shape' => 'InventoryItemCaptureTime', ], 'Entries' => [ 'shape' => 'InventoryItemEntryList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceType', 'ResourceId', ], 'members' => [ 'ResourceType' => [ 'shape' => 'ResourceTypeForTagging', ], 'ResourceId' => [ 'shape' => 'ResourceId', ], ], ], 'ListTagsForResourceResult' => [ 'type' => 'structure', 'members' => [ 'TagList' => [ 'shape' => 'TagList', ], ], ], 'LoggingInfo' => [ 'type' => 'structure', 'required' => [ 'S3BucketName', 'S3Region', ], 'members' => [ 'S3BucketName' => [ 'shape' => 'S3BucketName', ], 'S3KeyPrefix' => [ 'shape' => 'S3KeyPrefix', ], 'S3Region' => [ 'shape' => 'S3Region', ], ], ], 'MaintenanceWindowAllowUnassociatedTargets' => [ 'type' => 'boolean', ], 'MaintenanceWindowCutoff' => [ 'type' => 'integer', 'max' => 23, 'min' => 0, ], 'MaintenanceWindowDurationHours' => [ 'type' => 'integer', 'max' => 24, 'min' => 1, ], 'MaintenanceWindowEnabled' => [ 'type' => 'boolean', ], 'MaintenanceWindowExecution' => [ 'type' => 'structure', 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], 'WindowExecutionId' => [ 'shape' => 'MaintenanceWindowExecutionId', ], 'Status' => [ 'shape' => 'MaintenanceWindowExecutionStatus', ], 'StatusDetails' => [ 'shape' => 'MaintenanceWindowExecutionStatusDetails', ], 'StartTime' => [ 'shape' => 'DateTime', ], 'EndTime' => [ 'shape' => 'DateTime', ], ], ], 'MaintenanceWindowExecutionId' => [ 'type' => 'string', 'max' => 36, 'min' => 36, 'pattern' => '^[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}$', ], 'MaintenanceWindowExecutionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MaintenanceWindowExecution', ], ], 'MaintenanceWindowExecutionStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING', 'IN_PROGRESS', 'SUCCESS', 'FAILED', 'TIMED_OUT', 'CANCELLING', 'CANCELLED', 'SKIPPED_OVERLAPPING', ], ], 'MaintenanceWindowExecutionStatusDetails' => [ 'type' => 'string', 'max' => 250, 'min' => 0, ], 'MaintenanceWindowExecutionTaskExecutionId' => [ 'type' => 'string', ], 'MaintenanceWindowExecutionTaskId' => [ 'type' => 'string', 'max' => 36, 'min' => 36, 'pattern' => '^[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}$', ], 'MaintenanceWindowExecutionTaskIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MaintenanceWindowExecutionTaskId', ], ], 'MaintenanceWindowExecutionTaskIdentity' => [ 'type' => 'structure', 'members' => [ 'WindowExecutionId' => [ 'shape' => 'MaintenanceWindowExecutionId', ], 'TaskExecutionId' => [ 'shape' => 'MaintenanceWindowExecutionTaskId', ], 'Status' => [ 'shape' => 'MaintenanceWindowExecutionStatus', ], 'StatusDetails' => [ 'shape' => 'MaintenanceWindowExecutionStatusDetails', ], 'StartTime' => [ 'shape' => 'DateTime', ], 'EndTime' => [ 'shape' => 'DateTime', ], 'TaskArn' => [ 'shape' => 'MaintenanceWindowTaskArn', ], 'TaskType' => [ 'shape' => 'MaintenanceWindowTaskType', ], ], ], 'MaintenanceWindowExecutionTaskIdentityList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MaintenanceWindowExecutionTaskIdentity', ], ], 'MaintenanceWindowExecutionTaskInvocationId' => [ 'type' => 'string', 'max' => 36, 'min' => 36, 'pattern' => '^[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}$', ], 'MaintenanceWindowExecutionTaskInvocationIdentity' => [ 'type' => 'structure', 'members' => [ 'WindowExecutionId' => [ 'shape' => 'MaintenanceWindowExecutionId', ], 'TaskExecutionId' => [ 'shape' => 'MaintenanceWindowExecutionTaskId', ], 'InvocationId' => [ 'shape' => 'MaintenanceWindowExecutionTaskInvocationId', ], 'ExecutionId' => [ 'shape' => 'MaintenanceWindowExecutionTaskExecutionId', ], 'Parameters' => [ 'shape' => 'MaintenanceWindowExecutionTaskInvocationParameters', ], 'Status' => [ 'shape' => 'MaintenanceWindowExecutionStatus', ], 'StatusDetails' => [ 'shape' => 'MaintenanceWindowExecutionStatusDetails', ], 'StartTime' => [ 'shape' => 'DateTime', ], 'EndTime' => [ 'shape' => 'DateTime', ], 'OwnerInformation' => [ 'shape' => 'OwnerInformation', ], 'WindowTargetId' => [ 'shape' => 'MaintenanceWindowTaskTargetId', ], ], ], 'MaintenanceWindowExecutionTaskInvocationIdentityList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MaintenanceWindowExecutionTaskInvocationIdentity', ], ], 'MaintenanceWindowExecutionTaskInvocationParameters' => [ 'type' => 'string', 'sensitive' => true, ], 'MaintenanceWindowFilter' => [ 'type' => 'structure', 'members' => [ 'Key' => [ 'shape' => 'MaintenanceWindowFilterKey', ], 'Values' => [ 'shape' => 'MaintenanceWindowFilterValues', ], ], ], 'MaintenanceWindowFilterKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'MaintenanceWindowFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MaintenanceWindowFilter', ], 'max' => 5, 'min' => 0, ], 'MaintenanceWindowFilterValue' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'MaintenanceWindowFilterValues' => [ 'type' => 'list', 'member' => [ 'shape' => 'MaintenanceWindowFilterValue', ], ], 'MaintenanceWindowId' => [ 'type' => 'string', 'max' => 20, 'min' => 20, 'pattern' => '^mw-[0-9a-f]{17}$', ], 'MaintenanceWindowIdentity' => [ 'type' => 'structure', 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], 'Name' => [ 'shape' => 'MaintenanceWindowName', ], 'Enabled' => [ 'shape' => 'MaintenanceWindowEnabled', ], 'Duration' => [ 'shape' => 'MaintenanceWindowDurationHours', ], 'Cutoff' => [ 'shape' => 'MaintenanceWindowCutoff', ], ], ], 'MaintenanceWindowIdentityList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MaintenanceWindowIdentity', ], ], 'MaintenanceWindowMaxResults' => [ 'type' => 'integer', 'max' => 100, 'min' => 10, ], 'MaintenanceWindowName' => [ 'type' => 'string', 'max' => 128, 'min' => 3, 'pattern' => '^[a-zA-Z0-9_\\-.]{3,128}$', ], 'MaintenanceWindowResourceType' => [ 'type' => 'string', 'enum' => [ 'INSTANCE', ], ], 'MaintenanceWindowSchedule' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'MaintenanceWindowTarget' => [ 'type' => 'structure', 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], 'WindowTargetId' => [ 'shape' => 'MaintenanceWindowTargetId', ], 'ResourceType' => [ 'shape' => 'MaintenanceWindowResourceType', ], 'Targets' => [ 'shape' => 'Targets', ], 'OwnerInformation' => [ 'shape' => 'OwnerInformation', ], ], ], 'MaintenanceWindowTargetId' => [ 'type' => 'string', 'max' => 36, 'min' => 36, 'pattern' => '^[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}$', ], 'MaintenanceWindowTargetList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MaintenanceWindowTarget', ], ], 'MaintenanceWindowTask' => [ 'type' => 'structure', 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], 'WindowTaskId' => [ 'shape' => 'MaintenanceWindowTaskId', ], 'TaskArn' => [ 'shape' => 'MaintenanceWindowTaskArn', ], 'Type' => [ 'shape' => 'MaintenanceWindowTaskType', ], 'Targets' => [ 'shape' => 'Targets', ], 'TaskParameters' => [ 'shape' => 'MaintenanceWindowTaskParameters', ], 'Priority' => [ 'shape' => 'MaintenanceWindowTaskPriority', ], 'LoggingInfo' => [ 'shape' => 'LoggingInfo', ], 'ServiceRoleArn' => [ 'shape' => 'ServiceRole', ], 'MaxConcurrency' => [ 'shape' => 'MaxConcurrency', ], 'MaxErrors' => [ 'shape' => 'MaxErrors', ], ], ], 'MaintenanceWindowTaskArn' => [ 'type' => 'string', 'max' => 1600, 'min' => 1, ], 'MaintenanceWindowTaskId' => [ 'type' => 'string', 'max' => 36, 'min' => 36, 'pattern' => '^[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}$', ], 'MaintenanceWindowTaskList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MaintenanceWindowTask', ], ], 'MaintenanceWindowTaskParameterName' => [ 'type' => 'string', 'max' => 255, 'min' => 1, ], 'MaintenanceWindowTaskParameterValue' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'sensitive' => true, ], 'MaintenanceWindowTaskParameterValueExpression' => [ 'type' => 'structure', 'members' => [ 'Values' => [ 'shape' => 'MaintenanceWindowTaskParameterValueList', ], ], 'sensitive' => true, ], 'MaintenanceWindowTaskParameterValueList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MaintenanceWindowTaskParameterValue', ], 'sensitive' => true, ], 'MaintenanceWindowTaskParameters' => [ 'type' => 'map', 'key' => [ 'shape' => 'MaintenanceWindowTaskParameterName', ], 'value' => [ 'shape' => 'MaintenanceWindowTaskParameterValueExpression', ], 'sensitive' => true, ], 'MaintenanceWindowTaskParametersList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MaintenanceWindowTaskParameters', ], 'sensitive' => true, ], 'MaintenanceWindowTaskPriority' => [ 'type' => 'integer', 'min' => 0, ], 'MaintenanceWindowTaskTargetId' => [ 'type' => 'string', 'max' => 36, ], 'MaintenanceWindowTaskType' => [ 'type' => 'string', 'enum' => [ 'RUN_COMMAND', ], ], 'ManagedInstanceId' => [ 'type' => 'string', 'pattern' => '^mi-[0-9a-f]{17}$', ], 'MaxConcurrency' => [ 'type' => 'string', 'max' => 7, 'min' => 1, 'pattern' => '^([1-9][0-9]*|[1-9][0-9]%|[1-9]%|100%)$', ], 'MaxDocumentSizeExceeded' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'MaxErrors' => [ 'type' => 'string', 'max' => 7, 'min' => 1, 'pattern' => '^([1-9][0-9]*|[0]|[1-9][0-9]%|[0-9]%|100%)$', ], 'MaxResults' => [ 'type' => 'integer', 'max' => 50, 'min' => 1, ], 'MaxResultsEC2Compatible' => [ 'type' => 'integer', 'max' => 50, 'min' => 5, ], 'ModifyDocumentPermissionRequest' => [ 'type' => 'structure', 'required' => [ 'Name', 'PermissionType', ], 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'PermissionType' => [ 'shape' => 'DocumentPermissionType', ], 'AccountIdsToAdd' => [ 'shape' => 'AccountIdList', ], 'AccountIdsToRemove' => [ 'shape' => 'AccountIdList', ], ], ], 'ModifyDocumentPermissionResponse' => [ 'type' => 'structure', 'members' => [], ], 'NextToken' => [ 'type' => 'string', ], 'NormalStringMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'NotificationArn' => [ 'type' => 'string', ], 'NotificationConfig' => [ 'type' => 'structure', 'members' => [ 'NotificationArn' => [ 'shape' => 'NotificationArn', ], 'NotificationEvents' => [ 'shape' => 'NotificationEventList', ], 'NotificationType' => [ 'shape' => 'NotificationType', ], ], ], 'NotificationEvent' => [ 'type' => 'string', 'enum' => [ 'All', 'InProgress', 'Success', 'TimedOut', 'Cancelled', 'Failed', ], ], 'NotificationEventList' => [ 'type' => 'list', 'member' => [ 'shape' => 'NotificationEvent', ], ], 'NotificationType' => [ 'type' => 'string', 'enum' => [ 'Command', 'Invocation', ], ], 'OwnerInformation' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'sensitive' => true, ], 'PSParameterName' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => '^(?!^([aA][wW][sS]|[sS][sS][mM]))(?=^[a-zA-Z0-9_.-]*$).*$', ], 'PSParameterValue' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, 'pattern' => '^(?:(?!(\\{\\{.*\\}\\})).)*$', ], 'Parameter' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'PSParameterName', ], 'Type' => [ 'shape' => 'ParameterType', ], 'Value' => [ 'shape' => 'PSParameterValue', ], ], ], 'ParameterAlreadyExists' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'ParameterDescription' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'ParameterHistory' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'PSParameterName', ], 'Type' => [ 'shape' => 'ParameterType', ], 'KeyId' => [ 'shape' => 'ParameterKeyId', ], 'LastModifiedDate' => [ 'shape' => 'DateTime', ], 'LastModifiedUser' => [ 'shape' => 'String', ], 'Description' => [ 'shape' => 'ParameterDescription', ], 'Value' => [ 'shape' => 'PSParameterValue', ], ], ], 'ParameterHistoryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ParameterHistory', ], ], 'ParameterKeyId' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '^([a-zA-Z0-9:/_-]+)$', ], 'ParameterLimitExceeded' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'ParameterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Parameter', ], ], 'ParameterMetadata' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'PSParameterName', ], 'Type' => [ 'shape' => 'ParameterType', ], 'KeyId' => [ 'shape' => 'ParameterKeyId', ], 'LastModifiedDate' => [ 'shape' => 'DateTime', ], 'LastModifiedUser' => [ 'shape' => 'String', ], 'Description' => [ 'shape' => 'ParameterDescription', ], ], ], 'ParameterMetadataList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ParameterMetadata', ], ], 'ParameterName' => [ 'type' => 'string', ], 'ParameterNameList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PSParameterName', ], 'max' => 10, 'min' => 1, ], 'ParameterNotFound' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'ParameterType' => [ 'type' => 'string', 'enum' => [ 'String', 'StringList', 'SecureString', ], ], 'ParameterValue' => [ 'type' => 'string', ], 'ParameterValueList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ParameterValue', ], ], 'Parameters' => [ 'type' => 'map', 'key' => [ 'shape' => 'ParameterName', ], 'value' => [ 'shape' => 'ParameterValueList', ], ], 'ParametersFilter' => [ 'type' => 'structure', 'required' => [ 'Values', ], 'members' => [ 'Key' => [ 'shape' => 'ParametersFilterKey', ], 'Values' => [ 'shape' => 'ParametersFilterValueList', ], ], ], 'ParametersFilterKey' => [ 'type' => 'string', 'enum' => [ 'Name', 'Type', 'KeyId', ], ], 'ParametersFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ParametersFilter', ], ], 'ParametersFilterValue' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'ParametersFilterValueList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ParametersFilterValue', ], 'max' => 50, 'min' => 1, ], 'Patch' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'PatchId', ], 'ReleaseDate' => [ 'shape' => 'DateTime', ], 'Title' => [ 'shape' => 'PatchTitle', ], 'Description' => [ 'shape' => 'PatchDescription', ], 'ContentUrl' => [ 'shape' => 'PatchContentUrl', ], 'Vendor' => [ 'shape' => 'PatchVendor', ], 'ProductFamily' => [ 'shape' => 'PatchProductFamily', ], 'Product' => [ 'shape' => 'PatchProduct', ], 'Classification' => [ 'shape' => 'PatchClassification', ], 'MsrcSeverity' => [ 'shape' => 'PatchMsrcSeverity', ], 'KbNumber' => [ 'shape' => 'PatchKbNumber', ], 'MsrcNumber' => [ 'shape' => 'PatchMsrcNumber', ], 'Language' => [ 'shape' => 'PatchLanguage', ], ], ], 'PatchBaselineIdentity' => [ 'type' => 'structure', 'members' => [ 'BaselineId' => [ 'shape' => 'BaselineId', ], 'BaselineName' => [ 'shape' => 'BaselineName', ], 'BaselineDescription' => [ 'shape' => 'BaselineDescription', ], 'DefaultBaseline' => [ 'shape' => 'DefaultBaseline', ], ], ], 'PatchBaselineIdentityList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PatchBaselineIdentity', ], ], 'PatchBaselineMaxResults' => [ 'type' => 'integer', 'max' => 100, 'min' => 1, ], 'PatchClassification' => [ 'type' => 'string', ], 'PatchComplianceData' => [ 'type' => 'structure', 'required' => [ 'Title', 'KBId', 'Classification', 'Severity', 'State', 'InstalledTime', ], 'members' => [ 'Title' => [ 'shape' => 'PatchTitle', ], 'KBId' => [ 'shape' => 'PatchKbNumber', ], 'Classification' => [ 'shape' => 'PatchClassification', ], 'Severity' => [ 'shape' => 'PatchSeverity', ], 'State' => [ 'shape' => 'PatchComplianceDataState', ], 'InstalledTime' => [ 'shape' => 'PatchInstalledTime', ], ], ], 'PatchComplianceDataList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PatchComplianceData', ], ], 'PatchComplianceDataState' => [ 'type' => 'string', 'enum' => [ 'INSTALLED', 'INSTALLED_OTHER', 'MISSING', 'NOT_APPLICABLE', 'FAILED', ], ], 'PatchComplianceMaxResults' => [ 'type' => 'integer', 'max' => 100, 'min' => 10, ], 'PatchContentUrl' => [ 'type' => 'string', ], 'PatchDeploymentStatus' => [ 'type' => 'string', 'enum' => [ 'APPROVED', 'PENDING_APPROVAL', 'EXPLICIT_APPROVED', 'EXPLICIT_REJECTED', ], ], 'PatchDescription' => [ 'type' => 'string', ], 'PatchFailedCount' => [ 'type' => 'integer', ], 'PatchFilter' => [ 'type' => 'structure', 'required' => [ 'Key', 'Values', ], 'members' => [ 'Key' => [ 'shape' => 'PatchFilterKey', ], 'Values' => [ 'shape' => 'PatchFilterValueList', ], ], ], 'PatchFilterGroup' => [ 'type' => 'structure', 'required' => [ 'PatchFilters', ], 'members' => [ 'PatchFilters' => [ 'shape' => 'PatchFilterList', ], ], ], 'PatchFilterKey' => [ 'type' => 'string', 'enum' => [ 'PRODUCT', 'CLASSIFICATION', 'MSRC_SEVERITY', 'PATCH_ID', ], ], 'PatchFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PatchFilter', ], 'max' => 4, 'min' => 0, ], 'PatchFilterValue' => [ 'type' => 'string', 'max' => 64, 'min' => 1, ], 'PatchFilterValueList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PatchFilterValue', ], 'max' => 20, 'min' => 1, ], 'PatchGroup' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$', ], 'PatchGroupList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PatchGroup', ], ], 'PatchGroupPatchBaselineMapping' => [ 'type' => 'structure', 'members' => [ 'PatchGroup' => [ 'shape' => 'PatchGroup', ], 'BaselineIdentity' => [ 'shape' => 'PatchBaselineIdentity', ], ], ], 'PatchGroupPatchBaselineMappingList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PatchGroupPatchBaselineMapping', ], ], 'PatchId' => [ 'type' => 'string', 'pattern' => '(^KB[0-9]{1,7}$)|(^MS[0-9]{2}\\-[0-9]{3}$)', ], 'PatchIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PatchId', ], 'max' => 50, 'min' => 0, ], 'PatchInstalledCount' => [ 'type' => 'integer', ], 'PatchInstalledOtherCount' => [ 'type' => 'integer', ], 'PatchInstalledTime' => [ 'type' => 'timestamp', ], 'PatchKbNumber' => [ 'type' => 'string', ], 'PatchLanguage' => [ 'type' => 'string', ], 'PatchList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Patch', ], ], 'PatchMissingCount' => [ 'type' => 'integer', ], 'PatchMsrcNumber' => [ 'type' => 'string', ], 'PatchMsrcSeverity' => [ 'type' => 'string', ], 'PatchNotApplicableCount' => [ 'type' => 'integer', ], 'PatchOperationEndTime' => [ 'type' => 'timestamp', ], 'PatchOperationStartTime' => [ 'type' => 'timestamp', ], 'PatchOperationType' => [ 'type' => 'string', 'enum' => [ 'Scan', 'Install', ], ], 'PatchOrchestratorFilter' => [ 'type' => 'structure', 'members' => [ 'Key' => [ 'shape' => 'PatchOrchestratorFilterKey', ], 'Values' => [ 'shape' => 'PatchOrchestratorFilterValues', ], ], ], 'PatchOrchestratorFilterKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'PatchOrchestratorFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PatchOrchestratorFilter', ], 'max' => 5, 'min' => 0, ], 'PatchOrchestratorFilterValue' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'PatchOrchestratorFilterValues' => [ 'type' => 'list', 'member' => [ 'shape' => 'PatchOrchestratorFilterValue', ], ], 'PatchProduct' => [ 'type' => 'string', ], 'PatchProductFamily' => [ 'type' => 'string', ], 'PatchRule' => [ 'type' => 'structure', 'required' => [ 'PatchFilterGroup', 'ApproveAfterDays', ], 'members' => [ 'PatchFilterGroup' => [ 'shape' => 'PatchFilterGroup', ], 'ApproveAfterDays' => [ 'shape' => 'ApproveAfterDays', 'box' => true, ], ], ], 'PatchRuleGroup' => [ 'type' => 'structure', 'required' => [ 'PatchRules', ], 'members' => [ 'PatchRules' => [ 'shape' => 'PatchRuleList', ], ], ], 'PatchRuleList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PatchRule', ], 'max' => 10, 'min' => 0, ], 'PatchSeverity' => [ 'type' => 'string', ], 'PatchStatus' => [ 'type' => 'structure', 'members' => [ 'DeploymentStatus' => [ 'shape' => 'PatchDeploymentStatus', ], 'ApprovalDate' => [ 'shape' => 'DateTime', ], ], ], 'PatchTitle' => [ 'type' => 'string', ], 'PatchVendor' => [ 'type' => 'string', ], 'PingStatus' => [ 'type' => 'string', 'enum' => [ 'Online', 'ConnectionLost', 'Inactive', ], ], 'PlatformType' => [ 'type' => 'string', 'enum' => [ 'Windows', 'Linux', ], ], 'PlatformTypeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PlatformType', 'locationName' => 'PlatformType', ], ], 'PutInventoryRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'Items', ], 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', ], 'Items' => [ 'shape' => 'InventoryItemList', ], ], ], 'PutInventoryResult' => [ 'type' => 'structure', 'members' => [], ], 'PutParameterRequest' => [ 'type' => 'structure', 'required' => [ 'Name', 'Value', 'Type', ], 'members' => [ 'Name' => [ 'shape' => 'PSParameterName', ], 'Description' => [ 'shape' => 'ParameterDescription', ], 'Value' => [ 'shape' => 'PSParameterValue', ], 'Type' => [ 'shape' => 'ParameterType', ], 'KeyId' => [ 'shape' => 'ParameterKeyId', ], 'Overwrite' => [ 'shape' => 'Boolean', 'box' => true, ], ], ], 'PutParameterResult' => [ 'type' => 'structure', 'members' => [], ], 'RegisterDefaultPatchBaselineRequest' => [ 'type' => 'structure', 'required' => [ 'BaselineId', ], 'members' => [ 'BaselineId' => [ 'shape' => 'BaselineId', ], ], ], 'RegisterDefaultPatchBaselineResult' => [ 'type' => 'structure', 'members' => [ 'BaselineId' => [ 'shape' => 'BaselineId', ], ], ], 'RegisterPatchBaselineForPatchGroupRequest' => [ 'type' => 'structure', 'required' => [ 'BaselineId', 'PatchGroup', ], 'members' => [ 'BaselineId' => [ 'shape' => 'BaselineId', ], 'PatchGroup' => [ 'shape' => 'PatchGroup', ], ], ], 'RegisterPatchBaselineForPatchGroupResult' => [ 'type' => 'structure', 'members' => [ 'BaselineId' => [ 'shape' => 'BaselineId', ], 'PatchGroup' => [ 'shape' => 'PatchGroup', ], ], ], 'RegisterTargetWithMaintenanceWindowRequest' => [ 'type' => 'structure', 'required' => [ 'WindowId', 'ResourceType', 'Targets', ], 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], 'ResourceType' => [ 'shape' => 'MaintenanceWindowResourceType', ], 'Targets' => [ 'shape' => 'Targets', ], 'OwnerInformation' => [ 'shape' => 'OwnerInformation', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'RegisterTargetWithMaintenanceWindowResult' => [ 'type' => 'structure', 'members' => [ 'WindowTargetId' => [ 'shape' => 'MaintenanceWindowTargetId', ], ], ], 'RegisterTaskWithMaintenanceWindowRequest' => [ 'type' => 'structure', 'required' => [ 'WindowId', 'Targets', 'TaskArn', 'ServiceRoleArn', 'TaskType', 'MaxConcurrency', 'MaxErrors', ], 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], 'Targets' => [ 'shape' => 'Targets', ], 'TaskArn' => [ 'shape' => 'MaintenanceWindowTaskArn', ], 'ServiceRoleArn' => [ 'shape' => 'ServiceRole', ], 'TaskType' => [ 'shape' => 'MaintenanceWindowTaskType', ], 'TaskParameters' => [ 'shape' => 'MaintenanceWindowTaskParameters', ], 'Priority' => [ 'shape' => 'MaintenanceWindowTaskPriority', 'box' => true, ], 'MaxConcurrency' => [ 'shape' => 'MaxConcurrency', ], 'MaxErrors' => [ 'shape' => 'MaxErrors', ], 'LoggingInfo' => [ 'shape' => 'LoggingInfo', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'RegisterTaskWithMaintenanceWindowResult' => [ 'type' => 'structure', 'members' => [ 'WindowTaskId' => [ 'shape' => 'MaintenanceWindowTaskId', ], ], ], 'RegistrationLimit' => [ 'type' => 'integer', 'max' => 1000, 'min' => 1, ], 'RegistrationsCount' => [ 'type' => 'integer', 'max' => 1000, 'min' => 1, ], 'RemoveTagsFromResourceRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceType', 'ResourceId', 'TagKeys', ], 'members' => [ 'ResourceType' => [ 'shape' => 'ResourceTypeForTagging', ], 'ResourceId' => [ 'shape' => 'ResourceId', ], 'TagKeys' => [ 'shape' => 'KeyList', ], ], ], 'RemoveTagsFromResourceResult' => [ 'type' => 'structure', 'members' => [], ], 'ResourceId' => [ 'type' => 'string', ], 'ResourceInUseException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'ResourceLimitExceededException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'ResourceType' => [ 'type' => 'string', 'enum' => [ 'ManagedInstance', 'Document', 'EC2Instance', ], ], 'ResourceTypeForTagging' => [ 'type' => 'string', 'enum' => [ 'ManagedInstance', 'MaintenanceWindow', 'Parameter', ], ], 'ResponseCode' => [ 'type' => 'integer', ], 'ResultAttribute' => [ 'type' => 'structure', 'required' => [ 'TypeName', ], 'members' => [ 'TypeName' => [ 'shape' => 'InventoryItemTypeName', ], ], ], 'ResultAttributeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResultAttribute', 'locationName' => 'ResultAttribute', ], 'max' => 1, 'min' => 1, ], 'S3BucketName' => [ 'type' => 'string', 'max' => 63, 'min' => 3, ], 'S3KeyPrefix' => [ 'type' => 'string', 'max' => 500, ], 'S3OutputLocation' => [ 'type' => 'structure', 'members' => [ 'OutputS3Region' => [ 'shape' => 'S3Region', ], 'OutputS3BucketName' => [ 'shape' => 'S3BucketName', ], 'OutputS3KeyPrefix' => [ 'shape' => 'S3KeyPrefix', ], ], ], 'S3OutputUrl' => [ 'type' => 'structure', 'members' => [ 'OutputUrl' => [ 'shape' => 'Url', ], ], ], 'S3Region' => [ 'type' => 'string', 'max' => 20, 'min' => 3, ], 'ScheduleExpression' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'SendCommandRequest' => [ 'type' => 'structure', 'required' => [ 'DocumentName', ], 'members' => [ 'InstanceIds' => [ 'shape' => 'InstanceIdList', ], 'Targets' => [ 'shape' => 'Targets', ], 'DocumentName' => [ 'shape' => 'DocumentARN', ], 'DocumentHash' => [ 'shape' => 'DocumentHash', ], 'DocumentHashType' => [ 'shape' => 'DocumentHashType', ], 'TimeoutSeconds' => [ 'shape' => 'TimeoutSeconds', 'box' => true, ], 'Comment' => [ 'shape' => 'Comment', ], 'Parameters' => [ 'shape' => 'Parameters', ], 'OutputS3Region' => [ 'shape' => 'S3Region', ], 'OutputS3BucketName' => [ 'shape' => 'S3BucketName', ], 'OutputS3KeyPrefix' => [ 'shape' => 'S3KeyPrefix', ], 'MaxConcurrency' => [ 'shape' => 'MaxConcurrency', ], 'MaxErrors' => [ 'shape' => 'MaxErrors', ], 'ServiceRoleArn' => [ 'shape' => 'ServiceRole', ], 'NotificationConfig' => [ 'shape' => 'NotificationConfig', ], ], ], 'SendCommandResult' => [ 'type' => 'structure', 'members' => [ 'Command' => [ 'shape' => 'Command', ], ], ], 'ServiceRole' => [ 'type' => 'string', ], 'SnapshotDownloadUrl' => [ 'type' => 'string', ], 'SnapshotId' => [ 'type' => 'string', 'max' => 36, 'min' => 36, 'pattern' => '^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$', ], 'StandardErrorContent' => [ 'type' => 'string', 'max' => 8000, ], 'StandardOutputContent' => [ 'type' => 'string', 'max' => 24000, ], 'StartAutomationExecutionRequest' => [ 'type' => 'structure', 'required' => [ 'DocumentName', ], 'members' => [ 'DocumentName' => [ 'shape' => 'DocumentARN', ], 'DocumentVersion' => [ 'shape' => 'DocumentVersion', 'box' => true, ], 'Parameters' => [ 'shape' => 'AutomationParameterMap', ], ], ], 'StartAutomationExecutionResult' => [ 'type' => 'structure', 'members' => [ 'AutomationExecutionId' => [ 'shape' => 'AutomationExecutionId', ], ], ], 'StatusAdditionalInfo' => [ 'type' => 'string', 'max' => 1024, ], 'StatusDetails' => [ 'type' => 'string', 'max' => 100, 'min' => 0, ], 'StatusMessage' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'StatusName' => [ 'type' => 'string', ], 'StatusUnchanged' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'StepExecution' => [ 'type' => 'structure', 'members' => [ 'StepName' => [ 'shape' => 'String', ], 'Action' => [ 'shape' => 'AutomationActionName', ], 'ExecutionStartTime' => [ 'shape' => 'DateTime', ], 'ExecutionEndTime' => [ 'shape' => 'DateTime', ], 'StepStatus' => [ 'shape' => 'AutomationExecutionStatus', ], 'ResponseCode' => [ 'shape' => 'String', ], 'Inputs' => [ 'shape' => 'NormalStringMap', ], 'Outputs' => [ 'shape' => 'AutomationParameterMap', ], 'Response' => [ 'shape' => 'String', ], 'FailureMessage' => [ 'shape' => 'String', ], 'FailureDetails' => [ 'shape' => 'FailureDetails', ], ], ], 'StepExecutionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'StepExecution', ], 'max' => 100, 'min' => 0, ], 'StopAutomationExecutionRequest' => [ 'type' => 'structure', 'required' => [ 'AutomationExecutionId', ], 'members' => [ 'AutomationExecutionId' => [ 'shape' => 'AutomationExecutionId', ], ], ], 'StopAutomationExecutionResult' => [ 'type' => 'structure', 'members' => [], ], 'String' => [ 'type' => 'string', ], 'StringDateTime' => [ 'type' => 'string', 'pattern' => '^([\\-]?\\d{4}(?!\\d{2}\\b))((-?)((0[1-9]|1[0-2])(\\3([12]\\d|0[1-9]|3[01]))?|W([0-4]\\d|5[0-2])(-?[1-7])?|(00[1-9]|0[1-9]\\d|[12]\\d{2}|3([0-5]\\d|6[1-6])))([T\\s]((([01]\\d|2[0-3])((:?)[0-5]\\d)?|24\\:?00)([\\.,]\\d(?!:))?)?(\\17[0-5]\\d([\\.,]\\d)?)?([zZ]|([\\-])([01]\\d|2[0-3]):?([0-5]\\d)?)?)?)?$', ], 'StringList' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'Tag' => [ 'type' => 'structure', 'required' => [ 'Key', 'Value', ], 'members' => [ 'Key' => [ 'shape' => 'TagKey', ], 'Value' => [ 'shape' => 'TagValue', ], ], ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '^(?!^(?i)aws:)(?=^[\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*$).*$', ], 'TagList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Tag', ], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$', ], 'Target' => [ 'type' => 'structure', 'members' => [ 'Key' => [ 'shape' => 'TargetKey', ], 'Values' => [ 'shape' => 'TargetValues', ], ], ], 'TargetCount' => [ 'type' => 'integer', ], 'TargetKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '^[\\p{L}\\p{Z}\\p{N}_.:/=\\-@]*$', ], 'TargetValue' => [ 'type' => 'string', ], 'TargetValues' => [ 'type' => 'list', 'member' => [ 'shape' => 'TargetValue', ], 'max' => 50, 'min' => 0, ], 'Targets' => [ 'type' => 'list', 'member' => [ 'shape' => 'Target', ], 'max' => 5, 'min' => 0, ], 'TimeoutSeconds' => [ 'type' => 'integer', 'max' => 2592000, 'min' => 30, ], 'TooManyTagsError' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'TooManyUpdates' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'TotalSizeLimitExceededException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'UnsupportedInventorySchemaVersionException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'UnsupportedParameterType' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'UnsupportedPlatformType' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'UpdateAssociationRequest' => [ 'type' => 'structure', 'required' => [ 'AssociationId', ], 'members' => [ 'AssociationId' => [ 'shape' => 'AssociationId', ], 'Parameters' => [ 'shape' => 'Parameters', ], 'DocumentVersion' => [ 'shape' => 'DocumentVersion', ], 'ScheduleExpression' => [ 'shape' => 'ScheduleExpression', ], 'OutputLocation' => [ 'shape' => 'InstanceAssociationOutputLocation', ], 'Name' => [ 'shape' => 'DocumentName', ], 'Targets' => [ 'shape' => 'Targets', ], ], ], 'UpdateAssociationResult' => [ 'type' => 'structure', 'members' => [ 'AssociationDescription' => [ 'shape' => 'AssociationDescription', ], ], ], 'UpdateAssociationStatusRequest' => [ 'type' => 'structure', 'required' => [ 'Name', 'InstanceId', 'AssociationStatus', ], 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'AssociationStatus' => [ 'shape' => 'AssociationStatus', ], ], ], 'UpdateAssociationStatusResult' => [ 'type' => 'structure', 'members' => [ 'AssociationDescription' => [ 'shape' => 'AssociationDescription', ], ], ], 'UpdateDocumentDefaultVersionRequest' => [ 'type' => 'structure', 'required' => [ 'Name', 'DocumentVersion', ], 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'DocumentVersion' => [ 'shape' => 'DocumentVersionNumber', ], ], ], 'UpdateDocumentDefaultVersionResult' => [ 'type' => 'structure', 'members' => [ 'Description' => [ 'shape' => 'DocumentDefaultVersionDescription', ], ], ], 'UpdateDocumentRequest' => [ 'type' => 'structure', 'required' => [ 'Content', 'Name', ], 'members' => [ 'Content' => [ 'shape' => 'DocumentContent', ], 'Name' => [ 'shape' => 'DocumentName', ], 'DocumentVersion' => [ 'shape' => 'DocumentVersion', ], ], ], 'UpdateDocumentResult' => [ 'type' => 'structure', 'members' => [ 'DocumentDescription' => [ 'shape' => 'DocumentDescription', ], ], ], 'UpdateMaintenanceWindowRequest' => [ 'type' => 'structure', 'required' => [ 'WindowId', ], 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], 'Name' => [ 'shape' => 'MaintenanceWindowName', ], 'Schedule' => [ 'shape' => 'MaintenanceWindowSchedule', ], 'Duration' => [ 'shape' => 'MaintenanceWindowDurationHours', 'box' => true, ], 'Cutoff' => [ 'shape' => 'MaintenanceWindowCutoff', 'box' => true, ], 'AllowUnassociatedTargets' => [ 'shape' => 'MaintenanceWindowAllowUnassociatedTargets', 'box' => true, ], 'Enabled' => [ 'shape' => 'MaintenanceWindowEnabled', 'box' => true, ], ], ], 'UpdateMaintenanceWindowResult' => [ 'type' => 'structure', 'members' => [ 'WindowId' => [ 'shape' => 'MaintenanceWindowId', ], 'Name' => [ 'shape' => 'MaintenanceWindowName', ], 'Schedule' => [ 'shape' => 'MaintenanceWindowSchedule', ], 'Duration' => [ 'shape' => 'MaintenanceWindowDurationHours', ], 'Cutoff' => [ 'shape' => 'MaintenanceWindowCutoff', ], 'AllowUnassociatedTargets' => [ 'shape' => 'MaintenanceWindowAllowUnassociatedTargets', ], 'Enabled' => [ 'shape' => 'MaintenanceWindowEnabled', ], ], ], 'UpdateManagedInstanceRoleRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceId', 'IamRole', ], 'members' => [ 'InstanceId' => [ 'shape' => 'ManagedInstanceId', ], 'IamRole' => [ 'shape' => 'IamRole', ], ], ], 'UpdateManagedInstanceRoleResult' => [ 'type' => 'structure', 'members' => [], ], 'UpdatePatchBaselineRequest' => [ 'type' => 'structure', 'required' => [ 'BaselineId', ], 'members' => [ 'BaselineId' => [ 'shape' => 'BaselineId', ], 'Name' => [ 'shape' => 'BaselineName', ], 'GlobalFilters' => [ 'shape' => 'PatchFilterGroup', ], 'ApprovalRules' => [ 'shape' => 'PatchRuleGroup', ], 'ApprovedPatches' => [ 'shape' => 'PatchIdList', ], 'RejectedPatches' => [ 'shape' => 'PatchIdList', ], 'Description' => [ 'shape' => 'BaselineDescription', ], ], ], 'UpdatePatchBaselineResult' => [ 'type' => 'structure', 'members' => [ 'BaselineId' => [ 'shape' => 'BaselineId', ], 'Name' => [ 'shape' => 'BaselineName', ], 'GlobalFilters' => [ 'shape' => 'PatchFilterGroup', ], 'ApprovalRules' => [ 'shape' => 'PatchRuleGroup', ], 'ApprovedPatches' => [ 'shape' => 'PatchIdList', ], 'RejectedPatches' => [ 'shape' => 'PatchIdList', ], 'CreatedDate' => [ 'shape' => 'DateTime', ], 'ModifiedDate' => [ 'shape' => 'DateTime', ], 'Description' => [ 'shape' => 'BaselineDescription', ], ], ], 'Url' => [ 'type' => 'string', ], 'Version' => [ 'type' => 'string', 'pattern' => '^[0-9]{1,6}(\\.[0-9]{1,6}){2,3}$', ], ],];
