<?php
// This file was auto-generated from sdk-root/src/data/organizations/2016-11-28/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2016-11-28', 'endpointPrefix' => 'organizations', 'jsonVersion' => '1.1', 'protocol' => 'json', 'serviceAbbreviation' => 'Organizations', 'serviceFullName' => 'AWS Organizations', 'signatureVersion' => 'v4', 'targetPrefix' => 'AWSOrganizationsV20161128', 'timestampFormat' => 'unixTimestamp', 'uid' => 'organizations-2016-11-28', ], 'operations' => [ 'AcceptHandshake' => [ 'name' => 'AcceptHandshake', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'AcceptHandshakeRequest', ], 'output' => [ 'shape' => 'AcceptHandshakeResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'HandshakeConstraintViolationException', ], [ 'shape' => 'HandshakeNotFoundException', ], [ 'shape' => 'InvalidHandshakeTransitionException', ], [ 'shape' => 'HandshakeAlreadyInStateException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'AttachPolicy' => [ 'name' => 'AttachPolicy', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'AttachPolicyRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'ConstraintViolationException', ], [ 'shape' => 'DuplicatePolicyAttachmentException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'PolicyNotFoundException', ], [ 'shape' => 'PolicyTypeNotEnabledException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TargetNotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'CancelHandshake' => [ 'name' => 'CancelHandshake', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CancelHandshakeRequest', ], 'output' => [ 'shape' => 'CancelHandshakeResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'HandshakeNotFoundException', ], [ 'shape' => 'InvalidHandshakeTransitionException', ], [ 'shape' => 'HandshakeAlreadyInStateException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'CreateAccount' => [ 'name' => 'CreateAccount', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateAccountRequest', ], 'output' => [ 'shape' => 'CreateAccountResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'ConstraintViolationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'FinalizingOrganizationException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'CreateOrganization' => [ 'name' => 'CreateOrganization', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateOrganizationRequest', ], 'output' => [ 'shape' => 'CreateOrganizationResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AlreadyInOrganizationException', ], [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'ConstraintViolationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'CreateOrganizationalUnit' => [ 'name' => 'CreateOrganizationalUnit', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateOrganizationalUnitRequest', ], 'output' => [ 'shape' => 'CreateOrganizationalUnitResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'ConstraintViolationException', ], [ 'shape' => 'DuplicateOrganizationalUnitException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ParentNotFoundException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'CreatePolicy' => [ 'name' => 'CreatePolicy', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreatePolicyRequest', ], 'output' => [ 'shape' => 'CreatePolicyResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'ConstraintViolationException', ], [ 'shape' => 'DuplicatePolicyException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'MalformedPolicyDocumentException', ], [ 'shape' => 'PolicyTypeNotAvailableForOrganizationException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DeclineHandshake' => [ 'name' => 'DeclineHandshake', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeclineHandshakeRequest', ], 'output' => [ 'shape' => 'DeclineHandshakeResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'HandshakeNotFoundException', ], [ 'shape' => 'InvalidHandshakeTransitionException', ], [ 'shape' => 'HandshakeAlreadyInStateException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DeleteOrganization' => [ 'name' => 'DeleteOrganization', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'OrganizationNotEmptyException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DeleteOrganizationalUnit' => [ 'name' => 'DeleteOrganizationalUnit', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteOrganizationalUnitRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'OrganizationalUnitNotEmptyException', ], [ 'shape' => 'OrganizationalUnitNotFoundException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DeletePolicy' => [ 'name' => 'DeletePolicy', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeletePolicyRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'PolicyInUseException', ], [ 'shape' => 'PolicyNotFoundException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DescribeAccount' => [ 'name' => 'DescribeAccount', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeAccountRequest', ], 'output' => [ 'shape' => 'DescribeAccountResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AccountNotFoundException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DescribeCreateAccountStatus' => [ 'name' => 'DescribeCreateAccountStatus', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeCreateAccountStatusRequest', ], 'output' => [ 'shape' => 'DescribeCreateAccountStatusResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'CreateAccountStatusNotFoundException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DescribeHandshake' => [ 'name' => 'DescribeHandshake', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeHandshakeRequest', ], 'output' => [ 'shape' => 'DescribeHandshakeResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'HandshakeNotFoundException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DescribeOrganization' => [ 'name' => 'DescribeOrganization', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'output' => [ 'shape' => 'DescribeOrganizationResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DescribeOrganizationalUnit' => [ 'name' => 'DescribeOrganizationalUnit', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeOrganizationalUnitRequest', ], 'output' => [ 'shape' => 'DescribeOrganizationalUnitResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'OrganizationalUnitNotFoundException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DescribePolicy' => [ 'name' => 'DescribePolicy', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribePolicyRequest', ], 'output' => [ 'shape' => 'DescribePolicyResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'PolicyNotFoundException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DetachPolicy' => [ 'name' => 'DetachPolicy', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DetachPolicyRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'ConstraintViolationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'PolicyNotAttachedException', ], [ 'shape' => 'PolicyNotFoundException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TargetNotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DisablePolicyType' => [ 'name' => 'DisablePolicyType', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DisablePolicyTypeRequest', ], 'output' => [ 'shape' => 'DisablePolicyTypeResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'ConstraintViolationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'PolicyTypeNotEnabledException', ], [ 'shape' => 'RootNotFoundException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'EnableAllFeatures' => [ 'name' => 'EnableAllFeatures', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'EnableAllFeaturesRequest', ], 'output' => [ 'shape' => 'EnableAllFeaturesResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'HandshakeConstraintViolationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'EnablePolicyType' => [ 'name' => 'EnablePolicyType', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'EnablePolicyTypeRequest', ], 'output' => [ 'shape' => 'EnablePolicyTypeResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'ConstraintViolationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'PolicyTypeAlreadyEnabledException', ], [ 'shape' => 'RootNotFoundException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'PolicyTypeNotAvailableForOrganizationException', ], ], ], 'InviteAccountToOrganization' => [ 'name' => 'InviteAccountToOrganization', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'InviteAccountToOrganizationRequest', ], 'output' => [ 'shape' => 'InviteAccountToOrganizationResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'HandshakeConstraintViolationException', ], [ 'shape' => 'DuplicateHandshakeException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'FinalizingOrganizationException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'LeaveOrganization' => [ 'name' => 'LeaveOrganization', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AccountNotFoundException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'ConstraintViolationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'MasterCannotLeaveOrganizationException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListAccounts' => [ 'name' => 'ListAccounts', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListAccountsRequest', ], 'output' => [ 'shape' => 'ListAccountsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListAccountsForParent' => [ 'name' => 'ListAccountsForParent', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListAccountsForParentRequest', ], 'output' => [ 'shape' => 'ListAccountsForParentResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ParentNotFoundException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListChildren' => [ 'name' => 'ListChildren', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListChildrenRequest', ], 'output' => [ 'shape' => 'ListChildrenResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ParentNotFoundException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListCreateAccountStatus' => [ 'name' => 'ListCreateAccountStatus', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListCreateAccountStatusRequest', ], 'output' => [ 'shape' => 'ListCreateAccountStatusResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListHandshakesForAccount' => [ 'name' => 'ListHandshakesForAccount', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListHandshakesForAccountRequest', ], 'output' => [ 'shape' => 'ListHandshakesForAccountResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListHandshakesForOrganization' => [ 'name' => 'ListHandshakesForOrganization', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListHandshakesForOrganizationRequest', ], 'output' => [ 'shape' => 'ListHandshakesForOrganizationResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListOrganizationalUnitsForParent' => [ 'name' => 'ListOrganizationalUnitsForParent', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListOrganizationalUnitsForParentRequest', ], 'output' => [ 'shape' => 'ListOrganizationalUnitsForParentResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ParentNotFoundException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListParents' => [ 'name' => 'ListParents', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListParentsRequest', ], 'output' => [ 'shape' => 'ListParentsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'ChildNotFoundException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListPolicies' => [ 'name' => 'ListPolicies', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListPoliciesRequest', ], 'output' => [ 'shape' => 'ListPoliciesResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListPoliciesForTarget' => [ 'name' => 'ListPoliciesForTarget', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListPoliciesForTargetRequest', ], 'output' => [ 'shape' => 'ListPoliciesForTargetResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TargetNotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListRoots' => [ 'name' => 'ListRoots', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListRootsRequest', ], 'output' => [ 'shape' => 'ListRootsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListTargetsForPolicy' => [ 'name' => 'ListTargetsForPolicy', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListTargetsForPolicyRequest', ], 'output' => [ 'shape' => 'ListTargetsForPolicyResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'PolicyNotFoundException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'MoveAccount' => [ 'name' => 'MoveAccount', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'MoveAccountRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'SourceParentNotFoundException', ], [ 'shape' => 'DestinationParentNotFoundException', ], [ 'shape' => 'DuplicateAccountException', ], [ 'shape' => 'AccountNotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'ServiceException', ], ], ], 'RemoveAccountFromOrganization' => [ 'name' => 'RemoveAccountFromOrganization', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'RemoveAccountFromOrganizationRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AccountNotFoundException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'ConstraintViolationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'MasterCannotLeaveOrganizationException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'UpdateOrganizationalUnit' => [ 'name' => 'UpdateOrganizationalUnit', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateOrganizationalUnitRequest', ], 'output' => [ 'shape' => 'UpdateOrganizationalUnitResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'DuplicateOrganizationalUnitException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'OrganizationalUnitNotFoundException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'UpdatePolicy' => [ 'name' => 'UpdatePolicy', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdatePolicyRequest', ], 'output' => [ 'shape' => 'UpdatePolicyResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AWSOrganizationsNotInUseException', ], [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'ConstraintViolationException', ], [ 'shape' => 'DuplicatePolicyException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'MalformedPolicyDocumentException', ], [ 'shape' => 'PolicyNotFoundException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], ], 'shapes' => [ 'AWSOrganizationsNotInUseException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'AcceptHandshakeRequest' => [ 'type' => 'structure', 'required' => [ 'HandshakeId', ], 'members' => [ 'HandshakeId' => [ 'shape' => 'HandshakeId', ], ], ], 'AcceptHandshakeResponse' => [ 'type' => 'structure', 'members' => [ 'Handshake' => [ 'shape' => 'Handshake', ], ], ], 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'Account' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'AccountId', ], 'Arn' => [ 'shape' => 'AccountArn', ], 'Email' => [ 'shape' => 'Email', ], 'Name' => [ 'shape' => 'AccountName', ], 'Status' => [ 'shape' => 'AccountStatus', ], 'JoinedMethod' => [ 'shape' => 'AccountJoinedMethod', ], 'JoinedTimestamp' => [ 'shape' => 'Timestamp', ], ], ], 'AccountArn' => [ 'type' => 'string', 'pattern' => '^arn:aws:organizations::\\d{12}:account\\/o-[a-z0-9]{10,32}\\/\\d{12}', ], 'AccountId' => [ 'type' => 'string', 'pattern' => '^\\d{12}$', ], 'AccountJoinedMethod' => [ 'type' => 'string', 'enum' => [ 'INVITED', 'CREATED', ], ], 'AccountName' => [ 'type' => 'string', 'max' => 50, 'min' => 1, 'sensitive' => true, ], 'AccountNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'AccountStatus' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'SUSPENDED', ], ], 'Accounts' => [ 'type' => 'list', 'member' => [ 'shape' => 'Account', ], ], 'ActionType' => [ 'type' => 'string', 'enum' => [ 'INVITE', 'ENABLE_ALL_FEATURES', 'APPROVE_ALL_FEATURES', ], ], 'AlreadyInOrganizationException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'AttachPolicyRequest' => [ 'type' => 'structure', 'required' => [ 'PolicyId', 'TargetId', ], 'members' => [ 'PolicyId' => [ 'shape' => 'PolicyId', ], 'TargetId' => [ 'shape' => 'PolicyTargetId', ], ], ], 'AwsManagedPolicy' => [ 'type' => 'boolean', ], 'CancelHandshakeRequest' => [ 'type' => 'structure', 'required' => [ 'HandshakeId', ], 'members' => [ 'HandshakeId' => [ 'shape' => 'HandshakeId', ], ], ], 'CancelHandshakeResponse' => [ 'type' => 'structure', 'members' => [ 'Handshake' => [ 'shape' => 'Handshake', ], ], ], 'Child' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'ChildId', ], 'Type' => [ 'shape' => 'ChildType', ], ], ], 'ChildId' => [ 'type' => 'string', 'pattern' => '^(\\d{12})|(ou-[0-9a-z]{4,32}-[a-z0-9]{8,32})$', ], 'ChildNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'ChildType' => [ 'type' => 'string', 'enum' => [ 'ACCOUNT', 'ORGANIZATIONAL_UNIT', ], ], 'Children' => [ 'type' => 'list', 'member' => [ 'shape' => 'Child', ], ], 'ConcurrentModificationException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'ConstraintViolationException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], 'Reason' => [ 'shape' => 'ConstraintViolationExceptionReason', ], ], 'exception' => true, ], 'ConstraintViolationExceptionReason' => [ 'type' => 'string', 'enum' => [ 'ACCOUNT_NUMBER_LIMIT_EXCEEDED', 'HANDSHAKE_RATE_LIMIT_EXCEEDED', 'OU_NUMBER_LIMIT_EXCEEDED', 'OU_DEPTH_LIMIT_EXCEEDED', 'POLICY_NUMBER_LIMIT_EXCEEDED', 'MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED', 'MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED', 'ACCOUNT_CANNOT_LEAVE_ORGANIZATION', 'MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED', 'MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED', 'ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED', 'MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE', ], ], 'CreateAccountFailureReason' => [ 'type' => 'string', 'enum' => [ 'ACCOUNT_LIMIT_EXCEEDED', 'EMAIL_ALREADY_EXISTS', 'INVALID_ADDRESS', 'INVALID_EMAIL', 'INTERNAL_FAILURE', ], ], 'CreateAccountRequest' => [ 'type' => 'structure', 'required' => [ 'Email', 'AccountName', ], 'members' => [ 'Email' => [ 'shape' => 'Email', ], 'AccountName' => [ 'shape' => 'AccountName', ], 'RoleName' => [ 'shape' => 'RoleName', ], 'IamUserAccessToBilling' => [ 'shape' => 'IAMUserAccessToBilling', ], ], ], 'CreateAccountRequestId' => [ 'type' => 'string', 'pattern' => '^car-[a-z0-9]{8,32}$', ], 'CreateAccountResponse' => [ 'type' => 'structure', 'members' => [ 'CreateAccountStatus' => [ 'shape' => 'CreateAccountStatus', ], ], ], 'CreateAccountState' => [ 'type' => 'string', 'enum' => [ 'IN_PROGRESS', 'SUCCEEDED', 'FAILED', ], ], 'CreateAccountStates' => [ 'type' => 'list', 'member' => [ 'shape' => 'CreateAccountState', ], ], 'CreateAccountStatus' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'CreateAccountRequestId', ], 'AccountName' => [ 'shape' => 'AccountName', ], 'State' => [ 'shape' => 'CreateAccountState', ], 'RequestedTimestamp' => [ 'shape' => 'Timestamp', ], 'CompletedTimestamp' => [ 'shape' => 'Timestamp', ], 'AccountId' => [ 'shape' => 'AccountId', ], 'FailureReason' => [ 'shape' => 'CreateAccountFailureReason', ], ], ], 'CreateAccountStatusNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'CreateAccountStatuses' => [ 'type' => 'list', 'member' => [ 'shape' => 'CreateAccountStatus', ], ], 'CreateOrganizationRequest' => [ 'type' => 'structure', 'members' => [ 'FeatureSet' => [ 'shape' => 'OrganizationFeatureSet', ], ], ], 'CreateOrganizationResponse' => [ 'type' => 'structure', 'members' => [ 'Organization' => [ 'shape' => 'Organization', ], ], ], 'CreateOrganizationalUnitRequest' => [ 'type' => 'structure', 'required' => [ 'ParentId', 'Name', ], 'members' => [ 'ParentId' => [ 'shape' => 'ParentId', ], 'Name' => [ 'shape' => 'OrganizationalUnitName', ], ], ], 'CreateOrganizationalUnitResponse' => [ 'type' => 'structure', 'members' => [ 'OrganizationalUnit' => [ 'shape' => 'OrganizationalUnit', ], ], ], 'CreatePolicyRequest' => [ 'type' => 'structure', 'required' => [ 'Content', 'Description', 'Name', 'Type', ], 'members' => [ 'Content' => [ 'shape' => 'PolicyContent', ], 'Description' => [ 'shape' => 'PolicyDescription', ], 'Name' => [ 'shape' => 'PolicyName', ], 'Type' => [ 'shape' => 'PolicyType', ], ], ], 'CreatePolicyResponse' => [ 'type' => 'structure', 'members' => [ 'Policy' => [ 'shape' => 'Policy', ], ], ], 'DeclineHandshakeRequest' => [ 'type' => 'structure', 'required' => [ 'HandshakeId', ], 'members' => [ 'HandshakeId' => [ 'shape' => 'HandshakeId', ], ], ], 'DeclineHandshakeResponse' => [ 'type' => 'structure', 'members' => [ 'Handshake' => [ 'shape' => 'Handshake', ], ], ], 'DeleteOrganizationalUnitRequest' => [ 'type' => 'structure', 'required' => [ 'OrganizationalUnitId', ], 'members' => [ 'OrganizationalUnitId' => [ 'shape' => 'OrganizationalUnitId', ], ], ], 'DeletePolicyRequest' => [ 'type' => 'structure', 'required' => [ 'PolicyId', ], 'members' => [ 'PolicyId' => [ 'shape' => 'PolicyId', ], ], ], 'DescribeAccountRequest' => [ 'type' => 'structure', 'required' => [ 'AccountId', ], 'members' => [ 'AccountId' => [ 'shape' => 'AccountId', ], ], ], 'DescribeAccountResponse' => [ 'type' => 'structure', 'members' => [ 'Account' => [ 'shape' => 'Account', ], ], ], 'DescribeCreateAccountStatusRequest' => [ 'type' => 'structure', 'required' => [ 'CreateAccountRequestId', ], 'members' => [ 'CreateAccountRequestId' => [ 'shape' => 'CreateAccountRequestId', ], ], ], 'DescribeCreateAccountStatusResponse' => [ 'type' => 'structure', 'members' => [ 'CreateAccountStatus' => [ 'shape' => 'CreateAccountStatus', ], ], ], 'DescribeHandshakeRequest' => [ 'type' => 'structure', 'required' => [ 'HandshakeId', ], 'members' => [ 'HandshakeId' => [ 'shape' => 'HandshakeId', ], ], ], 'DescribeHandshakeResponse' => [ 'type' => 'structure', 'members' => [ 'Handshake' => [ 'shape' => 'Handshake', ], ], ], 'DescribeOrganizationResponse' => [ 'type' => 'structure', 'members' => [ 'Organization' => [ 'shape' => 'Organization', ], ], ], 'DescribeOrganizationalUnitRequest' => [ 'type' => 'structure', 'required' => [ 'OrganizationalUnitId', ], 'members' => [ 'OrganizationalUnitId' => [ 'shape' => 'OrganizationalUnitId', ], ], ], 'DescribeOrganizationalUnitResponse' => [ 'type' => 'structure', 'members' => [ 'OrganizationalUnit' => [ 'shape' => 'OrganizationalUnit', ], ], ], 'DescribePolicyRequest' => [ 'type' => 'structure', 'required' => [ 'PolicyId', ], 'members' => [ 'PolicyId' => [ 'shape' => 'PolicyId', ], ], ], 'DescribePolicyResponse' => [ 'type' => 'structure', 'members' => [ 'Policy' => [ 'shape' => 'Policy', ], ], ], 'DestinationParentNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'DetachPolicyRequest' => [ 'type' => 'structure', 'required' => [ 'PolicyId', 'TargetId', ], 'members' => [ 'PolicyId' => [ 'shape' => 'PolicyId', ], 'TargetId' => [ 'shape' => 'PolicyTargetId', ], ], ], 'DisablePolicyTypeRequest' => [ 'type' => 'structure', 'required' => [ 'RootId', 'PolicyType', ], 'members' => [ 'RootId' => [ 'shape' => 'RootId', ], 'PolicyType' => [ 'shape' => 'PolicyType', ], ], ], 'DisablePolicyTypeResponse' => [ 'type' => 'structure', 'members' => [ 'Root' => [ 'shape' => 'Root', ], ], ], 'DuplicateAccountException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'DuplicateHandshakeException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'DuplicateOrganizationalUnitException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'DuplicatePolicyAttachmentException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'DuplicatePolicyException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'Email' => [ 'type' => 'string', 'max' => 64, 'min' => 6, 'pattern' => '[^\\s@]+@[^\\s@]+\\.[^\\s@]+', 'sensitive' => true, ], 'EnableAllFeaturesRequest' => [ 'type' => 'structure', 'members' => [], ], 'EnableAllFeaturesResponse' => [ 'type' => 'structure', 'members' => [ 'Handshake' => [ 'shape' => 'Handshake', ], ], ], 'EnablePolicyTypeRequest' => [ 'type' => 'structure', 'required' => [ 'RootId', 'PolicyType', ], 'members' => [ 'RootId' => [ 'shape' => 'RootId', ], 'PolicyType' => [ 'shape' => 'PolicyType', ], ], ], 'EnablePolicyTypeResponse' => [ 'type' => 'structure', 'members' => [ 'Root' => [ 'shape' => 'Root', ], ], ], 'ExceptionMessage' => [ 'type' => 'string', ], 'ExceptionType' => [ 'type' => 'string', ], 'FinalizingOrganizationException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'GenericArn' => [ 'type' => 'string', 'pattern' => '^arn:aws:organizations::.+:.+', ], 'Handshake' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'HandshakeId', ], 'Arn' => [ 'shape' => 'HandshakeArn', ], 'Parties' => [ 'shape' => 'HandshakeParties', ], 'State' => [ 'shape' => 'HandshakeState', ], 'RequestedTimestamp' => [ 'shape' => 'Timestamp', ], 'ExpirationTimestamp' => [ 'shape' => 'Timestamp', ], 'Action' => [ 'shape' => 'ActionType', ], 'Resources' => [ 'shape' => 'HandshakeResources', ], ], ], 'HandshakeAlreadyInStateException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'HandshakeArn' => [ 'type' => 'string', 'pattern' => '^arn:aws:organizations::\\d{12}:handshake\\/o-[a-z0-9]{10,32}\\/[a-z_]{1,32}\\/h-[0-9a-z]{8,32}', ], 'HandshakeConstraintViolationException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], 'Reason' => [ 'shape' => 'HandshakeConstraintViolationExceptionReason', ], ], 'exception' => true, ], 'HandshakeConstraintViolationExceptionReason' => [ 'type' => 'string', 'enum' => [ 'ACCOUNT_NUMBER_LIMIT_EXCEEDED', 'HANDSHAKE_RATE_LIMIT_EXCEEDED', 'ALREADY_IN_AN_ORGANIZATION', 'ORGANIZATION_ALREADY_HAS_ALL_FEATURES', 'INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES', 'PAYMENT_INSTRUMENT_REQUIRED', 'ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD', 'ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED', ], ], 'HandshakeFilter' => [ 'type' => 'structure', 'members' => [ 'ActionType' => [ 'shape' => 'ActionType', ], 'ParentHandshakeId' => [ 'shape' => 'HandshakeId', ], ], ], 'HandshakeId' => [ 'type' => 'string', 'pattern' => '^h-[0-9a-z]{8,32}$', ], 'HandshakeNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'HandshakeNotes' => [ 'type' => 'string', 'max' => 1024, 'sensitive' => true, ], 'HandshakeParties' => [ 'type' => 'list', 'member' => [ 'shape' => 'HandshakeParty', ], ], 'HandshakeParty' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'HandshakePartyId', ], 'Type' => [ 'shape' => 'HandshakePartyType', ], ], ], 'HandshakePartyId' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'sensitive' => true, ], 'HandshakePartyType' => [ 'type' => 'string', 'enum' => [ 'ACCOUNT', 'ORGANIZATION', 'EMAIL', ], ], 'HandshakeResource' => [ 'type' => 'structure', 'members' => [ 'Value' => [ 'shape' => 'HandshakeResourceValue', ], 'Type' => [ 'shape' => 'HandshakeResourceType', ], 'Resources' => [ 'shape' => 'HandshakeResources', ], ], ], 'HandshakeResourceType' => [ 'type' => 'string', 'enum' => [ 'ACCOUNT', 'ORGANIZATION', 'ORGANIZATION_FEATURE_SET', 'EMAIL', 'MASTER_EMAIL', 'MASTER_NAME', 'NOTES', 'PARENT_HANDSHAKE', ], ], 'HandshakeResourceValue' => [ 'type' => 'string', 'sensitive' => true, ], 'HandshakeResources' => [ 'type' => 'list', 'member' => [ 'shape' => 'HandshakeResource', ], ], 'HandshakeState' => [ 'type' => 'string', 'enum' => [ 'REQUESTED', 'OPEN', 'CANCELED', 'ACCEPTED', 'DECLINED', 'EXPIRED', ], ], 'Handshakes' => [ 'type' => 'list', 'member' => [ 'shape' => 'Handshake', ], ], 'IAMUserAccessToBilling' => [ 'type' => 'string', 'enum' => [ 'ALLOW', 'DENY', ], ], 'InvalidHandshakeTransitionException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'InvalidInputException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], 'Reason' => [ 'shape' => 'InvalidInputExceptionReason', ], ], 'exception' => true, ], 'InvalidInputExceptionReason' => [ 'type' => 'string', 'enum' => [ 'INVALID_PARTY_TYPE_TARGET', 'INVALID_SYNTAX_ORGANIZATION_ARN', 'INVALID_SYNTAX_POLICY_ID', 'INVALID_ENUM', 'INVALID_LIST_MEMBER', 'MAX_LENGTH_EXCEEDED', 'MAX_VALUE_EXCEEDED', 'MIN_LENGTH_EXCEEDED', 'MIN_VALUE_EXCEEDED', 'IMMUTABLE_POLICY', 'INVALID_PATTERN', 'INVALID_PATTERN_TARGET_ID', 'INPUT_REQUIRED', 'INVALID_NEXT_TOKEN', 'MAX_LIMIT_EXCEEDED_FILTER', 'MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS', ], ], 'InviteAccountToOrganizationRequest' => [ 'type' => 'structure', 'required' => [ 'Target', ], 'members' => [ 'Target' => [ 'shape' => 'HandshakeParty', ], 'Notes' => [ 'shape' => 'HandshakeNotes', ], ], ], 'InviteAccountToOrganizationResponse' => [ 'type' => 'structure', 'members' => [ 'Handshake' => [ 'shape' => 'Handshake', ], ], ], 'ListAccountsForParentRequest' => [ 'type' => 'structure', 'required' => [ 'ParentId', ], 'members' => [ 'ParentId' => [ 'shape' => 'ParentId', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], ], ], 'ListAccountsForParentResponse' => [ 'type' => 'structure', 'members' => [ 'Accounts' => [ 'shape' => 'Accounts', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListAccountsRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], ], ], 'ListAccountsResponse' => [ 'type' => 'structure', 'members' => [ 'Accounts' => [ 'shape' => 'Accounts', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListChildrenRequest' => [ 'type' => 'structure', 'required' => [ 'ParentId', 'ChildType', ], 'members' => [ 'ParentId' => [ 'shape' => 'ParentId', ], 'ChildType' => [ 'shape' => 'ChildType', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], ], ], 'ListChildrenResponse' => [ 'type' => 'structure', 'members' => [ 'Children' => [ 'shape' => 'Children', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListCreateAccountStatusRequest' => [ 'type' => 'structure', 'members' => [ 'States' => [ 'shape' => 'CreateAccountStates', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], ], ], 'ListCreateAccountStatusResponse' => [ 'type' => 'structure', 'members' => [ 'CreateAccountStatuses' => [ 'shape' => 'CreateAccountStatuses', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListHandshakesForAccountRequest' => [ 'type' => 'structure', 'members' => [ 'Filter' => [ 'shape' => 'HandshakeFilter', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], ], ], 'ListHandshakesForAccountResponse' => [ 'type' => 'structure', 'members' => [ 'Handshakes' => [ 'shape' => 'Handshakes', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListHandshakesForOrganizationRequest' => [ 'type' => 'structure', 'members' => [ 'Filter' => [ 'shape' => 'HandshakeFilter', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], ], ], 'ListHandshakesForOrganizationResponse' => [ 'type' => 'structure', 'members' => [ 'Handshakes' => [ 'shape' => 'Handshakes', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListOrganizationalUnitsForParentRequest' => [ 'type' => 'structure', 'required' => [ 'ParentId', ], 'members' => [ 'ParentId' => [ 'shape' => 'ParentId', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], ], ], 'ListOrganizationalUnitsForParentResponse' => [ 'type' => 'structure', 'members' => [ 'OrganizationalUnits' => [ 'shape' => 'OrganizationalUnits', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListParentsRequest' => [ 'type' => 'structure', 'required' => [ 'ChildId', ], 'members' => [ 'ChildId' => [ 'shape' => 'ChildId', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], ], ], 'ListParentsResponse' => [ 'type' => 'structure', 'members' => [ 'Parents' => [ 'shape' => 'Parents', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListPoliciesForTargetRequest' => [ 'type' => 'structure', 'required' => [ 'TargetId', 'Filter', ], 'members' => [ 'TargetId' => [ 'shape' => 'PolicyTargetId', ], 'Filter' => [ 'shape' => 'PolicyType', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], ], ], 'ListPoliciesForTargetResponse' => [ 'type' => 'structure', 'members' => [ 'Policies' => [ 'shape' => 'Policies', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListPoliciesRequest' => [ 'type' => 'structure', 'required' => [ 'Filter', ], 'members' => [ 'Filter' => [ 'shape' => 'PolicyType', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], ], ], 'ListPoliciesResponse' => [ 'type' => 'structure', 'members' => [ 'Policies' => [ 'shape' => 'Policies', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListRootsRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], ], ], 'ListRootsResponse' => [ 'type' => 'structure', 'members' => [ 'Roots' => [ 'shape' => 'Roots', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTargetsForPolicyRequest' => [ 'type' => 'structure', 'required' => [ 'PolicyId', ], 'members' => [ 'PolicyId' => [ 'shape' => 'PolicyId', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], ], ], 'ListTargetsForPolicyResponse' => [ 'type' => 'structure', 'members' => [ 'Targets' => [ 'shape' => 'PolicyTargets', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'MalformedPolicyDocumentException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'MasterCannotLeaveOrganizationException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'MaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 20, 'min' => 1, ], 'MoveAccountRequest' => [ 'type' => 'structure', 'required' => [ 'AccountId', 'SourceParentId', 'DestinationParentId', ], 'members' => [ 'AccountId' => [ 'shape' => 'AccountId', ], 'SourceParentId' => [ 'shape' => 'ParentId', ], 'DestinationParentId' => [ 'shape' => 'ParentId', ], ], ], 'NextToken' => [ 'type' => 'string', ], 'Organization' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'OrganizationId', ], 'Arn' => [ 'shape' => 'OrganizationArn', ], 'FeatureSet' => [ 'shape' => 'OrganizationFeatureSet', ], 'MasterAccountArn' => [ 'shape' => 'AccountArn', ], 'MasterAccountId' => [ 'shape' => 'AccountId', ], 'MasterAccountEmail' => [ 'shape' => 'Email', ], 'AvailablePolicyTypes' => [ 'shape' => 'PolicyTypes', ], ], ], 'OrganizationArn' => [ 'type' => 'string', 'pattern' => '^arn:aws:organizations::\\d{12}:organization\\/o-[a-z0-9]{10,32}', ], 'OrganizationFeatureSet' => [ 'type' => 'string', 'enum' => [ 'ALL', 'CONSOLIDATED_BILLING', ], ], 'OrganizationId' => [ 'type' => 'string', 'pattern' => '^o-[a-z0-9]{10,32}$', ], 'OrganizationNotEmptyException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'OrganizationalUnit' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'OrganizationalUnitId', ], 'Arn' => [ 'shape' => 'OrganizationalUnitArn', ], 'Name' => [ 'shape' => 'OrganizationalUnitName', ], ], ], 'OrganizationalUnitArn' => [ 'type' => 'string', 'pattern' => '^arn:aws:organizations::\\d{12}:ou\\/o-[a-z0-9]{10,32}\\/ou-[0-9a-z]{4,32}-[0-9a-z]{8,32}', ], 'OrganizationalUnitId' => [ 'type' => 'string', 'pattern' => '^ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}$', ], 'OrganizationalUnitName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'OrganizationalUnitNotEmptyException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'OrganizationalUnitNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'OrganizationalUnits' => [ 'type' => 'list', 'member' => [ 'shape' => 'OrganizationalUnit', ], ], 'Parent' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'ParentId', ], 'Type' => [ 'shape' => 'ParentType', ], ], ], 'ParentId' => [ 'type' => 'string', 'pattern' => '^(r-[0-9a-z]{4,32})|(ou-[0-9a-z]{4,32}-[a-z0-9]{8,32})$', ], 'ParentNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'ParentType' => [ 'type' => 'string', 'enum' => [ 'ROOT', 'ORGANIZATIONAL_UNIT', ], ], 'Parents' => [ 'type' => 'list', 'member' => [ 'shape' => 'Parent', ], ], 'Policies' => [ 'type' => 'list', 'member' => [ 'shape' => 'PolicySummary', ], ], 'Policy' => [ 'type' => 'structure', 'members' => [ 'PolicySummary' => [ 'shape' => 'PolicySummary', ], 'Content' => [ 'shape' => 'PolicyContent', ], ], ], 'PolicyArn' => [ 'type' => 'string', 'pattern' => '^(arn:aws:organizations::\\d{12}:policy\\/o-[a-z0-9]{10,32}\\/[0-9a-z_]+\\/p-[0-9a-z]{10,32})|(arn:aws:organizations::aws:policy\\/[0-9a-z_]+\\/p-[0-9a-zA-Z_]{10,128})', ], 'PolicyContent' => [ 'type' => 'string', 'max' => 1000000, 'min' => 1, ], 'PolicyDescription' => [ 'type' => 'string', 'max' => 512, ], 'PolicyId' => [ 'type' => 'string', 'pattern' => '^p-[0-9a-zA-Z_]{8,128}$', ], 'PolicyInUseException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'PolicyName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'PolicyNotAttachedException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'PolicyNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'PolicySummary' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'PolicyId', ], 'Arn' => [ 'shape' => 'PolicyArn', ], 'Name' => [ 'shape' => 'PolicyName', ], 'Description' => [ 'shape' => 'PolicyDescription', ], 'Type' => [ 'shape' => 'PolicyType', ], 'AwsManaged' => [ 'shape' => 'AwsManagedPolicy', ], ], ], 'PolicyTargetId' => [ 'type' => 'string', 'pattern' => '^(r-[0-9a-z]{4,32})|(\\d{12})|(ou-[0-9a-z]{4,32}-[a-z0-9]{8,32})$', ], 'PolicyTargetSummary' => [ 'type' => 'structure', 'members' => [ 'TargetId' => [ 'shape' => 'PolicyTargetId', ], 'Arn' => [ 'shape' => 'GenericArn', ], 'Name' => [ 'shape' => 'TargetName', ], 'Type' => [ 'shape' => 'TargetType', ], ], ], 'PolicyTargets' => [ 'type' => 'list', 'member' => [ 'shape' => 'PolicyTargetSummary', ], ], 'PolicyType' => [ 'type' => 'string', 'enum' => [ 'SERVICE_CONTROL_POLICY', ], ], 'PolicyTypeAlreadyEnabledException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'PolicyTypeNotAvailableForOrganizationException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'PolicyTypeNotEnabledException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'PolicyTypeStatus' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'PENDING_ENABLE', 'PENDING_DISABLE', ], ], 'PolicyTypeSummary' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'PolicyType', ], 'Status' => [ 'shape' => 'PolicyTypeStatus', ], ], ], 'PolicyTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'PolicyTypeSummary', ], ], 'RemoveAccountFromOrganizationRequest' => [ 'type' => 'structure', 'required' => [ 'AccountId', ], 'members' => [ 'AccountId' => [ 'shape' => 'AccountId', ], ], ], 'RoleName' => [ 'type' => 'string', 'pattern' => '[\\w+=,.@-]{1,64}', ], 'Root' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'RootId', ], 'Arn' => [ 'shape' => 'RootArn', ], 'Name' => [ 'shape' => 'RootName', ], 'PolicyTypes' => [ 'shape' => 'PolicyTypes', ], ], ], 'RootArn' => [ 'type' => 'string', 'pattern' => '^arn:aws:organizations::\\d{12}:root\\/o-[a-z0-9]{10,32}\\/r-[0-9a-z]{4,32}', ], 'RootId' => [ 'type' => 'string', 'pattern' => '^r-[0-9a-z]{4,32}$', ], 'RootName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'RootNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'Roots' => [ 'type' => 'list', 'member' => [ 'shape' => 'Root', ], ], 'ServiceException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'SourceParentNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'TargetName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'TargetNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'TargetType' => [ 'type' => 'string', 'enum' => [ 'ACCOUNT', 'ORGANIZATIONAL_UNIT', 'ROOT', ], ], 'Timestamp' => [ 'type' => 'timestamp', ], 'TooManyRequestsException' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'ExceptionType', ], 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'UpdateOrganizationalUnitRequest' => [ 'type' => 'structure', 'required' => [ 'OrganizationalUnitId', ], 'members' => [ 'OrganizationalUnitId' => [ 'shape' => 'OrganizationalUnitId', ], 'Name' => [ 'shape' => 'OrganizationalUnitName', ], ], ], 'UpdateOrganizationalUnitResponse' => [ 'type' => 'structure', 'members' => [ 'OrganizationalUnit' => [ 'shape' => 'OrganizationalUnit', ], ], ], 'UpdatePolicyRequest' => [ 'type' => 'structure', 'required' => [ 'PolicyId', ], 'members' => [ 'PolicyId' => [ 'shape' => 'PolicyId', ], 'Name' => [ 'shape' => 'PolicyName', ], 'Description' => [ 'shape' => 'PolicyDescription', ], 'Content' => [ 'shape' => 'PolicyContent', ], ], ], 'UpdatePolicyResponse' => [ 'type' => 'structure', 'members' => [ 'Policy' => [ 'shape' => 'Policy', ], ], ], ],];
