<?php
/**
 * This is the endpoint that loads to return the terms of a given taxonomy.
 *
 * @package JobRelay_WP_Connector
 */

// get the status of the field listings endpoint display.
$endpoint_status = wpjmbb_get_field_listings_view_status();

// if we should be showing the  endpoint.
if ( 1 == $endpoint_status ) {

	// get all the job listing registered taxonomies.
	$taxonomies = get_object_taxonomies( 'job_listing' );

	// if we have taxonomies.
	if ( ! empty( $taxonomies ) ) {

		// create an output array.
		$output = array();

		// loop through each taxonomy.
		foreach ( $taxonomies as $taxonomy ) {

			// get all the terms for this taxonomy.
			$taxonomy_terms = get_terms(
				array(
					'taxonomy'   => $taxonomy,
					'hide_empty' => false,
				)
			);

			// if we have any terms.
			if ( ! empty( $taxonomy_terms ) && ! is_wp_error( $taxonomy_terms ) ) {

				// loop through each term.
				foreach ( $taxonomy_terms as $taxonomy_term ) {

					// add this term to the output.
					$output[ $taxonomy ][ $taxonomy_term->term_id ] = $taxonomy_term->name;

				}

			}

		}

		// allow the field listing output array to be filtered.
		$output = apply_filters( 'wpjmbb_field_listings_output', $output );

		// return the output.
		echo json_encode($output, JSON_THROW_ON_ERROR);

	}

} else {

	// echo an error.
	header( 'HTTP/1.1 401 Unauthorized' );
	esc_html_e( 'The field listings endpoint has been hidden. To show the field listings, please activate this in the settings page', 'wp-job-manager-broadbean' );
	die();

}

die();
