<?php
/* exist if directly accessed */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * function wpjmbb_add_settings_tab()
 *
 * adds settings for the integrations username and password
 * and the sample xml and instructional fields
 */
function wpjmbb_add_settings_tab( $settings ) {

	/* add our new settings in its own tab */
	$settings[ strtolower( apply_filters( 'wpjmbb_integration_service_name', 'Broadbean' ) ) ] = array(
		apply_filters( 'wpjmbb_integration_service_name', 'Broadbean' ),
		array(
			array(
				'name'          => 'wpjmbb_license_key',
				'std'           => '',
				'placeholder'   => 'License key',
				'label'         => __( 'License Key', 'wp-job-manager' ),
				'desc'          => __( 'Enter your plugin license key for auto updates and support features. Once saved you will need to activate it using the activate button which appears to the right.', 'wp-job-manager' ),
				'type'          => 'license',
				'attributes'    => array(),
			),
			array(
				'name'          => 'job_manager_bb_username',
				'std'           => '',
				'placeholder'   => 'Username',
				'label'         => __( 'Username', 'wp-job-manager' ),
				'desc'          => __( 'Enter a username for your feed. This username is used to authenticate when a job is sent.', 'wp-job-manager' ),
				'attributes'    => array(),
			),
			array(
				'name'          => 'job_manager_bb_password',
				'std'           => '',
				'placeholder'   => 'Username',
				'label'         => __( 'Password', 'wp-job-manager' ),
				'desc'          => __( 'Enter a password for your feed. Letters only (upper and lower is best). This username is used to authenticate when a job is sent.', 'wp-job-manager' ),
				'attributes'    => array(),
			),
			array(
				'name'          => 'job_manager_bb_logging',
				'std'           => '0',
				'label'         => __( 'Debug Logging', 'wp-job-manager' ),
				'cb_label'      => __( 'Tick to enable debug logging.', 'wp-job-manager' ),
				'desc'          => __( 'When checked the incoming raw feed data is saved with each job.', 'wp-job-manager' ),
				'type'          => 'checkbox',
				'placeholder'   => '',
				'attributes'    => array(),
			),
			array(
				'name'          => 'job_manager_show_readme',
				'std'           => '0',
				'label'         => __( 'Show Readme', 'wp-job-manager' ),
				'cb_label'      => __( 'Tick to enable the readme endpoint to display - see below.', 'wp-job-manager' ),
				'desc'          => sprintf( __( 'When checked the readme endpoint is visible at <code><a href="%1s">%2s</a></code>. This provides information on how the feed to your site should be built, including sample XML data.' ), home_url( '/wpjmbb/readme' ), home_url( '/wpjmbb/readme' ) ),
				'type'          => 'checkbox',
				'placeholder'   => '',
				'attributes'    => array(),
			),
			array(
				'name'          => 'job_manager_show_field_listings_endpoint',
				'std'           => '0',
				'label'         => __( 'Show Field Listings Endpoint', 'wp-job-manager' ),
				'cb_label'      => __( 'Tick to enable the field listings endpoint to display - see below.', 'wp-job-manager' ),
				'desc'          => sprintf( __( 'When checked the field listings endpoint is visible at <code><a href="%1s">%2s</a></code>. This provides information on the fields which have set values to choose from, such as the job categories and types.' ), home_url( '/wpjmbb/field-listings' ), home_url( '/wpjmbb/field-listings' ) ),
				'type'          => 'checkbox',
				'placeholder'   => '',
				'attributes'    => array(),
			),
		),
	);

	return $settings;

}

add_filter( 'job_manager_settings', 'wpjmbb_add_settings_tab' );
