<?php
/**
 * function function wpjmbb_setting_no_input_output()
 *
 * controls the output for settings fields of type no_input
 */
function wpjmbb_setting_no_input_output( $option, $attributes, $value, $placeholder ) {

	if ( $option['desc'] ) {
		echo ' <p class="description">' . $option['desc'] . '</p>';
	}

}

add_action( 'wp_job_manager_admin_field_no_input', 'wpjmbb_setting_no_input_output', 10, 4 );

/**
 * function wpjmbb_license_field()
 *
 * field type for adding the license to the settings tab
 * creates the license input as a password input and also adds
 * a submit button to activate the license.
 * the activate button only shows if a license is saved
 */
function wpjmbb_license_field( $option, $attributes, $value, $placeholder ) {

	?>

	<input id="setting-<?php echo $option['name']; ?>" class="regular-text" type="password" name="<?php echo $option['name']; ?>" value="<?php esc_attr_e( $value ); ?>" <?php echo implode( ' ', $attributes ); ?> <?php echo $placeholder; ?> />

	<?php

	/* add a nonce field to check for on activation of the license */
	wp_nonce_field( 'wpjmbb_license_nonce', 'wpjmbb_license_nonce' );

	/* get the license key and status */
	$license		= wpjmbb_get_license_key();
	$license_status = wpjmbb_get_license_key_status();

	/* if we have a license key and the status in no valid */
	if( $license !== false && $license_status !== 'valid' ) {

		/* output the activate license button */
		?>
		<input type="submit" class="button-secondary" name="wpjmbb_license_activate" value="<?php _e( 'Activate License' ); ?>"/>
		<?php

	}

	/* we have an active valid license */
	elseif( $license != false && $license_status != 'invalid' ) {

		/* output the deactivate license button */
		?>
		<input type="submit" class="button-secondary" name="wpjmbb_license_deactivate" value="<?php _e( 'Deactivate License' ); ?>"/>
		<?php

	}


	if ( $option['desc'] ) {
		echo ' <p class="description">' . $option['desc'] . '</p>';
	}

}

add_action( 'wp_job_manager_admin_field_license', 'wpjmbb_license_field', 10, 4 );
