<?php
/**
 * This is the readme file for information about building the feed to this plugin.
 *
 * @package WP_Job_Manager_Broadbean
 */

// get the job fields.
$fields = wpjmbb_get_fields();
//wp_var_dump( $fields );

// add the job title to the fields array.
$fields['_job_title'] = array(
	'label'         => 'Job Title',
	'type'          => 'text',
	'description'   => 'Enter the job title',
	'jobfeed_notes' => array(
		'data_type'     => 'string',
		'input_type'    => 'text',
		'default_value' => '',
		'example_value' => 'WordPress Developer',
		'notes'         => __( 'This is the main job title.', 'wp-job-manager-broadbean' ),
	),
);

// add the job description to the fields array.
$fields['_job_description'] = array(
	'label'         => 'Job Description',
	'type'          => 'wysiwyg',
	'description'   => 'Enter the job description',
	'jobfeed_notes' => array(
		'data_type'     => 'string',
		'input_type'    => 'text',
		'default_value' => '',
		'example_value' => 'This is the description of the job which can contain some HTML.',
		'notes'         => __( 'This is the main job description. It can contain HTML but not script or iframe tags. <strong>It should be wrapped in <a href="https://en.wikipedia.org/wiki/CDATA">CDATA tags</a></strong>.', 'wp-job-manager-broadbean' ),
	),
);

// get all the taxonomies that are associated with the job_listings post type.
$taxonomies = get_object_taxonomies( 'job_listing', 'objects' );

// if we have taxonomies.
if ( ! empty( $taxonomies ) && ! is_wp_error( $taxonomies ) ) {

	// loop through each taxonomy.
	foreach ( $taxonomies as $taxonomy ) {

		// add this taxonomy to the fields array.
		$fields[ $taxonomy->name ] = array(
			'label'         => $taxonomy->labels->singular_name,
			'type'          => 'text',
			'description'   => 'Assign ' . $taxonomy->labels->name . ' to this job.',
			'jobfeed_notes' => array(
				'data_type'     => 'string',
				'input_type'    => 'text',
				'default_value' => '',
				'example_value' => $taxonomy->labels->singular_name . ' 1, ' . $taxonomy->labels->singular_name . ' 2',
				'notes'         => 'This is for adding ' . $taxonomy->labels->name . ' to the job. Multiple values can be sent comma separated. The could be a text input to allow the user to enter any job category in manually or a select/checkbox input to select for a list of pre-defined ' . $taxonomy->labels->name . '.',
			),
		);

	}

}

?>

<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">

<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<title>WP Job Manager Feed Integration Information for <?php bloginfo( 'name' ); ?></title>
	<link rel="stylesheet" href="<?php echo esc_url( admin_url( 'css/install.css' ) ); ?>" type="text/css" />
</head>

<body style="max-width: 1000px; margin-top: 40px;">

	<div class="wrapper">

		<a href="https://highrise.digital"><img src="<?php echo esc_url( WPJMBB_LOCATION_URL . '/assets/images/hd-logo.png' ); ?>" alt="Highrise Digital logo image." /></a>

		<p><a class="button" href="https://store.highrise.digital/downloads/wp-job-manager-broadbean-add-on/">Buy a License</a></p>

		<p>This plugin is developed and maintained by <a href="https://highrise.digital">Highrise Digital</a></p>

		<h1><?php esc_html_e( 'WP Job Manager Job Feed Integration Information', 'wp-job-manager-broadbean' ); ?></h1>

		<?php

		// get the status of the readme file.
		$readme_status = wpjmbb_get_readme_view_status();

		// if we should be showing the readme endpoint.
		if ( 1 === $readme_status ) {

			?>

			<p>To provide support for this integration, <a href="https://highrise.digital">Highrise Digital</a> requires a valid license key (available on the plugin settings page when logged into WordPress) to be active. Please provide the license key when requesting support.</p>

			<p>The following information will help the integration team build a feed to your site. It contains information about how the data should be sent, including the format of each of the tags, field or XML nodes as well as the sample XML required to begin a feed build.</p>

			<p>The feed also includes a username and password (the same for all jobs added to this site), which must be sent with the job. This is checked with the username and password stored in the site. These are available on the settings screen from within the WordPress dashboard and security reasons they are not printed here.</p>

			<h2>Posting URL</h2>

			<p>This is the posting URL for adding, editing a deleting jobs.</p>

			<pre style="background-color: #F2F2F2; padding: 16px; font-size: 110%;"><?php echo home_url( '/?wpjmbb=' . apply_filters( 'wpjmbb_integration_service_name', 'broadbean' ) ); ?></pre>

			<h2>Job Fields Information</h2>

			<p>The information below outlines the fields each job has available, including the fields XML node, data type, the input type that should be used to add the data to a job and some notes, default values and example values for each field.</p>

			<?php

			// loop through each of the job fields.
			foreach ( $fields as $field_key => $field_value ) {

				// ignore the "filled" field.
				if ( '_filled' === $field_key ) {
					continue;
				}

				// remove the underscrore from the first part of the key.
				$bb_field = ltrim( $field_key, '_' );
				
				// change any dashes for underscore.
				$bb_field = str_replace( '-', '_', $bb_field );

				?>

				<div class="field" style="margin-bottom: 16px;">

					<table style="width: 100%; border: 1px solid black; border-collapse: collapse; border-top: none;">
						<thead>
							<tr>
								<th></th>
								<th></th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td style="width: 20%; border: 1px solid black; padding: 8px;">Field Label</td>
								<td style="width: 80%; border: 1px solid black; padding: 5px;"><?php echo esc_html( $field_value['label'] ); ?></td>
							</tr>
							<tr>
								<td style="width: 20%; border: 1px solid black; padding: 8px;">XML Tag</td>
								<td style="width: 80%; border: 1px solid black; padding: 5px;">&lt<?php echo esc_html( $bb_field ); ?>&gt</td>
							</tr>

							<?php

							// if this field has a jobfeed notes key.
							if ( ! empty( $field_value['jobfeed_notes'] ) ) {

								?>

								<tr>
									<td style="width: 20%; border: 1px solid black; padding: 8px;">Data Type</td>
									<td style="width: 80%; border: 1px solid black; padding: 5px;"><?php echo esc_html( $field_value['jobfeed_notes']['data_type'] ); ?></td>
								</tr>
								<tr>
									<td style="width: 20%; border: 1px solid black; padding: 8px;">Input Type</td>
									<td style="width: 80%; border: 1px solid black; padding: 5px;"><?php echo esc_html( $field_value['jobfeed_notes']['input_type'] ); ?></td>
								</tr>
								<tr>
									<td style="width: 20%; border: 1px solid black; padding: 8px;">Default Value</td>
									<td style="width: 80%; border: 1px solid black; padding: 5px;"><?php echo esc_html( $field_value['jobfeed_notes']['default_value'] ); ?></td>
								</tr>
								<tr>
									<td style="width: 20%; border: 1px solid black; padding: 8px;">Example Value</td>
									<td style="width: 80%; border: 1px solid black; padding: 5px;"><?php echo esc_html( $field_value['jobfeed_notes']['example_value'] ); ?></td>
								</tr>
								<tr>
									<td style="width: 20%; border: 1px solid black; padding: 8px;">Notes</td>
									<td style="width: 80%; border: 1px solid black; padding: 5px;"><?php echo wp_kses_post( $field_value['jobfeed_notes']['notes'] ); ?></td>
								</tr>

								<?php

							}

							?>

						</tbody>
					</table>

				</div><!-- // field -->

				<?php

			} // End foreach().

			?>

			<h2>Sample XML</h2>

			<p>The following sample XML files can be used in order to get an idea of the example XML that should be sent to the posting URL. Please note the usernames and password fields are blank. These values should be retreived from the settings screen.</p>

			<h3>Adding or Updating a Job</h3>

			<p>The add command can be used to either add or (edit) update a job. If the job reference sent, does not exist on an existing job, a new job is added. If a job does exist with this reference, that job is updated.</p>

			<div class="sample-xml" style="background-color: #F2F2F2; padding: 16px;">
					
				<?php

				echo '<pre style="font-size: 110%;">', htmlentities( '<?xml version="1.0" encoding="UTF-8"?>' ), '</pre>';

				$w = new XMLWriter;
				$w->openMemory();
				$w->setIndent(true);
				$w->startElement('job');
				
				/* add node for username and password & command */
				$w->writeElement( 'command', 'add' );
				$w->writeElement( 'username', '' );
				$w->writeElement( 'password', '' );

				// loop through our job fields.
				foreach ( $fields as $field_key => $field_value ) {

					// ignore the "filled" field.
					if ( '_filled' === $field_key ) {
						continue;
					}

					// remove the underscrore from the first part of the key.
					$bb_field = ltrim( $field_key, '_' );
					
					// change any dashes for underscore.
					$bb_field = str_replace( '-', '_', $bb_field );

					$w->writeElement( $bb_field, $field_value['jobfeed_notes']['example_value'] );

				}

				$w->endElement();
				$output = $w->outputMemory();
				echo '<pre style="font-size: 110%;">', htmlentities( $output ), '</pre>';

				?>

			</div>

			<h3>Deleting a Job</h3>

			<p>The delete command can be used to delete a job before its expiring date. It requires the job reference of the job you want to delete in the XML along with the delete command and the username and password.</p>

			<div class="sample-xml" style="background-color: #F2F2F2; padding: 16px;">

				<?php

				echo '<pre style="font-size: 110%;">', htmlentities( '<?xml version="1.0" encoding="UTF-8"?>' ), '</pre>';

				$w = new XMLWriter;
				$w->openMemory();
				$w->setIndent(true);
				$w->startElement('job');
				
				/* add node for username and password & command */
				$w->writeElement( 'command', 'delete' );
				$w->writeElement( 'username', '' );
				$w->writeElement( 'password', '' );
				$w->writeElement( 'job_reference', 'REF-1234' );

				$w->endElement();
				$output = $w->outputMemory();
				echo '<pre style="font-size: 110%;">', htmlentities( $output ), '</pre>';

				?>

			</div>

			<?php

		} else {

			?>

			<p>This readme file is current set to not display. To change this visit your sites WP Job Manager settings page and activate the readme there.</p>

			<?php

		}

		?>

	</div><!-- // wrapper -->

</body>
</html>

<?php
