<?php
/**
 * Registers endpoints for use in the plugin.
 *
 * @package WP_Job_Manager_Broadbean
 */

/**
 * Adds a new endpoint in WordPress for hd-job-integrator.
 */
function wpjmbb_add_endpoints() {

	add_rewrite_endpoint(
		'wpjmbb/readme', // this is the endpoint part of the url.
		EP_ROOT,
		'wpjmbb_readme' // this is var that is set when the endpoint is reached.
	);

	// add the taxonomy terms endpoint to return all the terms for a given taxonomy.
	add_rewrite_endpoint(
		'wpjmbb/field-listings', // this is the endpoint part of the url.
		EP_ROOT,
		'wpjmbb_field_listings' // this is var that is set when the endpoint is reached.
	);

}

add_action( 'init', 'wpjmbb_add_endpoints' );

/**
 * Makes sure that the endpoint variable has a true value when set.
 *
 * @param array $vars The current query vars.
 */
function wpjmbb_fix_endpoint_requests( $vars ) {

	// if the readme endpoint is set.
	if ( isset( $vars['wpjmbb_readme'] ) ) {

		// make sure the value is true.
		$vars['wpjmbb_readme'] = true;

	} else {

		unset( $vars['wpjmbb_readme'] );

	}

	// if the endpoint var is set.
	if ( isset( $vars['wpjmbb_field_listings'] ) ) {

		// make sure it is always equal to true.
		$vars['wpjmbb_field_listings'] = true;

	} else { // if the endpoint var is not set.

		// make sure it always is unset completely and not empty.
		unset( $vars['wpjmbb_field_listings'] );

	}

	// return the modified vars.
	return $vars;

}

add_filter( 'request', 'wpjmbb_fix_endpoint_requests' );

/**
 * When the endpoint for the game is visited load the correct template file.
 *
 * @param  string $template The current template WordPress will load from the theme.
 * @return string           The modified tempalte string WordPress will load.
 */
function wpjmbb_output_readme( $template ) {

	global $wp_query;

	// check the endpoint var is set to true - if not pass back original template.
	if ( true !== get_query_var( 'wpjmbb_readme' ) ) {
		return $template;
	}

	// check for a app push template file in the theme folder.
	if ( file_exists( STYLESHEETPATH . '/job_manager/' . sanitize_title( strtolower( apply_filters( 'wpjmbb_integration_service_name', 'broadbean' ) ) ) . '/wpjmbb-readme.php' ) ) {

		// load the file from the theme folder.
		require_once( STYLESHEETPATH . '/job_manager/' . sanitize_title( strtolower( apply_filters( 'wpjmbb_integration_service_name', 'broadbean' ) ) ) . '/wpjmbb-readme.php' );

	} else { // file not in theme folder.

		// load the timetables file from the plugin.
		require_once( WPJMBB_LOCATION . '/inc/templates/wpjmbb-readme.php' );

	}

	exit;

}

add_action( 'template_include', 'wpjmbb_output_readme' );

/**
 * When the endpoint for jobfeed is visited load the correct template file.
 *
 * @param  string $template The current template WordPress will load from the theme.
 * @return string           The modified tempalte string WordPress will load.
 */
function wpjmbb_load_field_listings_endpoint_template( $template ) {

	// check the endpoint var is set to true - if not pass back original template.
	if ( true !== get_query_var( 'wpjmbb_field_listings' ) ) {
		return $template;
	}

	// check for a app push template file in the theme folder.
	if ( file_exists( STYLESHEETPATH . '/job_manager/field-listings.php' ) ) {

		// load the file from the theme folder.
		return STYLESHEETPATH . '/job_manager/field-listings.php';

	} else { // file not in theme folder.

		// load the timetables file from the plugin.
		return apply_filters(
			'wpjmbb_field_listing_endpoint_template_location',
			WPJMBB_LOCATION . '/inc/templates/field-listings.php',
			$template
		);

	}

	return $template;

}

add_filter( 'template_include', 'wpjmbb_load_field_listings_endpoint_template' );
