<?php
/**
 * function wpjmbb_activate_license()
 *
 * activates a users license once enter into the settings screen
 * the user must click the activate button to make this work
 */
function wpjmbb_activate_license() {

	// listen for our activate button to be clicked
	if( isset( $_POST[ 'wpjmbb_license_activate' ] ) ) {

		// run a quick security check
	 	if( ! check_admin_referer( 'wpjmbb_license_nonce', 'wpjmbb_license_nonce' ) )  {
		 	return; // get out if we didn't click the Activate button
	 	}

		// set the transient. 1680049743
		set_transient( 'wpjmbb_license_key_status', true, 0 );

	}

}

add_action( 'admin_init', 'wpjmbb_activate_license' );

/**
 * function wpjmbb_deactivate_license()
 *
 * activates a users license once enter into the settings screen
 * the user must click the activate button to make this work
 */
function wpjmbb_deactivate_license() {

	// listen for our activate button to be clicked
	if( isset( $_POST[ 'wpjmbb_license_deactivate' ] ) ) {

		// run a quick security check
	 	if( ! check_admin_referer( 'wpjmbb_license_nonce', 'wpjmbb_license_nonce' ) )  {
		 	return; // get out if we didn't click the Activate button
	 	}

        set_transient( 'wpjmbb_license_key_status', 'invalid', 12 * HOUR_IN_SECONDS ); // 12 * HOUR_IN_SECONDS
    }
}

add_action( 'admin_init', 'wpjmbb_deactivate_license' );
