<?php
/**
 * function wpjmbb_job_reference_field()
 *
 * adds a job reference field to the wp job manager plugin and
 * also to the add-on to add this to the feed.
 *
 * @param	array	$fields are the current job fields
 * @return	array	$fields is the modified fields
 */
function wpjmbb_job_reference_field( $fields ) {
	
	/* add the job reference field */
	$fields[ '_job_reference' ] = array(
		'label'			=> 'Job Reference',
		'placeholder'   => '',
		'description'	=> 'Unique to each job, the job reference is used for the edit/delete commands.',
		'type'			=> 'text'
	);
	
	return $fields;
	
}

add_filter( 'wpjmbb_fields', 'wpjmbb_job_reference_field' );
add_filter( 'job_manager_job_listing_data_fields', 'wpjmbb_job_reference_field' );

/**
 * function wpjmbb_job_company_logo_field()
 *
 * adds a company logo field to the wp job manager plugin and
 * also to the add-on to add this to the feed.
 *
 * @param	array	$fields are the current job fields
 * @return	array	$fields is the modified fields
 */
function wpjmbb_job_company_logo_field( $fields ) {
	
	/* add the job reference field */
	$fields[ '_company_logo' ] = array(
		'label'			=> 'Company Logo',
		'placeholder'   => '',
		'description'	=> 'URL to the company logo.',
		'type'			=> 'file'
	);
	
	return $fields;
	
}

add_filter( 'wpjmbb_fields', 'wpjmbb_job_company_logo_field' );

/**
 * Adds the instructional information to the fields array used in the data endpoint.
 *
 * @param  array $fields An array of fields.
 * @return array         A modified array of fields.
 */
function wpjmbb_add_jobfeed_instructional_data( $fields ) {

	// add instructional information to each field, starting with application field, first checking it is present.
	if ( isset( $fields['_application'] ) ) {

		$fields['_application']['jobfeed_notes'] = array(
			'data_type'     => 'string',
			'input_type'    => 'auto',
			'default_value' => '',
			'example_value' => 'bob.12345.123@smith.aplitrak.com',
			'notes'         => 'This is the applicant tracking email address.'
		);

	}

	// if we have a job location field.
	if ( isset( $fields['_job_location'] ) ) {

		$fields['_job_location']['jobfeed_notes'] = array(
			'data_type'     => 'string',
			'input_type'    => 'text',
			'default_value' => '',
			'example_value' => 'The Yard, North Lane, Sandate, CT20 3AS',
			'notes'         => 'This is a location to be added to the job. It is the search string used to find the place in Google maps. Therefore it could be a broad placename e.g. London or a more specific address.'
		);

	}

	// if we have a company name field.
	if ( isset( $fields['_company_name'] ) ) {

		$fields['_company_name']['jobfeed_notes'] = array(
			'data_type'     => 'string',
			'input_type'    => 'text',
			'default_value' => '',
			'example_value' => 'ABC Financial Services',
			'notes'         => 'This is the name of the company for which this job is about.'
		);

	}

	// if we have a company website field.
	if ( isset( $fields['_company_website'] ) ) {

		$fields['_company_website']['jobfeed_notes'] = array(
			'data_type'     => 'string',
			'input_type'    => 'url',
			'default_value' => '',
			'example_value' => 'https://abcfinancialservices.test',
			'notes'         => 'This is the URL of the company for which the job is about. Should be a valid URL format.'
		);

	}

	// if we have a company tagline field.
	if ( isset( $fields['_company_tagline'] ) ) {

		$fields['_company_tagline']['jobfeed_notes'] = array(
			'data_type'     => 'string',
			'input_type'    => 'text',
			'default_value' => '',
			'example_value' => 'Providing financial services to individuals and business on the south east.',
			'notes'         => 'The tagline about the company for which this job is about.'
		);

	}

	// if we have a company twitter field.
	if ( isset( $fields['_company_twitter'] ) ) {

		$fields['_company_twitter']['jobfeed_notes'] = array(
			'data_type'     => 'string',
			'input_type'    => 'text',
			'default_value' => '',
			'example_value' => '@thehighriseteam',
			'notes'         => 'The Twitter handle the company for which this job is about. This should include the @ symbol.'
		);

	}

	// if we have a company video field.
	if ( isset( $fields['_company_video'] ) ) {

		$fields['_company_video']['jobfeed_notes'] = array(
			'data_type'     => 'string',
			'input_type'    => 'url',
			'default_value' => '',
			'example_value' => 'https://www.youtube.com/watch?v=U37Hd0gsHus',
			'notes'         => 'The URL to a video of the company for which this job is about. This could the URL to a video on social video sharing sites such as Youtube or the direct URL to a video file.'
		);

	}

	// if we have a company logo field.
	if ( isset( $fields['_company_logo'] ) ) {

		$fields['_company_logo']['jobfeed_notes'] = array(
			'data_type'     => 'string',
			'input_type'    => 'url',
			'default_value' => '',
			'example_value' => 'https://highrise.digital/cms/wp-admin/images/wordpress-logo.png',
			'notes'         => 'The URL to a logo image or the company this job is for. Any web image format is fine.'
		);

	}

	// if we have a featured field.
	if ( isset( $fields['_featured'] ) ) {

		$fields['_featured']['jobfeed_notes'] = array(
			'data_type'     => 'boolean',
			'input_type'    => 'checkbox',
			'default_value' => '0',
			'example_value' => '1',
			'notes'         => 'This is whether to mark the job as featured with WordPress. Send a value of 1 for featured and 0 for not featured.'
		);

	}

	// if we have a job expires field.
	if ( isset( $fields['_job_expires'] ) ) {

		$fields['_job_expires']['jobfeed_notes'] = array(
			'data_type'     => 'date',
			'input_type'    => 'date',
			'default_value' => '',
			'example_value' => '2019-12-01',
			'notes'         => 'This is the date this job should expire, sent in the YYYY-MM-DD format.'
		);

	}

	// if we have a job author field.
	if ( isset( $fields['_job_author'] ) ) {

		$fields['_job_author']['jobfeed_notes'] = array(
			'data_type'     => 'mixed',
			'input_type'    => 'text',
			'default_value' => '0',
			'example_value' => '21 or hello@email.com',
			'notes'         => 'This is either the user ID or the email address of the WordPress user who should be the author of the job.'
		);

	}

	// if we have a job reference field.
	if ( isset( $fields['_job_reference'] ) ) {

		$fields['_job_reference']['jobfeed_notes'] = array(
			'data_type'     => 'string',
			'input_type'    => 'text',
			'default_value' => '',
			'example_value' => 'REF-1234',
			'notes'         => 'This should be a unique job reference for this job. If a reference is not added manually, a unique reference should be auto generated.'
		);

	}

	return $fields;

}

add_filter( 'wpjmbb_fields', 'wpjmbb_add_jobfeed_instructional_data' );
