<?php
/**
 * Parcelforce irelandexpress rates.
 *
 * @package WC_RoyalMail/Rate
 */

/**
 * Rates for Parcelforce irelandexpress.
 *
 * Based on https://www.parcelforce.com/sites/default/files/4686_RM_PF_RETAIL%20TARIFF%20GUIDE_ENG_AW.PDF.
 */
class RoyalMail_Rate_Parcelforce_Irelandexpress extends Parcelforce_Rate {
	/**
	 * ID/Name of rate.
	 *
	 * @var string
	 */
	protected $rate_id = 'parcelforce_irelandexpress';

	/**
	 * Pricing bands.
	 *
	 * Key is zone and value is an array where key is weight (up to) in gram
	 * and value is the price (in penny).
	 *
	 * @var array
	 */
	protected $bands = array(
		'2019' => array(
			'5' => array(
				500   => 1668,
				1000  => 1668,
				1500  => 1668,
				2000  => 1668,
				2500  => 1770,
				3000  => 1770,
				3500  => 1770,
				4000  => 1770,
				4500  => 1770,
				5000  => 1770,
				5500  => 2118,
				6000  => 2118,
				6500  => 2118,
				7000  => 2118,
				7500  => 2118,
				8000  => 2118,
				8500  => 2118,
				9000  => 2118,
				9500  => 2118,
				10000 => 2118,
				15000 => 2764,
				20000 => 3301,
				25000 => 4414,
				30000 => 4828,
			),
		),
	);

	/**
	 * Maximum inclusive compensation.
	 *
	 * @version 2.5.3
	 * @since 2.5.3
	 *
	 * @var int
	 */
	protected $maximum_inclusive_compensation = 200;

	/**
	 * Maximum total cover.
	 *
	 * @version 2.5.3
	 * @since 2.5.3
	 *
	 * @var int
	 */
	protected $maximum_total_cover = 2500;
}
