<?php
/**
 * Parcelforce globalvalue rates.
 *
 * @package WC_RoyalMail/Rate
 */

/**
 * Rates for Parcelforce globalvalue.
 *
 * Based on https://www.parcelforce.com/sites/default/files/4686_RM_PF_RETAIL%20TARIFF%20GUIDE_ENG_AW.PDF
 * and 'Prices' tab on https://www.parcelforce.com/sending-parcel/international-parcel-delivery/global-value.
 */
class RoyalMail_Rate_Parcelforce_Globalvalue extends Parcelforce_Rate {
	/**
	 * ID/Name of rate.
	 *
	 * @var string
	 */
	protected $rate_id = 'parcelforce_globalvalue';

	/**
	 * Pricing bands.
	 *
	 * Key is zone and value is an array where key is weight (up to) in gram
	 * and value is the price (in penny).
	 *
	 * @var array
	 */
	protected $bands = array(
		'2019' => array(
			'4' => array(
				500   => 978,
				1000  => 1104,
				1500  => 1230,
				2000  => 1356,
				2500  => 1452,
				3000  => 1548,
				3500  => 1644,
				4000  => 1740,
				4500  => 1836,
				5000  => 1932,
				5500  => 1974,
				6000  => 2016,
				6500  => 2058,
				7000  => 2100,
				7500  => 2142,
				8000  => 2184,
				8500  => 2226,
				9000  => 2268,
				9500  => 2310,
				10000 => 2352,
				15000 => 2652,
				20000 => 2952,
				25000 => 3252,
				30000 => 3552,
			),
			'5' => array(
				500   => 1686,
				1000  => 1932,
				1500  => 2178,
				2000  => 2424,
				2500  => 2670,
				3000  => 2916,
				3500  => 3162,
				4000  => 3408,
				4500  => 3654,
				5000  => 3900,
				5500  => 4008,
				6000  => 4116,
				6500  => 4224,
				7000  => 4332,
				7500  => 4440,
				8000  => 4548,
				8500  => 4656,
				9000  => 4764,
				9500  => 4872,
				10000 => 4980,
				15000 => 5700,
				20000 => 6420,
				25000 => 7140,
				30000 => 7860,
			),
			'6' => array(
				500   => 2268,
				1000  => 2502,
				1500  => 2736,
				2000  => 2970,
				2500  => 3192,
				3000  => 3414,
				3500  => 3636,
				4000  => 3858,
				4500  => 4080,
				5000  => 4302,
				5500  => 4404,
				6000  => 4506,
				6500  => 4608,
				7000  => 4710,
				7500  => 4812,
				8000  => 4914,
				8500  => 5016,
				9000  => 5118,
				9500  => 5220,
				10000 => 5322,
				15000 => 6042,
				20000 => 6762,
				25000 => 7482,
				30000 => 8202,
			),
			'7' => array(
				500   => 2058,
				1000  => 2124,
				1500  => 2190,
				2000  => 2256,
				2500  => 2514,
				3000  => 2772,
				3500  => 3030,
				4000  => 3288,
				4500  => 3546,
				5000  => 3804,
				5500  => 4008,
				6000  => 4212,
				6500  => 4416,
				7000  => 4620,
				7500  => 4824,
				8000  => 5028,
				8500  => 5232,
				9000  => 5436,
				9500  => 5640,
				10000 => 5844,
				15000 => 6444,
				20000 => 7104,
				25000 => 7764,
				30000 => 8424,
			),
			'8' => array(
				500   => 2592,
				1000  => 2826,
				1500  => 3060,
				2000  => 3294,
				2500  => 3498,
				3000  => 3702,
				3500  => 3906,
				4000  => 4110,
				4500  => 4314,
				5000  => 4518,
				5500  => 4680,
				6000  => 4842,
				6500  => 5004,
				7000  => 5166,
				7500  => 5328,
				8000  => 5490,
				8500  => 5652,
				9000  => 5814,
				9500  => 5976,
				10000 => 6138,
				15000 => 6858,
				20000 => 7578,
				25000 => 8298,
				30000 => 9018,
			),
			'9' => array(
				500   => 2712,
				1000  => 3042,
				1500  => 3372,
				2000  => 3702,
				2500  => 3972,
				3000  => 4242,
				3500  => 4512,
				4000  => 4782,
				4500  => 5052,
				5000  => 5322,
				5500  => 5550,
				6000  => 5778,
				6500  => 6006,
				7000  => 6234,
				7500  => 6462,
				8000  => 6690,
				8500  => 6918,
				9000  => 7146,
				9500  => 7374,
				10000 => 7602,
				15000 => 8862,
				20000 => 10122,
				25000 => 11382,
				30000 => 12642,
			),
			'10' => array(
				500   => 2770,
				1000  => 3025,
				1500  => 3280,
				2000  => 3535,
				2500  => 4180,
				3000  => 4825,
				3500  => 5470,
				4000  => 6115,
				4500  => 6760,
				5000  => 7405,
				5500  => 7775,
				6000  => 8145,
				6500  => 8515,
				7000  => 8885,
				7500  => 9255,
				8000  => 9625,
				8500  => 9995,
				9000  => 10365,
				9500  => 10735,
				10000 => 11105,
				15000 => 13505,
				20000 => 15855,
				25000 => 18205,
				30000 => 20555,
			),
			'11' => array(
				500   => 3455,
				1000  => 4080,
				1500  => 4705,
				2000  => 5330,
				2500  => 5940,
				3000  => 6550,
				3500  => 7160,
				4000  => 7770,
				4500  => 8380,
				5000  => 8990,
				5500  => 9445,
				6000  => 9900,
				6500  => 10355,
				7000  => 10810,
				7500  => 11265,
				8000  => 11720,
				8500  => 12175,
				9000  => 12630,
				9500  => 13085,
				10000 => 13540,
				15000 => 16890,
				20000 => 20240,
				25000 => 23590,
				30000 => 26940,
			),
			'12' => array(
				500   => 3575,
				1000  => 4290,
				1500  => 5005,
				2000  => 5720,
				2500  => 6435,
				3000  => 7150,
				3500  => 7865,
				4000  => 8580,
				4500  => 9295,
				5000  => 10010,
				5500  => 10660,
				6000  => 11310,
				6500  => 11960,
				7000  => 12610,
				7500  => 13260,
				8000  => 13910,
				8500  => 14560,
				9000  => 15210,
				9500  => 15860,
				10000 => 16510,
				15000 => 20960,
				20000 => 25460,
				25000 => 29960,
				30000 => 34460,
			),
		),
	);

	/**
	 * Maximum inclusive compensation.
	 *
	 * @version 2.5.3
	 * @since 2.5.3
	 *
	 * @var int
	 */
	protected $maximum_inclusive_compensation = 100;

	/**
	 * Maximum total cover.
	 *
	 * @version 2.5.3
	 * @since 2.5.3
	 *
	 * @var int
	 */
	protected $maximum_total_cover = 500;
}
