<?php
/**
 * Parcelforce globaleconomy rates.
 *
 * @package WC_RoyalMail/Rate
 */

/**
 * Rates for Parcelforce globaleconomy.
 *
 * Based on https://www.parcelforce.com/sites/default/files/4686_RM_PF_RETAIL%20TARIFF%20GUIDE_ENG_AW.PDF
 * and 'Prices' tab on https://www.parcelforce.com/sending-parcel/international-parcel-delivery/global-economy.
 */
class RoyalMail_Rate_Parcelforce_Globaleconomy extends Parcelforce_Rate {
	/**
	 * ID/Name of rate.
	 *
	 * @var string
	 */
	protected $rate_id = 'parcelforce_globaleconomy';

	/**
	 * Pricing bands.
	 *
	 * Key is zone and value is an array where key is weight (up to) in gram
	 * and value is the price (in penny).
	 *
	 * @var array
	 */
	protected $bands = array(
		'2019' => array(
			'10' => array(
				500   => 2470,
				1000  => 2725,
				1500  => 2980,
				2000  => 3235,
				2500  => 3880,
				3000  => 4525,
				3500  => 5170,
				4000  => 5815,
				4500  => 6460,
				5000  => 7105,
				5500  => 7475,
				6000  => 7845,
				6500  => 8215,
				7000  => 8585,
				7500  => 8955,
				8000  => 9325,
				8500  => 9695,
				9000  => 10065,
				9500  => 10435,
				10000 => 10805,
				15000 => 13205,
				20000 => 15555,
				25000 => 17905,
				30000 => 20255,
			),
			'11' => array(
				500   => 3185,
				1000  => 3810,
				1500  => 4435,
				2000  => 5060,
				2500  => 5670,
				3000  => 6280,
				3500  => 6890,
				4000  => 7500,
				4500  => 8110,
				5000  => 8720,
				5500  => 9175,
				6000  => 9630,
				6500  => 10085,
				7000  => 10540,
				7500  => 10995,
				8000  => 11450,
				8500  => 11905,
				9000  => 12360,
				9500  => 12815,
				10000 => 13270,
				15000 => 16620,
				20000 => 19970,
				25000 => 23320,
				30000 => 26670,
			),
			'12' => array(
				500   => 3335,
				1000  => 4050,
				1500  => 4765,
				2000  => 5480,
				2500  => 6195,
				3000  => 6910,
				3500  => 7625,
				4000  => 8340,
				4500  => 9055,
				5000  => 9770,
				5500  => 10420,
				6000  => 11070,
				6500  => 11720,
				7000  => 12370,
				7500  => 13020,
				8000  => 13670,
				8500  => 14320,
				9000  => 14970,
				9500  => 15620,
				10000 => 16270,
				15000 => 20720,
				20000 => 25220,
				25000 => 29720,
				30000 => 34220,
			),
		),
	);
}
