<?php
/**
 * Parcelforce globalpriority rates.
 *
 * @package WC_RoyalMail/Rate
 */

/**
 * Rates for Parcelforce globalpriority.
 *
 * Based on https://www.parcelforce.com/sites/default/files/4686_RM_PF_RETAIL%20TARIFF%20GUIDE_ENG_AW.PDF
 * and 'Prices' tab on https://www.parcelforce.com/sending-parcel/international-parcel-delivery/global-priority.
 */
class RoyalMail_Rate_Parcelforce_Globalpriority extends Parcelforce_Rate {
	/**
	 * ID/Name of rate.
	 *
	 * @var string
	 */
	protected $rate_id = 'parcelforce_globalpriority';

	/**
	 * Pricing bands.
	 *
	 * Key is zone and value is an array where key is weight (up to) in gram
	 * and value is the price (in penny).
	 *
	 * @var array
	 */
	protected $bands = array(
		'2019' => array(
			'4' => array(
				500   => 3000,
				1000  => 3132,
				1500  => 3264,
				2000  => 3396,
				2500  => 3498,
				3000  => 3600,
				3500  => 3702,
				4000  => 3804,
				4500  => 3906,
				5000  => 4008,
				5500  => 4050,
				6000  => 4092,
				6500  => 4134,
				7000  => 4176,
				7500  => 4218,
				8000  => 4260,
				8500  => 4302,
				9000  => 4344,
				9500  => 4386,
				10000 => 4428,
				15000 => 4908,
				20000 => 5208,
				25000 => 5508,
				30000 => 5808,
			),
			'5' => array(
				500   => 3420,
				1000  => 3654,
				1500  => 3888,
				2000  => 4122,
				2500  => 4350,
				3000  => 4578,
				3500  => 4806,
				4000  => 5034,
				4500  => 5262,
				5000  => 5490,
				5500  => 5592,
				6000  => 5694,
				6500  => 5796,
				7000  => 5898,
				7500  => 6000,
				8000  => 6102,
				8500  => 6204,
				9000  => 6306,
				9500  => 6408,
				10000 => 6510,
				15000 => 7320,
				20000 => 8100,
				25000 => 8880,
				30000 => 9660,
			),
			'6' => array(
				500   => 3078,
				1000  => 3336,
				1500  => 3594,
				2000  => 3852,
				2500  => 4110,
				3000  => 4368,
				3500  => 4626,
				4000  => 4884,
				4500  => 5142,
				5000  => 5400,
				5500  => 5514,
				6000  => 5628,
				6500  => 5742,
				7000  => 5856,
				7500  => 5970,
				8000  => 6084,
				8500  => 6198,
				9000  => 6312,
				9500  => 6426,
				10000 => 6540,
				15000 => 8010,
				20000 => 8730,
				25000 => 9450,
				30000 => 10170,
			),
			'7' => array(
				500   => 3582,
				1000  => 3780,
				1500  => 3978,
				2000  => 4176,
				2500  => 4392,
				3000  => 4608,
				3500  => 4824,
				4000  => 5040,
				4500  => 5256,
				5000  => 5472,
				5500  => 5628,
				6000  => 5784,
				6500  => 5940,
				7000  => 6096,
				7500  => 6252,
				8000  => 6408,
				8500  => 6564,
				9000  => 6720,
				9500  => 6876,
				10000 => 7032,
				15000 => 8532,
				20000 => 9192,
				25000 => 9852,
				30000 => 10512,
			),
			'8' => array(
				500   => 3894,
				1000  => 4110,
				1500  => 4326,
				2000  => 4542,
				2500  => 4776,
				3000  => 5010,
				3500  => 5244,
				4000  => 5478,
				4500  => 5712,
				5000  => 5946,
				5500  => 6138,
				6000  => 6330,
				6500  => 6522,
				7000  => 6714,
				7500  => 6906,
				8000  => 7098,
				8500  => 7290,
				9000  => 7482,
				9500  => 7674,
				10000 => 7866,
				15000 => 10086,
				20000 => 10806,
				25000 => 11526,
				30000 => 12246,
			),
			'9' => array(
				500   => 4218,
				1000  => 4542,
				1500  => 4866,
				2000  => 5190,
				2500  => 5466,
				3000  => 5742,
				3500  => 6018,
				4000  => 6294,
				4500  => 6570,
				5000  => 6846,
				5500  => 7080,
				6000  => 7314,
				6500  => 7548,
				7000  => 7782,
				7500  => 8016,
				8000  => 8250,
				8500  => 8484,
				9000  => 8718,
				9500  => 8952,
				10000 => 9186,
				15000 => 10446,
				20000 => 11706,
				25000 => 12966,
				30000 => 14226,
			),
			'10' => array(
				500   => 4480,
				1000  => 4735,
				1500  => 4990,
				2000  => 5245,
				2500  => 5895,
				3000  => 6545,
				3500  => 7195,
				4000  => 7845,
				4500  => 8495,
				5000  => 9145,
				5500  => 9520,
				6000  => 9895,
				6500  => 10270,
				7000  => 10645,
				7500  => 11020,
				8000  => 11395,
				8500  => 11770,
				9000  => 12145,
				9500  => 12520,
				10000 => 12895,
				15000 => 15295,
				20000 => 17695,
				25000 => 20095,
				30000 => 22495,
			),
			'11' => array(
				500   => 4750,
				1000  => 5350,
				1500  => 5950,
				2000  => 6550,
				2500  => 7150,
				3000  => 7750,
				3500  => 8350,
				4000  => 8950,
				4500  => 9550,
				5000  => 10150,
				5500  => 10605,
				6000  => 11060,
				6500  => 11515,
				7000  => 11970,
				7500  => 12425,
				8000  => 12880,
				8500  => 13335,
				9000  => 13790,
				9500  => 14245,
				10000 => 14700,
				15000 => 18150,
				20000 => 21500,
				25000 => 24850,
				30000 => 28200,
			),
			'12' => array(
				500   => 6015,
				1000  => 6710,
				1500  => 7405,
				2000  => 8100,
				2500  => 8790,
				3000  => 9480,
				3500  => 10170,
				4000  => 10860,
				4500  => 11550,
				5000  => 12240,
				5500  => 12860,
				6000  => 13480,
				6500  => 14100,
				7000  => 14720,
				7500  => 15340,
				8000  => 15960,
				8500  => 16580,
				9000  => 17200,
				9500  => 17820,
				10000 => 18440,
				15000 => 22890,
				20000 => 27390,
				25000 => 31890,
				30000 => 36390,
			),
		),
	);

	/**
	 * Maximum inclusive compensation.
	 *
	 * @version 2.5.3
	 * @since 2.5.3
	 *
	 * @var int
	 */
	protected $maximum_inclusive_compensation = 100;

	/**
	 * Maximum total cover.
	 *
	 * @version 2.5.3
	 * @since 2.5.3
	 *
	 * @var int
	 */
	protected $maximum_total_cover = 2500;
}
