<?php
/**
 * Parcelforce globalexpress rates.
 *
 * @package WC_RoyalMail/Rate
 */

/**
 * Rates for Parcelforce globalexpress.
 *
 * Based on https://www.parcelforce.com/sites/default/files/4686_RM_PF_RETAIL%20TARIFF%20GUIDE_ENG_AW.PDF
 * and 'Prices' tab on https://www.parcelforce.com/sending-parcel/international-parcel-delivery/global-express.
 */
class RoyalMail_Rate_Parcelforce_Globalexpress extends Parcelforce_Rate {
	/**
	 * ID/Name of rate.
	 *
	 * @var string
	 */
	protected $rate_id = 'parcelforce_globalexpress';

	/**
	 * Pricing bands.
	 *
	 * Key is zone and value is an array where key is weight (up to) in gram
	 * and value is the price (in penny).
	 *
	 * @var array
	 */
	protected $bands = array(
		'2019' => array(
			'4' => array(
				500   => 5250,
				1000  => 5508,
				1500  => 5766,
				2000  => 6024,
				2500  => 6276,
				3000  => 6528,
				3500  => 6780,
				4000  => 7032,
				4500  => 7284,
				5000  => 7536,
				5500  => 7818,
				6000  => 8100,
				6500  => 8382,
				7000  => 8664,
				7500  => 8946,
				8000  => 9228,
				8500  => 9510,
				9000  => 9792,
				9500  => 10074,
				10000 => 10356,
				15000 => 12516,
				20000 => 14856,
				25000 => 17196,
				30000 => 19536,
			),
			'5' => array(
				500   => 4794,
				1000  => 5046,
				1500  => 5298,
				2000  => 5550,
				2500  => 5922,
				3000  => 6294,
				3500  => 6666,
				4000  => 7038,
				4500  => 7410,
				5000  => 7782,
				5500  => 7956,
				6000  => 8130,
				6500  => 8304,
				7000  => 8478,
				7500  => 8652,
				8000  => 8826,
				8500  => 9000,
				9000  => 9174,
				9500  => 9348,
				10000 => 9522,
				15000 => 11862,
				20000 => 13602,
				25000 => 15342,
				30000 => 17082,
			),
			'6' => array(
				500   => 4350,
				1000  => 4758,
				1500  => 5166,
				2000  => 5574,
				2500  => 5910,
				3000  => 6246,
				3500  => 6582,
				4000  => 6918,
				4500  => 7254,
				5000  => 7590,
				5500  => 7800,
				6000  => 8010,
				6500  => 8220,
				7000  => 8430,
				7500  => 8640,
				8000  => 8850,
				8500  => 9060,
				9000  => 9270,
				9500  => 9480,
				10000 => 9690,
				15000 => 11610,
				20000 => 13350,
				25000 => 15090,
				30000 => 16830,
			),
			'7' => array(
				500   => 4476,
				1000  => 4836,
				1500  => 5196,
				2000  => 5556,
				2500  => 5976,
				3000  => 6396,
				3500  => 6816,
				4000  => 7236,
				4500  => 7656,
				5000  => 8076,
				5500  => 8394,
				6000  => 8712,
				6500  => 9030,
				7000  => 9348,
				7500  => 9666,
				8000  => 9984,
				8500  => 10302,
				9000  => 10620,
				9500  => 10938,
				10000 => 11256,
				15000 => 13716,
				20000 => 15756,
				25000 => 17796,
				30000 => 19836,
			),
			'8' => array(
				500   => 4806,
				1000  => 5190,
				1500  => 5574,
				2000  => 5958,
				2500  => 6270,
				3000  => 6582,
				3500  => 6894,
				4000  => 7206,
				4500  => 7518,
				5000  => 7830,
				5500  => 8142,
				6000  => 8454,
				6500  => 8766,
				7000  => 9078,
				7500  => 9390,
				8000  => 9702,
				8500  => 10014,
				9000  => 10326,
				9500  => 10638,
				10000 => 10950,
				15000 => 14010,
				20000 => 16770,
				25000 => 19530,
				30000 => 22290,
			),
			'9' => array(
				500   => 5250,
				1000  => 5718,
				1500  => 6186,
				2000  => 6654,
				2500  => 7404,
				3000  => 8154,
				3500  => 8904,
				4000  => 9654,
				4500  => 10404,
				5000  => 11154,
				5500  => 11658,
				6000  => 12162,
				6500  => 12666,
				7000  => 13170,
				7500  => 13674,
				8000  => 14178,
				8500  => 14682,
				9000  => 15186,
				9500  => 15690,
				10000 => 16194,
				15000 => 19554,
				20000 => 23274,
				25000 => 26994,
				30000 => 30714,
			),
			'10' => array(
				500   => 5255,
				1000  => 5755,
				1500  => 6255,
				2000  => 6755,
				2500  => 7155,
				3000  => 7555,
				3500  => 7955,
				4000  => 8355,
				4500  => 8755,
				5000  => 9155,
				5500  => 9580,
				6000  => 10005,
				6500  => 10430,
				7000  => 10855,
				7500  => 11280,
				8000  => 11705,
				8500  => 12130,
				9000  => 12555,
				9500  => 12980,
				10000 => 13405,
				15000 => 16655,
				20000 => 19855,
				25000 => 23055,
				30000 => 26255,
			),
			'11' => array(
				500   => 6370,
				1000  => 7030,
				1500  => 7690,
				2000  => 8350,
				2500  => 8925,
				3000  => 9500,
				3500  => 10075,
				4000  => 10650,
				4500  => 11225,
				5000  => 11800,
				5500  => 12270,
				6000  => 12740,
				6500  => 13210,
				7000  => 13680,
				7500  => 14150,
				8000  => 14620,
				8500  => 15090,
				9000  => 15560,
				9500  => 16030,
				10000 => 16500,
				15000 => 21650,
				20000 => 26700,
				25000 => 31750,
				30000 => 36800,
			),
			'12' => array(
				500   => 7270,
				1000  => 8145,
				1500  => 9020,
				2000  => 9895,
				2500  => 10705,
				3000  => 11515,
				3500  => 12325,
				4000  => 13135,
				4500  => 13945,
				5000  => 14755,
				5500  => 15385,
				6000  => 16015,
				6500  => 16645,
				7000  => 17275,
				7500  => 17905,
				8000  => 18535,
				8500  => 19165,
				9000  => 19795,
				9500  => 20425,
				10000 => 21055,
				15000 => 27705,
				20000 => 34455,
				25000 => 41205,
				30000 => 47955,
			),
		),
	);

	/**
	 * Maximum inclusive compensation.
	 *
	 * @version 2.5.3
	 * @since 2.5.3
	 *
	 * @var int
	 */
	protected $maximum_inclusive_compensation = 200;

	/**
	 * Maximum total cover.
	 *
	 * @version 2.5.3
	 * @since 2.5.3
	 *
	 * @var int
	 */
	protected $maximum_total_cover = 2500;
}
