<?php
/**
 * Setting page for Woocommerce Ecards Pro.
 *
 * @author Flipper Code <hello@flippercode.com>
 * @version 2.0.1
 * @package woocommerce-ecards-pro
 */

if ( isset( $_REQUEST['_wpnonce'] ) ) {
	$nonce = sanitize_text_field( wp_unslash( $_REQUEST['_wpnonce'] ) );
	if ( ! wp_verify_nonce( $nonce, 'wpgmp-nonce' ) ) {
		die( 'Cheating...' );
	} else {
		if(isset($response['success']))
		unset($_POST);
		else
		$data = $_POST;
	}
}

$form  = new WPECP_Template();
$form->set_header( esc_html__( 'Active Cron Schedules','woocommerce-ecards-pro' ), $response );

$schedules = wp_get_schedules();
$display = false;
foreach ( $schedules as $name => $sdata ) {
	if($name == 'deliver_woo_ecards') {
	$data_schedules[] = array($name, $sdata['interval'], $sdata['display']);	
	$display= true;
	}
}

if($display) {
$form->add_element( 'table', 'cron_view_action', array(
			'id' => 'cron_view_action',
			'heading' =>array('Action Name','Interval', 'Display'),
			'data' => $data_schedules,
			'before' => '<div class="fc-12">',
			'after' => '</div>',

));
} else{ 
	$form->add_element( 'message', 'cron_not_found', array(
			'id' => 'cron_not_found',
			'class'=> 'fc-msg fc-danger',
			'value' => esc_html__('The cron job action registered for this plugin has been de-registered somehow due to conflict with some other theme/plugin. Please re-activate this(Woocommerce Reminder Pro) plugin & the cron job issue for not sending ecards will be fixed automatically.' , 'woocommerce-ecards-pro'),
			'before' => '<div class="fc-12">',
			'after' => '</div>',

));
}

$form->add_element( 'group', 'display_cron_email', array(
			'value' => esc_html__( 'Test Email', 'woocommerce-ecards-pro' ),
			'before' => '<div class="fc-12">',
			'after' => '</div>',

));

$admin_email = get_bloginfo('admin_email');
$form->add_element( 'text', 'plugin_email_to', array(
			'lable' => esc_html__( 'Recipient Email', 'woocommerce-ecards-pro' ),
			'value' => isset( $data['plugin_email_to'] ) ? $data['plugin_email_to'] : $admin_email,
			'class' => 'form-control',
			'before' => '<div class="fc-6" >',
			'after' => '</div>',
			'required' => true,
			'default_value' => $admin_email,
			'desc' => esc_html__('Recipient Email Address Field ' , 'woocommerce-ecards-pro')
));

$form->add_element( 'text', 'plugin_email_subject', array(
			'lable' => esc_html__( 'Email Subject', 'woocommerce-ecards-pro' ),
			'value' => isset( $data['plugin_email_subject'] ) ? $data['plugin_email_subject'] : '',
			'class' => 'form-control',
			'before' => '<div class="fc-6" >',
			'after' => '</div>',
			'required' => true,
			'desc' => esc_html__('Email Subject Text Field' , 'woocommerce-ecards-pro')
));

$form->add_element(
	'textarea', 'plugin_email_message', array(
	'lable' => esc_html__( 'Message', 'woocommerce-ecards-pro' ),
	'value' => isset( $data['plugin_email_message'] ) ? $data['plugin_email_message'] : '',
	'id' => 'email_message',
	'placeholder' => '',
	'required' => true,
	'desc' => esc_html__( 'Email Message Text Field.', 'woocommerce-ecards-pro' ),
	)
);

$form->add_element(
	'submit', 'plugin_test_email_submit', array(
		'value' => esc_html__( 'Send Email ', 'woocommerce-ecards-pro' ),
	)
);

$form->add_element( 'group', 'reset_plugin_settings', array(
	'value' => esc_html__( 'Reset Plugin Settings', 'woocommerce-ecards-pro' ),
	'before' => '<div class="fc-12">',
	'after' => '</div>',

));

$form->add_element(
	'message', 'reset_plugin_message', array(
		'value' => esc_html__( 'Type "YES" & click on "Reset" button to restore the plugin\'s default settings. All customizations made to plugin\'s settings page will be lost & plugin will be reset.', 'woocommerce-ecards-pro' ),
		'class' => 'fc-msg fc-success',
		'before' => '<div class="fc-12">',
		'after' => '</div>',
	)
);

$form->add_element(
	'text', 'plugin_install_fresh_settings', array(
		'label'  => esc_html__( 'Verify Action', 'woocommerce-ecards-pro' ),
		'value' => isset( $data['plugin_install_fresh_settings'] ) ? $data['plugin_install_fresh_settings'] : '',
		'class'  => 'form-control',
		'desc'   => esc_html__( 'Type "YES" and click on button below to install plugin\'s default settings again. Only reset when you are in need to reset plugin completely.', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-5">',
		'after'  => '</div>',
	)
);


$form->add_element(
	'submit', 'plugin_fresh_install_submit', array(
		'value' => esc_html__( 'Reset','woocommerce-ecards-pro' ),
	)
);

$form->add_element(
	'hidden', 'operation', array(
		'value' => 'save',
	)
);


$form->render();
