<?php
/**
 * Class: ECP_Model_Tools
 *
 * @author Flipper Code <hello@flippercode.com>
 * @version 2.0.1
 * @package woocommerce-ecards-pro
 */

if ( ! class_exists( 'ECP_Model_Tools' ) ) {

	/**
	 * Setting model for Plugin Options.
	 *
	 * @package age-gate-pro
	 * @author Flipper Code <hello@flippercode.com>
	 */
	class ECP_Model_Tools extends FlipperCode_Model_Base {

		/**
		 * Intialize Backup object.
		 */
		function __construct() {}

		/**
		 * Admin menu for Settings Operation
		 *
		 * @return array Admin menu navigation(s).
		 */
		function navigation() {
			
			return array(
				'ecp_tools_tools' => esc_html__( 'Tools', 'woocommerce-ecards-pro' ),
			);
		}

		public function send_test_email() {
			
			$to = sanitize_text_field($_POST['plugin_email_to']);
			$subject = sanitize_text_field($_POST['plugin_email_subject']);
			$message = sanitize_textarea_field($_POST['plugin_email_message']);
			wp_mail( $to, $subject, 'Message: ' .$message );
			$response['success'] = esc_html__( 'Email Sent successfully.', 'woocommerce-ecards-pro' );
			return $response;

		}

		public function install_fresh_settings() {

			if ( isset( $_POST['plugin_fresh_install_submit'] ) && sanitize_text_field($_POST['plugin_install_fresh_settings']) == 'YES' ) {

				delete_option( 'wp-ecards-pro');
				$default_data = ECP_Fresh_Settings::get_fresh_settings();
				update_option('wp-ecards-pro',serialize(wp_unslash($default_data)) );

				$response['success'] = esc_html__( 'Plugin\'s default settings stored successfully.', 'woocommerce-ecards-pro' );
			}
			else{
				$response['error'] = esc_html__( 'Please type "YES" in capitals to reset plugin and to install plugin\'s fresh settings again.', 'woocommerce-ecards-pro' );
			}
			return $response;

		}

		/**
		 * Add or Edit Operation.
		 */
		function save() {
			
			//Nonce Verification	
			if ( isset( $_REQUEST['_wpnonce'] ) ) {
				$nonce = sanitize_text_field( wp_unslash( $_REQUEST['_wpnonce'] ) ); }
			if ( isset( $nonce ) and ! wp_verify_nonce( $nonce, 'wpgmp-nonce' ) ) {
				die( 'Cheating...' );
			}

			// Permission Verification
			if ( ! current_user_can( 'administrator' ) ) {
				die( 'You are not allowed to save changes!' );
			}
			
			$this->verify( $_POST );
			if ( is_array( $this->errors ) and ! empty( $this->errors ) ) {
				$this->throw_errors();
			}
			
			//Install Fresh Settings
			if(isset($_POST['plugin_fresh_install_submit'])){

		 		if ( empty ($_POST['plugin_install_fresh_settings'])){
					$this->errors[] = esc_html__( 'Please type "YES" to reset plugin settings.', 'woocommerce-ecards-pro' );
					$this->throw_errors();
				}
				$response = $this->install_fresh_settings();
				return $response;
				
		 	}
		 	elseif(isset($_POST['plugin_test_email_submit'])){

		 		if (empty($_POST['plugin_email_to'] && $_POST['plugin_email_subject'] && $_POST['plugin_email_message']) ) {
		 			if (empty($_POST['plugin_email_to'] ) ){
						$this->errors[] = esc_html__( 'Recipient email cannot be empty', 'woocommerce-ecards-pro' );
					}
					if (empty($_POST['plugin_email_subject'] ) ){
						$this->errors[] = esc_html__( 'Email subject cannot be empty', 'woocommerce-ecards-pro');
					}
					if (empty($_POST['plugin_email_message'] ) ){
						$this->errors[] = esc_html__( 'Email message cannot be empty', 'woocommerce-ecards-pro');
					}
					$this->throw_errors();
				}
				
				$response = $this->send_test_email();
				return $response;

		 	}
		 	
		}

	}
}
