<?php
/**
 * Setting page for Ecards Pro.
 *
 * @author Flipper Code <hello@flippercode.com>
 * @version 1.0.8
 * @package wp_ecards_pro
 */

$form  = new WPECP_Template();
$form->set_header( esc_html__( 'Ecard Product Form - General Settings', 'woocommerce-ecards-pro' ), $response );
$data = maybe_unserialize( get_option( 'wp-ecards-pro' ) );
if ( isset( $_POST ) and isset( $_POST['ecp_save_settings'] ) ) {
	$data = $_POST;
}

$form->add_element(
	'checkbox_toggle', 'display_column_for_ecard_product', array(
		'lable' => esc_html__( 'Highlight Ecard Product', 'woocommerce-ecards-pro' ),
		'value' => 'true',
		'current' => isset( $data['display_column_for_ecard_product'] ) ? $data['display_column_for_ecard_product'] : '',
		'class' => 'checkbox_toggle',
		'default_value' => 'true',
		'desc' => esc_html__( 'Highlight ecard product on products listing page in backend. It helps differentiating ecard products from regular products right on the backend products listing screen.', 'woocommerce-ecards-pro' ),
	)
);

$form->add_element(
	'checkbox_toggle', 'enable_multiple_recepients', array(
		'lable' => esc_html__( 'Enable Multiple Recepients', 'woocommerce-ecards-pro' ),
		'value' => 'true',
		'current' => isset( $data['enable_multiple_recepients'] ) ? $data['enable_multiple_recepients'] : '',
		'class' => 'checkbox_toggle',
		'default_value' => 'true',
		'desc' => esc_html__( 'Enable buyers to send ecard to multiple recepients by providing comma seperated names and email addresses.', 'woocommerce-ecards-pro' ),
	)
);

$form->add_element(
	'checkbox_toggle', 'ask_sender_information', array(
		'lable' => esc_html__( 'Ask Sender Information', 'woocommerce-ecards-pro' ),
		'value' => 'true',
		'current' => isset( $data['ask_sender_information'] ) ? $data['ask_sender_information'] : '',
		'class' => 'checkbox_toggle',
		'default_value' => 'true',
		'desc' => esc_html__( 'Ask sender name and sender\'s email address on ecard product form.', 'woocommerce-ecards-pro' ),
	)
);

$form->add_element(
	'checkbox_toggle', 'ask_date_information', array(
		'lable' => esc_html__( 'Ask Ecard Delivery Date', 'woocommerce-ecards-pro' ),
		'value' => 'true',
		'current' => isset( $data['ask_date_information'] ) ? $data['ask_date_information'] : '',
		'class' => 'checkbox_toggle',
		'default_value' => 'true',
		'desc' => esc_html__( 'Enable datepicker control on ecard form for users to schedule delivery of ecard on any date.', 'woocommerce-ecards-pro' ),
	)
);

$form->add_element(
	'checkbox_toggle', 'copy_to_self', array(
		'lable' => esc_html__( 'Copy Ecard to Self', 'woocommerce-ecards-pro' ),
		'value' => 'true',
		'current' => isset( $data['copy_to_self'] ) ? $data['copy_to_self'] : '',
		'class' => 'checkbox_toggle',
		'default_value' => 'true',
		'desc' => esc_html__( 'Enable visitors to send ecard copy to their email address.', 'woocommerce-ecards-pro' ),
	)
);

$form->add_element(
	'group', 'ecard_preview_display_settings', array(
		'value' => esc_html__( 'Allow Visitors To View Ecard Preview', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-12">',
		'after' => '</div>',
	)
);

$form->add_element(
	'checkbox_toggle', 'ask_preview_information', array(
		'lable' => esc_html__( 'On Product Page', 'woocommerce-ecards-pro' ),
		'value' => 'true',
		'current' => isset( $data['ask_preview_information'] ) ? $data['ask_preview_information'] : '',
		'class' => 'checkbox_toggle',
		'default_value' => 'true',
		'desc' => esc_html__( 'Allow visitors to see ecard preview on product page.', 'woocommerce-ecards-pro' ),
	)
);

$form->add_element(
	'checkbox_toggle', 'ask_preview_information_cart', array(
		'lable' => esc_html__( 'On Cart Page', 'woocommerce-ecards-pro' ),
		'value' => 'true',
		'current' => isset( $data['ask_preview_information_cart'] ) ? $data['ask_preview_information_cart'] : '',
		'class' => 'checkbox_toggle',
		'default_value' => 'true',
		'desc' => esc_html__( 'Allow visitors to see ecard preview on cart page.', 'woocommerce-ecards-pro' ),
	)
);

$form->add_element(
	'checkbox_toggle', 'ask_preview_information_checkout', array(
		'lable' => esc_html__( 'On Checkout Page', 'woocommerce-ecards-pro' ),
		'value' => 'true',
		'current' => isset( $data['ask_preview_information_checkout'] ) ? $data['ask_preview_information_checkout'] : '',
		'class' => 'checkbox_toggle',
		'default_value' => 'true',
		'desc' => esc_html__( 'Allow visitors to see ecard preview on checkout page.', 'woocommerce-ecards-pro' ),
	)
);

$form->add_element(
	'group', 'ecard_update_display_settings', array(
		'value' => esc_html__( 'Allow Visitors To Update Ecard Content', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-12">',
		'after' => '</div>',
	)
);

$form->add_element(
	'checkbox_toggle', 'allow_update_cart', array(
		'lable' => esc_html__( 'On Cart Page', 'woocommerce-ecards-pro' ),
		'value' => 'true',
		'current' => isset( $data['allow_update_cart'] ) ? $data['allow_update_cart'] : '',
		'class' => 'checkbox_toggle',
		'default_value' => 'true',
		'desc' => esc_html__( 'Allow visitors to update ecard content on cart page.', 'woocommerce-ecards-pro' ),
	)
);

$form->add_element(
	'group', 'display_ordersummery_group', array(
		'value' => esc_html__( 'Display / Hide Ecard Order Information', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-12">',
		'after' => '</div>',
	)
);

$form->add_element(
	'checkbox', 'display_ecard_order_listing', array(
		'id' => 'display_ecard_order_listing',
		'lable' => esc_html__( 'Highlight Ecards Orders', 'woocommerce-ecards-pro' ),
		'value' => true,
		'current' => isset( $data['display_ecard_order_listing'] ) ? $data['display_ecard_order_listing'] : '',
		'desc' => esc_html__( 'Display Ecard Related Information On Orders Listing Page', 'woocommerce-ecards-pro' ),
	)
);

$form->add_element(
	'checkbox_toggle', 'ask_order_cart', array(
		'lable' => esc_html__( 'Display on Cart Page', 'woocommerce-ecards-pro' ),
		'value' => 'true',
		'id' => 'date_filters',
		'current' => isset( $data['ask_order_cart'] ) ? $data['ask_order_cart'] : '',
		'class' => 'checkbox_toggle switch_onoff',
		'default_value' => 'true',
		'data' => array( 'target' => '.cart_page_ecard_fields' ),
	)
);

$ecardFields = array(
	'recipient_name' => 'Recepient Name',
	'recipient_email_address' => 'Recepient Email Address',
	'ecard_delivery_date' => 'Ecard Delivery Date',
	'default_subject' => 'Ecard Subject',
	'ecard_heading' => 'Ecard Heading',
	'ecard_message' => 'Ecard Message',
	'sender_name' => 'Sender Name',
	'sender_email_address' => 'Sender Email Address',
);

$show = ( 'true' == isset( $data['ask_order_cart'] ) or 'true' == isset( $_POST['ask_order_cart'] ) ) ? 'true' : 'false';
$form->add_element(
	'multiple_checkbox', 'cart_page_ecard_fields[]', array(
		'lable' => esc_html__( 'Information On Cart Page', 'woocommerce-ecards-pro' ),
		'value' => $ecardFields,
		'current' => isset( $data['cart_page_ecard_fields'] ) ? $data['cart_page_ecard_fields'] : '',
		'class' => 'form-control chk-vertical cart_page_ecard_fields',
		'show' => $show,
		'before' => '<div class="fc-9 cart_page_ecard_fields_listing" >',
		'after' => '</div>',
		'display_mode' => 'chk-vertical',
	)
);

$form->add_element(
	'checkbox_toggle', 'ask_order_checkout', array(
		'lable' => esc_html__( 'Display on Checkout Page', 'woocommerce-ecards-pro' ),
		'value' => 'true',
		'id' => 'date_filters',
		'current' => isset( $data['ask_order_checkout'] ) ? $data['ask_order_checkout'] : '',
		'class' => 'checkbox_toggle switch_onoff',
		'default_value' => 'true',
		'data' => array( 'target' => '.checkout_page_ecard_fields' ),
	)
);

$show = ( 'true' == isset( $data['ask_order_checkout'] ) or 'true' == isset( $_POST['ask_order_checkout'] ) ) ? 'true' : 'false';
$form->add_element(
	'multiple_checkbox', 'checkout_page_ecard_fields[]', array(
		'lable' => esc_html__( 'Information On Checkout Page', 'woocommerce-ecards-pro' ),
		'value' => $ecardFields,
		'current' => isset( $data['checkout_page_ecard_fields'] ) ? $data['checkout_page_ecard_fields'] : '',
		'class' => 'form-control checkout_page_ecard_fields',
		'show' => $show,
		'before' => '<div class="fc-9 checkout_page_ecard_fields_listing" >',
		'after' => '</div>',
		'display_mode' => 'chk-vertical',
	)
);


$form->add_element(
	'group', 'ecard_btn_customisation', array(
		'value' => esc_html__( 'Ecard\'s Add To Cart Button Label Settings', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-12">',
		'after' => '</div>',

	)
);

$form->add_element(
	'text', 'button_labels[add_to_cart_shop]', array(
		'lable' => esc_html__( 'Button Label On Shop Page', 'woocommerce-ecards-pro' ),
		'value' => isset( $data['button_labels']['add_to_cart_shop'] ) ? $data['button_labels']['add_to_cart_shop'] : '',
		'default_value' => esc_html__( 'Add To Cart', 'woocommerce-ecards-pro' ),
		'desc' => esc_html__( 'Button Label for "Add To Cart" button on shop page', 'woocommerce-ecards-pro' ),
		'class' => 'form-control',
		'placeholder' => esc_html__( 'Add To Cart', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-6" >',
		'after' => '</div>',
	)
);

$form->add_element(
	'text', 'button_labels[add_to_cart_product]', array(
		'lable' => esc_html__( 'Button Label On Product Page', 'woocommerce-ecards-pro' ),
		'value' => isset( $data['button_labels']['add_to_cart_product'] ) ? $data['button_labels']['add_to_cart_product'] : '',
		'default_value' => esc_html__( 'Add To Cart', 'woocommerce-ecards-pro' ),
		'desc' => esc_html__( 'Button Label for "Add To Cart"  button on product page', 'woocommerce-ecards-pro' ),
		'class' => 'form-control',
		'placeholder' => esc_html__( 'Add To Cart', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-6" >',
		'after' => '</div>',
	)
);

$form->add_element(
	'group', 'display_msg_group', array(
		'value' => esc_html__( 'Ecard Form Label Settings', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-12">',
		'after' => '</div>',

	)
);

$form->add_element(
	'text', 'recipient_name', array(
		'lable' => esc_html__( 'Recepient Full Name', 'woocommerce-ecards-pro' ),
		'value' => isset( $data['recipient_name'] ) ? $data['recipient_name'] : '',
		'default_value' => esc_html__( 'eCard Recepient Full Name', 'woocommerce-ecards-pro' ),
		'desc' => esc_html__( 'Label for "Recepient Full Name Field."', 'woocommerce-ecards-pro' ),
		'class' => 'form-control',
		'placeholder' => esc_html__( 'eCard Name', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-6" >',
		'after' => '</div>',
	)
);

$form->add_element(
	'text', 'recipient_email_address', array(
		'lable' => esc_html__( 'Recipient Email Address', 'woocommerce-ecards-pro' ),
		'value' => isset( $data['recipient_email_address'] ) ? $data['recipient_email_address'] : '',
		'default_value' => esc_html__( 'Recipient Email', 'woocommerce-ecards-pro' ),
		'desc' => esc_html__( 'Label for "Recipient Email Address field".', 'woocommerce-ecards-pro' ),
		'class' => 'form-control',
		'placeholder' => esc_html__( 'Recipient Email', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-6" >',
		'after' => '</div>',
	)
);


$form->add_element(
	'text', 'ecard_delivery_date', array(
		'lable' => esc_html__( 'Send eCard On', 'woocommerce-ecards-pro' ),
		'value' => isset( $data['ecard_delivery_date'] ) ? $data['ecard_delivery_date'] : '',
		'default_value' => esc_html__( 'Send eCard On', 'woocommerce-ecards-pro' ),
		'desc' => esc_html__( 'Label for Send eCard On date field.', 'woocommerce-ecards-pro' ),
		'class' => 'form-control',
		'placeholder' => esc_html__( 'Send Ecard On', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-6" >',
		'after' => '</div>',
	)
);

$form->add_element(
	'text', 'default_subject', array(
		'lable' => esc_html__( 'eCard Email Subject', 'woocommerce-ecards-pro' ),
		'value' => isset( $data['default_subject'] ) ? $data['default_subject'] : '',
		'default_value' => esc_html__( 'eCard Subject', 'woocommerce-ecards-pro' ),
		'desc' => esc_html__( 'Label for ecard email subject field.', 'woocommerce-ecards-pro' ),
		'class' => 'form-control',
		'placeholder' => esc_html__( 'eCard Subject', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-6" >',
		'after' => '</div>',
	)
);

$form->add_element(
	'text', 'ecard_heading', array(
		'lable' => esc_html__( 'eCard Heading', 'woocommerce-ecards-pro' ),
		'value' => isset( $data['ecard_heading'] ) ? $data['ecard_heading'] : '',
		'default_value' => esc_html__( 'eCard Heading', 'woocommerce-ecards-pro' ),
		'desc' => esc_html__( 'Label for ecard heading field.', 'woocommerce-ecards-pro' ),
		'class' => 'form-control',
		'placeholder' => esc_html__( 'eCard Heading', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-6" >',
		'after' => '</div>',
	)
);

$form->add_element(
	'text', 'ecard_message', array(
		'lable' => esc_html__( 'eCard Message', 'woocommerce-ecards-pro' ),
		'value' => isset( $data['ecard_message'] ) ? $data['ecard_message'] : '',
		'default_value' => esc_html__( 'eCard Message', 'woocommerce-ecards-pro' ),
		'desc' => esc_html__( 'Label for ecard message field.', 'woocommerce-ecards-pro' ),
		'class' => 'form-control',
		'placeholder' => esc_html__( 'eCard Message', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-6" >',
		'after' => '</div>',
	)
);

$form->add_element(
	'text', 'sender_name', array(
		'lable' => esc_html__( 'Your Name', 'woocommerce-ecards-pro' ),
		'value' => isset( $data['sender_name'] ) ? $data['sender_name'] : '',
		'default_value' => esc_html__( 'Your Name', 'woocommerce-ecards-pro' ),
		'desc' => esc_html__( 'Label for sender name field.', 'woocommerce-ecards-pro' ),
		'class' => 'form-control',
		'placeholder' => esc_html__( 'Your Name', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-6" >',
		'after' => '</div>',
	)
);

$form->add_element(
	'text', 'copyself_label', array(
		'lable' => esc_html__( 'Copy to Self', 'woocommerce-ecards-pro' ),
		'value' => isset( $data['copyself_label'] ) ? $data['copyself_label'] : '',
		'default_value' => esc_html__( 'Copy to Self', 'woocommerce-ecards-pro' ),
		'desc' => esc_html__( 'Label for \'copy to self\' option on ecard form field.', 'woocommerce-ecards-pro' ),
		'class' => 'form-control',
		'placeholder' => esc_html__( 'Copy to Self', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-6" >',
		'after' => '</div>',
	)
);

$form->add_element(
	'text', 'sender_email_address', array(
		'lable' => esc_html__( 'Your Email Address', 'woocommerce-ecards-pro' ),
		'value' => isset( $data['sender_email_address'] ) ? $data['sender_email_address'] : '',
		'default_value' => esc_html__( 'Your Email Address', 'woocommerce-ecards-pro' ),
		'desc' => esc_html__( 'Label for sender\'s email address field.', 'woocommerce-ecards-pro' ),
		'class' => 'form-control',
		'placeholder' => esc_html__( 'Your Email Address', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-6" >',
		'after' => '</div>',
	)
);

$form->add_element(
	'text', 'visit_site_label', array(
		'lable' => esc_html__( 'Visit Site', 'woocommerce-ecards-pro' ),
		'value' => isset( $data['visit_site_label'] ) ? $data['visit_site_label'] : '',
		'default_value' => esc_html__( 'Visit Site', 'woocommerce-ecards-pro' ),
		'desc' => esc_html__( 'Label for \'visit site\' button display in the email.', 'woocommerce-ecards-pro' ),
		'class' => 'form-control',
		'placeholder' => esc_html__( 'Visit Site', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-6" >',
		'after' => '</div>',
	)
);



$form->add_element(
	'group', 'display_email_group', array(
		'value' => esc_html__( 'Email Settings', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-12">',
		'after' => '</div>',

	)
);

$form->add_element(
	'textarea', 'ecard_footer', array(
		'lable' => esc_html__( 'Ecard Footer Content', 'woocommerce-ecards-pro' ),
		'value' => isset( $data['ecard_footer'] ) ? $data['ecard_footer'] : '',
		'id' => 'ecard_footer',
		'placeholder' => '',
		'desc' => esc_html__( 'Enter Ecard Footer Content. You can use {sitename} placeholder in above textarea.', 'woocommerce-ecards-pro' ),
	)
);


$form->add_element(
	'checkbox_toggle', 'send_via_mandrill', array(
		'lable' => esc_html__( 'Send Via Mandrill', 'woocommerce-ecards-pro' ),
		'value' => 'true',
		'id' => 'date_filters',
		'current' => isset( $data['send_via_mandrill'] ) ? $data['send_via_mandrill'] : '',
		'class' => 'checkbox_toggle switch_onoff',
		'default_value' => 'true',
		'desc' => esc_html__( 'Choose \'yes\' to send email using mandrill api.', 'woocommerce-ecards-pro' ),
		'data' => array( 'target' => '.mandrill_key' ),
	)
);

$show = ( 'true' == isset( $data['send_via_mandrill'] ) or 'true' == isset( $_POST['send_via_mandrill'] ) ) ? 'true' : 'false';
$form->add_element(
	'text', 'mandrill_key', array(
		'lable' => esc_html__( 'Mandrill Api Key', 'woocommerce-ecards-pro' ),
		'value' => isset( $data['mandrill_key'] ) ? $data['mandrill_key'] : '',
		'before' => '<div class="fc-6 mandrill_key" >',
		'after' => '</div>',
		'id' => 'mandrill_key',
		'placeholder' => '',
		'desc' => esc_html__( 'Enter Mandrill Api Key', 'woocommerce-ecards-pro' ),
		'show' => $show,
	)
);

$form->add_element(
	'group', 'ecard_order_setting', array(
		'value' => esc_html__( 'Ecard Order Status Advance Settings', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-12">',
		'after' => '</div>',
	)
);

$form->add_element(
	'checkbox', 'autocomplete_ecard_orders', array(
		'id' => 'autocomplete_ecard_orders',
		'lable' => esc_html__( 'Automatic Update Order Status', 'woocommerce-ecards-pro' ),
		'value' => true,
		'current' => isset( $data['autocomplete_ecard_orders'] ) ? $data['autocomplete_ecard_orders'] : '',
		'desc' => esc_html__( 'Automatically set status of those orders to complete that contains only ecards and payment has been made using paypal.', 'woocommerce-ecards-pro' ),
	)
);

$form->add_element(
	'group', 'display_cron_group', array(
		'value' => esc_html__( 'Cron Job Settings', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-12">',
		'after' => '</div>',

	)
);

$form->add_element(
	'radio', 'ecard_cron', array(
		'lable' => esc_html__( 'Look For Pending Ecards', 'woocommerce-ecards-pro' ),
		'radio-val-label' => array(
			'deliver_woo_ecards' => esc_html__( 'Earliest', 'woocommerce-ecards-pro' ),
			'hourly' => esc_html__( 'Hourly', 'woocommerce-ecards-pro' ),
			'twicedaily' => esc_html__( 'Twice Daily', 'woocommerce-ecards-pro' ),
			'daily' => esc_html__( 'Daily', 'woocommerce-ecards-pro' ),
		),
		'default_value' => 'deliver_woo_ecards',
		'current' => isset( $data['ecard_cron'] ) ? $data['ecard_cron'] : 'deliver_woo_ecards',
		'desc' => esc_html__( 'Cron job will be used to send scheduled eCards purchased by your customers to their recepient\'s email addresses. Set the frequency after how much time you want the wordpress cron job system to again look for pending ecards in woocommerce orders that needs to be delivered. Ecards will be delivered only when the ecard delivery date condition is met. This setting is just for telling wordpress after how much time pending ecards must be again checked in woocommerce orders. This plugin uses wordpress\'s native cron job system that required atleast one user to be active on site to perform cron job processes on supposed time. For sites having good traffic "Twice Daily" option is good. For sites having less amount of daily traffic "Earliest" option is recommended to avoid delay in sending ecards. ', 'woocommerce-ecards-pro' ),
	)
);

$form->add_element(
	'group', 'custom_css_group', array(
		'value' => esc_html__( 'Additional Settings', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-12">',
		'after' => '</div>',

	)
);

$form->add_element(
	'textarea', 'ecard_custom_css', array(
		'lable' => esc_html__( 'Custom CSS For Frontend', 'woocommerce-ecards-pro' ),
		'value' => isset( $data['ecard_custom_css'] ) ? $data['ecard_custom_css'] : '',
		'id' => 'ecard_custom_css',
		'placeholder' => '',
		'desc' => esc_html__( 'Custom CSS For Frontend', 'woocommerce-ecards-pro' ),
	)
);

$form->add_element(
	'submit', 'ecp_save_settings', array(
		'value' => esc_html__( 'Save Settings ', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-2">',
		'after' => '</div>',
	)
);
$form->add_element(
	'hidden', 'operation', array(
		'value' => 'save',
	)
);

$form->add_element(
	'hidden', 'default_templates[email]', array(
		'value' => isset( $data['default_templates']['email'] ) ? $data['default_templates']['email'] : '',
	)
);

$form->add_element(
	'hidden', 'admin_ecard_title', array(
		'id' => 'admin_ecard_title',
		'value' => '',
	)
);
$form->add_element(
	'hidden', 'admin_ecard_msg', array(
		'id' => 'admin_ecard_msg',
		'value' => '',
	)
);

$form->render();
