<?php
/**
 * Class: AGP_Model_Settings
 *
 * @author Flipper Code <hello@flippercode.com>
 * @version 1.0.0
 * @package super-contact-form
 */

if ( ! class_exists( 'ECP_Model_Settings' ) ) {

	/**
	 * Setting model for Plugin Options.
	 *
	 * @package age-gate-pro
	 * @author Flipper Code <hello@flippercode.com>
	 */
	class ECP_Model_Settings extends FlipperCode_Model_Base {

		/**
		 * Intialize Backup object.
		 */
		function __construct() {

		}

			/**
			 * Admin menu for Settings Operation
			 *
			 * @return array Admin menu navigation(s).
			 */
		function navigation() {
			return array(
				'ecp_settings_settings' => esc_html__( 'Plugin Settings', 'woocommerce-ecards-pro' ),
			);
		}

			/**
			 * Install table associated with Rule entity.
			 *
			 * @return string SQL query to install post_widget_rules table.
			 */
		public function install() {

		}

		   /**
			* Get Rule(s)
			*
			* @param  array $where  Conditional statement.
			* @return array         Array of Rule object(s).
			*/
		public function fetch( $where = array() ) {

			$objects = $this->get( $this->table, $where );
			if ( isset( $objects ) ) {
				return $objects;
			}
		}




			/**
			 * Add or Edit Operation.
			 */
		function save() {

			$entityID = '';

			if ( isset( $_REQUEST['_wpnonce'] ) ) {
				$nonce = sanitize_text_field( wp_unslash( $_REQUEST['_wpnonce'] ) ); }

			if ( isset( $nonce ) and ! wp_verify_nonce( $nonce, 'wpgmp-nonce' ) ) {

				die( 'Cheating...' );

			}

			$this->verify( $_POST );

			// Custom Validation
			if ( isset( $_POST['send_via_mandrill'] ) == 'true' and empty( $_POST['mandrill_key'] ) ) {
				$this->errors[] = esc_html__( 'Please enter mandrill api key if you want to use mandrill email service', 'woocommerce-ecards-pro' );
			}

			if ( is_array( $this->errors ) and ! empty( $this->errors ) ) {
				$this->throw_errors();
			}
			if ( isset( $_POST['entityID'] ) ) {
				$entityID = intval( wp_unslash( $_POST['entityID'] ) );
			}

			if ( $entityID > 0 ) {
				$where[ $this->unique ] = $entityID;
			} else {
				$where = '';
			}

			update_option( 'wp-ecards-pro', wp_unslash( $_POST ) );

			$response['success'] = esc_html__( 'Ecards Pro Setting(s) updated successfully.', 'woocommerce-ecards-pro' );

			return $response;
		}


	}
}
