<?php
/**
 * Setting page for Ecards Pro.
 *
 * @author Flipper Code <hello@flippercode.com>
 * @version 1.0.1
 * @package wp_ecards_pro
 */
?>
<div class="se-pre-con"></div>
<?php
$form  = new WPECP_Template();
$form->set_header( esc_html__( 'Send Ecards Instantly', 'woocommerce-ecards-pro' ), $response );
$data = maybe_unserialize( get_option( 'wp-ecards-pro' ) );
if ( isset( $_POST ) and isset( $_POST['ecp_save_settings'] ) ) {
	$data = $_POST;
}

$ecards = new WP_Query(
	array(
		'post_type' => 'product',
		'meta_key' => 'convert_into_ecard',
		'meta_value' => 'yes',
		'posts_per_page' => -1,
	)
);
$ecards_data = array( '0' => 'Please Select An Ecard' );
foreach ( $ecards->posts as $ecard ) {
	$ecards_data[ $ecard->ID ] = $ecard->post_title;
}

$form->add_element(
	'select', 'ecard_listing', array(
		'id' => 'ecard_listing',
		'lable' => esc_html__( 'Select Ecard To Send', 'woocommerce-ecards-pro' ),
		'options' => $ecards_data,
		'desc' => esc_html__( 'Select Ecard To Send', 'woocommerce-ecards-pro' ),
	)
);


$form->add_element(
	'radio', 'ecard_recepients', array(
		'lable' => esc_html__( 'Select Recepients Of Ecard', 'woocommerce-ecards-pro' ),
		'radio-val-label' => array(
			'all' => esc_html__( 'All Site Users', 'woocommerce-ecards-pro' ),
			'role_based' => esc_html__( 'Users With Particular Role', 'woocommerce-ecards-pro' ),
			'particular_users' => esc_html__( 'Particular Users', 'woocommerce-ecards-pro' ),
			'particular_email' => esc_html__( 'Specify Email Address Directly', 'woocommerce-ecards-pro' ),
		),
		'default_value' => 'particular_email',
		'desc' => esc_html__( 'Select User/Users To Send Ecard', 'woocommerce-ecards-pro' ),
		'class' => 'chkbox_class ecard_recepients switch_onoff',
		'required' => true,
		'data' => array( 'target' => '.wep_userselection_type' ),

	)
);

$user_roles = get_editable_roles();
$userroles = array( '' => 'Please Select User Role' );
foreach ( $user_roles as $role => $roleInfo ) {
	$userroles[ $role ] = $roleInfo['name'];
}

$form->add_element(
	'select', 'list_user_roles', array(
		'id' => 'list_user_roles',
		'lable' => esc_html__( 'Select User Role To Send Ecard', 'woocommerce-ecards-pro' ),
		'options' => $userroles,
		'desc' => esc_html__( 'Ecard will be send to all users having this role in your website.', 'woocommerce-ecards-pro' ),
		'class' => 'form-control wep_userselection_type wep_userselection_type_role_based',
		'show' => 'false',

	)
);

$blogusers = get_users();
$userlist = array( '' => 'Please Select Users' );
foreach ( $blogusers as $user ) {
	$userlist[ $user->ID ] = $user->data->display_name;

}
$form->add_element(
	'select', 'particular_users', array(
		'id' => 'particular_users',
		'lable' => esc_html__( 'Select Users To Send Ecard', 'woocommerce-ecards-pro' ),
		'options' => $userlist,
		'desc' => esc_html__( 'Ecard will be send to the selected users only.', 'woocommerce-ecards-pro' ),
		'class' => 'form-control wep_userselection_type wep_userselection_type_particular_users',
		'show' => 'false',
	)
);

$form->add_element(
	'text', 'particular_receiver', array(
		'id' => 'particular_receiver',
		'lable' => esc_html__( 'Ecard\'s Receiver Email Address : ', 'woocommerce-ecards-pro' ),
		'class' => 'form-control wep_userselection_type wep_userselection_type_particular_email',
		'placeholder' => esc_html__( 'Enter Ecard\'s Receiver Email Address', 'woocommerce-ecards-pro' ),
		'desc' => esc_html__( 'Enter email address of recepient to whom you want to send ecard. Click preview button displayed below to see a preview of Ecard that will be send. Please note that default placeholders displayed in preview will not be replaced before sending ecard, because we are sending to an anonoymous email address and we are assuming that the entered email address does not belong to this website. Type heading and message manually before sending and remove any user related placeholders if exist.', 'woocommerce-ecards-pro' ),

	)
);


$form->add_element(
	'button', 'preview_current_ecard', array(
		'id' => 'preview_current_ecard',
		'value' => esc_html__( 'Preview Ecard', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-2">',
		'after' => '</div>',
		'class' => 'e-card-preview fc-btn fc-btn-orange',
	)
);

$form->add_element(
	'button', 'send_ecards_btn', array(
		'id' => 'send_ecards_btn',
		'value' => esc_html__( 'Send Ecard Now', 'woocommerce-ecards-pro' ),
		'before' => '<div class="fc-2">',
		'after' => '</div>',
		'class' => 'send-instantly fc-btn fc-btn-blue',
	)
);

$form->add_element(
	'hidden', 'admin_ecard_title', array(
		'id' => 'admin_ecard_title',
		'value' => '',
	)
);
$form->add_element(
	'hidden', 'admin_ecard_msg', array(
		'id' => 'admin_ecard_msg',
		'value' => '',
	)
);

$form->render();
