<?php
/**
 * Template class
 *
 * @author Flipper Code<hello@flippercode.com>
 * @version 3.0.0
 * @package Posts
 */

if ( ! class_exists( 'WPECP_Template' ) ) {

	/**
	 * Controller class to display views.
	 *
	 * @author: Flipper Code<hello@flippercode.com>
	 * @version: 3.0.0
	 * @package: Ecards
	 */

	class WPECP_Template extends FlipperCode_HTML_Markup {


		function __construct( $options = array() ) {

			$productOverview = array(
				'subscribe_mailing_list' => esc_html__( 'Subscribe to our mailing list', 'woocommerce-ecards-pro' ),
				'product_info_heading' => esc_html__( 'Product Information', 'woocommerce-ecards-pro' ),
				'product_info_desc' => esc_html__( 'For our each product we have set up demo pages where you can see the plugin in working mode.', 'woocommerce-ecards-pro' ),
				'live_demo_caption' => esc_html__( 'Live Demos', 'woocommerce-ecards-pro' ),
				'installed_version' => esc_html__( 'Installed version :', 'woocommerce-ecards-pro' ),
				'latest_version_available' => esc_html__( 'Latest Version Available : ', 'woocommerce-ecards-pro' ),
				'updates_available' => esc_html__( 'Update Available', 'woocommerce-ecards-pro' ),
				'subscribe_now' => array(
					'heading' => esc_html__( 'Subscribe Now', 'woocommerce-ecards-pro' ),
					'desc1' => esc_html__( 'Receive updates on our  new product features and new products effortlessly.', 'woocommerce-ecards-pro' ),
					'desc2' => esc_html__( 'We will not share your email addresses in any case.', 'woocommerce-ecards-pro' ),
				),
				'product_support' => array(
					'heading' => esc_html__( 'Product Support', 'woocommerce-ecards-pro' ),
					'desc' => esc_html__( 'For our each product we have very well explained starting guide to get you started in matter of minutes.', 'woocommerce-ecards-pro' ),
					'click_here' => esc_html__( ' Click Here', 'woocommerce-ecards-pro' ),
					'desc2' => esc_html__( 'For our each product we have set up demo pages where you can see the plugin in working mode. You can see a working demo before making a purchase.', 'woocommerce-ecards-pro' ),
				),
				'refund' => array(
					'heading' => esc_html__( 'Get Refund', 'woocommerce-ecards-pro' ),
					'desc' => esc_html__( 'Please click on the below button to initiate the refund process.', 'woocommerce-ecards-pro' ),
					'request' => esc_html__( 'Request a Refund', 'woocommerce-ecards-pro' ),
				),
				'support' => array(
					'heading' => esc_html__( 'Extended Technical Support', 'woocommerce-ecards-pro' ),
					'desc1' => esc_html__( 'We provide technical support for all of our products. You can opt for 12 months support below.', 'woocommerce-ecards-pro' ),
					'link' => esc_html__( 'Extend support', 'woocommerce-ecards-pro' ),
					'link2' => esc_html__( 'Get Extended Licence', 'woocommerce-ecards-pro' ),
				),

			);

			$productInfo = array(
				'productName' => esc_html__( 'Woocommerce Ecards Pro', 'woocommerce-ecards-pro' ),
				'productSlug' => esc_html__( 'woocommerce-ecards-pro', 'woocommerce-ecards-pro' ),
				'productTagLine' => esc_html__( 'A wordpress extention that allows you to sell E-cards with woocommerce that end user can customize and email to anyone on scheduled date. Also enables site administrators to send ecards to registered users of their site.', 'woocommerce-ecards-pro' ),
				'productTextDomain' => 'woocommerce-ecards-pro',
				'productIconImage' => ECP_URL . 'assets/images/wp-poet.png',
				'productVersion' => ECP_VERSION,
				'docURL' => 'http://guide.flippercode.com/woo-ecards-pro/',
				'videoURL' => 'https://www.youtube.com/playlist?list=PLlCp-8jiD3p2m4N-vfWR68xf2j-uPlegI',
				'demoURL' => 'http://www.flippercode.com/product/woocommerce-ecard-pro/',
				'productImagePath' => ECP_URL . 'assets/images/',
				'productSaleURL' => 'http://codecanyon.net/item/woocommerce-ecards-pro/18477382',
				'multisiteLicence' => 'http://codecanyon.net/item/woocommerce-ecards-pro/18477382?license=extended&open_purchase_for_item_id=18477382&purchasable=source',
				'productOverview' => $productOverview,
			);

			$productInfo = array_merge( $productInfo, $options );
			parent::__construct( $productInfo );

		}

	}

}
