(function($) {
    'use strict';
    $.fn.fcModal = function(options) {
        var fcmodal = $.extend({
            onOpen: function() {},
            register_fc_modal_handing_events: function() {
                $('body').on('click', '.fc-modal-btn', function() {

                    var releatedModal = $(this).data('target');
                    if ($('#' + releatedModal).length > 0) {
                        fcmodal.onOpen();
                        $('#' + releatedModal).css('display', 'block');
                    }

                });

                $('body').on('click', '.fc-modal-close', function() {
                    var releatedModal = $(this).closest('div.fc-modal');
                    $(releatedModal).css('display', 'none');
                });

                window.onclick = function(event) {

                    if ($(event.toElement).hasClass('fc-modal'))
                        $('.fc-modal').hide();

                }
            }
        }, options);

        return this.each(function() {
            fcmodal.register_fc_modal_handing_events();
        });
    };
})(jQuery);

(function($) {
    'use strict';

    jQuery(document).ready(function($) {

        var dateToday = new Date();
        if ($('.datepicker').length > 0) {
            jQuery('.datepicker').datepicker({
                dateFormat: 'yy-mm-dd',
                minDate: dateToday
            });
        }

        function removeElements(text, selector) {
            var wrapped = $("<div>" + text + "</div>");
            wrapped.find(selector).remove();
            return wrapped.html();
        }

        $('.fc-modal').fcModal({
            onOpen: function() {

                $('.fc-modal-header h3').html('eCard Preview');
                var ecard_heading = ($('#ecard_heading').val() != '' && $('#ecard_heading').val() != undefined) ? $('#ecard_heading').val() : 'You Have Received A New eCard';
                ecard_heading = removeElements(ecard_heading, 'script');
                var emailaddress = ($('#recipient_email_address').val() != '' && $('#recipient_email_address').val() != undefined) ? $('#recipient_email_address').val() : '';
                var ecard_message = ($('#ecard_message').val() != '' && $('#ecard_message').val() != undefined) ? $('#ecard_message').val() : '';
                ecard_message = removeElements(ecard_message, 'script');
                $('.email_title').html(ecard_heading);
                $('.ecard_to').html(emailaddress);
                if ($('#sender_name').val() != '' && $('#sender_name').val() != undefined) {
                    ecard_message = ecard_message.replace("{sender_name}", $('#sender_name').val());
                }

                if ($('#sender_email_address').val() != '' && $('#sender_email_address').val() != undefined)
                    ecard_message = ecard_message.replace("{sender_email}", $('#sender_email_address').val());
                if ($('#recipient_email_address').val() != '' && $('#recipient_email_address').val() != undefined && $('#recipient_email_address').val() != 'undefined') {
                    ecard_message = ecard_message.replace("{recipient_email}", $('#recipient_email_address').val());
                }
                ecard_message = ecard_message.replace("{website_name}", website_name);
                ecard_message = ecard_message.replace("{site_url}", website_url);
                $('.email_message_content').html(ecard_message);

            }
        });

        function setup_ecard_preview(relatedEcardId, recepientEmail) {

            var recepientEmail = $.trim(recepientEmail);
            var relatedEcardId = $.trim(relatedEcardId);
            var current_item = '';

            if ($('.cart_items_details').length > 0) {
                $('.cart_items_details').each(function(i, obj) {

                    if (recepientEmail == $(obj).data('ecard-recepient') && relatedEcardId == $(obj).data('ecard-id')) {
                        var imgsrc = $(obj).data('ecard-img-src');
                        var ecardmsg = $(obj).data('ecard-msg');
                        var ecardtitle = $(obj).data('ecard-heading');
                        $('.email_title').html(ecardtitle);
                        $('.email_message_content').html(ecardmsg);
                        $('img.fluid').attr('src', imgsrc);
                        return true;
                    }
                });
            }

        }

        $(document).on('click', '.e-card-preview', function(e) {

            e.preventDefault();
            var ecardinfo = $(this).attr('id').split('/');
            var relatedEcardId = ecardinfo[1];
            var recepientEmail = ecardinfo[2];
            setup_ecard_preview(relatedEcardId, recepientEmail);

            if ($('#ecardpreview-container').length > 0) {

                $('.fc-modal-header h3').html('eCard Preview');
                $('.ecard_editable_content').each(function(index, item) {

                    $(this).attr('contenteditable', 'false');
                    if ($('.update-content-container').length > 0) {
                        $('.update-content-container').remove();
                    }

                });
                $('.email_title,.email_message,.email_message_content').removeClass('ecard_editable_content');
                $('#ecardpreview-container').css('display', 'block');
            }

        });

        $('body').on('click', '.e-card-update', function(e) {

            e.preventDefault();
            var ecardinfo = $(this).attr('id').split('/');
            var relatedEcardId = ecardinfo[1];
            var recepientEmail = ecardinfo[2];
            var recepientName = ecardinfo[3];
            setup_ecard_preview(relatedEcardId, recepientEmail);
            $('.fc-modal-header h3').html('Update eCard');
            $('.ecard-real-preview').data('ecard-id', relatedEcardId);
            $('.email_title,.email_message_content').addClass('ecard_editable_content');
            $('#ecardpreview-container').css('display', 'block');

            if ($('.fc-modal-body .update-content-container').length == 0) {

                var $buttonMarkup = '<div class="update-content-container action"><input type="button" class="update_ecard_msg_btn" value="Update Content"><div class="fc-loader" style="width: 64px;margin:0 auto;"><img src="' + loader_url + '" class="loader-img" style="display:none;"></div><input type="hidden" name="ec_id" id="ec_id" value=""><input type="hidden" name="ec_add" id="ec_add" value=""><input type="hidden" name="ec_name" id="ec_name" value=""></div>';
                $('.fc-modal-body .update-content-container').after($buttonMarkup);
                $('.email_message_content').after($buttonMarkup);
                $('.ecard_editable_content').each(function(index, item) {
                    $(this).attr('contenteditable', 'true');

                });

            }
            $('#ec_name').val(recepientName);
            $('#ec_add').val(recepientEmail);
            $('#ec_id').val(relatedEcardId);


        });

        $('body').on('click', '.update_ecard_msg_btn', function() {

            $(this).next('.fc-loader').find('img').css('display', 'block');
            var $parent = $(this).closest('.update-content-container').prev('.ecard_editable_content');
            var ecard_heading = $('.email_title').text();
            var ecard_message = $('.email_message_content').text();
            var ecard_heading = removeElements(ecard_heading, 'script');
            var ecard_message = removeElements(ecard_message, 'script');
            var relatedEcardId = $('#ec_id').val();
            var recepientName = $('#ec_name').val();
            var recepientEmail = $('#ec_add').val();

            jQuery.ajax({
                type: "POST",
                url: ecards_ajax_url,
                datatype: 'json',
                data: {
                    'action': 'wep_update_ecard_meta',
                    'ecard_heading': ecard_heading,
                    'ecard_message': ecard_message,
                    'product_id': relatedEcardId,
                    'recipient_name': recepientName,
                    'recepient_email': recepientEmail,
                    'nonce': ecp_settings.nonce
                },
                beforeSend: function() {},
                success: function(data) {
                    $('.fc-loader').find('img').css('display', 'none');
                }

            });

        });

    });
})(jQuery);
