(function($) {
    'use strict';

    jQuery(document).ready(function($) {

        $('.fc-modal').fcModal({});

        function prepare_markup($id) {

            jQuery.ajax({
                type: "POST",
                url: settings_obj.ajax_url,
                datatype: 'json',
                data: {
                    action: 'get_current_ecard_info',
                    'ecard_id': $id,
                    'nonce': settings_obj.nonce
                },
                beforeSend: function() {
                    $('.se-pre-con').show();
                },
                success: function(data) {

                    var data = $.parseJSON(data);
                    if (data.img == null) {
                        alert('Featured Image For This Ecard Is Not Yet Uploaded.');
                    } else {
                        $('.email_title').html(data.title);
                        $('.email_message_content').html(data.msg);
                        $('img.fluid').attr('src', data.img);

                        $('#admin_ecard_title').val(data.title);
                        $('#admin_ecard_msg').val(data.msg);
                    }
                    $('.se-pre-con').hide();
                }

            });

        }

        $(document).on('change', '#ecard_listing', function() {

            if ($(this).val() != 0)
                prepare_markup($(this).val());

        });

        function check_for_ecard() {

            if ($('#ecard_listing').val() == '0') {
                alert('Please Select An Ecard First');
                return false;
            } else {
                return true;
            }

        }

        window.attach_ecard = function(html) {
            $('.ecard_editable_image').html(html);
            var imgcss = {
                'max-width': '100%',
                'height': 'auto'
            };
            $('.ecard_editable_image img').css(imgcss).addClass('fluid');
            try {
                tb_remove();
            } catch (e) {};
        }

        $(document).on('click', '.ecard_editable_image', function() {
            var target = $(this).find('img').attr('class');
            window.send_to_editor = window.attach_ecard;
            tb_show('', 'media-upload.php?post_ID=0&target=' + target + '&type=image&TB_iframe=true');
            return false;

        });

        function update_ecard_heading() {

            if ($('input[name=ecard_recepients]:checked').val() == 'particular_email') {
                $('.email_title').text('You\'ve Got This Ecard.');
            } else {
                $('.email_title').text('Dear {username}');
            }
        }

        $('input[type=radio][name=ecard_recepients]').change(function() {
            if (this.value == 'particular_email') {
                $('.email_title').text('You\'ve Got This Ecard.');
            } else {
                $('.email_title').text('Dear {username}');
            }
        });

        $(document).on('click', '#preview_current_ecard', function() {

            if (check_for_ecard()) {

                if ($('#ecardpreview-container').length > 0) {

                    update_ecard_heading();
                    $('.se-pre-con').show();
                    $('.email_title,.email_message_content').addClass('ecard_editable_content');
                    if ($('.ecard_editable_image').length == 0) {
                        $('img.fluid').wrap('<div class="ecard_editable_image"></div>');
                    }
                    $('.ecard_editable_content').each(function(index, item) {
                        $(this).attr('contenteditable', true);
                    });
                    $('#ecardpreview-container').css('display', 'block');
                    $('.se-pre-con').hide();
                } else {
                    console.log('Ecard Container Not Fpund , Check Screen Hook');
                }

            }

        });

        function isValidEmailAddress(emailAddress) {
            var pattern = /^([a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+(\.[a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+)*|"((([ \t]*\r\n)?[ \t]+)?([\x01-\x08\x0b\x0c\x0e-\x1f\x7f\x21\x23-\x5b\x5d-\x7e\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|\\[\x01-\x09\x0b\x0c\x0d-\x7f\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))*(([ \t]*\r\n)?[ \t]+)?")@(([a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.)+([a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.?$/i;
            return pattern.test(emailAddress);
        };

        $(document).on('click', '#send_ecards_btn', function() {


            if (check_for_ecard()) {

                var userchoice = $('input[name=ecard_recepients]:checked').val();
                var userroles = $('#list_user_roles').val();
                var userlisting = $('#particular_users').val();
                var useremail = $('#particular_receiver').val();
                var error = false;
                if (userchoice == 'role_based' && userroles == '') {

                    alert('Please select a user role to send Ecard');
                    error = true;
                    return false;
                } else if (userchoice == 'particular_users' && userlisting == '') {
                    alert('Please select users to send Ecard');
                    error = true;
                    return false;
                } else if (userchoice == 'particular_email') {

                    if (useremail == '') {
                        alert('Please enter ecard recepient\'s email address first and cross check it before sending.');
                        error = true;
                        return false;
                    } else if (!isValidEmailAddress(useremail)) {
                        alert('Please enter a valid email address to send ecard.');
                        error = true;
                        return false;
                    }

                }

                if (!error) {

                    if (confirm('Are you sure you want to send Ecard ?')) {

                        //Send Ecards  
                        jQuery.ajax({
                            type: "POST",
                            url: settings_obj.ajax_url,
                            datatype: 'json',
                            data: {
                                action: 'send_ecards_to_users',
                                'ecard_id': $('#ecard_listing').val(),
                                'ecard_title': $('.email_title').html(),
                                'ecard_msg': $('.email_message_content').html(),
                                'ecard_img': $('img.fluid').attr('src'),
                                'user_choice': userchoice,
                                'user_role': userroles,
                                'user_listing': userlisting,
                                'particular_receiver': $('#particular_receiver').val(),
                                'nonce': settings_obj.nonce
                            },
                            beforeSend: function() {
                                $('.se-pre-con').show();
                            },
                            success: function(data) {
                                var data = $.parseJSON(data);
                                $('.se-pre-con').hide();
                                alert('Ecards Sent To Users Successfully !');
                            }

                        });
                        return true;
                    } else {
                        return false;
                    }

                }
            }


        });

    });

}(jQuery));

(function($) {
    $.fn.fcModal = function(options) {

        var fcmodal = $.extend({
            onOpen: function() {},
            register_fc_modal_handing_events: function() {

                $('.fc-modal').each(function(i, obj) {

                    var initiator = $(this).data('initiator');

                    if (typeof initiator != typeof undefined) {
                        if ($(initiator.length)) {

                            $(initiator).data('target', $(this).attr('id'));
                            var releatedModal = $(this).attr('id');
                            $('body').on('click', initiator, function() {

                                if ($('#' + releatedModal).length > 0) {
                                    fcmodal.onOpen();
                                    $('#' + releatedModal).css('display', 'block');
                                }

                            });


                        }
                    }


                });

                $('body').on('click', '.fc-modal-close', function() {
                    var releatedModal = $(this).closest('div.fc-modal');
                    $(releatedModal).css('display', 'none');
                });

                window.onclick = function(event) {

                    if ($(event.toElement).hasClass('fc-modal'))
                        $('.fc-modal').hide();

                }
            }
        }, options);

        return this.each(function() {
            fcmodal.register_fc_modal_handing_events();
        });
    };
})(jQuery);