<?php

/**
 * Bookings and Appointment Plugin for WooCommerce
 *
 * Class for integrating Dokan Products with Bookings & Appointment Plugin
 *
 * @author   Tyche Softwares
 * @package  BKAP/Vendors/WC-Vendors
 * @version  4.6.0
 * @category Classes
 */

/**
 * Class for WC Vendors Products integration with Booking plugin
 *
 * @since 4.6.0
 */
class bkap_wcv_product {

	/**
	 * Default constructor
	 *
	 * @since 4.6.0
	 */
	public function __construct() {

		// Add the booking tab
		add_filter( 'wcv_product_meta_tabs', array( &$this, 'bkap_add_booking_tab' ) );
		// Add the booking meta box in the Booking tab
		add_action( 'wcv_after_variations_tab', array( &$this, 'bkap_add_tab_data' ), 10, 1 );

	}

	/**
	 * Add our Bookings Tab to the existing tabs added by WC Vendors
	 *
	 * @param array $tabs_array Data containing the available options for tabs
	 * @returns array Array with Booking details added to it
	 * @since 4.6.0
	 */
	function bkap_add_booking_tab( $tabs_array ) {

		$tabs_array['bkap_booking'] = array(
			'label'  => __( 'Booking', 'woocommerce-booking' ),
			'target' => 'bkap_booking',
			'class'  => array( 'show_if_simple', 'show_if_variable', 'show_if_grouped' ),
		);

		return $tabs_array;
	}

	/**
	 * Add our Booking Meta Box on each product page
	 *
	 * @since 4.6.0
	 * @param string|int $product_id Current Product ID
	 * @global mixed $post Current Post Object
	 */
	function bkap_add_tab_data( $product_id ) {

		if ( $product_id > 0 ) { // it's an existing product
			$bkap_version = get_option( 'woocommerce_booking_db_version' );

			global $post;
			$post    = get_post( $product_id, OBJECT );
			$results = setup_postdata( $post );

			bkap_load_scripts_class::bkap_load_products_css( $bkap_version );
			bkap_load_scripts_class::bkap_load_bkap_tab_css( $bkap_version );

			?>
			<div class="wcv_bkap_booking tabs-content" id="bkap_booking">
				<?php
				bkap_booking_box_class::bkap_meta_box();
				?>
				
			</div>
			<?php

			$ajax_url = get_admin_url() . 'admin-ajax.php';

			bkap_load_scripts_class::bkap_common_admin_scripts_js( $bkap_version );
			bkap_load_scripts_class::bkap_load_product_scripts_js( $bkap_version, $ajax_url );

			wp_register_script(
				'bkap-wcv',
				plugins_url() . '/woocommerce-booking/assets/js/vendors/wc-vendors/product.js',
				'',
				$bkap_version,
				true
			);

			wp_localize_script(
				'bkap-wcv',
				'bkap_wcv_params',
				array(
					'ajax_url' => $ajax_url,
					'post_id'  => $product_id,
				)
			);

			wp_enqueue_script( 'bkap-wcv' );

			wp_enqueue_style(
				'bkap-wcv-products',
				plugins_url() . '/woocommerce-booking/assets/css/vendors/wc-vendors/products.css',
				'',
				$bkap_version,
				false
			);

			wp_reset_postdata();
			?>

			<script type="text/javascript">
				jQuery(document).ready(function ( $ ) {
					$('.tstab-content').wrapInner('<div class="tstab-content-inner"></div>');
					$(document).on('click', '.tstab-tab', function(){
						data_link = $(this).data("link");
						cur_data_link = $('.tstab-tab.tstab-active').data("link");
						if ( cur_data_link !== data_link ) {
						$('.tstab-content').removeClass('tstab-active').hide();
						$("#"+data_link).addClass('tstab-active').css('position', 'relative').fadeIn('slow');
						$('.tstab-tab').removeClass('tstab-active');
						$(this).addClass('tstab-active');
						}
					});

					// Hide the Booking Resource checkbox
					jQuery( '.bkap_type_box' ).hide();
				});
			</script>

			<?php
		} else {
			?>
			<div class="wcv_bkap_booking tabs-content" id="bkap_booking"><?php _e( 'Please save the product once to make sure you can add the Booking Settings.', 'woocommerce-booking' ); ?></div>
			<?php
		}
	}


} // end of class
$bkap_wcv_product = new bkap_wcv_product();
?>
