<?php
/**
 * Bookings and Appointment Plugin for WooCommerce
 *
 * Bookings in Calendar View.
 *
 * @author   Tyche Softwares
 * @package  BKAP/Booking-Calendar-View
 * @since    1.7
 * @category Classes
 */

if ( ! class_exists( 'Bkap_Calendar_View' ) ) {
	exit();
}

/**
 * Class Bkap_Calendar_View.
 */
class Bkap_Calendar_View {

	/**
	 * This function will add the calendar div to load the Booking Calendar.
	 */
	public static function bkap_calendar_view_page() {

		if ( isset( $_GET['booking_view'] ) && 'booking_calender' === $_GET['booking_view'] ) {
			?>
			<h2><?php esc_html_e( 'Calendar View', 'woocommerce-booking' ); ?></h2>
			<div id="bkap_events_loader" style="font-size: medium;">
				<h4 style="text-align: center;">
					<?php esc_html_e( 'Loading Calendar Events....', 'woocommerce-booking' ); ?>
					<span><img src=<?php echo plugins_url() . '/woocommerce-booking/assets/images/ajax-loader.gif'; ?>></span>
				</h4>
			</div>
			<div id='bkap-calendar'></div>
			<?php
		}
	}

	/**
	 * Called during AJAX request for qtip content for a calendar item
	 *
	 * @since 2.0.0
	 */
	public static function bkap_booking_calender_content() {
		$content      = '';
		$date_formats = bkap_get_book_arrays( 'bkap_date_formats' );
		// get the global settings to find the date formats
		$global_settings = json_decode( get_option( 'woocommerce_booking_global_settings' ) );
		$date_format_set = $date_formats[ $global_settings->booking_date_format ];

		$order_txt     = __( 'Order:', 'woocommerce-booking' );
		$product_txt   = __( 'Product Name:', 'woocommerce-booking' );
		$customer_txt  = __( 'Customer Name: ', 'woocommerce-booking' );
		$qty_txt       = __( 'Quantity: ', 'woocommerce-booking' );
		$startdate_txt = __( 'Start Date: ', 'woocommerce-booking' );
		$enddate_txt   = __( 'End Date: ', 'woocommerce-booking' );
		$time_txt      = __( 'Time: ', 'woocommerce-booking' );
		$resource_txt  = __( 'Resource: ', 'woocommerce-booking' );

		if ( ! empty( $_REQUEST['order_id'] ) && ! empty( $_REQUEST['event_value'] ) ) {
			$order_id = $_REQUEST['order_id'];
			$order    = new WC_Order( $order_id );

			$order_items              = $order->get_items();
			$attribute_name           = '';
			$attribute_selected_value = '';

			if ( version_compare( WOOCOMMERCE_VERSION, '3.0.0' ) < 0 ) {
				$billing_first_name = $order->billing_first_name;
				$billing_last_name  = $order->billing_last_name;
			} else {
				$billing_first_name = $order->get_billing_first_name();
				$billing_last_name  = $order->get_billing_last_name();
			}

			$value[] = $_REQUEST['event_value'];

			$content = '<table>
												<tr> <td> <strong>' . $order_txt . '</strong></td><td><a href="post.php?post=' . $order_id . '&action=edit">#' . $order_id . ' </a> </td> </tr>
												<tr> <td> <strong>' . $product_txt . '</strong></td><td> ' . get_the_title( $value[0]['post_id'] ) . '</td> </tr>
												<tr> <td> <strong>' . $customer_txt . '</strong></td><td> ' . $billing_first_name . ' ' . $billing_last_name . '</td> </tr>
												';

			foreach ( $order_items as $item_id => $item ) {

				if ( $item['variation_id'] != '' && $value[0]['post_id'] == $item['product_id'] && $value[0]['order_item_id'] == $item_id ) {
					$variation_product              = get_post_meta( $item['product_id'] );
					$product_variation_array_string = $variation_product['_product_attributes'];
					$product_variation_array        = unserialize( $product_variation_array_string[0] );

					foreach ( $product_variation_array as $product_variation_key => $product_variation_value ) {
						if ( isset( $item[ $product_variation_key ] ) && '' !== $item[ $product_variation_key ] ) {

							$attribute_name           = $product_variation_value['name'];
							$attribute_selected_value = $item [ $product_variation_key ];
							$content                 .= ' <tr> <td> <strong>' . $attribute_name . ':</strong></td> <td> ' . $attribute_selected_value . '</td> </tr> ';
						}
					}
				}

				if ( $item['qty'] != '' && $value[0]['post_id'] == $item['product_id'] && $value[0]['order_item_id'] == $item_id ) {
					$content .= ' <tr> <td> <strong>' . $qty_txt . '</strong></td> <td> ' . $item['qty'] . '</td> </tr> ';
				}
			}
			if ( isset( $value[0]['start_date'] ) && $value[0]['start_date'] != '' ) {
				$value_date = $value[0]['start_date'];
				$content   .= ' <tr> <td> <strong>' . $startdate_txt . '</strong></td><td> ' . $value_date . '</td> </tr>';
			}

			if ( isset( $value[0]['end_date'] ) && $value[0]['end_date'] != '' ) {
				$value_end_date = $value[0]['end_date'];
				$content       .= ' <tr> <td> <strong>' . $enddate_txt . '</strong></td><td> ' . $value_end_date . '</td> </tr> ';
			}

			// Booking Time
			$time = '';
			if ( isset( $value[0]['from_time'] ) && $value[0]['from_time'] != '' && isset( $value[0]['to_time'] ) && $value[0]['to_time'] != '' ) {
				if ( $global_settings->booking_time_format == 12 ) {
					$to_time   = '';
					$from_time = date( 'h:i A', strtotime( $value[0]['from_time'] ) );
					$time      = $from_time;

					if ( isset( $value[0]['to_time'] ) && $value[0]['to_time'] != '' ) {
						$to_time = date( 'h:i A', strtotime( $value[0]['to_time'] ) );
						$time    = $from_time . ' - ' . $to_time;
					}
				} else {
					$time = $time = $value[0]['from_time'] . ' - ' . $value[0]['to_time'];
				}

				$content .= '<tr> <td> <strong>' . $time_txt . '</strong></td><td> ' . $time . '</td> </tr>';

			} elseif ( isset( $value[0]['from_time'] ) && $value[0]['from_time'] != '' ) {
				if ( $global_settings->booking_time_format == 12 ) {

					$to_time   = '';
					$from_time = date( 'h:i A', strtotime( $value[0]['from_time'] ) );
					$time      = $from_time . ' - Open-end';
				} else {
					$time = $time = $value[0]['from_time'] . ' - Open-end';
				}
				$content .= '<tr> <td> <strong>' . $time_txt . '</strong></td><td> ' . $time . '</td> </tr>';
			}

			if ( isset( $value[0]['resource'] ) && $value[0]['resource'] != '' ) {
				$value_resource = $value[0]['resource'];
				$content       .= ' <tr> <td> <strong>' . $resource_txt . '</strong></td><td> ' . $value_resource . '</td> </tr> ';
			}

			$content = apply_filters( 'bkap_display_additional_info_in_calendar_tip', $content, $value );

			$content .= '</table>';

			if ( $value[0]['post_id'] ) {
				$post_image = get_the_post_thumbnail( $value[0]['post_id'], array( 100, 100 ) );

				if ( ! empty( $post_image ) ) {
					$content = '<div style="float:left; margin:0px 5px 5px 0px; ">' . $post_image . '</div>' . $content;
				}
			}
		}

		echo $content;
		die();
	}
}
