<?php
/**
 * Bookings and Appointment Plugin for WooCommerce
 *
 * Handles the JSON output for bookings to be displayed in Calendar View for admin.
 *
 * @author   Tyche Softwares
 * @package  BKAP/Calendar
 */
$url    = dirname( __FILE__ );
$my_url = explode( 'wp-content', $url );
$path   = $my_url[0];

require_once $path . 'wp-load.php';
global $wpdb;

$booking_args = array(
	'posts_per_page'   => -1,
	'offset'           => 0,
	'orderby'          => 'date',
	'order'            => 'DESC',
	'post_type'        => 'bkap_booking',
	'post_status'      => array( 'paid', 'confirmed' ),
	'suppress_filters' => true,
);

if ( isset( $_GET['vendor_id'] ) ) {
	$booking_args['meta_key']   = '_bkap_vendor_id';
	$booking_args['meta_value'] = $_GET['vendor_id'];
	$vendor_id                  = isset( $_GET['vendor_id'] ) ? sanitize_text_field( wp_unslash( $_GET['vendor_id'] ) ) : 0; //phpcs:ignore
	$vendor_global_holidays     = ( $vendor_id > 0 ) ? get_user_meta( $vendor_id, '_bkap_vendor_holidays', true ) : array();
}

$bkap_posts_array = get_posts( $booking_args );

$data = array();

foreach ( $bkap_posts_array as $key => $value ) {

	$booking = new BKAP_Booking( $value->ID );

	$order = $booking->get_order();

	if ( false === $order ) {
		continue;
	}

	$order_status = $order->get_status();
	if ( isset( $order_status ) && ( $order_status != 'wc-cancelled' ) && ( $order_status != 'wc-refunded' ) && ( $order_status != 'trash' ) && ( $order_status != '' ) && ( $order_status != 'wc-failed' ) ) {

		$product = $booking->get_product();

		if ( false === $product ) {
			continue;
		}

		$product_name = $product_id = '';
		if ( isset( $product ) && $product !== '' && $product !== null ) {
			$product_name = html_entity_decode( $product->get_title(), ENT_COMPAT, 'UTF-8' );
			$product_id   = $product->get_id();
		}

		$user             = new WP_User( get_current_user_id() );
		$add_event        = 'YES';
		$booking_settings = get_post_meta( $product_id, 'woocommerce_booking_settings', true );
		if ( isset( $user->roles[0] ) && $user->roles[0] == 'tour_operator' ) {

			$add_event = 'NO';
			if ( isset( $booking_settings['booking_tour_operator'] ) && $booking_settings['booking_tour_operator'] == get_current_user_id() ) {
				$add_event = 'YES';
			}
		}
		if ( isset( $add_event ) && 'YES' == $add_event ) {

			$resource_title = '';
			if ( $booking->get_resource() != '' ) {
				$resource_title = $booking->get_resource_title();
			}

			$value = array(
				'order_id'      => $order->get_id(),
				'post_id'       => $product_id,
				'start_date'    => $booking->get_start_date(),
				'end_date'      => $booking->get_end_date(),
				'from_time'     => $booking->get_start_time(),
				'to_time'       => $booking->get_end_time(),
				'order_item_id' => $booking->get_item_id(),
				'resource'      => $resource_title,
			);

			$value        = apply_filters( 'bkap_additional_data_value_in_calendar_tip', $value, $booking );
			$product_name = apply_filters( 'bkap_product_name_calendar_title', $product_name, $booking );

			if ( $booking->get_start_time() != '' && $booking->get_end_time() != '' ) { // this condition is used for adding from and to time slots.

				$post_from_timestamp = strtotime( $booking->get_start() );
				$post_from_date      = date( 'Y-m-d H:i:s', $post_from_timestamp );

				$post_to_timestamp = strtotime( $booking->get_end() );
				$post_to_date      = date( 'Y-m-d H:i:s', $post_to_timestamp );

				array_push(
					$data,
					array(
						'id'    => $order->get_id(),
						'title' => $product_name,
						'start' => $post_from_date,
						'end'   => $post_to_date,
						'value' => $value,
					)
				);
			} elseif ( $booking->get_start_time() != '' ) { // this condition is used for adding only from time slots.
				$post_from_timestamp = strtotime( $booking->get_start() );
				$post_from_date      = date( 'Y-m-d H:i:s', $post_from_timestamp );

				$time    = strtotime( $booking->get_start() );
				$endTime = date( 'H:i', strtotime( '+30 minutes', $time ) );

				$post_to_timestamp = strtotime( $endTime );
				$post_to_date      = date( 'Y-m-d H:i:s', $post_to_timestamp );

				array_push(
					$data,
					array(
						'id'    => $order->get_id(),
						'title' => $product_name,
						'start' => $post_from_date,
						'end'   => $post_to_date,
						'value' => $value,
					)
				);
			} else {

				$start = strtotime( $booking->get_start() );
				$end   = strtotime( $booking->get_end() );

				if ( isset( $booking_settings['booking_charge_per_day'] ) && $booking_settings['booking_charge_per_day'] == 'on' ) {
					$end += ( 60 * 60 * 24 );
				}

				array_push(
					$data,
					array(
						'id'    => $order->get_id(),
						'title' => $product_name,
						'start' => date( 'Y-m-d', $start ),
						'end'   => date( 'Y-m-d', $end ),
						'value' => $value,
					)
				);
			}
		}
	}
}

if ( isset( $vendor_global_holidays ) && is_array( $vendor_global_holidays ) && count( $vendor_global_holidays ) > 0 ) {
	foreach ( $vendor_global_holidays as $holiday_data ) {

		$start       = date( 'Y-m-d', strtotime( $holiday_data['start'] ) ); //phpcs:ignore
		$end         = date( 'Y-m-d', strtotime( $holiday_data['end'] ) ); //phpcs:ignore
		$end_display = date( 'Y-m-d', strtotime( $holiday_data['end'] . '+1 day' ) ); //phpcs:ignore

		$value = array(
			'id'         => $holiday_data['id'],
			'start_date' => $start,
			'end_date'   => $end,
		);
		array_push(
			$data,
			array(
				'id'        => $holiday_data['id'],
				'title'     => $holiday_data['range_name'],
				'start'     => $start,
				'end'       => $end_display,
				'color'     => 'grey',
				'className' => 'nonbusiness',
				'value'     => $value,
			)
		);
	}
}
echo json_encode( $data );