function bkap_dokan_vendor_global_availability() {
		jQuery(".popup-overlay, .popup-content").addClass("active");
}

jQuery( document ).ready( function() {
	var global_settings = JSON.parse( bkap_dokan_localize_params.global_settings );
	
	jQuery( "#availability-start" ).datepicker({ 
		minDate: 0,
		firstDay: global_settings.booking_calendar_day,
		dateFormat: global_settings.booking_date_format
	});

	jQuery( "#availability-end" ).datepicker({
		minDate: 0,
		firstDay: global_settings.booking_calendar_day,
		dateFormat: global_settings.booking_date_format
	});

	// X icon & the Cancel button.
	jQuery(".availability-close, .bkap-dokan-avail-cancel").on("click", function() {

		// clear the fields
		jQuery( ".update-type" ).val( '' );
		jQuery( ".update-id" ).val();
		jQuery( "#availability-start" ).datepicker('setDate', '');
		jQuery( "#availability-end" ).datepicker('setDate', '');
		jQuery( ".title" ).val( '' );

		jQuery(".popup-overlay, .popup-content").removeClass("active");
	});

	// Event click on the calendar.
	jQuery( "#calendar" ).on( 'click', "a.nonbusiness", function() {
		// Update only the type. Popup fields will be populated using the event details in booking-calendar.js
		jQuery( ".update-type" ).val( 'edit' );
		jQuery(".popup-overlay, .popup-content").addClass("active");

	});

	// Delete button click
	jQuery( ".bkap-dokan-avail-delete" ).on( 'click', function() {

		var data = {
			id: jQuery( ".update-id" ).val(),
			action: 'bkap_dokan_vendor_global_availability_delete'
		};

		jQuery.post( bkap_dokan_localize_params.ajax_url, data, function( response ) {

			// clear the fields
			jQuery( ".update-type" ).val( '' );
			jQuery( ".update-id" ).val();
			jQuery( "#availability-start" ).datepicker('setDate', '');
			jQuery( "#availability-end" ).datepicker('setDate', '');
			jQuery( ".title" ).val( '' );

			// close the Popup.
			jQuery(".popup-overlay, .popup-content").removeClass("active");

			// Update the Calendar to reflect the changes.
			jQuery('#calendar').fullCalendar('refetchEvents');	
		});
	});

	// Save button click.
	jQuery( ".bkap-dokan-avail-save" ).on( "click", function() {

		var date_s = jQuery( "#availability-start" ).datepicker('getDate');
		var start_date = date_s.getDate() + "-" + ( date_s.getMonth() + 1 ) + "-" + date_s.getFullYear();

		var date_e = jQuery( "#availability-end" ).datepicker( 'getDate' );
		var end_date = date_e.getDate() + "-" + ( date_e.getMonth() + 1 ) + "-" + date_e.getFullYear();

		var title = jQuery( ".title" ).val();
		var data = {
			start_date: start_date,
			end_date: end_date,
			title: title,
			update_type: jQuery( ".update-type" ).val(),
			update_id: jQuery( ".update-id" ).val(),
			action: 'bkap_dokan_vendor_global_availability'
		};

		jQuery.post( bkap_dokan_localize_params.ajax_url, data, function( response ) {

			// clear the fields
			jQuery( ".update-type" ).val( '' );
			jQuery( ".update-id" ).val();
			jQuery( "#availability-start" ).datepicker('setDate', '');
			jQuery( "#availability-end" ).datepicker('setDate', '');
			jQuery( ".title" ).val( '' );

			// close the Popup.
			jQuery(".popup-overlay, .popup-content").removeClass("active");

			if( 'success' == response ) {
				// Update the Calendar to reflect the changes.
				jQuery('#calendar').fullCalendar('refetchEvents');	
			}

		} );
	})
});