// Global weekdays/dates & timeslot value for managing timeslot states.
var time_slot = {
  'row_number': 0,
  'booking_weekday': '',
  'from_time': '',
  'to_time': '',
  'max_lockout': '',
  'global_time_check': '',
  'global_toggle_btn': false,
  'product_price': '',
  'additional_note': ''
};

/**
 * This function validate the number field.
 * 
 * @function bkap_field_validation
 *
 * @since 5.8.0
 */
function bkap_field_validation( field, bkap_compare_value, bkap_field_name = '' ) {

  let bkap_field_value = 0;
  if ( '' != field.value ) {
    bkap_field_value = parseInt( field.value );
  }

  if ( bkap_field_value < bkap_compare_value ) {
    alert( bkap_field_name + ' can not be less than ' + bkap_compare_value + '!' );
    field.value = bkap_compare_value;
  }
}

/**
 * This function appends/removes the weekdays selected
 * in the Weekdays UI from the weekday list in the Date
 * & Time table
 *
 * @function append_weekdays
 *
 * @since 4.0
 */
function append_weekdays() {
  jQuery( "#set_weekdays" ).on( 'click', '[id^="booking_weekday_"]', function() {
      // Update the date/day selector for time slots 
    var id = this.id;
    var name = this.name;
      if ( jQuery( '#' + id ).prop( "checked" ) ) { // add the weekday
        
        // add the weekday in the default row
        jQuery( '#bkap_date_timeslot_table tr[id="bkap_default_date_time_row"]' ).each(function (i, row) {
          jQuery( '#bkap_dateday_selector' ).append( '<option value="' + id + '">' + name + '</option>' );
        });
        
        // add the weekday from the existing rows
        jQuery( '#bkap_date_timeslot_table tr[id^="bkap_date_time_row_"]' ).each(function (i, row) {
          var element_id = jQuery( this ).find( 'select[id^="bkap_dateday_selector_"]' ).prop( 'id' );
          element_id = '#' + element_id;
        
          // first check if the row is visible or no, if yes, then simply add the option value
          if ( jQuery( this ).is( ':visible' ) ) {
            jQuery( element_id ).append( '<option value="' + id + '">' + name + '</option>' );
          } else {
          
            // if not then it possible that the row was hidden as the weekday was disabled
            var weekday_selected = jQuery( element_id ).val();
            if ( weekday_selected == id ) {
            
              // if yes, then make the row visible again
              jQuery( this ).toggle();
            } else {
              jQuery( element_id ).append( '<option value="' + id + '">' + name + '</option>' );
            }
          
          }
        });
      } else { // remove the weekday
        
        // remove the weekday in the default row
        jQuery( '#bkap_date_timeslot_table tr[id="bkap_default_date_time_row"]' ).each(function (i, row) {
          var selector = '#bkap_dateday_selector option[value="' + id + '"]';
          jQuery( selector ).remove();
        });
      
        // remove the weekday from all the existing rows
        jQuery( '#bkap_date_timeslot_table tr[id^="bkap_date_time_row_"]' ).each(function (i, row) {
          var element_id = jQuery( this ).find( 'select[id^="bkap_dateday_selector_"]' ).prop( 'id' );
          element_id = '#' + element_id;
          
          // first check if the same weekday has been selected here
          var weekday_selected = jQuery( element_id ).val();
          
          // if yes then we need to hide that row
          if ( weekday_selected == id ) {
            jQuery( this ).hide();
          } else { // else simply remove the option from the drop down
            var selector = element_id + ' option[value="' + id + '"]';
              jQuery( selector ).remove();
          }
        });
      }
    });
}

/**
 * This function appends/removes the specific dates selected
 * in the Specific Dates Table from the Day/Date column in the 
 * Date & Time table
 *
 * @function append_specific_dates
 * 
 * @param {string} id - ID of the div to append specific dates
 * @param {string} value - specific dates values
 *
 * @since 4.0
 */
function append_specific_dates( id, value ) {
  
  if ( id != undefined && value != undefined ) {
    var specific_id_split   = id.split( '_' );
    var row_number      = specific_id_split[ 3 ];
    
    var range_id      = '#range_dropdown_' + row_number;
    var range_set       = jQuery( range_id ).val();
        
    if ( 'specific_dates' == range_set ) {
      
      var specific_dates  = value;
      
      if( specific_dates != "" ){ // If specific dates are blank in the textarea then don't check for adding dates
        
      var specific_list   = specific_dates.split( ',' );
      
      // loop through all the dates
      specific_list.forEach( function( date ) {
        
        // add the date in the default row
          jQuery( '#bkap_date_timeslot_table tr[id="bkap_default_date_time_row"]' ).each(function (i, row) {
            jQuery( '#bkap_dateday_selector' ).append( '<option value="' + date + '">' + date + '</option>' );
          });
          
          // add the date in the existing rows
        jQuery( '#bkap_date_timeslot_table tr[id^="bkap_date_time_row_"]' ).each(function (i, row) {
            
          var element_id  = jQuery( this ).find( 'select[id^="bkap_dateday_selector_"]' ).prop( 'id' );
            element_id    = '#' + element_id;
            var selector  = element_id + ' option[value=\'' + date + '\']';
            
            if ( jQuery( selector ).length == 0 ) { // check if the date is already present in the dropdown
              jQuery( element_id ).append( '<option value="' + date + '">' + date + '</option>' );
            } 
          });
      });
      }
      
      //To remove the date from the select2 dropdown if the date is unselected.
      
      var all_specific_datess = "";
      //run through each row and get all the dates in specific dates.
        jQuery( '.specific tr[class^="added_specific_date_range_row_"]' ).each(function (i, row) {
          var all_specific_dates    = jQuery( this ).find( 'select[id^="range_dropdown"]' ).val();
          var specific_dates_each_row = jQuery( this ).find( 'textarea[id*="specific_dates_multidatepicker"]' ).val();
          
          if( specific_dates_each_row != "" ){
            all_specific_datess += ","+specific_dates_each_row; 
          }
        });
        
        if( all_specific_datess != "" ){ // if there are no specific date then don't go for check for removing dates from select2 dropdown.
        
        var all_specific_datess_array = all_specific_datess.split( ',' );
        
        all_specific_datess_array.slice(1);
        
        var all_dates_in_select2_option = [];
        jQuery( "#bkap_dateday_selector > option" ).each( function(){
          var value = this.innerHTML;
          if( !isNaN( value.charAt(0) ) ){
            all_dates_in_select2_option.push( value );
          }
        });
        
        // Remove date from the option if not present.
        all_dates_in_select2_option.forEach( function( date1 ) {
           
          if( jQuery.inArray( date1, all_specific_datess_array ) == -1 ){
            // Remove the date in the default row.
            jQuery( '#bkap_date_timeslot_table tr[id="bkap_default_date_time_row"]' ).each(function (i, row) {
                jQuery( '#bkap_dateday_selector' ).find('option[value="'+date1+'"]').remove();
              });
            
            // Remove date from existing row
            jQuery( '#bkap_date_timeslot_table tr[id^="bkap_date_time_row"]' ).each( function (i, row) {
                var element_id = jQuery( this ).find( 'select[id^="bkap_dateday_selector_"]' ).prop( 'id' );
                element_id = '#' + element_id;
                jQuery(element_id).find('option[value="'+date1+'"]').remove();
                
              });
          }
        });
      
        }
      
    }
  } 
}

/** This function displays the Weekdays setup UI
 * It is called for multiple days
 *
 * @function bkap_add_weekdays
 * 
 * @since 4.0
 */
function bkap_add_weekdays() {
  
  jQuery( "#set_weekdays" ).css( "display", "block" );
  jQuery( ".weekdays_flex_child_3" ).css( "display", "none" );
  
}

/** This function will allow only numeric value
 *  in the time input of the date and time table.
 *
 * @function bkap_isNumberKey
 * 
 * @param {object} evt - Event Object
 * @returns {bool}
 * @since 4.0
 */
function bkap_isNumberKey( evt ){
    
  var charCode  = (evt.which) ? evt.which : evt.keyCode;
  var first     = [ 48, 49, 50 ];
  var second    = [ 48, 49, 50, 51 ];
  var third     = [ 48, 49, 50, 51, 52, 53 ];

  if ( evt.target.value.length == 1 && evt.target.value == 2 && second.indexOf( charCode ) == -1 )
    return false;

  if ( evt.target.value.length == 0 && first.indexOf( charCode ) == -1 )
    return false;

  if ( evt.target.value.length == 3 && third.indexOf( charCode ) == -1 )
    return false;
  
  if ( ( evt.target.value.length == 0 || evt.target.value.length == 1 || evt.target.value.length == 3 || evt.target.value.length == 4 ) && charCode == 58)
    return false;
  
  if ( evt.target.value.length == 2 && charCode != 58)
    return false;
  
  if ( charCode > 31 && ( charCode < 48 || charCode > 57 ) && charCode != 58 )
    return false;

  return true;
}

/**
 * This function displays the weekdays setup UI
 * for single days and date & time
 * 
 * @function bkap_add_weekdays_avail
 * 
 * @since 4.0
 */
function bkap_add_weekdays_avail() {
  
  jQuery( "#set_weekdays" ).css( "display", "block" );
  jQuery( ".weekdays_flex_child_3" ).css( "display", "block" );
}

/**
 * Gets the data for the general tab from the fields and 
 * creates & returns an array.
 *
 * @function bkap_get_general_tab_data
 * 
 * @returns {object} JSON Object containing Booking Options
 * @since 4.0
 */
function bkap_get_general_tab_data() {
  
  // General tab
  var booking_options = {};
  
  if ( jQuery( "#booking_enable_date" ).prop( "checked" ) ) {
    booking_options[ 'booking_enable_date' ] = jQuery( "#booking_enable_date" ).val();
  } else {
    booking_options[ 'booking_enable_date' ] = '';
  }

  var booking_type = jQuery( '#bkap-booking-type').val();

  booking_options[ 'booking_type' ] = booking_type;
  
  if ( typeof booking_options_additional == 'function' ) { 
    booking_options = booking_options_additional(booking_options); 
  }
  
  let multidates_type         = jQuery( '#bkap_multidates_fixed_range').val();
  let multidates_fixed_number = jQuery( '#bkap_multidates_fixed_number').val();
  let multidates_range_min    = jQuery( '#bkap_multidates_range_min').val();
  let multidates_range_max    = jQuery( '#bkap_multidates_range_max').val();

  booking_options[ 'multidates_type' ]         = multidates_type;
  booking_options[ 'multidates_fixed_number' ] = multidates_fixed_number;
  booking_options[ 'multidates_range_min' ]    = multidates_range_min;
  booking_options[ 'multidates_range_max' ]    = multidates_range_max;
  
  if ( jQuery( "#enable_inline_calendar" ).prop( "checked" ) ) {
    booking_options[ 'enable_inline' ] = jQuery( "#enable_inline_calendar" ).val();
  } else {
    booking_options[ 'enable_inline' ] = '';
  }
  
  if ( jQuery( "#booking_purchase_without_date" ).prop( "checked" ) ) {
    booking_options[ 'purchase_wo_date' ] = jQuery( "#booking_purchase_without_date" ).val();
  } else {
    booking_options[ 'purchase_wo_date' ] = '';
  }
  
  if ( jQuery( "#bkap_requires_confirmation" ).prop( "checked" ) ) {
    booking_options[ 'requires_confirmation' ] = jQuery( "#bkap_requires_confirmation" ).val();
  } else {
    booking_options[ 'requires_confirmation' ] = '';
  }

  /* POS Addon - Block single week  */
  if( jQuery( "#wkpbk_block_single_week" ).prop( "checked" ) ){
    booking_options[ 'wkpbk_block_single_week' ] = jQuery( "#wkpbk_block_single_week" ).val();  
    booking_options[ 'special_booking_start_weekday' ] = jQuery( "#special_booking_start_weekday" ).val();
    booking_options[ 'special_booking_end_weekday' ]   = jQuery( "#special_booking_end_weekday" ).val();

  }else {
    booking_options[ 'wkpbk_block_single_week' ] = '';
    booking_options[ 'special_booking_start_weekday' ] = '';
    booking_options[ 'special_booking_end_weekday' ]   = '';
    
  }

  /* Specific Dates Dropdown*/
  if ( jQuery( "#bkap_date_in_dropdown" ).prop( "checked" ) ) {
    booking_options[ 'bkap_date_in_dropdown' ] = jQuery( "#bkap_date_in_dropdown" ).val();
  } else {
    booking_options[ 'bkap_date_in_dropdown' ] = '';
  }
  
  return booking_options;
  
}

function bkap_get_only_day_type() {
  
  var only_day_type = jQuery( 'input:radio[name=booking_enable_only_day]:checked').val();

  var booking_type = 'only_day';
      
  if ( only_day_type != undefined ) {
    
    if( 'booking_enable_single_day' == only_day_type.trim() ) {
      booking_type = 'only_day';
    } else if ( 'booking_enable_multiple_days' == only_day_type.trim() ) {
      booking_type = 'multiple_days';
    }

  }

  return booking_type;
}

function bkap_get_date_and_time_type() {

  var date_time_type = jQuery( 'input:radio[name=booking_enable_date_time]:checked').val();
      
  booking_type = 'date_time';
  
  if ( date_time_type != undefined ) {
    
    if( 'booking_enable_fixed_time' == date_time_type.trim() ) {
      booking_type = 'date_time';
    } else if ( 'booking_enable_duration_time' == date_time_type.trim() ) {
      booking_type = 'duration_time';
    }

  }

  return booking_type;
}

/**
 * This function will save all the settings on
 * the General tab
 *
 * @function bkap_save_booking_options
 * 
 * @since 4.0
 */
function bkap_save_booking_options(){

  booking_options = bkap_get_general_tab_data();
  
  // setup the data
    var data = {
            booking_options: JSON.stringify( booking_options ),
            product_id: bkap_settings_params.post_id,
            action: 'bkap_save_settings'
    };
            
    jQuery.post( bkap_settings_params.ajax_url, data, function(response) {  
      // add a fade out message which informs the admin that the settings have been saved
      jQuery( '#general_update_notification' ).addClass( 'bkap_updated_notice' );
      jQuery( '#general_update_notification' ).css( 'display', 'block' );
      jQuery( '#general_update_notification' ).html( bkap_settings_params.general_update_msg ).fadeOut( 10000 );
    });
}

/**
 * This function will save all the settings on
 * the General tab
 *
 * @function bkap_save_booking_options
 * 
 * @since 4.0
 */
function bkap_save_resources(){

  resource_data = bkap_resource_data();

  // setup the data
    var data = {
      resource_data:    JSON.stringify( resource_data ),
      product_id: bkap_settings_params.post_id,
      action: 'bkap_save_settings'
    };
            
    jQuery.post( bkap_settings_params.ajax_url, data, function(response) {  
      // add a fade out message which informs the admin that the settings have been saved
      jQuery( '#resource_update_notification' ).addClass( 'bkap_updated_notice' );
      jQuery( '#resource_update_notification' ).css( 'display', 'block' );
      jQuery( '#resource_update_notification' ).html( bkap_settings_params.resource_update_msg ).fadeOut( 10000 );
    });
}

jQuery( document ).on( 'click', '#test_connection', function( e ) {
  e.preventDefault();
  var data = {
    gcal_api_test_result: '',
    gcal_api_pre_test: '',
    gcal_api_test: 1,
    user_id: bkap_settings_params.user_id,
    product_id: bkap_settings_params.post_id,
    action: 'display_nag'
  };
  jQuery( '#test_connection_ajax_loader' ).show();
  jQuery.post( bkap_settings_params.ajax_url, data, function( response ) {
    jQuery( '#test_connection_message' ).html( response );
    jQuery( '#test_connection_ajax_loader' ).hide();
  });
});

// add new ics feed
jQuery( document ).on( 'click', '#add_new_ics_feed', function () {
  var rowCount = parseInt( jQuery( '#product_ics_feed_list tr:last' ).prop( 'id' ) )  + 1;
  if ( isNaN( parseInt( rowCount ) ) ) {
    rowCount = 0;
  }
  jQuery( "#product_ics_feed_list" ).append( "<tr id='" + rowCount + "'><th></th><td class='ics_feed_url'><input type='text' id='product_ics_fee_url_" + rowCount + "' name='product_ics_fee_url_" + rowCount + "' size='40' value=''></td></tr>" );				
});

// delete an existing feed
jQuery( document ).on( 'click', 'input[type=\'button\'][name=\'delete_ics_feed\']', function () {
  var key = jQuery( this ).prop( 'id' );
  var data = {
    ics_feed_key: key,
    product_id: bkap_settings_params.post_id,
    action: 'bkap_delete_ics_url_feed'
  };
  jQuery.post( bkap_settings_params.ajax_url, data, function( response ) {
    if( response == 'yes' ) {
      jQuery( 'table#product_ics_feed_list tr#' + key ).remove();
    } 
  });
});

jQuery( document ).on( 'click', 'input[type=\'button\'][name=\'import_ics\']', function() {
  jQuery( '#import_event_message' ).show();
  var key = jQuery( this ).prop( 'id' );
  var data = {
    ics_feed_key: key,
    product_id: bkap_settings_params.post_id,
    action: 'bkap_import_events'
  };
  jQuery.post( bkap_settings_params.ajax_url, data, function( response ) {
    jQuery( '#import_event_message' ).hide();
    jQuery( '#success_message' ).html( response );  
    jQuery( '#success_message' ).fadeIn();
    setTimeout( function() {
      jQuery( '#success_message' ).fadeOut();
    },3000 );
  });
});

jQuery( document ).on( 'click', '#enable_automated_mapping', function () {

  if ( jQuery( '#enable_automated_mapping' ).prop( 'checked' ) ) {
    jQuery( '#gcal_default_variation' ).prop( 'disabled', false );
  } else {
    jQuery( '#gcal_default_variation' ).prop( 'disabled', true );
  }
});

var acc = document.getElementsByClassName("bkap-integrations-accordion");
var a;

for( a = 0; a < acc.length; a++ ) {
  acc[a].addEventListener( "click", function() {
    this.classList.toggle( "bkap-accordion-active" );
    var panel = this.nextElementSibling;
    if ( panel.style.display === "block" ) {
      panel.style.display = "none";
    } else {
      panel.style.display = "block";
    }
  });
}


/**
 * This function will get all the settings on
 * the Availability tab and return them as an array
 *
 * @function bkap_get_availability_data
 * 
 * @returns {object} JSON Object containing Booking Availability Data
 * @since 4.0
 */
function bkap_get_availability_data() {
  
  // settings tab
  var settings_data = {};
  
  settings_data[ 'abp' ]          = jQuery( "#booking_minimum_number_days" ).val();
  settings_data[ 'max_bookable' ] = jQuery( "#booking_maximum_number_days" ).val();
  
  if ( jQuery( "#booking_lockout_date" ).length > 0 ) {
    settings_data[ 'date_lockout' ] = jQuery( "#booking_lockout_date" ).val();
  }
  
  if ( jQuery( "#booking_minimum_number_days_multiple" ).length > 0 ) {
    settings_data[ 'min_days_multiple' ] = jQuery( "#booking_minimum_number_days_multiple" ).val();
  }
  
  if ( jQuery( "#booking_maximum_number_days_multiple" ).length > 0 ) {
    settings_data[ 'max_days_multiple' ] = jQuery( "#booking_maximum_number_days_multiple" ).val();
  }
  
  // all weekdays data   
  var all_weekdays  = jQuery('*[id^="booking_weekday_"]');
  var all_lockout   = jQuery('*[id^="weekday_lockout_"]');
  var all_price     = jQuery('*[id^="weekday_price_"]');
  
  for ( i=0; i <= 6; i++ ) {
    
    // weekdays
    var weekday_name = 'booking_weekday_' + i;
    
    if ( jQuery( all_weekdays[ i ] ).prop( "checked" ) ) {
      settings_data[ weekday_name ] = jQuery( all_weekdays[ i ] ).val();
    } else {
      settings_data[ weekday_name ] = '';
    }
    
    // lockout for each weekday
    var lockout_name = 'weekday_lockout_' + i;
    settings_data[ lockout_name ] = jQuery( all_lockout[ i ] ).val();
    
    // price for each weekday
    var price_name = 'weekday_price_' + i;
    settings_data[ price_name ] = jQuery( all_price[ i ] ).val();
  }

  var custom_range        = '';
  var specific_dates_list = '';
  var range_months        = '';
  var holidays_list       = '';
  var holiday_range       = '';
  
  if ( jQuery( '#specific_date_checkbox' ).prop( 'checked' ) ) {
    settings_data[ 'enable_specific' ] = jQuery( '#specific_date_checkbox' ).val();
  } else {
    settings_data[ 'enable_specific' ] = '';
  }
    
  //run through each row
  jQuery( '.specific tr[class^="added_specific_date_range_row_"]' ).each(function (i, row) {
    
    var range_set = jQuery(this).find( 'select[id^="range_dropdown"]' ).val();
    
    switch( range_set ) {
      
      case 'custom_range':
        
        var custom_start = jQuery( this ).find( 'input[class*="datepicker_start_date"]' ).val();
        var custom_end = jQuery( this ).find( 'input[class*="datepicker_end_date"]' ).val();
        
        if ( jQuery( this ).find( 'input[id*="bkap_bookable_nonbookable"]' ).prop( 'checked' ) ) {
          var booking_status = 'on';
        } else {
          var booking_status = '';
        }
        
        var recur_years = jQuery( this ).find( 'input[id*="bkap_number_of_year_to_recur_custom_range"]' ).val();
        
        if ( booking_status == 'on' ) {
          custom_range += custom_start + '+' + custom_end + '+' + recur_years + ';';
        } else {
          holiday_range += custom_start + '+' + custom_end + '+' + recur_years + '+' + range_set + ';';
        }
        
        break;
      
      case 'specific_dates':
        
        var specific_dates = jQuery( this ).find( 'textarea[id*="specific_dates_multidatepicker"]' ).val();
        if ( jQuery( this ).find( 'input[id*="bkap_bookable_nonbookable"]' ).prop( 'checked' ) ) {
          var booking_status = 'on';
        } else {
          var booking_status = '';
        }
        
        var lockout = jQuery( this ).find( 'input[id*="bkap_specific_date_lockout"]' ).val();
        var price = jQuery( this ).find( 'input[id*="bkap_specific_date_price"]' ).val();
        
        if ( booking_status == 'on' ) {
          specific_dates_list += specific_dates + '+' + lockout + '+' + price + ';';
        } else {
          holidays_list += specific_dates +  '+' + range_set + ';';
        }
        
        break;
      
      case 'range_of_months':
        
        var custom_start = jQuery( this ).find( 'select[id*="bkap_availability_from_month"]' ).val();
        var custom_end = jQuery( this ).find( 'select[id*="bkap_availability_to_month"]' ).val();
        if ( jQuery( this ).find( 'input[id*="bkap_bookable_nonbookable"]' ).prop( 'checked' ) ) {
          var booking_status = 'on';
        } else {
          var booking_status = '';
        }
        var recur_years = jQuery( this ).find( 'input[id*="bkap_number_of_year_to_recur_month"]' ).val();
        
         
        if ( booking_status == 'on' ) {
          range_months += custom_start + '+' + custom_end + '+' + recur_years + ';';
        } else {
          holiday_range += custom_start + '+' + custom_end + '+' + recur_years +  '+' + range_set + ';';
        }
        
        break;
      
      case 'holidays':
        
        var holidays = jQuery( this ).find( 'textarea[id*="holidays_multidatepicker"]' ).val();
        if ( jQuery( this ).find( 'input[id*="bkap_bookable_nonbookable"]' ).prop( 'checked' ) ) {
          var booking_status = 'on';
        } else {
          var booking_status = '';
        }
        
        var recur_years = jQuery( this ).find( 'input[id*="bkap_number_of_year_to_recur_holiday"]' ).val();
        
        if ( booking_status == 'on' ) {
          specific_dates_list += holidays + '+0' + ';';
        } else {
          holidays_list += holidays + '+' + recur_years +  '+' + range_set + ';';
        }
        
        break;
      
      default:
      break;
    }      
  }); 
    
  settings_data[ 'holidays_list' ]  = holidays_list;
  settings_data[ 'specific_list' ]  = specific_dates_list;
  settings_data[ 'month_range' ]    = range_months;
  settings_data[ 'custom_range' ]   = custom_range;
  settings_data[ 'holiday_range' ]  = holiday_range;

  //run through each row of the date time table
  var booking_times       = {}; 

  var time_type  = jQuery( '#bkap-booking-type').val();
  
  if ( time_type == "date_time" || time_type == "multidates_fixedtime"  ) {

    var j = 0;
    var datetimecheck = true;
    jQuery( '#bkap_date_timeslot_table tr[id^="bkap_date_time_row_"]' ).each(function (i, row) {

      var selector        = jQuery( this ).find( 'select[id^="bkap_dateday_selector_"]' ).val();
      var bkap_from_time  = jQuery( this ).find( 'input[id^="bkap_from_time_"]' ).val();

      if ( selector == "" || selector == null || bkap_from_time == "" || bkap_from_time == null ) {
        datetimecheck = false;
      }
      
      booking_times[j] = {};
      booking_times[j][ 'day' ]           = selector;

      booking_times[j][ 'from_time' ]     = jQuery( this ).find( 'input[id^="bkap_from_time_"]' ).val();        
      booking_times[j][ 'to_time' ]       = jQuery( this ).find( 'input[id^="bkap_to_time_"]' ).val();        
      booking_times[j][ 'lockout_slot' ]  = jQuery( this ).find( 'input[id^="bkap_lockout_time_"]' ).val();        
      booking_times[j][ 'slot_price' ]    = jQuery( this ).find( 'input[id^="bkap_price_time_"]' ).val();
      
      var global_check = '';
      if ( jQuery( this ).find( 'input[id*="bkap_global_time"]' ).prop( 'checked' ) ) {
        global_check = 'on';
      } 
      
      booking_times[j][ 'global_time_check' ] = global_check;        
      booking_times[j][ 'booking_notes' ]     = jQuery( this ).find( 'textarea[id^="bkap_note_time_"]' ).val();
      
      j++;

    });

    if ( !datetimecheck ) {
      return settings_data = { error : "datetime" };
    }

    jQuery( '.bkap_date_timeslot_div' ).trigger( 'bkap_added' );
    jQuery( '.bkap_date_timeslot_div' ).trigger( 'bkap_row_updated' );

    var bkap_data_toolbar = jQuery( '.bkap_date_timeslot_div' ).find( '.bkap_toolbar' );

    if ( undefined != bkap_data_toolbar.data( 'time-slots') ) {
      var bkap_time_slots   =  bkap_data_toolbar.attr( 'data-time-slots');

      var bkap_time_slots_parsing = JSON.parse( bkap_time_slots );
      /**
       * Count is greater than 4 because when we have empty object its minimum length will be 2. So more than that will make sure that we have a data.
       * @since: 4.5.0
       */
      if ( Object.keys( bkap_time_slots_parsing ).length > 0  ) {
          booking_times = bkap_time_slots_parsing;
      }
    }

    settings_data[ 'booking_times' ] = booking_times;

    if ( typeof bkapdt_settings_data == 'function' ) { 
      settings_data = bkapdt_settings_data( settings_data ); 
    }

  } else if ( time_type == "duration_time" ){
        
        var duration_times = {};

        var duration = duration_min = duration_max = 1;
        if ( jQuery( "#bkap_duration" ).val() != "" ) {
          duration = parseInt( jQuery( "#bkap_duration" ).val() );
        }
        if ( jQuery( "#bkap_duration_min" ).val() != "" ) {
          duration_min = parseInt( jQuery( "#bkap_duration_min" ).val() );
        }
        if ( jQuery( "#bkap_duration_max" ).val() != "" ) {
          duration_max = parseInt( jQuery( "#bkap_duration_max" ).val() );
        }
        
        duration_times[ 'duration_label' ]        = jQuery( "#bkap_duration_label" ).val();
        duration_times[ 'duration' ]              = duration;
        duration_times[ 'duration_min' ]          = duration_min;
        duration_times[ 'duration_max' ]          = duration_max;
        duration_times[ 'duration_max_booking' ]  = parseInt( jQuery( "#bkap_duration_max_booking" ).val() );
        duration_times[ 'duration_price' ]        = jQuery( "#bkap_duration_price" ).val();
        duration_times[ 'first_duration' ]        = jQuery( "#bkap_duration_start" ).val();
        duration_times[ 'end_duration' ]          = jQuery( "#bkap_duration_end" ).val();

        if ( jQuery( '#bkap_duration_type' ).length > 0 ) {
          duration_times[ 'duration_type' ] = jQuery( '#bkap_duration_type' ).val();
        }

        settings_data['duration_times']           = duration_times
  }

  if ( time_type == "date_time" || time_type == "multidates_fixedtime" || time_type == 'duration_time' ) {
    
    if ( jQuery( '#bkap_all_data_unavailable' ).prop( 'checked' ) ) {
      settings_data[ 'all_data_unavailable' ] = jQuery( '#bkap_all_data_unavailable' ).val();
    } else {
      settings_data[ 'all_data_unavailable' ] = '';
    }

    settings_data['manage_time_availability'] = bkap_mta_data();
  }

  return settings_data;
}

/**
 * Get Manage Time Availability Data
 *
 * @function bkap_mta_data
 * 
 * @returns {object} JSON Object containing Manage Time Availability Data
 * @since 5.9.0
 */
 function bkap_mta_data(){
  let bkap_mta = [];
  jQuery( '#bkap_availability_rows tr' ).each( function ( i, row ) {

    let bkap_mta_type       = jQuery( this ).find( 'select[name^="bkap_availability_type"]' ).val();
    let bkap_mta_bookable   = jQuery( this ).find( 'input[name^="bkap_availability_bookable_hidden"]' ).val();
    let bkap_mta_priority   = jQuery( this ).find( 'input[name^="bkap_availability_priority"]' ).val();
    let bkap_mta_from_date  = jQuery( this ).find( 'input[name^="bkap_availability_from_date"]' ).val();
    let bkap_mta_to_date    = jQuery( this ).find( 'input[name^="bkap_availability_to_date"]' ).val();

    bkap_mta[i]             = {};
    bkap_mta[i]['type']     = bkap_mta_type;
    bkap_mta[i]['bookable'] = bkap_mta_bookable;
    bkap_mta[i]['priority'] = bkap_mta_priority;

    switch ( bkap_mta_type ) {
      case 'custom':
       bkap_mta[i]['from']  = bkap_mta_from_date;
       bkap_mta[i]['to']    = bkap_mta_to_date;
        break;
      case 'months':
        bkap_mta[i]['from'] = jQuery( this ).find( 'select[name^="bkap_availability_from_month"]' ).val();
        bkap_mta[i]['to']   = jQuery( this ).find( 'select[name^="bkap_availability_to_month"]' ).val();
        break;
      case 'weeks':
        bkap_mta[i]['from'] = jQuery( this ).find( 'select[name^="bkap_availability_from_week"]' ).val();
        bkap_mta[i]['to']   = jQuery( this ).find( 'select[name^="bkap_availability_to_week"]' ).val();
        break;
      case 'days':
        bkap_mta[i]['from'] = jQuery( this ).find( 'select[name^="bkap_availability_from_day_of_week"]' ).val();
        bkap_mta[i]['to']   = jQuery( this ).find( 'select[name^="bkap_availability_to_day_of_week"]' ).val();
        break;
      case 'time':
      case 'time:1':
      case 'time:2':
      case 'time:3':
      case 'time:4':
      case 'time:5':
      case 'time:6':
      case 'time:0':
        bkap_mta[i]['from'] = jQuery( this ).find( 'input[name^="bkap_availability_from_time"]' ).val();
        bkap_mta[i]['to']   = jQuery( this ).find( 'input[name^="bkap_availability_to_time"]' ).val();
        break;

      case 'time:range':
        bkap_mta[i]['from']      = jQuery( this ).find( 'input[name^="bkap_availability_from_time"]' ).val();
        bkap_mta[i]['to']        = jQuery( this ).find( 'input[name^="bkap_availability_to_time"]' ).val();
        bkap_mta[i]['from_date'] = bkap_mta_from_date;
        bkap_mta[i]['to_date']   = bkap_mta_to_date;
        break;
      default:
        break;
    }
  });

  return bkap_mta;
 }

/**
 * Save the booking settings
 *
 * @function bkap_save_product_settings
 * 
 * @returns {object} JSON Object containing Booking Options
 * @since 4.6.0
 */
function bkap_save_product_settings(){
  
  booking_options   = bkap_get_general_tab_data();
  settings_data     = bkap_get_availability_data();
  gcal_settings     = bkap_get_gcal_data();
  fixed_block_data  = bkap_fixed_block_data();
  price_range_data  = bkap_price_range_data();
  resource_data     = bkap_resource_data();

  var error = {};
  if ( 'error' in settings_data ) {    
    error = { error : bkap_settings_params.error_input_field_msg };
  }

  var fixed_blocks_enable = '';
  var price_ranges_enable = '';
  var block_price         = '';
  var block_price     = jQuery( 'input:radio[name=bkap_enable_block_pricing_type]:checked').val();
  
  if( block_price != undefined ){
    if ( block_price.length > 0 && block_price == "booking_block_price_enable" ) {
      price_ranges_enable = block_price;
    }
    
    if ( block_price.length > 0 && block_price == "booking_fixed_block_enable" ) {
      fixed_blocks_enable = block_price;
    }
  }

  if ( 'error' in error ){
    return error;
  } else {
    // setup the data
    var data = {
      booking_options:  JSON.stringify( booking_options ),
      settings_data:    JSON.stringify( settings_data ),
      gcal_data:        JSON.stringify( gcal_settings ),
      ranges_enabled:   price_ranges_enable,
      blocks_enabled:   fixed_blocks_enable,
      fixed_block_data: JSON.stringify( fixed_block_data ),
      price_range_data: price_range_data,
      resource_data:    JSON.stringify( resource_data ),
      product_id:       bkap_settings_params.post_id,
      action:           'bkap_save_settings'
    };

    return data;
  }
}

/**
 * This function will save all the settings on
 * the Availability tab
 *
 * @function bkap_save_settings
 *
 * @since 4.0
 */
function bkap_save_settings() {
    
  settings_data = bkap_get_availability_data();

  if ( 'error' in settings_data ){
    // add a fade out message which informs the admin that the Availability have been saved
      jQuery( '#availability_update_notification' ).addClass( 'bkap_error_notice' );
      jQuery( '#availability_update_notification' ).css( 'display', 'block' );
      jQuery( '#availability_update_notification' ).html( bkap_settings_params.error_input_field_msg ).fadeOut( 10000 );
  } else {
  // setup the data
    var data = {
            settings_data:  JSON.stringify( settings_data ),
            product_id:     bkap_settings_params.post_id,
            action:         'bkap_save_settings'
    };

   jQuery.post( bkap_settings_params.ajax_url, data, function( response ) {

      // Readonly from time and to time fields once Save Button is clicked
      if(jQuery( '#bkap_date_timeslot_table tr[id^="bkap_date_time_row_"]' ).length != 0 ){
        jQuery( '#bkap_date_timeslot_table tr[id^="bkap_date_time_row_"]' ).each(function (i, row) {
          var from_id = jQuery( this ).find( 'input[id^="bkap_from_time_"]' ).prop( 'id' );
          from_id = '#' + from_id;
          
          jQuery(from_id).attr( 'readonly', 'readonly' );

          var to_id = jQuery( this ).find( 'input[id^="bkap_to_time_"]' ).prop( 'id' );
          to_id = '#' + to_id;
          
          jQuery(to_id).attr('readonly', 'readonly');

          var datedate_select = jQuery( this ).find( '[id^="bkap_dateday_selector_"]' ).prop( 'id' );
          datedate_select_id = '#' + datedate_select;
          
          jQuery(datedate_select_id).prop('disabled', 'disabled');
        });
      }

      // add a fade out message which informs the admin that the Availability have been saved
      jQuery( '#availability_update_notification' ).addClass( 'bkap_updated_notice' );
      jQuery( '#availability_update_notification' ).css( 'display', 'block' );
      jQuery( '#availability_update_notification' ).html( bkap_settings_params.availability_update_msg ).fadeOut( 10000 );
    });
  }    
}

/**
 * This function will save the settings on
 * the Fixed Blocks tab
 *
 * @function bkap_save_fixed_block_settings
 * 
 * @since 4.0
 */
function bkap_save_fixed_block_settings() {

  var fixed_blocks_enable = '';
  
  var block_price = jQuery( 'input:radio[name=bkap_enable_block_pricing_type]:checked').val();
  
  jQuery('.bkap_fixed_block_booking').removeClass('bkap_disable_block_pricing');
  
  jQuery('.bkap_fixed_block_booking').show();
  jQuery('.bkap_price_range_booking').hide();
  
  if ( block_price.length > 0 && block_price == "booking_fixed_block_enable" ) {
    fixed_blocks_enable = block_price;
  }

  if ( bkap_settings_params.post_id != 0 ) {
    // setup the data
    var data = {
            blocks_enabled: fixed_blocks_enable,
            product_id:     bkap_settings_params.post_id,
            action:         'bkap_save_settings'
    };

    jQuery.post( bkap_settings_params.ajax_url, data, function(response) {  
    });  
  }
}

/**
 * This function will save all the fixed blocks
 * added in the Fixed Booking Blocks table.
 *
 * @function bkap_save_fixed_blocks
 * 
 * @since 4.0
 */
function bkap_save_fixed_blocks() {

  var fixed_blocks_enable = '';
  var fixed_block_data  = bkap_fixed_block_data();
  
  if( !fixed_block_data ){
      return false;
  }
  
    var data = {
        fixed_block_data: JSON.stringify( fixed_block_data ),
            product_id: bkap_settings_params.post_id,
            action: 'bkap_save_settings'
    };
  
  jQuery.post( bkap_settings_params.ajax_url, data, function(response) {  
      // add a fade out message which informs the admin that the Availability have been saved
      jQuery( '#block_pricing_update_notification' ).addClass( 'bkap_updated_notice' );
      jQuery( '#block_pricing_update_notification' ).css( 'display', 'block' );
      jQuery( '#block_pricing_update_notification' ).html( bkap_block_pricing_params.save_fixed_blocks ).fadeOut( 10000 );
    });

}

/**
 * Populate Fixed Block Data
 *
 * @function bkap_fixed_block_data
 * 
 * @returns {mixed} JSON Object containing fixed block data else false
 *
 * @since 4.0.0
 */ 
function bkap_fixed_block_data(){
  
  var fixed_block_data    = {};
  var fixed_block_row_data  = '';
  var validate_field      = "";
  
  jQuery( '#bkap_fixed_block_booking_table tr[id^="bkap_fixed_block_row_"]' ).each( function ( i, row ) {
    
    var block_name          = jQuery( this ).find( 'input[id*="booking_block_name"]' ).val();
    var number_of_days        = jQuery( this ).find( 'input[id*="number_of_days"]' ).val();
    var start_day           = jQuery( this ).find( 'select[id*="start_day"]' ).val();
    var end_day           = jQuery( this ).find( 'select[id*="end_day"]' ).val();
    var price             = jQuery( this ).find( 'input[id*="fixed_block_price"]' ).val();
    var fixed_block_row_id      = this.id;
    var split_data = fixed_block_row_id.split( '_' );
      var fixed_block_row_id_number = split_data[ 4 ];
        
    if( block_name == "" ){
      alert("Block name must be filled out");
      validate_field = "FAILED";
          return false;
    }
    if( number_of_days == "" ){
      alert("Number of days must be filled out");
      validate_field = "FAILED";
          return false;
    }
    if( price == "" ){      
      alert("Price must be filled out");
      validate_field = "FAILED";
          return false;
    }
    
    fixed_block_row_data += block_name + '&&' + number_of_days + '&&' + start_day + '&&' + end_day + '&&' + price + '&&' + fixed_block_row_id_number + ';';   
  });
  
  fixed_block_data[ 'bkap_fixed_block_data' ] = fixed_block_row_data;
  
  if( validate_field == "FAILED" ){
    return false;
  }else{
    return fixed_block_data;
  }
  
}

/**
 * Save Price by Range data
 *
 * @function bkap_save_price_ranges
 * 
 * @since 4.0.0
 */
function bkap_save_price_ranges(){
  
  var price_range_enable  = '';
  var price_range_data    = bkap_price_range_data();
  
  if ( !price_range_data ) {
      return false;
  }
  
  var data = {
      price_range_data: price_range_data,
          product_id: bkap_settings_params.post_id,
          action: 'bkap_save_settings'
  };

  if ( bkap_settings_params.post_id != 0 ) {
    jQuery.post( bkap_settings_params.ajax_url, data, function(response) {  
      // add a fade out message which informs the admin that the Availability have been saved
      jQuery( '#block_pricing_update_notification' ).addClass( 'bkap_updated_notice' );
      jQuery( '#block_pricing_update_notification' ).css( 'display', 'block' );
      jQuery( '#block_pricing_update_notification' ).html( bkap_block_pricing_params.save_price_ranges ).fadeOut( 10000 );
    });
  }
}

/**
 * Get Price Range Data
 *
 * @function bkap_price_range_data
 * 
 * @returns {mixed} JSON Object containing Price Range Data else false
 * @since 4.1.0
 */
function bkap_price_range_data(){
  
  var price_range_data    = {};
  var price_range_row_data  = '';
  var validate_field      = "";
  
  var attribute_count = 0; 
  
  // Calculating new ID to assign new tr.
  jQuery( "tr#bkap_default_price_range_row > td select[id^='attribute_']" ).each( function(){
    attribute_count++;
  });
  
  jQuery( '#bkap_price_range_booking_table tr[id^="bkap_price_range_row_"]' ).each( function ( i, row ) {
    var attributes = "";
    var attribute_values = "";  
    if( attribute_count > 0 ){
      
      jQuery( "tr#"+this.id+" > td select[id^='attribute_']" ).each( function(){
        attribute_count++;
        
        var select_id = jQuery(this)[0].id;
        
        var select_new_id = "#"+select_id+" :selected ";
        
        var value = jQuery(select_new_id).val();
        attribute_values += value+"~~";
        
      });
      if( attribute_values.length > 0 ){
        //attribute_values = attribute_values.substring(0, attribute_values.length - 2);
      }
    }
    
    var min_number            = jQuery( this ).find( 'input[id*="number_of_start_days"]' ).val();
    var max_number            = jQuery( this ).find( 'input[id*="number_of_end_days"]' ).val();
    var per_day_price           = jQuery( this ).find( 'input[id*="per_day_price"]' ).val();
    var fixed_price           = jQuery( this ).find( 'input[id*="fixed_price"]' ).val();
    
    var price_range_row_id        = this.id;
    var split_data            = price_range_row_id.split( '_' );
      var price_range_row_id_number     = split_data[ 4 ];
    
    if( min_number == "" ){
      alert("Minimum Days must be filled out");
      validate_field = "FAILED";
          return false;
    }
    if( max_number == "" ){
      alert("Maximum Days must be filled out");
      validate_field = "FAILED";
          return false;
    }
    
    if( max_number != "" && min_number != "" ){
      if( parseInt(max_number) < parseInt(min_number) ){
        alert("Minimum days should be less than the Maximum days.");
        validate_field = "FAILED";
            return false;
      }
    }
    
    if( per_day_price == "" && fixed_price == "" ){     
      alert("Price must be filled out");
      validate_field = "FAILED";
          return false;
    }
    
    price_range_row_data += attribute_values + min_number + '~~' + max_number + '~~' + per_day_price + '~~' + fixed_price + '~~' + price_range_row_id_number + ';;';   
  });
  
  price_range_data = price_range_row_data;
  
  if( validate_field == "FAILED" ){
    return false;
  }else{
    return price_range_data;
  }
  
}

/**
 * This function get save the settings on
 * Resource tab
 *
 * @function bkap_resource_data
 *
 * @since 4.16.0
 */

function bkap_resource_data(){

  jQuery( '#_bkap_resource' ).val();

  var resource_data = {};
  
  if ( jQuery( '#_bkap_resource' ).prop( "checked" ) ) {
    resource_data[ '_bkap_resource' ] = jQuery( '#_bkap_resource' ).val();
  } else {
    resource_data[ '_bkap_resource' ] = '';
  }

  resource_data[ '_bkap_product_resource_lable' ]     = jQuery( '#bkap_product_resource_lable' ).val();
  resource_data[ '_bkap_product_resource_selection' ] = jQuery( '#bkap_product_resource_selection :selected' ).val();

  var resource_ids = [];
  var resource_costs = {};

  //run through each row
  jQuery( '.bkap_resource_info tr[class^="bkap_resource_row"]' ).each(function (i, row) {
    var resource_id   = jQuery( this ).find( 'input[name*="resource_id"]' ).val();
    var resource_cost = jQuery( this ).find( 'input[name*="resource_cost"]' ).val();

    if ( resource_cost == "" ) {
      resource_cost = 0;
    }

    resource_ids.push( resource_id );
    resource_costs[resource_id] = resource_cost;
          
  });

  resource_data[ '_bkap_product_resources' ]   = resource_ids;
  resource_data[ '_bkap_resource_base_costs' ] = resource_costs;

  return resource_data;
}


/**
 * This function will save the settings on
 * the Price tab
 *
 * @function bkap_save_price_by_range_settings
 *
 * @since 4.0
 */
function bkap_save_price_by_range_settings() {

  var price_ranges_enable = '';
  var block_price     = jQuery( 'input:radio[name=bkap_enable_block_pricing_type]:checked').val();
  
  
  jQuery('.bkap_price_range_booking').removeClass('bkap_disable_block_pricing');
  
  jQuery('.bkap_fixed_block_booking').hide();
  jQuery('.bkap_price_range_booking').show();
  
  if ( block_price.length > 0 && block_price == "booking_block_price_enable" ) {
    price_ranges_enable = block_price;
  }

  if ( bkap_settings_params.post_id != 0 ) {
    // setup the data
    var data = {
            ranges_enabled: price_ranges_enable,
            product_id: bkap_settings_params.post_id,
            action: 'bkap_save_settings'
    };

    jQuery.post( bkap_settings_params.ajax_url, data, function(response) {  
    });
  }
}

/**
 * This function will get the settings on
 * the Google Calendar tab and return an array
 *
 * @function bkap_get_gcal_data
 * 
 * @returns {object} JSON Object containing GCal Settings
 * @since 4.0
 */
function bkap_get_gcal_data() {

  var gcal_settings  = {};
  var gcal_sync_mode = jQuery( 'input:radio[name=product_sync_integration_mode]:checked').val();

  if ( gcal_sync_mode != undefined ) {
    gcal_settings[ 'gcal_sync_mode' ] = gcal_sync_mode.trim();
  }
  
  gcal_settings[ 'key_file_name' ]     = jQuery( '#product_sync_key_file_name' ).val();  
  gcal_settings[ 'service_acc_email' ] = jQuery( '#product_sync_service_acc_email_addr' ).val();  
  gcal_settings[ 'calendar_id' ]       = jQuery( '#product_sync_calendar_id' ).val();
  
  gcal_settings[ 'bkap_calendar_oauth_integration' ]                  = {};
  gcal_settings[ 'bkap_calendar_oauth_integration' ]['client_id']     = jQuery( '#product_authclient_id' ).val();
  gcal_settings[ 'bkap_calendar_oauth_integration' ]['client_secret'] = jQuery( '#product_authclient_secret' ).val();
  gcal_settings[ 'bkap_calendar_oauth_integration' ]['calendar_id']   = jQuery( '#product_authcalendar_id option:selected' ).val();
  
  if ( jQuery( "#enable_automated_mapping" ).prop( "checked" ) ) {
    gcal_settings[ 'gcal_auto_mapping'] = jQuery( "#enable_automated_mapping" ).val();
  } 
  
  if ( jQuery( '#gcal_default_variation' ).length > 0 ) {
    gcal_settings[ 'default_variation' ] = jQuery( '#gcal_default_variation' ).val();
  }
  
  for( var key = 0; ; key++ ) {
  
    var field_name = 'product_ics_fee_url_' + key;
    if ( jQuery( '#' + field_name ).length > 0 ) {
      gcal_settings[ 'ics_feed_url_' + key ] = jQuery( '#' + field_name ).val();
    } else {
      break;
    }
  }

  if ( typeof bkap_additional_integration_data == 'function' ) { 
    gcal_settings = bkap_additional_integration_data( gcal_settings ); 
  }

  if ( jQuery( "#enable_zoom_meeting" ).prop( "checked" ) ) {
    gcal_settings[ 'zoom_meeting'] = jQuery( "#enable_zoom_meeting" ).val();
  }

  if ( jQuery( "#bkap_zoom_meeting_host" ).length > 0 ) {      
      gcal_settings[ 'zoom_meeting_host'] = jQuery( "#bkap_zoom_meeting_host option:selected" ).val();
  }
  
  return gcal_settings;
}

/**
 * This function will save the settings on
 * the Google Calendar tab
 *
 * @function bkap_save_gcal_settings
 * 
 * @since 4.0
 */
function bkap_save_gcal_settings() {

  gcal_settings = bkap_get_gcal_data();
  
  // setup the data
    var data = {
            gcal_data: JSON.stringify( gcal_settings ),
            product_id: bkap_settings_params.post_id,
            action: 'bkap_save_settings'
    };

    jQuery.post( bkap_settings_params.ajax_url, data, function(response) {  
      // add a fade out message which informs the admin that the Availability have been saved
      jQuery( '#gcal_update_notification' ).addClass( 'bkap_updated_notice' );
      jQuery( '#gcal_update_notification' ).css( 'display', 'block' );
      jQuery( '#gcal_update_notification' ).html( bkap_settings_params.gcal_update_msg ).fadeOut( 10000 );
    });

}

jQuery( document ).ready( function () {
	

	  // JS actions for Resources start.

    // Type box.
    if ( jQuery( 'body' ).hasClass( 'wc-wp-version-gte-55' ) ) {
      jQuery( '.bkap_type_box' ).appendTo( '#woocommerce-booking .hndle' );
    } else {
      jQuery( '.bkap_type_box' ).appendTo( '#woocommerce-booking .hndle span' );
    }  

	  // Clicking on Single Day will hide Set Weekdays & Availability button and show Set Weekdays button
	  jQuery( "#_bkap_resource" ).click( function() {
	    //jQuery("#block_booking").removeAttr( "style" );

	      if ( jQuery( "#_bkap_resource" ).prop( "checked" ) == false){
	        jQuery("#resource_tab_settings").css( "display", "none" );
	        
	      }else{
	        jQuery("#resource_tab_settings").removeAttr( "style" );
	        
	      }
	  });

	  // Add a resource in the meta box
	  jQuery('#bkap_resource_section').on('click', 'button.bkap_add_resource', function(){
	    var loop              = jQuery('.bkap_resource_row').length;
	    var add_resource_id   = jQuery('select.bkap_add_resource_id').val();
	    var add_resource_name = '';

	    if ( ! add_resource_id ) {
	      add_resource_name = prompt( "Please enter resource name:" );

	      if ( ! add_resource_name ) {
	        return false;
	      }
	    }
	    
	    //jQuery( '.woocommerce_bookable_resources' ).block( { message: null } );

	    var data = {
	      action:            'bkap_add_resource',
	      post_id:           bkap_settings_params.post_id,
	      loop:              loop,
	      add_resource_id:   add_resource_id,
	      add_resource_name: add_resource_name,      
	    };

	    jQuery.post( bkap_settings_params.ajax_url, data, function( response ) {
	      if ( response.error ) {
	        alert( response.error );
	      } else {
	        jQuery( '.bkap_resource_info' ).append( response.html ).unblock();
	        
	        if ( add_resource_id ) {
	          jQuery( '.bkap_add_resource_id' ).find( 'option[value=' + add_resource_id + ']' ).remove();
	        }
	      }
	    });

	    return false;
	  });


    jQuery( document ).on( "click", "[id^=bkap_remove_resource]" , function() {

      var clicked_resource_id = jQuery(this)[0].id;       
      var split_data          = clicked_resource_id.split( '_' );
      var resource_id         = split_data[ 3 ];

      if ( resource_id == undefined ) {
        resource_id = 0;
        var y = confirm( bkap_resource_params.delete_resource_conf_all );
      }else{
        var y = confirm( bkap_resource_params.delete_resource_conf );
      }         
    
      if( y == true ) {
        var passed_id = bkap_settings_params.post_id;
        var data = {
          post_id: passed_id,
          delete_resource : resource_id,
          action: "bkap_delete_resource"
        };
        
        jQuery.ajax({
            url: bkap_settings_params.ajax_url,
            type: "POST",
            data : data,
            beforeSend: function() {
             //loading  

            },
            success: function( data, textStatus, xhr ) {

              if ( resource_id == 0 ) {
                jQuery('.bkap_resource_row').remove();
              }else{
                bkap_rr_id = "#"+clicked_resource_id;
                jQuery( bkap_rr_id ).parent().remove();
              }
            
              // add a fade out message which informs the admin that the settings have been saved
              jQuery( '#resource_update_notification' ).addClass( 'bkap_updated_notice' );
              jQuery( '#resource_update_notification' ).css( 'display', 'block' );
              jQuery( '#resource_update_notification' ).html( bkap_resource_params.delete_resource ).fadeOut( 5000 );
            },
            error: function( xhr, textStatus, errorThrown ) {
              // error status
            }
        });      
      }

    });

	  // JS actions for Resources end.

  // on change event for product type
  jQuery( '#product-type' ).on( 'change', function(){
    
    var product_type = jQuery( '#product-type' ).val();

    let allowed_type = [ 'simple', 'variable', 'subscription', 'variable-subscription' ];

    if ( jQuery.inArray( product_type, allowed_type ) != -1 ) {
      if ( jQuery( '#_bkap_resource' ).prop( "checked" ) ) {
        jQuery( '#resource_tab_settings' ).css( "display", "block" );
      }
    } else {
      jQuery( '#resource_tab_settings' ).css( "display", "none" );
    }

    if( 'grouped' == product_type ) {
      jQuery( '#bkap_gcal_msg' ).css( "display", "block" );
      jQuery( '#bkap_gcal_fields').prop( 'disabled', 'disabled' );
    } else {
      jQuery( '#bkap_gcal_msg' ).css( "display", "none" );
      jQuery( '#bkap_gcal_fields').prop( 'disabled', '' );      
    }
  });
  
  // save all the booking settings data when clicking on the Publish button
  jQuery( '#publish, #save-post' ).on( 'click', function( event ) {
    
    var data = bkap_save_product_settings();
    
    if ( 'error' in data ) {
      alert( data.error );
      return false;
    } else {
      jQuery.post( bkap_settings_params.ajax_url, data, function( response ) { 
      });
    }
  }); 

	/*
	 * Expand/Collapse rows in the Availability by Dates/Months table.
	 */
	jQuery( document ).on( 'click', '.bkap_expand_all', function() {
		jQuery( ".bkap_row_toggle" ).show();
		return false;
	})
	jQuery( document ).on( 'click', '.bkap_close_all', function() {
		jQuery( ".bkap_row_toggle" ).hide();
		return false;
	});
	
	/*
	 * Expand/Collapse rows in the Weekdays/Dates And It's Timeslots  table.
	 */
	jQuery( document ).on( 'click', '.bkap_time_expand_all', function() {
		jQuery( ".bkap_time_row_toggle" ).show();
		return false;
	})
	jQuery( document ).on( 'click', '.bkap_time_close_all', function() {
		jQuery( ".bkap_time_row_toggle" ).hide();
		return false;
	});
	
	/*
	 * Expand/Collapse rows in the Fixed Booking Blocks table.
	 */
	jQuery( document ).on( 'click', '.bkap_fixed_expand_all', function() {
		
		jQuery( ".bkap_fixed_row_toggle" ).show();
		return false;
	});
	jQuery( document ).on( 'click', '.bkap_fixed_close_all', function() {
		jQuery( ".bkap_fixed_row_toggle" ).hide();
		return false;
	});
	
	/*
	 * Expand/Collapse rows in the Fixed Booking Blocks table.
	 */
	jQuery( document ).on( 'click', '.bkap_price_range_expand_all', function() {
		
		jQuery( ".bkap_price_range_row_toggle" ).show();
		return false;
	});
	jQuery( document ).on( 'click', '.bkap_price_range_close_all', function() {
		jQuery( ".bkap_price_range_row_toggle" ).hide();
		return false;
	});	
	
	/**
	 * Below code will shows fields based on the hovered on the Booking Type.
	 */
	jQuery( "#bkap-booking-type" ).change( function() {
		let bkap_type = jQuery( this ).val();
		let bkap_msg  = '';
		switch( bkap_type ) {
			case 'only_day':
      case 'multidates':

				jQuery( ".multiple_days_setup" ).css( "display", "none" );
				jQuery( ".show-multiple-day-per-night-price-description" ).css( "display", "none" );
				jQuery( ".bkap_date_timeslot_div" ).css( "display", "none" );
				jQuery( ".bkap_duration_date_timeslot_div" ).css( "display", "none" );
				jQuery( "#bkap_time_duration_availability" ).css( "display", "none" );
				jQuery( "#block_booking_price" ).css( "display", "none" );
				jQuery( "#block_booking" ).css( "display", "none" );				
				jQuery( "input#specific_date_checkbox" ).removeAttr("title");
        jQuery( "#purchase_wo_date_section" ).removeAttr( "style" );
        bkap_add_weekdays_avail();
        
        if ( 'multidates' == bkap_type ) {
          jQuery( "#bkap_multidate_options" ).removeAttr( 'style' );
          bkap_msg = bkap_settings_params.multidates_text;
        } else {
          jQuery( '#bkap_multidate_options' ).css( 'display', 'none' );
          bkap_msg = bkap_settings_params.single_day_text;
        }
				break;
			case 'multiple_days':

				jQuery( ".show-multiple-day-per-night-price-description" ).html( "<b><i>" + bkap_settings_params.multiple_nights_price_text + "</i></b>" );
			
				// apply Select 2 when displaying records in Weekdays/Dates And It's Timeslots table.
				jQuery( ".show-multiple-day-per-night-price-description" ).removeAttr( "style" );
				jQuery( "#set_weekdays" ).css( "display", "none" );
				jQuery( ".bkap_date_timeslot_div" ).css( "display", "none" );
				jQuery( ".bkap_duration_date_timeslot_div" ).css( "display", "none" );
				jQuery( "#bkap_time_duration_availability" ).css( "display", "none" );
				
				jQuery("#block_booking_price").removeAttr( "style" );
				jQuery("#block_booking").removeAttr( "style" );
				jQuery("input#specific_date_checkbox").removeAttr("title");
				
        jQuery( ".multiple_days_setup" ).removeAttr( "style" );
        jQuery( '#bkap_multidate_options' ).css( 'display', 'none' );
				bkap_add_weekdays();
				
				bkap_msg = bkap_settings_params.multiple_nights_text;
				break;
			case 'date_time':
      case 'multidates_fixedtime':

				//Hide Fixed Block Booking and Price By Range tab when Date and Time option. 
				jQuery( "#block_booking" ).css( "display", "none" );
				jQuery( "#block_booking_price" ).css( "display", "none" );				
				bkap_add_weekdays_avail();
				// hide the multiple days setup fields in the Availability tab
				jQuery( ".multiple_days_setup" ).css( "display", "none" );
				// display the purchase without date setting in the General tab
				jQuery( "#purchase_wo_date_section" ).removeAttr( "style" );
				
				// Display day/date and timeslot table when Date and time type is enabled.
        jQuery( ".bkap_date_timeslot_div" ).removeAttr( "style" );
        jQuery( '#bkap_multidate_options' ).css( 'display', 'none' );
        append_weekdays();

				jQuery( "#bkap_time_duration_availability" ).removeAttr( "style" );
        
        if ( 'multidates_fixedtime' == bkap_type ) {
          jQuery( "#bkap_multidate_options" ).removeAttr( 'style' );
          bkap_msg = bkap_settings_params.multidates_fixedtime_text;
        } else {
          jQuery( '#bkap_multidate_options' ).css( 'display', 'none' );
          bkap_msg = bkap_settings_params.fixed_time_text;
        }
				
				break;
			case 'duration_time':

				jQuery( "#block_booking" ).css( "display", "none" );
				jQuery( "#block_booking_price" ).css( "display", "none" );				
				bkap_add_weekdays_avail();
				// hide the multiple days setup fields in the Availability tab
				jQuery( ".multiple_days_setup" ).css( "display", "none" );
				// display the purchase without date setting in the General tab
				jQuery( "#purchase_wo_date_section" ).removeAttr( "style" );
				jQuery( ".bkap_date_timeslot_div" ).css( "display", "none" );
				jQuery( ".bkap_duration_date_timeslot_div" ).removeAttr( "style" );
				jQuery( "#bkap_time_duration_availability" ).removeAttr( "style" );
        jQuery( '#bkap_multidate_options' ).css( 'display', 'none' );
        
				bkap_add_weekdays();
				
				bkap_msg = bkap_settings_params.duration_time_text;
				break;
			case 'multidates':
				bkap_msg = 'MultiDates';
				break;
			case 'multidates_fixedtime':
				jQuery( "#block_booking" ).css( "display", "none" );
        jQuery( "#block_booking_price" ).css( "display", "none" );
        jQuery( "#bkap_multidate_options" ).removeAttr( 'style' );        

				bkap_msg = 'MultiDatesFixed Time';
				break;	
		}

		jQuery( ".show-booking-day-description" ).removeAttr( "style" );
		jQuery( ".show-booking-day-description" ).html( "<b><i>" + bkap_msg + "</i></b>" );
  });
  
  jQuery( "#bkap_multidates_fixed_range" ).change( function() {
    let multidates_type = jQuery( this ).val();
    switch ( multidates_type ) {
      case 'fixed':
        jQuery( "#enable_multidate_fixed_section" ).removeAttr( 'style' );
        jQuery( "#enable_multidate_range_section" ).css( "display", "none" );
        break;
      case 'range':
        jQuery( "#enable_multidate_range_section" ).removeAttr( 'style' );
        jQuery( "#enable_multidate_fixed_section" ).css( "display", "none" );
        break;
    }
  });
  
	// If multiple day is enable then show Fixed and Range field in the Booking meta box header.			
	if ( jQuery( '#bkap-booking-type').val() == 'multiple_days' ){
		jQuery("#block_booking_price").removeAttr( "style" );
		jQuery("#block_booking").removeAttr( "style" ); // when adding new product the Block Pricing tab was always being displayed.		
	} else {
		jQuery("#block_booking_price").css( "display", "none" );
		jQuery("#block_booking").css( "display", "none" );
  }
  
  // on load of new product page show settigs based on single day.
  if ( jQuery( '#bkap-booking-type').val() == 'only_day' ){
    jQuery( ".multiple_days_setup" ).css( "display", "none" );
    jQuery( ".show-multiple-day-per-night-price-description" ).css( "display", "none" );
    jQuery( '#bkap_multidate_options' ).css( 'display', 'none' );
    bkap_add_weekdays_avail();
  }
	
	// apply Select 2 when displaying records in Weekdays/Dates And It's Timeslots table.
	if ( jQuery(".bkap_dateday_selector").length > 0 ) {
		jQuery(".bkap_dateday_selector").select2({
			allowClear: false,
			width: '100%',
		});
	}
	
	// Enable and disable lockout based on enable/disable weekday.	
	jQuery( document ).on( "click", "[id^=week_day_]" , function() {
		var week_id = lastChar = lock_id = weekday_id = "";
			week_id    = jQuery(this)[0].id;
			week_id        = "#"+week_id;
			lastChar   = week_id.slice(-1);
			lock_id    = "#weekday_lockout_"+lastChar;
		
			weekday_id = "#"+week_id+"[checked]";  
		
		if ( jQuery( week_id ).prop("checked") == false){
			jQuery( lock_id ).val("");
			jQuery(lock_id).prop("disabled", true);
		}else{
			jQuery( lock_id ).removeAttr( "disabled" );
		}
	});
	
	// Bkap box.
	jQuery( '.bkap_box' ).appendTo( '#woocommerce-booking .hndle span' );		
	
	jQuery( function() {
	// Prevent inputs in meta box headings opening/closing contents.
		jQuery( '#woocommerce-booking' ).find( '.hndle' ).unbind( 'click.postboxes' );

      jQuery( '#woocommerce-booking' ).on( 'click', '.hndle', function( event ) {

      // If the user clicks on some form input inside the h3 the box should not be toggled.
      if ( jQuery( event.target ).filter( 'input, option, label, select' ).length ) {
        return;
      }

      jQuery( '#woocommerce-booking' ).toggleClass( 'closed' );
    });
  });
    
    if( jQuery('#specific_date_checkbox').prop("checked") == false ){
    jQuery( ".specific_date" ).css( "display", "none" );
  }
    
    // Enable Specific dates
    jQuery('#specific_date_checkbox').click( function() {
      
      if(jQuery('#specific_date_checkbox').prop("checked") == true){
        jQuery( ".specific_date" ).removeAttr( "style" );
        }
        else if(jQuery('#specific_date_checkbox').prop("checked") == false){
        
          jQuery( ".specific_date" ).css( "display", "none" );
        }
      
      //var formats = ["d.m.y", "d-m-yyyy","MM d, yy"];
      //jQuery('textarea[id^="booking_specific_date_textarea"]').datepick({dateFormat: formats[1], multiSelect: 999, monthsToShow: 1, showTrigger: '#calImg'});
         
    });
    
    // This will add datepicker to the Start Date textbox.
    jQuery(".specific").on("focus","input.datepicker_start_date",function () {
      
      var from_start_date_id  = from_start_date_new_id = "";
        
      from_start_date_id    = jQuery(this)[0].id;
      from_start_date_new_id  = "#"+from_start_date_id;
        jQuery( from_start_date_new_id ).datepicker({
          minDate: 0,
          dateFormat: "d-m-yy"  
        });
          
    });
    
  // This will add datepicker to the End Date textbox.
    jQuery(".specific").on( "focus", "input.datepicker_end_date", function() {
      
      var to_end_date_id  = to_end_date_new_id = "";
        
      to_end_date_id    = jQuery(this)[0].id;
      to_end_date_new_id  = "#"+to_end_date_id;
        jQuery( to_end_date_new_id ).datepicker({
          minDate: 0,
          dateFormat: "d-m-yy"  
        });
          
    });
    
    // This will add multiple dates picker to the specific and holiday textarea.
    jQuery(".specific").on( "focus", "textarea", function() {
      
      var multiple_dates_specific_holiday_id  = multiple_dates_specific_holiday_new_id = "";
        
      multiple_dates_specific_holiday_id    = jQuery(this)[0].id;
      multiple_dates_specific_holiday_new_id  = "#"+multiple_dates_specific_holiday_id;
        multiple_dates_specific_holiday_value  = jQuery( multiple_dates_specific_holiday_new_id ).val();
      
        var formats               = ["d.m.y", "d-m-yyyy","MM d, yy"];
      jQuery( multiple_dates_specific_holiday_new_id ).datepick({
        minDate: new Date(), 
        dateFormat: formats[1], 
        multiSelect: 999, 
        monthsToShow: 1, 
        showTrigger: '#calImg',
        onClose: function() {
          
          append_specific_dates( multiple_dates_specific_holiday_id, multiple_dates_specific_holiday_value ); 
        }
      });
    });
    
    // Clicking on Calendar Image should populate the
    
    
    jQuery( ".specific" ).on( "click", "[id^=custom_check]",  function() {
      
      var custom_check_cal_id       = jQuery(this)[0].id;
      var spliting_custom_check_cal_id  = custom_check_cal_id.split( '_' );
      var custom_check_cal_id_number    = parseInt( spliting_custom_check_cal_id[3] );
      
      if( spliting_custom_check_cal_id[1] == "checkout" ){
          var custom_checkout_textbox_id = "#datepicker_textbox__"+custom_check_cal_id_number;
          jQuery(custom_checkout_textbox_id).focus();
      }else if ( spliting_custom_check_cal_id[1] == "checkin" ){
          var custom_checkin_textbox_id = "#datepicker_textbox_"+custom_check_cal_id_number;
          jQuery(custom_checkin_textbox_id).focus();
      }
    });
  
    
    jQuery( ".specific" ).on( "click", ".bkap_multiple_datepicker_cal_image",  function() {
      
      var multiple_datepicker_image_id      = jQuery(this)[0].id;
      var spliting_multiple_datepicker_image_id   = multiple_datepicker_image_id.split( '_' );
      
      if ( spliting_multiple_datepicker_image_id.length == 5 ){
        var multiple_datepicker_image_id_number   = parseInt( spliting_multiple_datepicker_image_id[4] );
      }else{
        var multiple_datepicker_image_id_number   = parseInt( spliting_multiple_datepicker_image_id[3] );
      }
      
      if( spliting_multiple_datepicker_image_id[0] == "specific" ){
        
          var specific_date_multidate_cal_id  = "#specific_dates_multidatepicker_"+multiple_datepicker_image_id_number;
          var specific_date_multidate_cal_value  = jQuery( specific_date_multidate_cal_id ).val();
          var formats             = ["d.m.y", "d-m-yyyy","MM d, yy"];
        
          jQuery( specific_date_multidate_cal_id ).datepick({
            minDate: new Date(), 
            dateFormat: formats[1], 
            multiSelect: 999, 
            monthsToShow: 1, 
            showTrigger: '#calImg',
            onClose: function() {
              append_specific_dates( specific_date_multidate_cal_id, specific_date_multidate_cal_value ); 
          }
          });

          jQuery( specific_date_multidate_cal_id ).focus();
          
      }else if ( spliting_multiple_datepicker_image_id[0] == "holiday" ){
        
          var holiday_multidate_cal_id  = "#holidays_multidatepicker_"+multiple_datepicker_image_id_number;
          var formats           = ["d.m.y", "d-m-yyyy","MM d, yy"];
        
          jQuery( holiday_multidate_cal_id ).datepick({minDate: new Date(), dateFormat: formats[1], multiSelect: 999, monthsToShow: 1, showTrigger: '#calImg'});
          jQuery( holiday_multidate_cal_id ).focus();
      }
      
    });

	var booking_type_radio = jQuery( '#bkap-booking-type').val();
console.log( booking_type_radio );
	if ( booking_type_radio != undefined && ( 'date_time' == booking_type_radio.trim() || 'duration_time' == booking_type_radio.trim() ) ) {
		append_weekdays();
	}
	// This will remove the tr from the specific date/month table when clicking on the delete button.
	
	jQuery( ".specific" ).on( "click", "[id^=bkap_close]",  function() {

    // place an ajax call to update the DB
      var id = this.id;
      
      var split_data = id.split( '_' );
      var row_number = split_data[ 2 ];

      var range_set = jQuery( '#range_dropdown_' + row_number ).val();
      var record_type = range_set;
      
      switch( range_set ) {
          case 'custom_range':
            var start = jQuery( '#datepicker_textbox_' + row_number ).val();
          var end = jQuery( '#datepicker_textbox__' + row_number ).val();
                if ( jQuery( '#bkap_bookable_nonbookable_' + row_number ).prop( 'checked' ) ) {
                } else {
                  record_type = 'holiday_range'; 
                }
                break;
          case 'range_of_months':
            var start_name = 'select[id="bkap_availability_from_month_' + row_number + '"]'
          var start = jQuery( start_name ).val();
            
            var end_name = 'select[id="bkap_availability_to_month_' + row_number + '"]'
          var end = jQuery( end_name ).val();
          if ( jQuery( '#bkap_bookable_nonbookable_' + row_number ).prop( 'checked' ) ) {
          } else {
            record_type = 'holiday_range';
          }
          break;
          case 'specific_dates':
            var start = jQuery( '#specific_dates_multidatepicker_' + row_number ).val();
            var end = '';
            break;
          case 'holidays':
            var start = jQuery( '#holidays_multidatepicker_' + row_number ).val();
            var end = '';
            break;
        default:
        break;
              
      }
      
      var data = {
          product_id: bkap_settings_params.post_id,
          record_type: record_type,
          start: start,
          end: end,
          action: 'bkap_delete_specific_range'
      };
      
      jQuery.post( bkap_settings_params.ajax_url, data, function(response) {
        jQuery( '.added_specific_date_range_row_' + row_number ).remove();
      });
    });
	
	// Update the global toggle switch.
    jQuery( ".bkap_date_timeslot_div" ).on( "click", '.bkap_switch>[id^=bkap_global_time]', function( e ) {
      var cur_elem_id  = this.id;
      var cur_elem_arr = cur_elem_id.split( '_' );
      var row_no       = cur_elem_arr[ 3 ];
      if( row_no == time_slot.row_number ) {
          time_slot.global_toggle_btn = true;
      }

    });  

    // This will edit the tr under the date and time table when clicking on the edit icon.
    jQuery( ".bkap_date_timeslot_div" ).on( "click", "[id^=bkap_edit]",  function( e ) {
        e.preventDefault();
        e.stopPropagation();
     
        // Disable edit action on other rows .
        jQuery( '.bkap_actions').each( function( e ) {
            var cur_elem_id  = this.id;
            var cur_elem_arr = cur_elem_id.split( '_' );
            var row_no       = cur_elem_arr[ 2 ];
            
            if ( 'undefined' !== row_no ) {
              jQuery('#bkap_actions_' + row_no ).html( '<a href="#" id="bkap_edit_' + row_no +'" class="bkap_edit_row"><i class="fa fa-edit" aria-hidden="true"></i></a><a href="#" id="bkap_close_' + row_no + '" class="bkap_delete_row"><i class="fa fa-trash" aria-hidden="true"></i></a>' ); 
              jQuery('#bkap_from_time_' + row_no ).attr( 'readonly', true );
              jQuery('#bkap_to_time_' + row_no ).attr( 'readonly', true );
            }
        });

        var id           = this.id;
        var split_data   = id.split( '_' );
        var row_number   = split_data[ 2 ];
        var from_time_id = '#bkap_from_time_' + row_number;
        var to_time_id   = '#bkap_to_time_' + row_number;

        to_time               = jQuery( '#bkap_to_time_' + row_number ).val();
        from_time             = jQuery( '#bkap_from_time_' + row_number ).val();
        var bkap_lockout_time = jQuery( '#bkap_lockout_time_' + row_number );
        var bkap_price_time   = jQuery( '#bkap_price_time_' + row_number );
        var bkap_global_time  = jQuery( '#bkap_global_time_' + row_number );
        var bkap_note_time    = jQuery( '#bkap_note_time_' + row_number );

        time_slot.row_number    = row_number;
        time_slot.from_time     = from_time;
        time_slot.to_time       = to_time;
        time_slot.max_lockout   = jQuery( '#bkap_lockout_time_' + row_number ).val();
        time_slot.product_price = jQuery( '#bkap_price_time_' + row_number ).val();
        if( jQuery( '#bkap_global_time_' + row_number ).prop( 'checked' ) ) {
          time_slot.global_time_check = 'on';
        }

        time_slot.additional_note = jQuery( '#bkap_note_time_' + row_number ).val();
        time_slot.booking_weekday = jQuery( '#bkap_dateday_selector_' + row_number ).val();

        jQuery( from_time_id ).attr( 'readonly', false );
        jQuery( to_time_id ).attr( 'readonly', false );
        jQuery('#bkap_actions_' + row_number ).html( '<a href="#" id="bkap_save_timeslot_' + row_number + '" class="bkap_save_timeslot"><i class="fa fa-check" aria-hidden="true"></i></a><a href="#" id="bkap_cancel_timeslot_' + row_number + '" class="bkap_cancel_timeslot"><i class="fa fa-times" aria-hidden="true"></i></a>' ); 

    });

    // Save the timeslot after editing.
    jQuery( ".bkap_date_timeslot_div" ).on( "click", "[id^=bkap_save_timeslot]",  function( e ) { 
        e.preventDefault();
        e.stopPropagation();
        var id         = this.id;
        var split_data = id.split( '_' );
        var row_number = split_data[ 3 ];
        var product_id = bkap_settings_params.post_id;
        
        //  Add new current timeslot values to the global `time_slot` object defined earlier.
        time_slot.cur_from_time       = jQuery( '#bkap_from_time_' + row_number ).val();
        time_slot.cur_to_time         = jQuery( '#bkap_to_time_' + row_number ).val();
        time_slot.cur_max_lockout     = jQuery( '#bkap_lockout_time_' + row_number ).val();
        if( jQuery( '#bkap_global_time_' + row_number ).prop( 'checked' ) ) {
          time_slot.cur_global_time_check = 'on';
        }

        time_slot.cur_product_price   = jQuery( '#bkap_price_time_' + row_number ).val();
        time_slot.cur_additional_note = jQuery( '#bkap_note_time_' + row_number ).val();
        time_slot.product_id          = bkap_settings_params.post_id;
        time_slot.action              = 'bkap_update_date_time_slot';

        // Hide the message container first, to remove old message from view.
        jQuery( '#availability_update_notification' ).css( 'display', 'none' );

        jQuery.post( bkap_settings_params.ajax_url, time_slot, function( response ) {
            jQuery( '#bkap_from_time_' + row_number ).attr( 'readonly', true );
            jQuery( '#bkap_to_time_' + row_number ).attr( 'readonly', true );
            jQuery('#bkap_actions_' + row_number ).html( '<a href="#" id="bkap_edit_' + row_number +'" class="bkap_edit_row"><i class="fa fa-edit" aria-hidden="true"></i></a><a href="#" id="bkap_close_' + row_number + '" class="bkap_delete_row"><i class="fa fa-trash" aria-hidden="true"></i></a>' );
            jQuery( '.bkap_date_timeslot_div' ).trigger( 'bkap_row_edited', [ row_number, 'edit' ] );
            // Add a fade out message which informs the admin that the timeslot has been updated.
            jQuery( '#availability_update_notification' ).addClass( 'bkap_updated_notice' );
            jQuery( '#availability_update_notification' ).css( 'display', 'block' );
            jQuery( '#availability_update_notification' ).html( response.message ).fadeOut( 10000 );

        });


    });

    // Reset the timeslot opened for editing to its default settings.
    jQuery( ".bkap_date_timeslot_div" ).on( "click", "[id^=bkap_cancel_timeslot]",  function( e ) {

      e.preventDefault();
      e.stopPropagation();
      var id           = this.id;
      var split_data   = id.split( '_' );
      var row_number   = split_data[ 3 ];
      var from_time_id = '#bkap_from_time_' + row_number;
      var to_time_id   = '#bkap_to_time_' + row_number;

      // Reset to the default value.
      jQuery( '#bkap_lockout_time_' + row_number ).val( time_slot.max_lockout );
      jQuery( '#bkap_price_time_' + row_number ).val( time_slot.product_price );
      jQuery( '#bkap_global_time_' + row_number ).val( time_slot.global_time );
      jQuery( '#bkap_note_time_' + row_number ).val( time_slot.additional_note );

      // Reset the global toggle switch button to initial state.
      if( true == time_slot.global_toggle_btn ) {
        jQuery('#bkap_global_time_'+ row_number ).trigger( 'click' );
      }

      jQuery( from_time_id ).val( time_slot.from_time ).attr( 'readonly', true );
      jQuery( to_time_id ).val( time_slot.to_time ).attr( 'readonly', true );

      jQuery('#bkap_actions_' + row_number ).html( '<a href="#" id="bkap_edit_' + row_number +'" class="bkap_edit_row"><i class="fa fa-edit" aria-hidden="true"></i></a><a href="#" id="bkap_close_' + row_number + '" class="bkap_delete_row"><i class="fa fa-trash" aria-hidden="true"></i></a>' );

    });

  
    // This will remove the tr from the date and time table when clicking on the delete button.
    jQuery( ".bkap_date_timeslot_div" ).on( "click", "[id^=bkap_close]",  function( e ) {
      e.preventDefault();
      e.stopPropagation();
      bkap_time_slots_meta_box_ajax.bkap_block();
      var id           = this.id;
      var split_data   = id.split( '_' );
      var row_number   = split_data[ 2 ];      
      var day_id       = '#bkap_dateday_selector_' + row_number;
      var from_time_id = '#bkap_from_time_' + row_number;
      var to_time_id   = '#bkap_to_time_' + row_number;
      
      var day          = jQuery( day_id ).val();
      var from_time    = jQuery( from_time_id ).val();
      var to_time      = jQuery( to_time_id ).val();
      
      var data = {
        product_id: bkap_settings_params.post_id,
        day: day,
        from_time: from_time,
        to_time: to_time,
        action: 'bkap_delete_date_time'
      };
      
      jQuery.post( bkap_settings_params.ajax_url, data, function(response) {  
        jQuery( '#bkap_date_time_row_' + row_number ).remove();
        jQuery( '.bkap_date_timeslot_div' ).trigger( 'bkap_row_deleted', [ row_number, 'delete' ] );
        bkap_time_slots_meta_box_ajax.unblock();
      });
    });

    jQuery( ".bkap_date_timeslot_div" ).on( "click", "[id^=bkap_remove_all_timeslots]",  function() {
      
      var available_timeslots = jQuery( '#bkap_date_timeslot_table tr[id^="bkap_date_time_row"]' ).length;
      
      if ( available_timeslots > 0 ) {
        var y = confirm( bkap_settings_params.confirm_delete_all_timeslots );
        if ( y == true ) {
          bkap_time_slots_meta_box_ajax.bkap_block();
        
          var data = {
            product_id: bkap_settings_params.post_id,
            action: 'bkap_delete_all_date_time'
          };
          
          jQuery.post( bkap_settings_params.ajax_url, data, function(response) { 
            jQuery( '#bkap_date_timeslot_table tr[id^="bkap_date_time_row"]' ).each(function (i, row) {
              jQuery( this ).remove();
            });
            jQuery( '.bkap_date_timeslot_div' ).trigger( 'bkap_all_row_deleted' );
            bkap_time_slots_meta_box_ajax.unblock();
            jQuery( '#availability_update_notification' ).addClass( 'bkap_updated_notice' );
            jQuery( '#availability_update_notification' ).css( 'display', 'block' );
            jQuery( '#availability_update_notification' ).html( bkap_settings_params.success_delete_all_timeslots ).fadeOut( 10000 );
          });
        }
      } else {
        alert( bkap_settings_params.no_timeslots_available );
      }
    });
    
    // This will add new row in SET AVAILABILITY BY DATE/MONTHS table
  jQuery( ".bkap_add_new_range" ).on( "click" , function() {
    var each_row    = new Array();
    var i         = 0;
    var last_class_name = "";
    
    
    // Calculating new ID to assign new tr.
    jQuery( "tr[class^='added_specific_date_range_row']" ).each( function(){
      
      var class_name_row  = jQuery(this)[0].className;
      last_class_name = class_name_row;
      var res = class_name_row.replace("added_specific_date_range_row_", "");
      
      if( res == class_name_row && each_row.length == 0){
        each_row[i] = 1;
      }else{
        each_row[i] = parseInt(res);
      }
      i++;
    
    });
    
    if( isNaN( each_row[0] ) ){
      each_row.shift();
    }
    var max = Math.max.apply(Math,each_row);
    var new_id = max + 1;
    
    
    
    // This will written complete tr element.
    var tr = jQuery(".added_specific_date_range_row")[0].outerHTML; // This will written complete tr element.
    // Removing style and giving new id to the tr
    var new_tr = tr.replace("class=\"added_specific_date_range_row\" style=\"display: none;\"", "class=\"added_specific_date_range_row_"+new_id+"\"");
    
    // Changing id of elements with the new one.
    new_tr = new_tr.replace( "id=\"datepicker_textbox1\""         , "id=\"datepicker_textbox_"+new_id+"\"" ); 
    new_tr = new_tr.replace( "id=\"datepicker_textbox2\""         , "id=\"datepicker_textbox__"+new_id+"\"" ); 
    
    new_tr = new_tr.replace( "id=\"range_dropdown\""          , "id=\"range_dropdown_"+new_id+"\"" );
    new_tr = new_tr.replace( "id=\"textareamultidate_cal1\""      , "id=\"specific_dates_multidatepicker_"+new_id+"\"" );
    new_tr = new_tr.replace( "id=\"textareamultidate_cal2\""      , "id=\"holidays_multidatepicker_"+new_id+"\"" );
    
    new_tr = new_tr.replace( "id=\"bkap_availability_from_month\""    , "id=\"bkap_availability_from_month_"+new_id+"\"" );
    new_tr = new_tr.replace( "id=\"bkap_booking_availability_to_month\"", "id=\"bkap_booking_availability_to_month_"+new_id+"\"" );
    
    new_tr = new_tr.replace( "id=\"custom_checkin_cal\""        , "id=\"custom_checkin_cal_"+new_id+"\"" );
    new_tr = new_tr.replace( "id=\"custom_checkout_cal\""       , "id=\"custom_checkout_cal_"+new_id+"\"" );
    
    new_tr = new_tr.replace( "id=\"month_checkin_cal\""         , "id=\"month_checkin_cal_"+new_id+"\"" );
    new_tr = new_tr.replace( "id=\"month_checkout_cal\""        , "id=\"month_checkout_cal_"+new_id+"\"" );
    
    new_tr = new_tr.replace( "id=\"specific_date_multidate_cal\""   , "id=\"specific_date_multidate_cal_"+new_id+"\"" );
    new_tr = new_tr.replace( "id=\"holiday_multidate_cal\""       , "id=\"holiday_multidate_cal_"+new_id+"\"" );
    
    new_tr = new_tr.replace( "id=\"bkap_bookable_nonbookable\""     , "id=\"bkap_bookable_nonbookable_"+new_id+"\"" );
    new_tr = new_tr.replace( "id=\"bkap_close\""            , "id=\"bkap_close_"+new_id+"\"" );
    new_tr = new_tr.replace( "id=\"bkap_myPopup\""            , "id=\"bkap_myPopup_"+new_id+"\"" );
    
    // changing the id of defauld fields for Lockout column to new ID.
    
    new_tr = new_tr.replace( "id=\"bkap_number_of_year_to_recur_custom_range\"" , "id=\"bkap_number_of_year_to_recur_custom_range_"+new_id+"\"" );
    new_tr = new_tr.replace( "id=\"bkap_number_of_year_to_recur_holiday\""    , "id=\"bkap_number_of_year_to_recur_holiday_"+new_id+"\"" );
    new_tr = new_tr.replace( "id=\"bkap_number_of_year_to_recur_month\""    , "id=\"bkap_number_of_year_to_recur_month_"+new_id+"\"" );
    new_tr = new_tr.replace( "id=\"bkap_specific_date_lockout\""        , "id=\"bkap_specific_date_lockout_"+new_id+"\"" );
    new_tr = new_tr.replace( "id=\"bkap_specific_date_price\""          , "id=\"bkap_specific_date_price_"+new_id+"\"" );
    
    last_class_name = last_class_name.replace(" bkap_row_toggle", "");
    var last_class_name_new = "."+last_class_name;
    
    jQuery( last_class_name_new ).after(new_tr);
  });
  
  // This will add new row in SET DATE/DAYS and TIMESLOT table
  
  jQuery( ".bkap_add_new_date_time_range" ).on( "click" , function() {
    
    var each_row_time     = [];
    var i_time        = 0;
    var last_class_name_time = "bkap_default_date_time_row";
    
    
    // Calculating new ID to assign new tr.
    jQuery( "tr[id^='bkap_date_time_row']" ).each( function(){
      
      var class_name_row_time  = jQuery(this)[0].id;
      
      last_class_name_time = class_name_row_time;
      
      //bkap_date_time_row_1
      
      var res = class_name_row_time.replace("bkap_date_time_row_", "");
      
      if( res == class_name_row_time && each_row_time.length == 0){
        each_row_time[i_time] = 1;
      }else{
        each_row_time[i_time] = parseInt(res);
      }
      i_time++;
    
    });

    if( each_row_time.length == 0 ){
      each_row_time[i_time] = 1;
    }
    if( isNaN( each_row_time[0] ) ){
      each_row_time.shift();
    }
    var max_time = Math.max.apply(Math,each_row_time);
    var new_id_time = max_time + 1;
    
    // This will written complete tr element.
    var time_tr = jQuery("#bkap_default_date_time_row")[0].outerHTML; // This will written complete tr element.
    // Removing style and giving new id to the tr
    var new_time_tr = time_tr.replace('id="bkap_default_date_time_row" style="display: none;"', 'id="bkap_date_time_row_'+new_id_time+'" class="bkap_added"');
    
    // Changing the id of elements with new one.
    new_time_tr = new_time_tr.replace("id=\"bkap_dateday_selector\"",   "id=\"bkap_dateday_selector_"+new_id_time+"\"");
    new_time_tr = new_time_tr.replace("id=\"bkap_from_time\"",      "id=\"bkap_from_time_"+new_id_time+"\"");
    new_time_tr = new_time_tr.replace("id=\"bkap_to_time\"",      "id=\"bkap_to_time_"+new_id_time+"\"");
    new_time_tr = new_time_tr.replace("id=\"bkap_lockout_time\"",     "id=\"bkap_lockout_time_"+new_id_time+"\"");
    new_time_tr = new_time_tr.replace("id=\"bkap_price_time\"",     "id=\"bkap_price_time_"+new_id_time+"\"");
    new_time_tr = new_time_tr.replace("id=\"bkap_global_time\"",    "id=\"bkap_global_time_"+new_id_time+"\"");
    new_time_tr = new_time_tr.replace("id=\"bkap_note_time\"",      "id=\"bkap_note_time_"+new_id_time+"\"");
    //var new_time_tr = time_tr.replace("id=\"bkap_default_date_time_row\" style=\"display:none\"", "id=\"bkap_date_time_row_"+new_id_time+"\"");
    new_time_tr = new_time_tr.replace( "id=\"bkap_close\"",       "id=\"bkap_close_"+new_id_time+"\"" );
    new_time_tr = new_time_tr.replace( "id=\"bkap_edit\"",       "id=\"bkap_edit_"+new_id_time+"\"" );

    var last_class_name_time_new = "#"+last_class_name_time;

    // Close the earlier timeslot opened for editing.
    jQuery('#bkap_actions_' + time_slot.row_number ).html( '<a href="#" id="bkap_edit_' + time_slot.row_number +'" class="bkap_edit_row"><i class="fa fa-edit" aria-hidden="true"></i></a><a href="#" id="bkap_close_' + time_slot.row_number + '" class="bkap_delete_row"><i class="fa fa-trash" aria-hidden="true"></i></a>' );

    jQuery( last_class_name_time_new ).after(new_time_tr);
    
    jQuery( document ).find( '#bkap_dateday_selector_' + new_id_time ).select2({width:'100%'});
  });
  
  
  // This will add new row in Fixed Block Booking table
  
  jQuery( ".bkap_add_new_fixed_block" ).on( "click" , function() {
    
    var each_fixed_block      = new Array();
    var i_fixed_bock        = 0;
    var last_class_name_fixed_block = "bkap_default_fixed_block_row";
    
    
    // Calculating new ID to assign new tr.
    jQuery( "tr[id^='bkap_fixed_block_row']" ).each( function(){
      
      var id_of_fixed_block_row   = jQuery(this)[0].id;
      
      last_class_name_fixed_block = id_of_fixed_block_row;
      var res           = id_of_fixed_block_row.replace("bkap_fixed_block_row_", "");
      
      if( res == id_of_fixed_block_row && each_fixed_block.length == 0){
        each_fixed_block[i_fixed_bock] = 0;
      }else{
        each_fixed_block[i_fixed_bock] = parseInt(res);
      }
      i_fixed_bock++;
    
    });
    
    if( each_fixed_block.length == 0 ){
      var new_id_fixed_block = 0;
      //each_fixed_block[i_fixed_bock] = 0;
    }else{
      if( isNaN( each_fixed_block[0] ) ){
        each_fixed_block.shift();
      }
      
      var max_fixed_block = Math.max.apply(Math,each_fixed_block);
      var new_id_fixed_block = max_fixed_block+1;
      
    }
    
    
    // This will written complete tr element.
    var time_tr = jQuery("#bkap_default_fixed_block_row")[0].outerHTML; // This will written complete tr element.
    // Removing style and giving new id to the tr
    var new_time_tr = time_tr.replace("id=\"bkap_default_fixed_block_row\" style=\"display: none;\"", "id=\"bkap_fixed_block_row_"+new_id_fixed_block+"\"");
    
    // Changing the id of elements with new one.
    new_time_tr = new_time_tr.replace("id=\"booking_block_name\"",  "id=\"booking_block_name_"+new_id_fixed_block+"\"");
    new_time_tr = new_time_tr.replace("id=\"number_of_days\"",    "id=\"number_of_days_"+new_id_fixed_block+"\"");
    new_time_tr = new_time_tr.replace("id=\"start_day\"",       "id=\"start_day_"+new_id_fixed_block+"\"");
    new_time_tr = new_time_tr.replace("id=\"end_day\"",       "id=\"end_day_"+new_id_fixed_block+"\"");
    new_time_tr = new_time_tr.replace("id=\"fixed_block_price\"",   "id=\"fixed_block_price_"+new_id_fixed_block+"\"");
    new_time_tr = new_time_tr.replace("id=\"bkap_fixed_block_close\"",      "id=\"bkap_fixed_block_close_"+new_id_fixed_block+"\"" );
    
    var last_class_name_fixed_block_new = "#"+last_class_name_fixed_block;
    
    jQuery( last_class_name_fixed_block_new ).after(new_time_tr);
  });

  /*
  * This is to delete all fixed booking block.
  */
  
  jQuery( ".bkap_remove_all_fixed_blocks" ).on( "click" , function() {
    var y = confirm( bkap_block_pricing_params.confirm_delete_all_fixed_blocks );
    
    var available_fixed_block_row = jQuery( '#bkap_fixed_block_booking_table tr[id^="bkap_fixed_block_row_"]' ).length;
    
    if( y == true && available_fixed_block_row > 0 ) {
      
      var passed_id = bkap_settings_params.post_id;
      var data = {
        post_id: passed_id, 
        action: "bkap_delete_all_blocks"
      };
      
      jQuery.ajax({
                url: bkap_settings_params.ajax_url,
                type: "POST",
                data : data,
                beforeSend: function() {
                 //loading  

                },
                success: function( data, textStatus, xhr ) {
                    // Hide all the rows except the first one (column names)
                  jQuery( '#bkap_fixed_block_booking_table tr[id^="bkap_fixed_block_row_"]' ).each(function (i, row) {
                  
                  jQuery( this ).remove();
                });
                
                // add a fade out message which informs the admin that the settings have been saved
                  jQuery( '#block_pricing_update_notification' ).addClass( 'bkap_updated_notice' );
                  jQuery( '#block_pricing_update_notification' ).css( 'display', 'block' );
                  jQuery( '#block_pricing_update_notification' ).html( bkap_block_pricing_params.delete_all_fixed_blocks ).fadeOut( 10000 );
                },
                error: function( xhr, textStatus, errorThrown ) {
                  // error status
                }
            });
      
    }
    
  });
  
  // This is to delete a specific block.
  jQuery( "#bkap_fixed_block_booking_table" ).on( "click", "[id^=bkap_fixed_block_close]",  function() {
    var y = confirm( bkap_block_pricing_params.confirm_delete_fixed_block );
    
    var id = this.id;
    var split_data = id.split( '_' );
      var row_number = split_data[ 4 ];
      
      var block_name    = jQuery( '#booking_block_name_' + row_number ).val();
      var number_of_days  = jQuery( '#number_of_days_' + row_number ).val();
      var start_day     = jQuery( '#start_day_' + row_number ).val();
      var end_day     = jQuery( '#end_day_' + row_number ).val();
      var block_price   = jQuery( '#fixed_block_price_' + row_number ).val();
      

      var fixed_block_row_data = block_name+"&&"+number_of_days+"&&"+start_day+"&&"+end_day+"&&"+block_price;
    
    
    if( y == true ) {
      
      var passed_id = bkap_settings_params.post_id;
      var data = {
        post_id: passed_id,
        fixed_block_key : row_number,
        action: "bkap_delete_block"
      };
      
      jQuery.ajax({
                url: bkap_settings_params.ajax_url,
                type: "POST",
                data : data,
                beforeSend: function() {
                 //loading  

                },
                success: function( data, textStatus, xhr ) {
                    // Hide all the rows except the first one (column names)
                  //jQuery( '#bkap_fixed_block_booking_table tr[id^="bkap_fixed_block_row_"]' ).each(function (i, row) {
                    jQuery( '#bkap_fixed_block_row_' + row_number ).remove();
                  //jQuery( this ).remove();
                //});
                
                // add a fade out message which informs the admin that the settings have been saved
                  jQuery( '#block_pricing_update_notification' ).addClass( 'bkap_updated_notice' );
                  jQuery( '#block_pricing_update_notification' ).css( 'display', 'block' );
                  jQuery( '#block_pricing_update_notification' ).html( bkap_block_pricing_params.delete_fixed_block ).fadeOut( 10000 );
                },
                error: function( xhr, textStatus, errorThrown ) {
                  // error status
                }
            });
      
    }
  });
  
  
  /*
  * This is to delete all fixed booking block.
  */
  
  jQuery( ".bkap_remove_all_price_ranges" ).on( "click" , function() {
    var y = confirm( bkap_block_pricing_params.confirm_delete_all_price_ranges );
    
    var available_price_range_row = jQuery( '#bkap_price_range_booking_table tr[id^="bkap_price_range_row_"]' ).length;
    
    if( y == true && available_price_range_row > 0 ) {
      
      var passed_id = bkap_settings_params.post_id;
      var data = {
        post_id: passed_id, 
        action: "bkap_delete_all_ranges"
      };
      
      jQuery.ajax({
                url: bkap_settings_params.ajax_url,
                type: "POST",
                data : data,
                beforeSend: function() {
                 //loading  

                },
                success: function( data, textStatus, xhr ) {
                    // Hide all the rows except the first one (column names)
                  jQuery( '#bkap_price_range_booking_table tr[id^="bkap_price_range_row_"]' ).each(function (i, row) {
                  
                  jQuery( this ).remove();
                });
                
                // add a fade out message which informs the admin that the settings have been saved
                  jQuery( '#block_pricing_update_notification' ).addClass( 'bkap_updated_notice' );
                  jQuery( '#block_pricing_update_notification' ).css( 'display', 'block' );
                  jQuery( '#block_pricing_update_notification' ).html( bkap_block_pricing_params.delete_all_price_ranges ).fadeOut( 10000 );
                },
                error: function( xhr, textStatus, errorThrown ) {
                  // error status
                }
            });
      
    }
    
  });
  
  
  
  // This is to delete a specific price rnage.
  jQuery( "#bkap_price_range_booking_table" ).on( "click", "[id^=bkap_price_range_close]",  function() {
    var y = confirm( bkap_block_pricing_params.confirm_delete_price_range );
    
    if( y == true ) {
      
      var id = this.id;
      var split_data = id.split( '_' );
        var row_number = split_data[ 4 ];
      
      var passed_id = bkap_settings_params.post_id;
      var data = {
        post_id: passed_id,
        price_range_key : row_number,
        action: "bkap_delete_range"
      };
      
      jQuery.ajax({
                url: bkap_settings_params.ajax_url,
                type: "POST",
                data : data,
                beforeSend: function() {
                 //loading  

                },
                success: function( data, textStatus, xhr ) {
                    // Hide all the rows except the first one (column names)
                  //jQuery( '#bkap_fixed_block_booking_table tr[id^="bkap_fixed_block_row_"]' ).each(function (i, row) {
                    jQuery( '#bkap_price_range_row_' + row_number ).remove();
                  //jQuery( this ).remove();
                //});
                
                // add a fade out message which informs the admin that the settings have been saved
                  jQuery( '#block_pricing_update_notification' ).addClass( 'bkap_updated_notice' );
                  jQuery( '#block_pricing_update_notification' ).css( 'display', 'block' );
                  jQuery( '#block_pricing_update_notification' ).html( bkap_block_pricing_params.delete_price_range ).fadeOut( 10000 );
                },
                error: function( xhr, textStatus, errorThrown ) {
                  // error status
                }
            });
      
    }
  });
  
  // Clear Selection of the Block Pricing option.
  
  jQuery( document ).on( 'click', '.bkap_clear_block_pricing_selection', function() {
    
    jQuery( '[name="bkap_enable_block_pricing_type"]' ).removeAttr('checked');
    jQuery( '[name="bkap_enable_block_pricing_type"]' ).removeAttr('checked');
    jQuery('.bkap_fixed_block_booking').addClass( 'bkap_disable_block_pricing' );
    jQuery('.bkap_price_range_booking').addClass( 'bkap_disable_block_pricing' );    
    
    if ( bkap_settings_params.post_id != 0 ) {
      // setup the data
      var data = {
              product_id: bkap_settings_params.post_id,
              action: 'bkap_block_pricing_options'
      };
              
      jQuery.post( bkap_settings_params.ajax_url, data, function(response) { 
      });
    }
      
    return false;
  });
  
// This will add new row in Fixed Block Booking table
  
  jQuery( ".bkap_add_new_price_range" ).on( "click" , function() {
    
    var attribute_count = 0; 
    
    // Calculating new ID to assign new tr.
    jQuery( "tr#bkap_default_price_range_row > td select[id^='attribute_']" ).each( function(){
      attribute_count++;
    });
    
    var each_price_range      = new Array();
    var i_price_range         = 0;
    var last_class_name_price_range = "bkap_default_price_range_row";
    
    // Calculating new ID to assign new tr.
    jQuery( "tr[id^='bkap_price_range_row']" ).each( function(){
      
      var id_of_price_range_row   = jQuery(this)[0].id;
      
      last_class_name_price_range = id_of_price_range_row;
      var res           = id_of_price_range_row.replace("bkap_price_range_row_", "");
      
      if( res == id_of_price_range_row && each_price_range.length == 0){
        each_price_range[i_price_range] = 0;
      }else{
        each_price_range[i_price_range] = parseInt(res);
      }
      i_price_range++;
    
    });
    
    if( each_price_range.length == 0 ){
      var new_id_price_range = 0;
    }else{
      if( isNaN( each_price_range[0] ) ){
        each_price_range.shift();
      }
      
      var max_price_range = Math.max.apply(Math,each_price_range);
      var new_id_price_range = max_price_range+1;
    }
    
    // This will return complete tr element.
    var price_range_tr = jQuery("#bkap_default_price_range_row")[0].outerHTML; // This will written complete tr element.
    
    // Removing style and giving new id to the tr
    var new_time_tr = price_range_tr.replace("id=\"bkap_default_price_range_row\" style=\"display: none;\"", "id=\"bkap_price_range_row_"+new_id_price_range+"\"");
    
    // Changing the id of elements with new one.
    
    if( attribute_count > 0 ) {
      for( i=1; i <= attribute_count; i++ ){
        new_time_tr = new_time_tr.replace("id=\"attribute_"+i+"\" value=\"\"",  "id=\"attribute_"+i+"_"+new_id_price_range+"\"");
      }
    }
    
    new_time_tr = new_time_tr.replace("id=\"number_of_start_days\"",  "id=\"number_of_start_days_"+new_id_price_range+"\"");
    new_time_tr = new_time_tr.replace("id=\"number_of_end_days\"",    "id=\"number_of_end_days_"+new_id_price_range+"\"");
    new_time_tr = new_time_tr.replace("id=\"per_day_price\"",       "id=\"per_day_price_"+new_id_price_range+"\"");
    new_time_tr = new_time_tr.replace("id=\"end_day\"",         "id=\"end_day_"+new_id_price_range+"\"");
    new_time_tr = new_time_tr.replace("id=\"fixed_price\"",       "id=\"fixed_price_"+new_id_price_range+"\"");
    new_time_tr = new_time_tr.replace("id=\"bkap_price_range_close\"",  "id=\"bkap_price_range_close_"+new_id_price_range+"\"" );
    
    var last_class_name_price_range_new = "#"+last_class_name_price_range;
    
    jQuery( last_class_name_price_range_new ).after(new_time_tr);
  });
  
  /*
  * This is to change the From(Start Date) and To(End Date) field based on the selected option in the Range type option.
  */
  
  jQuery( ".specific" ).on( "change", "select[id^=range_dropdown]",  function() {
    
    var select_element_id      = jQuery(this)[0].id;
    var select_element_id_name = "#"+select_element_id;
    var id_name                = jQuery(select_element_id_name).closest("tr").prop("class");
    var id                     = "."+id_name;    
    var tr_element             = jQuery(id);
    
    switch ( this.value ) {
      case "specific_dates":
        var added_specific_date_range_row = jQuery(".added_specific_date_range_row");
        jQuery( id ).find( ".date_selection_textbox1" ).css( "display", "none" );
        jQuery( id ).find( ".date_selection_textbox2" ).css( "display", "none" );
        jQuery( id ).find( ".date_selection_textbox3" ).removeAttr( "style" ); // enabling specidif
        jQuery( id ).find( ".date_selection_textbox4" ).css( "display", "none" );
        jQuery( id ).find( ".date_selection_textbox5" ).css( "display", "none" );
        jQuery( id ).find( ".date_selection_textbox6" ).css( "display", "none" );
        jQuery( id ).find( ".bkap_lockout_column_data_1" ).css( "display", "none" );
        jQuery( id ).find( ".bkap_lockout_column_data_2" ).css( "display", "none" );
        jQuery( id ).find( ".bkap_lockout_column_data_3" ).css( "display", "none" );
        jQuery( id ).find( ".bkap_lockout_column_data_4" ).removeAttr( "style" );
        jQuery( id ).find( "input[name='bkap_bookable_nonbookable']" ).prop( "checked", true );
        break;
      case "holidays":
        var added_specific_date_range_row = jQuery(".added_specific_date_range_row");
        jQuery( id ).find( ".date_selection_textbox1" ).css( "display", "none" );
        jQuery( id ).find( ".date_selection_textbox2" ).css( "display", "none" );
        jQuery( id ).find( ".date_selection_textbox3" ).css( "display", "none" );
        jQuery( id ).find( ".date_selection_textbox4" ).css( "display", "none" );
        jQuery( id ).find( ".date_selection_textbox6" ).removeAttr( "style" );
        jQuery( id ).find( ".date_selection_textbox5" ).css( "display", "none" );
        
        jQuery( id ).find( ".bkap_lockout_column_data_1" ).css( "display", "none" );
        jQuery( id ).find( ".bkap_lockout_column_data_2" ).removeAttr( "style" );
        jQuery( id ).find( ".bkap_lockout_column_data_3" ).css( "display", "none" );
        jQuery( id ).find( ".bkap_lockout_column_data_4" ).css( "display", "none" );
        jQuery( id ).find( "input[name='bkap_bookable_nonbookable']" ).prop( "checked", false );
        break;
      case "custom_range":
        var added_specific_date_range_row = jQuery(".added_specific_date_range_row");
    
        jQuery( id ).find( ".date_selection_textbox1" ).removeAttr( "style" );
        jQuery( id ).find( ".date_selection_textbox2" ).removeAttr( "style" );
        jQuery( id ).find( ".date_selection_textbox3" ).css( "display", "none" );
        jQuery( id ).find( ".date_selection_textbox4" ).css( "display", "none" );
        jQuery( id ).find( ".date_selection_textbox5" ).css( "display", "none" );
        jQuery( id ).find( ".date_selection_textbox6" ).css( "display", "none" );
        
        jQuery( id ).find( ".bkap_lockout_column_data_1" ).removeAttr( "style" );
        jQuery( id ).find( ".bkap_lockout_column_data_2" ).css( "display", "none" );
        jQuery( id ).find( ".bkap_lockout_column_data_3" ).css( "display", "none" );
        jQuery( id ).find( ".bkap_lockout_column_data_4" ).css( "display", "none" ); 
        
        break;
      case "range_of_months":
        var added_specific_date_range_row = jQuery(".added_specific_date_range_row");
        jQuery( id ).find( ".date_selection_textbox1" ).css( "display", "none" );
        jQuery( id ).find( ".date_selection_textbox2" ).css( "display", "none" );
        jQuery( id ).find( ".date_selection_textbox3" ).css( "display", "none" );
        jQuery( id ).find( ".date_selection_textbox4" ).removeAttr( "style" );
        jQuery( id ).find( ".date_selection_textbox5" ).removeAttr( "style" );
        jQuery( id ).find( ".date_selection_textbox6" ).css( "display", "none" );
        
        jQuery( id ).find( ".bkap_lockout_column_data_1" ).css( "display", "none" );
        jQuery( id ).find( ".bkap_lockout_column_data_2" ).css( "display", "none" );
        jQuery( id ).find( ".bkap_lockout_column_data_3" ).removeAttr( "style" );
        jQuery( id ).find( ".bkap_lockout_column_data_4" ).css( "display", "none" ); 
        
        break;
      default:
        break;
    }
  });
    
    
    // Enable and disable lockout and price fields based on enable/disable weekday.
    
    jQuery( document ).on( "click", "[id^=booking_weekday]" , function() {
    
      var week_id = lastChar = lock_id = weekday_id = "";
       week_id    = jQuery(this)[0].id;
       week_id        = "#"+week_id;
       
       lastChar   = week_id.slice(-1);
       
       lock_id    = "#weekday_lockout_"+lastChar;
      
      if ( jQuery( week_id ).prop("checked") == false){
        // enable the lockout field
        jQuery(lock_id).prop( "disabled", true );
      }else{
        // disable the lockout field
        jQuery( lock_id ).prop( "disabled", false );
      }
    });
  
  // Collapesing the tabs of Booking meta box.  
  jQuery( document ).on( "click", "#bkap_collapse" , function() {
    
      var style_tab = jQuery(".tstab-tabs-nav").attr("style");
      
      if ( style_tab.search( "width: 6%" ) == -1 ){
        jQuery(".bkap_tab").css( "font-size", "0" );
        jQuery(".tstab-tabs.vertical.top-left > ul").css( "width", "6%" );
        jQuery("span.dashicons-admin-collapse").css( "transform", "rotate(180deg)" );
        
        jQuery(".bkap_tab .fa").css( "font-size", "12px" );
        jQuery("#bkap_collapse").css( "font-size", "0" );
      }else{
        jQuery(".tstab-tabs.vertical.top-left > ul").css( "width", "20%" );
          jQuery("span.dashicons-admin-collapse").css( "transform", "" );
          jQuery(".bkap_tab").css( "font-size", "12px" );
          jQuery("#bkap_collapse").css( "font-size", "12px" );
      }
    });
  
  
  // This will add multiple dates picker to the specific and holiday textarea.
    jQuery("#bkap_date_timeslot_table").on( "focus", "[id^=bkap_note_time]", function() {
    // Automatically increase textarea of Note in date/day and timeslot table.
      week_id   = jQuery(this)[0].id;
      var textarea = document.getElementById(week_id);
      var limit = 200;

      textarea.oninput = function() {
        textarea.style.height = "";
        textarea.style.height = Math.min(textarea.scrollHeight, 300) + "px";
      };
      
    });
    
    // To show message when bookable is enabled/disabled for Holidays and Specific Dates.
    
  jQuery( ".specific" ).on( "click", "[id^=bkap_bookable_nonbookable]",  function() {
  
    var id      = this.id;
    var row_number  = id.lastIndexOf("_");
    row_number    = id.substring(row_number + 1);

    var range_set   = jQuery( '#range_dropdown_' + row_number ).val();
    var record_type = range_set;
    var popup_id  = "bkap_myPopup_"+row_number
    
      var popup     = document.getElementById( popup_id );
    
    if( record_type == "holidays" ){
      jQuery( popup ).text("You can't set Holiday Dates as Bookable.");
      jQuery( popup ).addClass("bkap_show");
      setTimeout( function(){
          var selected_bookable_id = "#"+id;
          jQuery( selected_bookable_id ).prop( 'checked', false );
        }, 500);
        setTimeout( function(){ jQuery( popup ).removeClass("bkap_show"); 
        jQuery( popup ).text("");
        }, 4000);
    }
    
    if( record_type == "specific_dates" ){
      var selected_specific_id = "#"+id;
      
      if ( jQuery( selected_specific_id ).prop("checked") === false){
        
        jQuery( popup ).text("All the selected Specific Dates will be considered as Holiday Dates if the bookable is switched to OFF");
        jQuery( popup ).addClass("bkap_show");
        
          setTimeout( function(){ jQuery( popup ).removeClass("bkap_show"); 
          jQuery( popup ).text("");
          }, 4000);
      }
    }
  });

  // If price is not specified, show a message that Booking box wont be displayed
  jQuery( '#booking_enable_date' ).change(function() {
    if ( this.checked && 
         jQuery( '#product-type' ).val() === 'simple' && 
         ( jQuery( '#_regular_price' ).val() === '' && jQuery( '#_sale_price' ).val() === '' ) ) {

      var msg_append = '<div class="booking_options-flex-child" id="bkap_price_message">'+
        '<p class="show-bkap-price-message">'+
        '<strong><i>Please note that Booking fields will not be displayed on front end until Price is added for the product</i></strong>'+
        '</p></div>';
      jQuery( '#enable_booking_options_section' ).after( msg_append );
    }else if( jQuery( '#bkap_price_message' ).length > 0 ){
      jQuery( '#bkap_price_message' ).remove();
    }
  });

  // Copy the booking setting when clicking on copy settings button

  jQuery( '.bkap_export_booking_link' ).click( function() {

    jQuery( '#bkap_product_status_txt' ).select();    
    document.execCommand( 'copy' );

    jQuery( "#bkap_myPopup" ).text( "Settings are copied!" );
    jQuery( "#bkap_myPopup" ).addClass( "bkap_show" );
  
    setTimeout( function(){ jQuery( "#bkap_myPopup" ).removeClass( "bkap_show" ); 
      jQuery( "#bkap_myPopup" ).text("");
    }, 2000);

    return false;
  });


  // Google Sync Tab Js

  var isChecked = jQuery( "#product_sync_integration_mode:checked" ).val();

  switch ( isChecked ) {
    case 'oauth':
      jQuery( ".bkap_directly_mode" ).css( 'display', 'none' ); // hiding directly more options
      break;
    case 'directly':
      jQuery( ".bkap_oauth_mode" ).css( 'display', 'none' ); // hiding OAuth options
      break;
    default:
      // Hiding Both options.
      jQuery( ".bkap_directly_mode" ).css( 'display', 'none' );
      jQuery( ".bkap_oauth_mode" ).css( 'display', 'none' );
      break;
  }

  // if its a variable product
  if ( jQuery( '#enable_automated_mapping' ).length > 0 ) {
    var isChecked = jQuery( "#enable_automated_mapping:checked" ).val();

    if ( isChecked == 'on' ) {
      jQuery( '#gcal_default_variation' ).prop( 'disabled', false );
    } else {
      jQuery( '#gcal_default_variation' ).prop( 'disabled', true );
    }
  }
    // on change routine for radio button
  jQuery( "input[type=radio][id=product_sync_integration_mode]" ).change( function() {

    var isChecked = jQuery( this ).val();

    switch ( isChecked ) {
      case 'oauth':
        jQuery( ".bkap_directly_mode" ).css( 'display', 'none' ); // hide directly mode options
        jQuery( ".bkap_oauth_mode" ).removeAttr( 'style' );
        break;
      case 'directly':
        jQuery( ".bkap_directly_mode" ).removeAttr( 'style' ); // hide directly mode options 
        jQuery( ".bkap_oauth_mode" ).css( 'display', 'none' );
        break;    
      default:
        jQuery( ".bkap_directly_mode" ).css( 'display', 'none' );
        jQuery( ".bkap_oauth_mode" ).css( 'display', 'none' );
        break;
    }
  });

  jQuery( '#bkap_copy_redirect_uri' ).on( 'click', function() {
		jQuery( '.bkap-auth-redirect-uri' ).select();
		document.execCommand( 'copy' );

			jQuery( "#bkap_redirect_uri_copied" ).html("<b>Copied!</b>");
			jQuery( "#bkap_redirect_uri_copied" ).show();
			setTimeout( function(){ jQuery( "#bkap_redirect_uri_copied" ).hide(); 
				jQuery( "#bkap_redirect_uri_copied" ).html("");
			}, 4000 );
	});

});

  jQuery('.tstab-content').wrapInner('<div class="tstab-content-inner"></div>');
  jQuery(document).on('click', '.tstab-tab', function(){
    data_link = jQuery(this).data("link");
    cur_data_link = jQuery('.tstab-tab.tstab-active').data("link");
    if ( cur_data_link !== data_link ) {
      jQuery('.tstab-content').removeClass('tstab-active').hide();
      jQuery("#"+data_link).addClass('tstab-active').css('position', 'relative').fadeIn('slow');
      jQuery('.tstab-tab').removeClass('tstab-active');
      jQuery(this).addClass('tstab-active');
    }
  });

/**
 * This function allows entring the numbers(non decimal) in the field.
 *
 * @function bkap_only_number
 * @param {event} event - Event Object
 * @returns {bool} Returns true or false based on character entered
 * @since 4.19.0
 */
function bkap_only_number( event ) {
	return event.charCode >= 48 && event.charCode <= 57;
}