// Listing helpers.
const bkapListing = ( function( $ ) {

	let activeAjaxCount = 0;
	
	return {
		// loading.
		loading( isLoading ) {
			if ( ! isLoading ) {
				$( '.tyche_loader' ).hide();
			} else {
				$( '.tyche_loader' ).show();
			}
		},
		// eventRender callback
		eventRender( info, isAdmin ) {
			const extendedProps = info.event.extendedProps;
			const bkapView = extendedProps.view;

			// Check Availability
			bkapListing.checkAvailability( info, isAdmin );

			// Add meta
			if ( extendedProps.resources ) {
				const resource = bkap_data.resource;
				let resource_data = extendedProps.resources.split( '=>' );
				bkapListing.addMeta( `${ resource }: ${ resource_data[1] }`, info.el.lastChild.childNodes[ 0 ] ); // Resource
			}

			if ( isAdmin ) {
				let price = bkapListing.bkap_format_money( bkap_data.bkap_currency_args, extendedProps.price );
				bkapListing.addMeta( `${ bkap_data.price }: ${ price }`, info.el.lastChild.childNodes[ 0 ] ); // Resource
			}

			// Add cta (form/button)
			switch ( bkapView ) {
				case 'list':
					$( info.el ).on( 'click', function( e ) {
						if ( e.target.getAttribute( 'href' ) == null ) {
							e.preventDefault();
						}
					} );

					bkapListing.addCta( info, info.el.lastChild );
					break;
				default:
					break;
			}
		},
		// Check booked
		checkAvailability( info, isAdmin ) {

			let extendedProp = info.event.extendedProps;
			let view     = extendedProp.view;
			let calc     = true;
			let start    = info.event.start;
			let m        = start.getMonth(), d = start.getDate(), y = start.getFullYear();
			let date     = d + "-" + ( m+1 ) + "-" + y;
			let holidays = info.event.extendedProps.holidays;

			if ( jQuery.inArray( date, holidays ) != -1 ) {
				calc = false;
				$( info.el ).hide();
			}

			// Data.
			let bkapBooked   = false;
			let booking_type = info.event.extendedProps.bookingType;
			let show_time    = info.event.extendedProps.showTime;
			if ( 'duration_time' == booking_type ) {
				calc = false;
			}

			var dateCall = ( 'only_day' == booking_type || 'multiple_days' == booking_type || 'multidates' == booking_type ) ? true : false;
			var timeCall = ( 'date_time' == booking_type || 'multidates_fixedtime' == booking_type ) ? true : false;

			if ( dateCall || ! show_time ) {
				var bkapCheckData = {
					action: 'bkap_date_lockout',
					post_id: info.event.id,
					date: info.event.start.toISOString(),
					cal_price: true,
				};
			}
			
			if ( timeCall && show_time ) {
				var bkapCheckData = {
					action: 'bkap_get_time_lockout',
					post_id: info.event.id,
					checkin_date: date,
					bkap_page: 'product',
					timeslot_value: info.event.extendedProps.timeslot_value,
					date_time_type: 'on',
					cal_price: true,
				};
			}

			if ( extendedProp.manage_time_availability ) {
				var mta_availability = bkapListing.bkap_check_time_in_availability_data( info.event, date );
				if ( ! mta_availability ) {
					$( info.el ).hide();
				}
			}

			if ( extendedProp.resources ) { 
				let res = extendedProp.resources;
				let resource_data = res.split( '=>' );
				bkapCheckData.resource_id = resource_data[0];
			}

			// If product having custom range then list product only on the custom range dates
			if ( info.event.extendedProps.custom_range_dates != undefined ) { 
				let custom_range = info.event.extendedProps.custom_range_dates;
				if ( jQuery.inArray( date, custom_range ) != -1 ) {
					calc = true;
				} else {
					calc = false;
					$( info.el ).hide();
				}
			}

			// Check availability
			if ( ! isAdmin && calc ) {

				if ( 'list' == view ) {
					activeAjaxCount++;
					jQuery('.tyche_loader').show();
				}

				$.ajax( {
					type: 'post',
					url: woocommerce_params.ajax_url,
					data: bkapCheckData,
					success( response ) {
						const bkapMaxQty = response.max_qty;
						let price        = response.price;
						if ( ! price ) {
							price = extendedProp.price;
						}

						const bkapSkipCheck = [
							'FALSE',
						];

						// Check max available.
						if ( bkapSkipCheck.includes( bkapMaxQty ) ) {
							bkapBooked = false;
						} else {
							if ( 'Unlimited' == bkapMaxQty ) {
								bkapBooked = true;
							} else {
								bkapBooked = bkapMaxQty > 0 ? true : false;
							}							
						}

						const available_slots = bkap_data.available_slots;

						if ( ! bkapBooked ) {
							if ( info.event.extendedProps.greyOutBooked != 'false' ) {
								// Grey Out Booked
								$( info.el ).addClass( 'bkap_greyOut' );
								
								// Removing all the inputs
								$( info.el ).find( 'input, .bkap-select-options' ).each( function( ii, objj ) {
									$( this ).remove();
								});
								// Add Sold out
								$( '<a/>', {
									text: bkap_data.sold_out,
									class: 'bkap-sold-out bkap_greyOut',
									href: '#',
								} ).appendTo( info.el.lastChild );
							} else {
								// Hide
								$( info.el ).hide();
								return false;
							}

							bkapListing.addMeta( available_slots + ': 0', info.el.lastChild.childNodes[ 0 ] ); // Slots
						} else {
							$( info.el ).find( '.bkap-list-qty' ).each( function( ii, objj ) {
								$( this ).attr( 'max', bkapMaxQty );
							});

							$( info.el ).find( 'input[name=bkap_price]' ).each( function( ii, objj ) {
								$( this ).val( price );
							});

							let price_format = bkapListing.bkap_format_money( bkap_data.bkap_currency_args, price );
							bkapListing.addMeta( `${ available_slots }: ${ bkapMaxQty }`, info.el.lastChild.childNodes[ 0 ] ); // Slots
							bkapListing.addMeta( `${ bkap_data.price }: ${ price_format }`, info.el.lastChild.childNodes[ 0 ], { class : 'bkap-meta-price' } ); // Slots
						}

						$( info.el ).addClass( 'bkap_availability_checked' );
					},
					complete(){
						if ( 'list' == view ) {
							activeAjaxCount--;
							if ( activeAjaxCount == 0 ) {
								jQuery('.tyche_loader').hide();
							}
						}
					}
				});
			}
		},
		bkap_check_time_in_availability_data( event_data, date ) {

			
			let manage_time_availability  = event_data.extendedProps.manage_time_availability;
			let timeslot = '';
			let from_date_obj = '';
			let to_date_obj   = '';
			if ( 'duration_time' == event_data.extendedProps.bookingType ) {
				timeslot      = '00:01 - 23:59';
				from_date_obj = event_data.start;
				to_date_obj   = event_data.end;
			} else {
				timeslot = event_data.extendedProps.timeslot_value;
				let timeslot_split            = timeslot.split( ' - ' );
				let from_time                 = timeslot_split[0];
				from_time                     = from_time.replace( ':', '-' );
				let to_time                   = timeslot_split[1];
				to_time                       = to_time.replace( ':', '-' );
				from_date_obj                 = bkapListing.bkap_create_date_obj_from_date_time( date + '-' + from_time );
				to_date_obj                   = bkapListing.bkap_create_date_obj_from_date_time( date + '-' + to_time );
			}
			
			let event_date                = bkapListing.bkap_create_date_obj_from_date_time( date );
			let final_timeslots_available = [];
			let final_timeslots_disable   = [];
			
			for ( i=0; i < manage_time_availability.length; i++ ) {
				let range           = manage_time_availability[i];
				let range_from_date = '';
				let range_to_date   = '';
				let range_check      = false;
				let check           = false;

				switch ( range.type ) {
					case 'custom':
						var range_from          = range.from;
						var range_from_split    = range_from.split( '-' );
						var range_from_date_str = range_from_split[2] + '-' + range_from_split[1] + '-' + range_from_split[0];
						range_from_date         = bkapListing.bkap_create_date_obj_from_date_time( range_from_date_str );
						
						var range_to            = range.to;
						var range_to_split      = range_to.split( '-' );
						var range_to_date_str   = range_to_split[2] + '-' + range_to_split[1] + '-' + range_to_split[0];
						range_to_date           = bkapListing.bkap_create_date_obj_from_date_time( range_to_date_str );
						
						range_check              = true;
						break;
					case 'months':
						var range_from          = range.from;
						var range_to            = range.to;
						var d                   = new Date();
  						var year                = d.getFullYear();
						var range_from_date_str = '01' + '-' + range_from + '-' + year;
						range_from_date         = bkapListing.bkap_create_date_obj_from_date_time( range_from_date_str );

						if ( range_from <= range_to ) {
							var range_to_date_str = '30-' + range_to + '-' + year;
						} else {
							year = year + 1;
							var range_to_date_str = '30-' + range_to + '-' + year ;
						}
						range_to_date = bkapListing.bkap_create_date_obj_from_date_time( range_to_date_str );

						range_check = true;

						break;
					case 'weeks':
						var range_from = range.from;
						var range_to   = range.to;
						var d          = new Date();
  						var year       = d.getFullYear();
						
						// Ref: https://stackoverflow.com/questions/16590500/javascript-calculate-date-from-week-number
						// Getting Start date accourding the Week Number
						var from_week   = new Date( year, 0, 1 + ( range_from - 1) * 7);
						var fdow        = from_week.getDay();
						range_from_date = from_week;
						if ( fdow <= 4 ){
							range_from_date.setDate( from_week.getDate() - from_week.getDay() + 1 );
						} else {
							range_from_date.setDate( from_week.getDate() + 8 - from_week.getDay() );
						}

						// Getting End date accourding the Week Number
						var to_week   = new Date( year, 0, 1 + ( range_to - 1) * 7);
						var tdow      = to_week.getDay();
						range_to_date = to_week;
						if ( tdow <= 4 ) {
							range_to_date.setDate( to_week.getDate() - to_week.getDay() + 1 );
						} else {
							range_to_date.setDate( to_week.getDate() + 8 - to_week.getDay() );
						}
						
						range_to_date.setDate( range_to_date.getDate() + 6 ); // Getting last date of the selected week.

						range_check = true;
						break;
					case 'days':
						var day1 = parseInt( range.from );
						var day2 = parseInt( range.to );
						var days = '';

						if ( day1 == day2 ) {
							days = day1.toString();
							if ( 7 == day1 ) {
								days = '0';
							}
						} else {
							for ( var i = 0; i < 7; i++ ) {
								if ( day1 < 7 ) {
									days = days + day1 + ',';
									day1 = day1 + 1;

									if ( day1 == day2 ) {

										if ( day1 == 7 ) {
											day1 = 0;
										}
										days = days + day1;
										break;
									}
									if ( day1 == 7 ) {
										day1 = 0;
									}
								}
							}
						}

						days = days.toString();
						var event_day = event_date.getDay().toString();
						if ( days.includes( event_day ) ) {
							range_from_date = bkapListing.bkap_create_date_obj_from_date_time( date );
							range_to_date   = bkapListing.bkap_create_date_obj_from_date_time( date + '-23-59' );
							range_check      = true;
						}

						break;
					case 'time':
					case 'time:range':
					case 'time:0':
					case 'time:1':
					case 'time:2':
					case 'time:3':
					case 'time:4':
					case 'time:5':
					case 'time:6':

						var range_fromtime = range.from;
						range_fromtime     = range_fromtime.replace( ':', '-' );
						var range_totime   = range.to;
						range_totime       = range_totime.replace( ':', '-' );

						if ( 'time' == range.type ) {
							range_check = true;
						} else {
							var range_type = range.type;
							var range_type_split = range_type.split( ':' );

							if ( 'range' == range_type_split[1] ) {

								var range_from          = range.from_date;
								var range_from_split    = range_from.split( '-' );
								var range_from_date_str = range_from_split[2] + '-' + range_from_split[1] + '-' + range_from_split[0];
								var range_fromdate      = bkapListing.bkap_create_date_obj_from_date_time( range_from_date_str );

								var range_to            = range.to_date;
								var range_to_split      = range_to.split( '-' );
								var range_to_date_str   = range_to_split[2] + '-' + range_to_split[1] + '-' + range_to_split[0];
								var range_todate        = bkapListing.bkap_create_date_obj_from_date_time( range_to_date_str );

								if ( event_date.getTime() >= range_fromdate.getTime() && event_date.getTime() <= range_todate.getTime() ) {
									range_check = true;
								}
							} else {
								if ( event_date.getDay() == range_type_split[1] ) {
									range_check = true;
								}
							}
							if ( range_check ) {
								range_from_date = bkapListing.bkap_create_date_obj_from_date_time( date + '-' +  range_fromtime );
								range_to_date   = bkapListing.bkap_create_date_obj_from_date_time( date + '-' +  range_totime );
							}
						}
						break;
				
					default:
						break;
				}

				if ( range_check ) {
					
					if ( parseInt( range.bookable ) ) {
						if ( bkapListing.bkap_date_time_inside_mta_range( from_date_obj, to_date_obj, range_from_date, range_to_date ) ) {
							if ( final_timeslots_available.indexOf( timeslot ) == -1 && final_timeslots_disable.indexOf( timeslot ) == -1) {
								final_timeslots_available.push( timeslot );
							}
						}
					} else {
						if ( bkapListing.bkap_date_time_inside_mta_range( from_date_obj, to_date_obj, range_from_date, range_to_date ) ) {
							if ( final_timeslots_disable.indexOf( timeslot ) == -1 && final_timeslots_available.indexOf( timeslot ) == -1 ) {
								final_timeslots_disable.push( timeslot );
								return false;
							}
						}
					}
				}
			}

			return true;
		},
		bkap_date_time_inside_mta_range( from_date_obj, to_date_obj, range_from_date, range_to_date ) {
			if ( ( from_date_obj.getTime() > range_from_date.getTime() && from_date_obj.getTime() < range_to_date.getTime() )
			|| ( to_date_obj.getTime() > range_from_date.getTime() && to_date_obj.getTime() < range_to_date.getTime() )
			|| ( from_date_obj.getTime() <= range_from_date.getTime() && to_date_obj.getTime() >= range_to_date.getTime() ) ) {
				return true;
			}
			return false;
		},
		bkap_create_date_obj_from_date_time( date_time ) {
			
			let date_time_split = date_time.split( '-' );
			if ( date_time_split.length > 3 ) {
				return new Date( date_time_split[2], date_time_split[1]-1, date_time_split[0], date_time_split[3], date_time_split[4] );
			} else {
				return new Date( date_time_split[2], date_time_split[1]-1, date_time_split[0] );
			}
		},
		addMeta( data, element, additional_info = {} ) {

			let add_class = ''
			if ( additional_info.class != undefined ){
				add_class = ' ' + additional_info.class;
			}
			$( '<span/>', {
				html: data,
				class: 'bkap-meta' + add_class,
			} ).appendTo( element );
		},
		// Formatting the Price according to Currency Option
		bkap_format_money: function( bkap_currency_args, price ) {
            return accounting.formatMoney( parseFloat( price ), {
                symbol      : bkap_currency_args['currency_format_symbol'],
                decimal     : bkap_currency_args['currency_format_decimal_sep'],
                thousand    : bkap_currency_args['currency_format_thousand_sep'],
                precision   : bkap_currency_args['currency_format_num_decimals'],
				format      : bkap_currency_args['currency_format'],				
            });
        },
		// Add form form for "add to cart" or "select options"
		addCta( info, element ) {

			let add_to_cart_form = false;
			let extended_prop    = info.event.extendedProps;

			if ( 'simple' === extended_prop.productType ) {
				if ( 'only_day' === extended_prop.bookingType || ( 'date_time' == extended_prop.bookingType && extended_prop.showTime ) ) {
					add_to_cart_form = true;
				}
			}

			let resource_id = 0;
			if ( extended_prop.resources ) { 
				let res = extended_prop.resources;
				let resource_data = res.split( '=>' );
				resource_id = resource_data[0];
			}

			if ( add_to_cart_form ) {
				// Add form for add to cart
				const bookingForm = $( '<form/>', {
					class: 'bkap-list-form',
				} ).appendTo( element );

				// Hidden field for "product id"
				$( '<input/>', {
					type: 'hidden',
					name: 'product_id',
					value: info.event.id,
				} ).appendTo( bookingForm );

				// Hidden field for "booking date"
				$( '<input/>', {
					type: 'hidden',
					name: 'booking_calender',
					value: moment( info.event.start ).format( 'YYYY-MM-DD' ),
				} ).appendTo( bookingForm );

				// Hidden field for "booking date" for backcompact
				$( '<input/>', {
					type: 'hidden',
					name: 'wapbk_hidden_date',
					value: moment( info.event.start ).format( 'D-M-YYYY' ),
				} ).appendTo( bookingForm );
				
				$( '<input/>', {
					type: 'hidden',
					name: 'bkap_price',
					value: '',
				} ).appendTo( bookingForm );

				if ( 'date_time' == extended_prop.bookingType ) {
					// Hidden field for "booking timeslot" for backcompact
					$( '<input/>', {
						type: 'hidden',
						name: 'time_slot',
						value: extended_prop.timeslot_value,
					} ).appendTo( bookingForm );
				}
				// Field for qty based on showQuantity				
				if ( info.event.extendedProps.showQuantity == 'true' ) {
					// Field for "Qty"
					$( '<input/>', {
						class: 'bkap-list-qty',
						name: 'quantity',
						value: '1',
						type: 'number',
						min: '1',
					} ).appendTo( bookingForm );
				} else {
					// Hidden field for "Qty"
					$( '<input/>', {
						class: 'bkap-list-qty',
						name: 'quantity',
						value: '1',
						type: 'hidden',
					} ).appendTo( bookingForm );
				}

				if ( resource_id ) {
					// Hidden field for "booking date" for backcompact
					$( '<input/>', {
						type: 'hidden',
						name: 'bkap_front_resource_selection',
						value: resource_id,
					} ).appendTo( bookingForm );					
				}

				// Add To Cart submit button
				$( '<input/>', {
					class: 'bkap-list-add-to-cart',
					type: 'submit',
					name: 'wapbk_hidden_date',
					value: bkap_data.add_to_cart,
				} ).appendTo( bookingForm );
			} else {
				// Add "Select Options"
				let bkap_date_str = '?bkap_date=';
				if ( info.event.url.includes( '?' ) ){
					bkap_date_str = '&bkap_date=';
				}
				$( '<a/>', {
					text: bkap_data.select_option,
					class: 'bkap-select-options',
					href: `${ info.event.url }${ bkap_date_str }${ moment( info.event.start ).format( 'YYYY-MM-DD' ) }`,
					click() {
						window.location.href = this.href;
					},
				} ).appendTo( element );
			}
		},
	};
}( jQuery ) );

// Listing Add to cart
( function( $ ) {
	// Add To Cart
	$( document ).on( 'click', '.bkap-list-add-to-cart', function( e ) {
		e.preventDefault();

		// Get data
		const data = $( this ).closest( 'form' ).serialize();
		const fc_list_item = $( this ).closest( ".bkap-list-form" );
		const button = $( this );

		// Submit add to cart
		$.ajax( {
			type: 'post',
			url: woocommerce_params.wc_ajax_url.toString().replace( '%%endpoint%%', 'add_to_cart' ),
			data,
			beforeSend( ) {
				button.removeClass( 'added' ).addClass( 'loading' );
				fc_list_item.block({
					message: null,
					overlayCSS: {
						background: '#eee',
						opacity: 0.6
					}
				});
			},
			complete( ) {
				button.addClass( 'added' ).removeClass( 'loading' );
				fc_list_item.unblock();
			},
			success( response ) {
				if ( response.error && response.product_url ) {
					window.location = response.product_url;
				} else {
					$( document.body ).trigger( 'added_to_cart', [ response.fragments, response.cart_hash, button ] );
				}
			},
		} );
	} );

	// Enable click on "added to cart"
	$( document ).on( 'click', 'a.added_to_cart', function() {
		window.location.href = this.href;
	} );
}( jQuery ) );
