/**
 * File for configuring Full Calendar
 * @namespace bkap_calendar
 * @since 2.5.0
 */
document.addEventListener('DOMContentLoaded', function() {
	var calendarEl = document.getElementById( 'bkap-calendar' );
	var calendar   = new FullCalendar.Calendar(calendarEl, {
		initialView: 'timeGridWeek',
		headerToolbar: {
			left: 'prev,next,today',
			center: 'title',
			right: 'dayGridMonth,timeGridWeek,timeGridDay'
		},
		navLinks: true, // can click day/week names to navigate views
		dayMaxEvents: true, // allow "more" link when too many events
		events: bkap.pluginurl,
		locale: booking_calendar_params.lang,
		loading: function( isLoading, view ) {
	    	if ( isLoading == true ) {
				jQuery( "#bkap_events_loader" ).show();
	    	} else if ( isLoading == false ) {
				jQuery( "#bkap_events_loader" ).hide();
	    	}
		},
		eventDidMount : function( info ) {
		
			var event_data = {
				action : 'bkap_booking_calender_content',
				order_id : info.event.id,
				event_value : info.event.extendedProps.value
			};
			jQuery(info.el).qtip({
				content:{
					text : 'Loading...',
					button: 'Close', // It will disply Close button on the tool tip.
					ajax : {
						url : bkap.ajaxurl,
						type : "POST",
						data : event_data
					}
				},
				show: {
					event: 'click', // Show tooltip only on click of the vent
					solo: true // Disply only One tool tip at time, hide other all tool tip
				},
				position: {
					my: 'bottom right', // this is for the botton v shape icon position.
					at: 'top right' // this is for the content box position
				},
				hide: 'unfocus', //this is used to keep the hover effect untill click outside on calender. For clickingthe order number
				style: {
					classes: 'qtip-light qtip-shadow'
				}
			});
		}
	});
	calendar.render();
});