/**
 * File for showing buttons on View Bookings Page
 * @namespace bkap_view_booking
 * @since 4.1.0
 */
jQuery( function ( $ ) {

	// Add buttons to product screen.
	var $product_screen = $( '.edit-php.post-type-bkap_booking' ),
		$title_action   = $product_screen.find( '.page-title-action:first' );

	$title_action.after( '<a href="#" class="page-title-action bkap_export_button" id="bkap_print">'+ bkap_view_booking.labels.print_label +'</a>' );
	$title_action.after( '<a href="#" class="page-title-action bkap_export_button" id="bkap_csv">'+ bkap_view_booking.labels.csv_label +'</a>' );
	$title_action.after( '<a href="'+ bkap_view_booking.url.calendar_url +'" class="page-title-action">'+ bkap_view_booking.labels.calendar_label +'</a>' );
	$( '.wp-header-end' ).before( '<div class="bkap-view-booking-messages"></div>' );
	$( '.wp-header-end' ).before( '<div class="bkap-view-booking-data" style="display:none;"></div>' );

});

jQuery( document ).ready(function ($) {

	/**
	 * Export CSV JS
	 */
	var BKAP_CSV_Export = {

		init : function() {
			this.click();
		},

		click : function() {
			let self = this;
			$('.bkap_export_button').on( 'click', function(e){
				e.preventDefault();

				let submitButton = $(this);
				let id           = $(this).prop('id');
				let type         = id.split( '_' );
				type             = type[1];

				$('.bkap-view-booking-messages').html( '<div id="bkap_myProgress"><div id="bkap_myBar" data-added="0">0%</div></div>' );

				if ( ! submitButton.hasClass( 'button-disabled' ) ) {
					$('.bkap_export_button').addClass('button-disabled');
					// start the process
					self.process_step( 1, self, type );
				}
			});
		},
		printBookings : function () {
			let printThis = document.getElementById('bkap_print_data').outerHTML;  
			let win = window.open();
			self.focus();
			win.document.open();
			win.document.write('<'+'html'+'><head><title>Print Bookings</title><meta http-equiv="Content-Type" content="text/html; charset=UTF-8"></head><'+'body'+'>');
			win.document.write( printThis );
			win.document.write('<'+'/body'+'><'+'/html'+'>');
			win.document.close();
			win.print();
		},

		process_step : function( step, self, csv_print ) {
			
			let total_items = $('.top .displaying-num').text();
			total_items = total_items.split(' ');
			total_items = total_items[0];
			total_items = parseInt( total_items.replace(/,/g, '') );
			let done_items = $('#bkap_myBar').data( 'added' );

			const bkapUrlParams = new URLSearchParams( window.location.search );
			let post_status     = bkapUrlParams.has( 'post_status' ) ? bkapUrlParams.get( 'post_status' ) : '';
			let s               = bkapUrlParams.has( 's' ) ? bkapUrlParams.get( 's' ) : '';
			let m               = bkapUrlParams.has( 'm' ) ? bkapUrlParams.get( 'm' ) : '';
			let post_type       = bkapUrlParams.has( 'post_type' ) ? bkapUrlParams.get( 'post_type' ) : '';
			let filter_products = bkapUrlParams.has( 'filter_products' ) ? bkapUrlParams.get( 'filter_products' ) : '';
			let filter_views    = bkapUrlParams.has( 'filter_views' ) ? bkapUrlParams.get( 'filter_views' ) : '';
			let filter_action   = bkapUrlParams.has( 'filter_action' ) ? bkapUrlParams.get( 'filter_action' ) : '';
			let paged           = bkapUrlParams.has( 'paged' ) ? bkapUrlParams.get( 'paged' ) : '';
			let order           = bkapUrlParams.has( 'order' ) ? bkapUrlParams.get( 'order' ) : '';
			let orderby         = bkapUrlParams.has( 'orderby' ) ? bkapUrlParams.get( 'orderby' ) : '';
			let filter_customer = bkapUrlParams.has( 'filter_customer' ) ? bkapUrlParams.get( 'filter_customer' ) : '';
			let data = {
				post_status,
				s,
				m,
				post_type,
				filter_products,
				filter_views,
				filter_action,
				paged,
				total_items,
				done_items,
				csv_print,
				orderby,
				order,
				filter_customer,
				action: 'bkap_do_ajax_export',
				step: step,
			};			

			jQuery.post( bkap_view_booking.ajax_url, data, function( response ) {
			}).done( function( response ) {
				if ( 'done' == response.step || response.error || response.success ) {
					// We need to get the actual in progress form, not all forms on the page
					$('.bkap_export_button').removeClass('button-disabled');

					if ( response.error ) {
						var error_message = response.message;
						$('.bkap-view-booking-messages').html('<div class="updated error"><p>' + error_message + '</p></div>')

					} else {
						$('#bkap_myBar').animate({
							width: '100%',
						}, 50, function() {
							$('.bkap-view-booking-messages').html( '' );
						});
						if ( 'print' == csv_print ) {
							self.printBookings();
							$( '.bkap-view-booking-data' ).html( '' )
						} else {
							window.location = response.url;
						}
					}

				} else {

					if ( 'print' == csv_print ) {
						let content = response.html_data;

						if ( step == 1 ) {
							$( '.bkap-view-booking-data' ).html( content );
						} else {
							$('#bkap_print_data').append( content );
						}
 					}
					$('#bkap_myBar').data( 'added', response.added );
					$('#bkap_myBar').animate({
						width: response.percentage + '%',
					}, 50, function() {
						// Animation complete.
					});
					
					$('#bkap_myBar').text( response.percentage + '%' );
					
					self.process_step( parseInt( response.step ), self, csv_print );
				}
			}).fail( function (response) {
				if ( window.console && window.console.log ) {
					console.log( response );
				}
			});
		},
	};
	BKAP_CSV_Export.init();
});

/*global bkap_view_booking.bkap_customer_filter_params */
jQuery( function( $ ) {

	var bkap_customer_filter_params = bkap_view_booking.bkap_customer_filter_params;

	function getEnhancedSelectFormatString() {
		return {
			'language': {
				errorLoading: function() {
					return bkap_customer_filter_params.i18n_searching;
				},
				inputTooLong: function( args ) {
					var overChars = args.input.length - args.maximum;

					if ( 1 === overChars ) {
						return bkap_customer_filter_params.i18n_input_too_long_1;
					}

					return bkap_customer_filter_params.i18n_input_too_long_n.replace( '%qty%', overChars );
				},
				inputTooShort: function( args ) {
					var remainingChars = args.minimum - args.input.length;

					if ( 1 === remainingChars ) {
						return bkap_customer_filter_params.i18n_input_too_short_1;
					}

					return bkap_customer_filter_params.i18n_input_too_short_n.replace( '%qty%', remainingChars );
				},
				loadingMore: function() {
					return bkap_customer_filter_params.i18n_load_more;
				},
				maximumSelected: function( args ) {
					if ( args.maximum === 1 ) {
						return bkap_customer_filter_params.i18n_selection_too_long_1;
					}

					return bkap_customer_filter_params.i18n_selection_too_long_n.replace( '%qty%', args.maximum );
				},
				noResults: function() {
					return bkap_customer_filter_params.i18n_no_matches;
				},
				searching: function() {
					return bkap_customer_filter_params.i18n_searching;
				}
			}
		};
	}

	try {
		$( document.body )

			.on( 'bkap-view-booking-init', function() {

				$( ':input.bkap-view-booking, :input.chosen_select' ).filter( ':not(.enhanced)' ).each( function() {
					var select2_args = $.extend({
						minimumResultsForSearch: 10,
						allowClear:  $( this ).data( 'allow_clear' ) ? true : false,
						placeholder: $( this ).data( 'placeholder' )
					}, getEnhancedSelectFormatString() );

					$( this ).selectWoo( select2_args ).addClass( 'enhanced' );
				});

				$( ':input.bkap-view-booking-nostd, :input.chosen_select_nostd' ).filter( ':not(.enhanced)' ).each( function() {
					var select2_args = $.extend({
						minimumResultsForSearch: 10,
						allowClear:  true,
						placeholder: $( this ).data( 'placeholder' )
					}, getEnhancedSelectFormatString() );

					$( this ).selectWoo( select2_args ).addClass( 'enhanced' );
				});


				$( ':input.bkap-customer-search-select-box' ).filter( ':not(.enhanced)' ).each( function() {
					var select2_args = {
						allowClear:  $( this ).data( 'allow_clear' ) ? true : false,
						placeholder: $( this ).data( 'placeholder' ),
						minimumInputLength: $( this ).data( 'minimum_input_length' ) ? $( this ).data( 'minimum_input_length' ) : '1',
						escapeMarkup: function( m ) {
							return m;
						},
						ajax: {
							url:         bkap_customer_filter_params.ajax_url,
							dataType:    'json',
							delay:       1000,
							data:        function( params ) {
								return {
									term:     params.term,
									action:   'woocommerce_bkap_view_bookings_json_search_customers',
									security: bkap_customer_filter_params.search_customers_nonce,
									exclude:  $( this ).data( 'exclude' )
								};
							},
							processResults: function( data ) {
								var terms = [];
								if ( data ) {
									$.each( data, function( id, text ) {
										terms.push({
											id: id,
											text: text
										});
									});
								}
								return {
									results: terms
								};
							},
							cache: true
						}
					};

					select2_args = $.extend( select2_args, getEnhancedSelectFormatString() );

					$( this ).selectWoo( select2_args ).addClass( 'enhanced' );

					if ( $( this ).data( 'sortable' ) ) {
						var $select = $(this);
						var $list   = $( this ).next( '.select2-container' ).find( 'ul.select2-selection__rendered' );

						$list.sortable({
							placeholder : 'ui-state-highlight select2-selection__choice',
							forcePlaceholderSize: true,
							items       : 'li:not(.select2-search__field)',
							tolerance   : 'pointer',
							stop: function() {
								$( $list.find( '.select2-selection__choice' ).get().reverse() ).each( function() {
									var id     = $( this ).data( 'data' ).id;
									var option = $select.find( 'option[value="' + id + '"]' )[0];
									$select.prepend( option );
								} );
							}
						});
					}
				});

			})

			.on( 'wc_backbone_modal_before_remove', function() {
				$( '.bkap-view-booking, :input.bkap-customer-search-select-box' ).filter( '.select2-hidden-accessible' )
					.selectWoo( 'close' );
			})

			.trigger( 'bkap-view-booking-init' );

		$( 'html' ).on( 'click', function( event ) {
			if ( this === event.target ) {
				$( '.bkap-view-booking, :input.bkap-customer-search-select-box' ).filter( '.select2-hidden-accessible' )
					.selectWoo( 'close' );
			}
		} );
	} catch( err ) {
		window.console.log( err );
	}
});
